<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://docbook.org/ns/docbook"
	xmlns="http://www.pixelmed.com/namespaces/contextgroups"
	exclude-result-prefixes="d"
  	version="1.0">

<xsl:strip-space elements="*" />

<xsl:output method="text" encoding="UTF-8" />

 <xsl:variable name='newline'><xsl:text>
</xsl:text></xsl:variable>


<xsl:template match="d:book">
	<definetemplates
			xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xmlns="http://www.pixelmed.com/namespaces/contextgroups"
			xsi:schemaLocation="http://www.pixelmed.com/namespaces/contextgroups http://www.pixelmed.com/schemas/contextgroups.xsd">
		<xsl:apply-templates match=""/>
	</definetemplates>
</xsl:template>

<xsl:template match="d:table[@label = '6-1']">
	<xsl:text>"</xsl:text><xsl:value-of select="d:thead/d:tr/d:th[1]"/><xsl:text>","</xsl:text><xsl:value-of select="d:thead/d:tr/d:th[2]"/><xsl:text>","</xsl:text><xsl:value-of select="d:thead/d:tr/d:th[3]"/><xsl:text>","</xsl:text><xsl:value-of select="d:thead/d:tr/d:th[4]"/><xsl:text>","</xsl:text><xsl:value-of select="d:thead/d:tr/d:th[5]"/><xsl:text>","</xsl:text><xsl:value-of select="d:thead/d:tr/d:th[6]"/><xsl:text>"</xsl:text><xsl:value-of select="$newline"/>
	<xsl:for-each select="d:tbody/d:tr">
		<!-- remove zero width spaces from keyword column -->
		<xsl:text>"</xsl:text><xsl:value-of select="d:td[1]"/><xsl:text>","</xsl:text><xsl:value-of select="d:td[2]"/><xsl:text>","</xsl:text><xsl:value-of select="translate(d:td[3],'&#x200b;','')"/><xsl:text>","</xsl:text><xsl:value-of select="d:td[4]"/><xsl:text>","</xsl:text><xsl:value-of select="d:td[5]"/><xsl:text>","</xsl:text><xsl:value-of select="d:td[6]"/><xsl:text>"</xsl:text><xsl:value-of select="$newline"/>
	</xsl:for-each>
</xsl:template>

<xsl:template match="d:table[@label = '7-1' or @label = '8-1']">
	<xsl:for-each select="d:tbody/d:tr">
		<!-- remove zero width spaces from keyword column -->
		<xsl:text>"</xsl:text><xsl:value-of select="d:td[1]"/><xsl:text>","</xsl:text><xsl:value-of select="d:td[2]"/><xsl:text>","</xsl:text><xsl:value-of select="translate(d:td[3],'&#x200b;','')"/><xsl:text>","</xsl:text><xsl:value-of select="d:td[4]"/><xsl:text>","</xsl:text><xsl:value-of select="d:td[5]"/><xsl:text>","</xsl:text><xsl:value-of select="d:td[6]"/><xsl:text>"</xsl:text><xsl:value-of select="$newline"/>
	</xsl:for-each>
</xsl:template>

<xsl:template match="node()|@*|">
		<xsl:apply-templates match=""/>
</xsl:template>

<xsl:template match="text()"/>

</xsl:stylesheet>
