/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.sax;

import com.renderx.sax.DOMWalker;
import com.renderx.sax.InputSource;
import com.renderx.sax.NullSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.URLSpec;
import com.renderx.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JAXPSourceConverter {
    public InputStream stream = null;
    public org.xml.sax.InputSource source = null;
    public XMLReader parser = null;

    public JAXPSourceConverter(Source source) throws SAXException, IOException {
        String string = source.getSystemId();
        if (string == null) {
            string = URLUtil.toURL(new File("untitled")).toExternalForm();
        }
        if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            this.source = sAXSource.getInputSource();
            this.parser = sAXSource.getXMLReader();
        } else if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            this.source = new NullSource(string);
            this.parser = new DOMWalker(dOMSource.getNode());
        } else if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            this.source = new InputSource(string);
            if (streamSource.getInputStream() != null) {
                this.source.setByteStream(streamSource.getInputStream());
            } else if (streamSource.getReader() != null) {
                this.source.setCharacterStream(streamSource.getReader());
            } else if (streamSource.getSystemId() != null) {
                URLSpec uRLSpec = new URLSpec(streamSource.getSystemId());
                this.stream = uRLSpec.openStream();
                this.source.setByteStream(this.stream);
            } else {
                throw new IOException("No meaningful data in a StreamSource");
            }
        }
        if (this.parser == null) {
            this.parser = XMLReaderFactory.createXMLReader();
        }
    }
}

