/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontConfigurationException;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.pslib.Image;
import com.renderx.pslib.PSDocument;
import com.renderx.pslib.PSOutputStream;
import com.renderx.pslib.Pages;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import com.renderx.util.User;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import junit.framework.Assert;
import junit.framework.TestCase;

public class Images {
    static final int MAX_ID_LENGTH = 80;
    private int counter = 0;
    private final Hashtable imgIndex = new Hashtable();
    private final Hashtable imgIdTable = new Hashtable();
    private final Hashtable imgCountTable = new Hashtable();

    com.renderx.graphics.Image getImageById(String string) {
        return (com.renderx.graphics.Image)this.imgIdTable.get(string);
    }

    int getImageCountById(String string) {
        int n = 0;
        try {
            n = (Integer)this.imgCountTable.get(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    String addImgAndReturnId(com.renderx.graphics.Image image, PSDocument pSDocument, boolean bl) throws ImageFormatException, IOException {
        String string;
        Image image2 = pSDocument.curimage;
        Pages.Page page = pSDocument.pages.currentPage;
        String string2 = string = bl ? (String)this.imgIndex.get(image.getFactory().getKey(image)) : (String)this.imgIndex.get(image);
        if (string == null) {
            if (image.source == null) {
                string = "$" + ++this.counter;
            } else {
                boolean bl2 = image.source.scheme != 3;
                String string3 = string = bl2 ? "$" + ++this.counter : this.makeUniqueId(image.source);
            }
            if (bl) {
                this.imgIndex.put(image.getFactory().getKey(image), string);
            } else {
                this.imgIndex.put(image, string);
            }
            this.imgIdTable.put(string, image);
        }
        this.imgCountTable.put(string, new Integer(1 + this.getImageCountById(string)));
        if (page != null) {
            page.images.snoc(string);
        } else if (image2 != null) {
            image2.subimages.snoc(string);
        }
        return string;
    }

    private String makeUniqueId(URLSpec uRLSpec) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        String string = uRLSpec.toString();
        int n = string.indexOf(58) + 1;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ("0123456789_-.abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) == -1) {
                bl = true;
            } else {
                if (bl) {
                    stringBuffer.append(':');
                }
                stringBuffer.append(c);
                bl = false;
            }
            ++n;
        }
        if (stringBuffer.length() == 0) {
            return "$" + ++this.counter;
        }
        String string2 = stringBuffer.toString();
        if (string2.length() > 80) {
            string2 = ":~" + new String(string2.substring(string2.length() + 2 - 80).getBytes());
        }
        if (this.imgIdTable.containsKey(string2)) {
            return "$" + ++this.counter + string2;
        }
        this.imgIdTable.put(string2, string2);
        return string2;
    }

    int getSize() {
        return this.imgCountTable.size();
    }

    void write(PSOutputStream pSOutputStream) throws IOException {
        if (!this.imgCountTable.isEmpty()) {
            pSOutputStream.println("\n");
            Enumeration enumeration = this.imgCountTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.getImageCountById(string) <= pSOutputStream.doc.IMAGE_INLINE_THRESHOLD) continue;
                try {
                    com.renderx.graphics.Image image;
                    com.renderx.graphics.Image image2 = image = this.getImageById(string);
                    synchronized (image2) {
                        boolean bl = false;
                        URLSpec uRLSpec = null;
                        if (image.source == null) {
                            uRLSpec = image.getFactory().getSource(image);
                            if (image.source == null) {
                                bl = true;
                                image.source = uRLSpec;
                            }
                        }
                        new Image(image, string).write(pSOutputStream);
                        if (bl) {
                            image.source = null;
                        }
                    }
                }
                catch (ImageFormatException imageFormatException) {
                    pSOutputStream.doc.errorHandler.exception("", imageFormatException);
                }
            }
        }
    }

    public static class Test
    extends TestCase {
        ErrorHandler errorHandler = new DefaultErrorHandler();
        URLCache urlcache = new URLCache();
        FontCatalog fontCatalog;
        ImageFactory imageFactory;

        public void setUp() {
            try {
                this.fontCatalog = new FontCatalog(this.urlcache, this.errorHandler);
                this.imageFactory = new ImageFactory(this.fontCatalog, this.urlcache, this.errorHandler);
            }
            catch (IOException iOException) {
                Assert.fail((String)("Cann't create fontCatalog or imageFactory: " + iOException));
            }
            catch (FontConfigurationException fontConfigurationException) {
                Assert.fail((String)("Cannot create font catalog: " + fontConfigurationException));
            }
        }

        public void test_addImg() throws IOException, ImageFormatException, UnregisteredMIMETypeException {
            Images images = new Images();
            PSDocument pSDocument = new PSDocument((OutputStream)new ByteArrayOutputStream(), new File(User.getProperty("user.dir")), this.imageFactory, this.fontCatalog, this.errorHandler);
            pSDocument.beginPage(1.0f, 1.0f, "1");
            String string = User.getProperty("user.dir") + File.separator + "test_png.png";
            String string2 = "com/renderx/pslib/TEST_DATA/test_png.png";
            this.resourceToFile(string2, string);
            com.renderx.graphics.Image image = pSDocument.imageFactory.makeImage(new URLSpec("resource:" + string2), "image/png");
            images.addImgAndReturnId(image, pSDocument, true);
            Assert.assertTrue((images.getSize() == 1 ? 1 : 0) != 0);
            images.addImgAndReturnId(image, pSDocument, true);
            Assert.assertTrue((images.getSize() == 1 ? 1 : 0) != 0);
            String string3 = User.getProperty("user.dir") + File.separator + "test_gif.gif";
            string2 = "com/renderx/pslib/TEST_DATA/test_gif.gif";
            this.resourceToFile(string2, string3);
            image = pSDocument.imageFactory.makeImage(new URLSpec("resource:" + string2), "image/gif");
            images.addImgAndReturnId(image, pSDocument, true);
            Assert.assertTrue((images.getSize() == 2 ? 1 : 0) != 0);
            images.addImgAndReturnId(image, pSDocument, true);
            Assert.assertTrue((images.getSize() == 2 ? 1 : 0) != 0);
            pSDocument.endPage();
            pSDocument.out.close();
            new File(string).delete();
            new File(string3).delete();
        }

        private void resourceToFile(String string, String string2) throws IOException {
            int n;
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, 1024)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }
    }
}

