/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.graphics.ICCRecord;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.URLSpec;
import java.io.IOException;

public class OutputIntent
extends PDFObject {
    URLSpec url;
    private DestOutputProfile profile;
    private String subtype;

    String getType() {
        return "OutputIntent";
    }

    public OutputIntent(IndirectObject indirectObject, URLSpec uRLSpec, String string) {
        super(indirectObject);
        this.url = uRLSpec;
        this.subtype = string;
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/S " + this.subtype);
        pDFOutputStream.println("/OutputCondition (Custom)");
        pDFOutputStream.println("/OutputConditionIdentifier (Custom)");
        pDFOutputStream.println("/Info (Custom)");
        this.profile = new DestOutputProfile(pDFOutputStream.getNextID(), this.url);
        pDFOutputStream.println("/DestOutputProfile " + this.profile.getID().toStringR());
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        if (this.profile != null) {
            this.profile.write(pDFOutputStream);
        }
    }

    static class DestOutputProfile
    extends PDFObject {
        URLSpec url;
        int length;
        IndirectObject length_id;
        ICCRecord iccRecord;

        public DestOutputProfile(IndirectObject indirectObject, URLSpec uRLSpec) {
            super(indirectObject);
            this.url = uRLSpec;
        }

        void writeBody(PDFOutputStream pDFOutputStream) {
            this.iccRecord = new ICCRecord(this.url, pDFOutputStream.doc.imageFactory.cache, pDFOutputStream.doc.errorHandler);
            pDFOutputStream.println("/N " + this.iccRecord.getProfile().colorSpace);
            this.length_id = pDFOutputStream.getNextID();
            pDFOutputStream.println("/Length " + this.length_id.toStringR());
            if (pDFOutputStream.compression) {
                pDFOutputStream.println("/Filter /FlateDecode");
            }
        }

        void writeTail(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.println(">>");
            pDFOutputStream.println("stream");
            int n = pDFOutputStream.size();
            pDFOutputStream.startStream();
            try {
                this.iccRecord.copyData(pDFOutputStream.getCurrentOutputStream());
            }
            catch (IOException iOException) {
                pDFOutputStream.exception("Cannot output DestOutputProfile for '" + this.url.toString() + "'", iOException);
            }
            pDFOutputStream.finishStream();
            this.length = pDFOutputStream.size() - n;
            pDFOutputStream.println("\nendstream");
            pDFOutputStream.println("endobj");
        }

        void writeSubObjects(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.printLength(this.length_id, this.length);
        }
    }
}

