/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.XYObject;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.xep.pre.Attr;
import java.io.IOException;

public class XLine
extends XYObject {
    public static final String STYLE_SOLID = "solid";
    public static final String STYLE_DASHED = "dashed";
    public static final String STYLE_DOTTED = "dotted";
    public static Hashtable patterns = new Hashtable();
    public Point2D destination = new Point2D(0, 0);
    public int thickness = 0;
    public String style = "solid";
    private ErrorHandler logger;

    public XLine(Point2D point2D, Point2D point2D2, int n, String string, Attr.Color color, int n2, ErrorHandler errorHandler) {
        super(point2D, color, n2);
        this.destination = point2D2;
        this.thickness = n;
        this.style = string;
        this.logger = errorHandler;
    }

    public void writeToAFP(AFP aFP) throws IOException {
        try {
            aFP.setColor(this.color);
            aFP.setOrientation(this);
            int n = (this.thickness + 1) / 2;
            if (this.origin.x == this.destination.x) {
                aFP.drawVerticalRule(new Point2D(this.origin.x - n, this.origin.y).toAFPCoordinates(), new Point2D(this.destination.y - this.origin.y, this.thickness).toAFPCoordinates());
            } else {
                aFP.drawHorizontalRule(new Point2D(this.origin.x, this.origin.y - n).toAFPCoordinates(), new Point2D(this.destination.x - this.origin.x, this.thickness).toAFPCoordinates());
            }
        }
        catch (AFPInternalException aFPInternalException) {
            this.logger.warning("AFP: Object has not been printed: " + this.toString());
            aFP.rollback();
        }
    }

    public String toString() {
        return "XLine[" + this.origin.toString() + " - " + this.destination.toString() + "]";
    }

    public static XLine[] generate(int n, int n2, int n3, int n4, int n5, String string, Attr.Color color, int n6, ErrorHandler errorHandler) {
        Pattern pattern = (Pattern)patterns.get(string);
        if (pattern == null) {
            errorHandler.warning("AFP: Couldn't find pattern for line.style='" + string + "' - assuming '" + STYLE_SOLID + "'");
            pattern = (Pattern)patterns.get(STYLE_SOLID);
        }
        return XLine.generate(n, n2, n3, n4, n5, color, n6, pattern, errorHandler);
    }

    private static XLine[] generate(int n, int n2, int n3, int n4, int n5, Attr.Color color, int n6, Pattern pattern, ErrorHandler errorHandler) {
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl;
        boolean bl2 = bl = n3 == n;
        if (bl) {
            n10 = Math.min(n2, n4);
            n9 = Math.max(n2, n4);
            n8 = n;
            n7 = n3;
        } else {
            n10 = Math.min(n, n3);
            n9 = Math.max(n, n3);
            n8 = n2;
            n7 = n4;
        }
        int n11 = n9 - n10;
        int n12 = pattern.getLength(n5);
        int n13 = pattern.getLengthSolid(n5);
        int n14 = (int)Math.ceil((double)n11 / (double)n12);
        XLine[] xLineArray = new XLine[n14];
        for (int i = 0; i < n14; ++i) {
            xLineArray[i] = new XLine(new Point2D(n10 + i * n12, n8), new Point2D(n10 + i * n12 + n13, n7), n5, STYLE_SOLID, color, n6, errorHandler);
            if (i == n14 - 1) {
                xLineArray[i].adjustPatternedLine(n9, pattern.lengthSolid != 1);
            }
            if (!bl) continue;
            xLineArray[i].swapXYMe();
        }
        return xLineArray;
    }

    private void adjustPatternedLine(int n, boolean bl) {
        if (bl || this.destination.x > n) {
            this.destination.x = n;
        }
        if (this.origin.x >= this.destination.x) {
            this.origin.x = this.destination.x - 1;
        }
    }

    private void swapXYMe() {
        this.origin.swapXYMe();
        this.destination.swapXYMe();
    }

    static {
        patterns.put(STYLE_SOLID, new Pattern(1, 0));
        patterns.put(STYLE_DASHED, new Pattern(5, 3));
        patterns.put(STYLE_DOTTED, new Pattern(1, 2));
    }

    public static class Pattern {
        public int lengthSolid;
        public int lengthBlank;

        public int getLength(int n) {
            return this.lengthBlank == 0 ? 0x3FFFFFFF : (this.lengthSolid + this.lengthBlank) * n;
        }

        public int getLengthSolid(int n) {
            return this.lengthBlank == 0 ? 0x3FFFFFFF : this.lengthSolid * n;
        }

        public Pattern(int n, int n2) {
            if (n <= 0 || n2 < 0) {
                throw new RuntimeException("Bad pattern: " + n + ", " + n2);
            }
            this.lengthSolid = n;
            this.lengthBlank = n2;
        }
    }
}

