<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:docbook="http://docbook.org/ns/docbook"
	xmlns="http://docbook.org/ns/docbook"
  	version="1.0">

<xsl:output method="text" encoding="utf-8"/>

<xsl:variable name="quote">"</xsl:variable>

<xsl:variable name="newline">
<xsl:text>
</xsl:text>
</xsl:variable>

<xsl:template name="processAttributeRow">

		<!-- do not try to canonicalize name to keyword (e.g., remove apostrophes) or look it up (perhaps by tag) yet, except to remove spaces :( -->
		<!-- leave nesting level in name, since not tring to detect sequence start and and yet :( -->
		<!--<xsl:variable name="attribute"><xsl:value-of select="translate(normalize-space(docbook:td[1]/docbook:para),' ','')"/></xsl:variable>-->
		<xsl:variable name="attribute"><xsl:value-of select="normalize-space(translate(docbook:td[1]/docbook:para,'>',''))"/></xsl:variable>
		<xsl:variable name="tag"><xsl:value-of select="normalize-space(docbook:td[2]/docbook:para)"/></xsl:variable>
		<xsl:variable name="description"><xsl:value-of select="normalize-space(docbook:td[4])"/></xsl:variable>

		<xsl:text>&#x9;</xsl:text>
		<xsl:text>Name=</xsl:text>
		<xsl:value-of select="$quote"/>
		<xsl:value-of select="$attribute"/>
		<xsl:value-of select="$quote"/>

		<xsl:text>&#x9;</xsl:text>
		<xsl:text>Tag=</xsl:text>
		<xsl:value-of select="$quote"/>
		<xsl:value-of select="$tag"/>
		<xsl:value-of select="$quote"/>

		<xsl:text>&#x9;</xsl:text>
		<xsl:text>Description=</xsl:text>
		<xsl:value-of select="$quote"/>
		<xsl:value-of select="$description"/>
		<xsl:value-of select="$quote"/>

		<xsl:value-of select="$newline"/>

</xsl:template>

<xsl:template match="docbook:table">
	<xsl:choose>
		<xsl:when test="contains(docbook:caption,'Module Attributes')
					and docbook:thead/docbook:tr/docbook:th[1]/docbook:para = 'Attribute Name'
					and docbook:thead/docbook:tr/docbook:th[2]/docbook:para = 'Tag'
					and docbook:thead/docbook:tr/docbook:th[3]/docbook:para = 'Type'
					and docbook:thead/docbook:tr/docbook:th[4]/docbook:para = 'Attribute Description'">
			
			<xsl:for-each select="docbook:tbody/docbook:tr">
				<xsl:choose>
					<xsl:when test="count(docbook:td) = 4">
						<xsl:call-template name="processAttributeRow"/>
					</xsl:when>
					<!-- ignore anything esle such as Macro Inclusion -->
				</xsl:choose>
			</xsl:for-each>

			<xsl:value-of select="$newline"/>
		</xsl:when>
		<xsl:when test="contains(docbook:caption,'Macro Attributes')
					and docbook:thead/docbook:tr/docbook:th[1]/docbook:para = 'Attribute Name'
					and docbook:thead/docbook:tr/docbook:th[2]/docbook:para = 'Tag'
					and docbook:thead/docbook:tr/docbook:th[3]/docbook:para = 'Type'
					and docbook:thead/docbook:tr/docbook:th[4]/docbook:para = 'Attribute Description'">
			
			<xsl:for-each select="docbook:tbody/docbook:tr">
				<xsl:choose>
					<xsl:when test="count(docbook:td) = 4">
						<xsl:call-template name="processAttributeRow"/>
					</xsl:when>
					<!-- ignore anything esle such as Macro Inclusion -->
				</xsl:choose>
			</xsl:for-each>
			
			<xsl:value-of select="$newline"/>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template match="@*|node()">
	<xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet>
