/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.gen.backends;

import com.renderx.sax.Serializer;
import com.renderx.util.Base64OutputStream;
import com.renderx.util.Hashtable;
import com.renderx.util.URLSpec;
import com.renderx.xep.gen.H4base;
import com.renderx.xep.lib.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class H4XEP
extends H4base {
    private Serializer serializer = null;
    private boolean EMBED_IMAGES;
    private final Hashtable imageIndex = new Hashtable();
    private int imageno = 0;
    private boolean newline = false;

    public static void init() {
    }

    protected void resetDefaultOptions() {
        this.EMBED_IMAGES = false;
    }

    protected void setOption(String string, String string2) {
        if (!"EMBED_IMAGES".equals(string)) {
            this.session.warning("Unrecognized XEP output option " + string + ": setting ignored");
            return;
        }
        if ("true".equals(string2 = string2.trim().toLowerCase()) || "yes".equals(string2)) {
            this.EMBED_IMAGES = true;
        } else if ("false".equals(string2) || "no".equals(string2)) {
            this.EMBED_IMAGES = false;
        } else {
            this.session.warning("Invalid EMBED_IMAGES value: " + string2 + "; setting ignored");
        }
    }

    public H4XEP(OutputStream outputStream, Session session, Properties properties) throws IOException {
        super(outputStream, session, properties);
    }

    public String outFormat() {
        return "xep";
    }

    protected String getPropertyPrefix() {
        return "com.renderx.xep.H4XEP.";
    }

    protected String getProcessingInstructionPrefix() {
        return "xep-out-";
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        super.processingInstruction(string, string2);
        this.serializer.processingInstruction(string, string2);
        this.serializer.ignorableWhitespace("\n".toCharArray(), 0, 1);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.serializer == null) {
            try {
                this.serializer = new Serializer(this.outstream);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.serializer.startDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object var5_5 = null;
        if (!this.newline) {
            this.serializer.ignorableWhitespace("\n".toCharArray(), 0, 1);
        }
        if ("http://www.renderx.com/XEP/xep".equals(string) && string2.equals("image") || "http://www.renderx.com/XEP/xep".equals(string) && string2.equals("media-object") || "http://www.renderx.com/XEP/xep".equals(string) && string2.equals("rich-media-object") || "http://www.renderx.com/XEP/xep".equals(string) && string2.equals("rich-media-resource") || "http://www.renderx.com/XEP/xep".equals(string) && string2.equals("poster")) {
            try {
                if (this.EMBED_IMAGES) {
                    attributes = this.embedImage(attributes);
                }
            }
            catch (IOException iOException) {
                this.session.exception("Error processing image", iOException);
            }
        }
        this.serializer.startElement("http://www.renderx.com/XEP/xep", string2, string3, attributes);
        this.newline = false;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.serializer.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.serializer.ignorableWhitespace(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.serializer.endElement(string, string2, string3);
        this.serializer.ignorableWhitespace("\n".toCharArray(), 0, 1);
        this.newline = true;
    }

    public void endDocument() throws SAXException {
        this.serializer.endDocument();
        super.endDocument();
    }

    private Attributes embedImage(Attributes attributes) throws IOException {
        String string;
        URLSpec uRLSpec;
        String string2;
        String string3;
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = attributesImpl.getIndex("src");
        if (n == -1) {
            this.session.error("No source specified for an image");
            return attributes;
        }
        int n2 = attributesImpl.getIndex("embed");
        if (n2 != -1) {
            attributesImpl.setValue(n2, "true");
        }
        if ((string3 = (String)this.imageIndex.get(string2 = attributesImpl.getValue(n))) != null) {
            attributesImpl.setQName(n, "id-ref");
            attributesImpl.setLocalName(n, "id-ref");
            attributesImpl.setValue(n, string3);
            return attributesImpl;
        }
        String string4 = attributesImpl.getValue("base");
        URLSpec uRLSpec2 = uRLSpec = string4 == null ? new URLSpec(string2) : new URLSpec(new URLSpec(string4), string2);
        if (uRLSpec.scheme != 1) {
            string = attributesImpl.getValue("type");
            if (string == null) {
                string = "application/octet-stream";
            }
            InputStream inputStream = this.session.config.cache.openStream(uRLSpec, this.session);
            StringWriter stringWriter = new StringWriter();
            try {
                stringWriter.write("data:" + string + ";base64,");
                Base64OutputStream base64OutputStream = new Base64OutputStream(stringWriter);
                byte[] byArray = new byte[8192];
                int n3 = 0;
                while ((n3 = inputStream.read(byArray)) != -1) {
                    base64OutputStream.write(byArray, 0, n3);
                }
                ((OutputStream)base64OutputStream).close();
                Object var16_15 = null;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            attributesImpl.setValue(n, stringWriter.toString());
        }
        string = "image" + ++this.imageno;
        this.imageIndex.put(string2, string);
        attributesImpl.addAttribute(attributesImpl.getURI(n), "id", "id", "CDATA", string);
        return attributesImpl;
    }
}

