/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.gen.backends;

import com.renderx.afpcommon.CodePage;
import com.renderx.afplib.AFPDocument;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.HighlightColorRegistry;
import com.renderx.afplib.NOPComment;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.Tag;
import com.renderx.afplib.Util;
import com.renderx.afplib.XPage;
import com.renderx.afplib.XTrialPage;
import com.renderx.util.ErrorHandler;
import com.renderx.util.User;
import com.renderx.xep.gen.H4base;
import com.renderx.xep.gen.backends.Stamp;
import com.renderx.xep.lib.ConfigurationException;
import com.renderx.xep.lib.LicenseException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.Attr;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class H4AFP
extends H4base
implements ErrorHandler {
    private String fontsCodePage;
    private Map afpFonts;
    private Map afpFontForcedCodepages;
    private HighlightColorRegistry highlightColors;
    private ErrorHandler logger;
    private AFPDocument document = null;
    private XPage currentPage = null;
    int pageNumber = 0;
    private int currentWordSpacingDelta = 0;
    private int currentLetterSpacingDelta = 0;
    private Attr.Color currentColor = Attr.Color.RGB.create(0L);
    private String afpObject = null;
    private String objectFormat = null;
    private String srcOverride = null;
    private boolean afpObjectEmbed = true;
    private ConfigManager optionsManager;
    private ArrayList codePages;
    private int skip = 0;
    private static final String[] otherOptions = new String[]{"CODEPAGE", "COUNTERCODEPAGE", "DATATYPE"};
    private static Object[] NOP_KEYWORDS = new Object[]{new Object[]{"NOPxy_beforeBPG", new Boolean(true), new Boolean(true)}, new Object[]{"NOPxy_afterBPG", new Boolean(false), new Boolean(true)}, new Object[]{"NOP_beforeBPG", new Boolean(true), new Boolean(false)}, new Object[]{"NOP_afterBPG", new Boolean(false), new Boolean(false)}};
    private OutputStream resOutput;

    private final void initAFPFonts() {
        if (this.afpFonts == null) {
            this.afpFonts = new HashMap();
        }
    }

    private final void initHighlightColors() {
        if (this.highlightColors == null) {
            this.highlightColors = new HighlightColorRegistry();
        }
    }

    public H4AFP(OutputStream outputStream, Session session, Properties properties) throws IOException, LicenseException, ConfigurationException {
        super(outputStream, session, properties);
        this.logger = session;
        this.initAFPFonts();
        this.initHighlightColors();
        this.afpFontForcedCodepages = new HashMap();
        this.getAFPFonts(properties);
        this.getAFPFonts(User.getProperties());
        this.getHighlightColors(properties);
        this.getHighlightColors(User.getProperties());
        this.getAFPFontForcedCodepages(properties);
        this.getAFPFontForcedCodepages(User.getProperties());
        if (!session.config.AFP) {
            session.error("AFP support is not licensed for this installation.");
            throw new LicenseException("AFP support is not licensed for this installation.");
        }
        this.resOutput = null;
        if (this.optionsManager.getResourceFile() != null && this.optionsManager.getResourceFile().length() > 0) {
            this.resOutput = new FileOutputStream(this.optionsManager.getResourceFile());
        }
        if (this.fontsCodePage == null || this.fontsCodePage.length() == 0) {
            throw new ConfigurationException("AFP generator configuration option is not properly defined.");
        }
        this.document = new AFPDocument(session, this, outputStream, this.resOutput, this.highlightColors, this.optionsManager);
        this.readCodePages(properties);
        this.optionsManager.readDataTypes(properties);
    }

    private void readCodePages(Properties properties) {
        Collection<Object> collection = properties.values();
        Iterator<Object> iterator = collection.iterator();
        this.codePages = new ArrayList();
        int n = 0;
        try {
            n = (Integer)properties.get("COUNTERCODEPAGE");
        }
        catch (NullPointerException nullPointerException) {
            n = -1;
        }
        for (int i = 0; i <= n; ++i) {
            this.codePages.add(new Object());
        }
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof CodePage)) continue;
            CodePage codePage = (CodePage)object;
            this.codePages.set(codePage.codePageNumber, codePage);
        }
        CodePage codePage = new CodePage("T1V10500", "Cp500", 0, 127, true);
        if (!this.codePages.contains(codePage)) {
            this.codePages.add(codePage);
        }
    }

    protected String getProcessingInstructionPrefix() {
        return "xep-afp-";
    }

    protected String getPropertyPrefix() {
        return "com.renderx.xep.H4AFP.";
    }

    public String outFormat() {
        return "afp";
    }

    protected void resetDefaultOptions() {
        this.optionsManager = new ConfigManager(this.session);
        this.fontsCodePage = "T1V10500";
        this.optionsManager.resetOptions();
    }

    protected void setOption(String string, String string2) {
        if (!this.optionsManager.setOptionFromConfig(string, string2)) {
            this.initAFPFonts();
            this.initHighlightColors();
            if (string.equals("AFPFONT")) {
                String[] stringArray = string2.split("[\\s,]+", 2);
                if (stringArray.length == 2) {
                    this.afpFonts.put(stringArray[0], H4AFP.extractAFPFontAliases(stringArray[1]));
                }
            } else if (string.startsWith("AFPFONT,")) {
                this.afpFonts.put(string.substring(8), H4AFP.extractAFPFontAliases(string2));
            } else if (string.startsWith("HIGHLIGHTCOLOR,")) {
                this.registerHighlightColor(string.substring("HIGHLIGHTCOLOR,".length()), string2);
            } else if (!this.isOtherAcceptedOption(string)) {
                this.session.warning("Unrecognized AFP option " + string + ": setting ignored");
            }
        }
    }

    private boolean isOtherAcceptedOption(String string) {
        for (int i = 0; i < otherOptions.length; ++i) {
            if (!string.startsWith(otherOptions[i])) continue;
            return true;
        }
        return false;
    }

    public CodePage extractAFPCodePages(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        CodePage codePage = null;
        try {
            while (stringArray[n2].substring(0, 4).equals("from") && stringArray[n2 + 1].substring(0, 4).equals("till")) {
                arrayList.add(new Integer(Integer.parseInt(stringArray[n2].substring(6, 10), 16)));
                arrayList.add(new Integer(Integer.parseInt(stringArray[n2 + 1].substring(6, 10), 16)));
                n2 += 2;
            }
            codePage = new CodePage(stringArray[n2 + 1], stringArray[n2], (Integer)arrayList.get(0), (Integer)arrayList.get(1), stringArray[n2 + 2].startsWith("true"));
            if (n - n2 != 3) {
                throw new Exception();
            }
            for (n2 = 2; n2 < arrayList.size(); n2 += 2) {
                codePage.addCodeRange((Integer)arrayList.get(n2), (Integer)arrayList.get(n2 + 1));
            }
        }
        catch (Exception exception) {
            this.session.error("wrong format for AFP codepage, options ignored");
            codePage = null;
        }
        return codePage;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.document = null;
        if (this.resOutput != null) {
            try {
                this.resOutput.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.skip > 0) {
            ++this.skip;
            return;
        }
        if (!"http://www.renderx.com/XEP/xep".equals(string)) {
            this.skip = 1;
            return;
        }
        try {
            this.toLogStartElement(string2, string3, attributes);
            switch ((Short)idtab.get(string2)) {
                case 0: {
                    this.document.begin();
                    this.pageNumber = 0;
                    break;
                }
                case 1: {
                    XPage xPage = this.currentPage;
                    ++this.pageNumber;
                    XPage xPage2 = this.currentPage = this.session.config.AFPTrial && this.pageNumber > 10 && this.pageNumber % 2 == 1 ? new XTrialPage(this.document, attributes, this.fontsCodePage, this.session, this, this, this.afpFonts, this.afpFontForcedCodepages, this.optionsManager, this.codePages) : new XPage(this.document, attributes, this.fontsCodePage, this.session, this, this.afpFonts, this.afpFontForcedCodepages, this.optionsManager, this.codePages);
                    if (xPage != null) {
                        this.currentPage.setTextStyle(xPage.getCurrentStyle());
                    }
                    break;
                }
                case 10: {
                    this.currentPage.addText(attributes, this.currentColor, this.currentLetterSpacingDelta, this.currentWordSpacingDelta);
                    break;
                }
                case 9: {
                    this.currentPage.setTextStyle(attributes);
                    break;
                }
                case 16: {
                    float f = Float.parseFloat(attributes.getValue("red"));
                    float f2 = Float.parseFloat(attributes.getValue("green"));
                    float f3 = Float.parseFloat(attributes.getValue("blue"));
                    this.currentColor = Attr.Color.RGB.create(f, f2, f3);
                    break;
                }
                case 17: {
                    this.currentColor = Attr.Color.Grayscale.create(Float.parseFloat(attributes.getValue("gray")));
                    break;
                }
                case 20: {
                    this.currentColor = Attr.Color.Registration.create(Float.parseFloat(attributes.getValue("tint")));
                    break;
                }
                case 18: {
                    float f = Float.parseFloat(attributes.getValue("cyan"));
                    float f4 = Float.parseFloat(attributes.getValue("magenta"));
                    float f5 = Float.parseFloat(attributes.getValue("yellow"));
                    float f6 = Float.parseFloat(attributes.getValue("black"));
                    this.currentColor = Attr.Color.CMYK.create(f, f4, f5, f6);
                    break;
                }
                case 19: {
                    float f;
                    float f7;
                    Attr.Color.Opaque opaque = null;
                    if (attributes.getValue("alt-cyan") != null) {
                        f7 = Float.parseFloat(attributes.getValue("alt-cyan"));
                        f = Float.parseFloat(attributes.getValue("alt-magenta"));
                        float f8 = Float.parseFloat(attributes.getValue("alt-yellow"));
                        float f9 = Float.parseFloat(attributes.getValue("alt-black"));
                        opaque = Attr.Color.CMYK.create(f7, f, f8, f9);
                    } else if (attributes.getValue("alt-red") != null) {
                        f7 = Float.parseFloat(attributes.getValue("alt-red"));
                        f = Float.parseFloat(attributes.getValue("alt-green"));
                        float f10 = Float.parseFloat(attributes.getValue("alt-blue"));
                        opaque = Attr.Color.RGB.create(f7, f, f10);
                    } else if (attributes.getValue("alt-gray") != null) {
                        f7 = Float.parseFloat(attributes.getValue("alt-gray"));
                        opaque = Attr.Color.Grayscale.create(f7);
                    }
                    f7 = Float.parseFloat(attributes.getValue("tint"));
                    Attr.Color.SpotColor spotColor = Attr.Color.SpotColor.create(attributes.getValue("colorant"), opaque, f7);
                    this.currentColor = spotColor;
                    this.currentPage.registerHighlightColor(spotColor);
                    break;
                }
                case 12: {
                    if (this.optionsManager.isUseShadingPatterns() && this.shadingPatternCanBeApplied()) {
                        this.currentPage.addShadedRectangle(attributes, this.currentColor);
                        break;
                    }
                    this.currentPage.addRectangle(attributes, this.currentColor);
                    break;
                }
                case 11: {
                    this.currentPage.addLine(attributes, this.currentColor);
                    break;
                }
                case 13: {
                    this.currentPage.setupPolygon(this.currentColor, attributes);
                    break;
                }
                case 14: {
                    this.currentPage.addPoint(attributes);
                    break;
                }
                case 15: {
                    this.currentPage.addGraphic(attributes, this.session.config.imageFactory, this.afpObject, this.afpObjectEmbed);
                    this.srcOverride = null;
                    this.objectFormat = null;
                    this.afpObject = null;
                    this.afpObjectEmbed = false;
                    break;
                }
                case 7: {
                    this.currentLetterSpacingDelta = H4AFP.parseLength(attributes.getValue("value"));
                    break;
                }
                case 6: {
                    this.currentWordSpacingDelta = H4AFP.parseLength(attributes.getValue("value"));
                    break;
                }
                case 3: {
                    this.currentPage.setTranslation(attributes);
                    break;
                }
                case 2: {
                    this.currentPage.setRotation(attributes);
                    break;
                }
                case 5: {
                    this.currentPage.setClipOn(attributes);
                    break;
                }
                case 26: {
                    String string4 = attributes.getValue("value");
                    int n = H4AFP.parseLength(attributes.getValue("x"));
                    int n2 = H4AFP.parseLength(attributes.getValue("y"));
                    if (string4 != null) {
                        this.processPinpoint(string4, n, n2);
                    }
                    break;
                }
                case 27: {
                    this.skip = 1;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    break;
                }
                default: {
                    this.warning("XEP intermediate format element \"" + string2 + "\" is not supported");
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void toLogStartElement(String string, String string2, Attributes attributes) {
        if (this.optionsManager.getLogLevel() >= 3) {
            String string3 = "".equals(string) ? string2 : string;
            String string4 = "<" + string3;
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string5 = attributes.getLocalName(i);
                    if ("".equals(string5)) {
                        string5 = attributes.getQName(i);
                    }
                    string4 = string4 + " " + string5 + "=\"" + attributes.getValue(i) + "\"";
                }
            }
            this.info(string4);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.skip > 0) {
            --this.skip;
            return;
        }
        if (!"http://www.renderx.com/XEP/xep".equals(string)) {
            this.skip = 1;
            return;
        }
        switch ((Short)idtab.get(string2)) {
            case 0: {
                this.document.end();
                break;
            }
            case 1: {
                try {
                    if (this.session.config.PUT_STAMP || this.session.config.AFPTrial) {
                        Stamp.put(this, this.session);
                    }
                    this.document.beginPage(this.currentPage);
                }
                catch (AFPInternalException aFPInternalException) {
                    this.logger.error(aFPInternalException.toString());
                    System.exit(-1);
                }
                break;
            }
            case 13: {
                this.currentPage.addPolygon();
                break;
            }
            case 5: {
                this.currentPage.setClipOff();
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.logger.info("<?" + string + " " + string2 + "?>");
        String string3 = this.getProcessingInstructionPrefix();
        if (string.startsWith(string3)) {
            String string4 = string.substring(string3.length());
            if ("form-definition".equals(string4)) {
                this.document.processFormDefinition(string2);
            } else if ("page-definition".equals(string4)) {
                this.document.processPageDefinition(string2);
            } else if ("copy-group".equals(string4)) {
                this.document.processCopyGroup(string2);
            } else if ("invoke-medium-map".equals(string4) || "page-device".equals(string4)) {
                this.currentPage.addIMM(string2);
            } else {
                super.processingInstruction(string, string2);
            }
        }
    }

    private final void getAFPFonts(Properties properties) {
        String string = this.getPropertyPrefix();
        String string2 = string + "AFPFont,";
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string3.startsWith(string2)) {
                this.afpFonts.put(string3.substring(string2.length()), H4AFP.extractAFPFontAliases(properties.getProperty(string3)));
                continue;
            }
            if (!string3.startsWith("AFPFont,")) continue;
            this.afpFonts.put(string3.substring("AFPFont,".length()), H4AFP.extractAFPFontAliases(properties.getProperty(string3)));
        }
    }

    private final void getAFPFontForcedCodepages(Properties properties) {
        String string = this.getPropertyPrefix();
        String string2 = string + "AFPFontForcedCodepage,";
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            this.afpFontForcedCodepages.put(string3.substring(string2.length()), properties.getProperty(string3));
        }
    }

    private void getHighlightColors(Properties properties) {
        String string = this.getPropertyPrefix();
        String string2 = string + "HighlightColor,";
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            this.registerHighlightColor(string3.substring(string2.length()), properties.getProperty(string3));
        }
    }

    private void registerHighlightColor(String string, String string2) {
        int n = Integer.decode(string);
        try {
            String string3 = string2;
            this.highlightColors.registerColor(new Attr.Color.SpotColor(string3, null, 1), n, this.logger);
            this.session.info("Highlight color [" + string3 + "] indexed to #" + n + " (" + string.toLowerCase() + ")");
        }
        catch (AFPInternalException aFPInternalException) {
            aFPInternalException.printStackTrace();
        }
    }

    private static final String[] extractAFPFontAliases(String string) {
        String[] stringArray = new String[9];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < 9; ++i) {
            stringArray[i] = Util.name8(stringTokenizer.nextToken());
        }
        return stringArray;
    }

    private void processPinpoint(String string, int n, int n2) {
        Object[] objectArray;
        for (int i = 0; i < NOP_KEYWORDS.length; ++i) {
            Point2D point2D;
            objectArray = (Object[])NOP_KEYWORDS[i];
            Point2D point2D2 = point2D = (Boolean)objectArray[2] != false ? this.currentPage.toPageCoordinates(n, n2) : null;
            if (!this.processNOPComment((String)objectArray[0], (Boolean)objectArray[1], string, point2D)) continue;
            return;
        }
        if (this.processPageGroups(string)) {
            return;
        }
        if (this.processTLE(string)) {
            return;
        }
        if (string.startsWith("AFPObjectToken=")) {
            String[] stringArray = string.split("=");
            if (stringArray.length == 2 && (objectArray = stringArray[1].split(",")).length == 2) {
                this.afpObject = Util.name8((String)objectArray[0]);
                this.afpObjectEmbed = objectArray[1] != "discard";
                this.srcOverride = null;
                this.objectFormat = null;
                if (this.afpObject.length() > 8) {
                    this.logger.error("AFPObjectToken error : [" + this.afpObject + "] - longer than 8 characters.");
                    this.afpObject = null;
                    this.afpObjectEmbed = false;
                }
            }
            return;
        }
        this.processExternalObjectInstructions(string);
    }

    private boolean processNOPComment(String string, boolean bl, String string2, Point2D point2D) {
        if (!string2.startsWith(string)) {
            return false;
        }
        String[] stringArray = Util.splitPreservingQuotes(string2);
        if (stringArray.length == 2) {
            if (this.currentPage != null) {
                this.currentPage.addPageDecorator(new NOPComment(point2D, stringArray[1], bl));
            }
        } else {
            this.logger.error("Error in AFP NOP comment " + string2);
        }
        return true;
    }

    private boolean processPageGroups(String string) {
        boolean bl = false;
        bl = string.startsWith("PAGE_GROUP_BEGIN");
        if (!bl && !string.startsWith("PAGE_GROUP_END")) {
            return false;
        }
        String[] stringArray = string.split(",");
        if (bl) {
            if (stringArray.length == 2) {
                this.document.processPageGroupBegin(stringArray[1]);
            } else {
                this.logger.error("Error in AFP page group begin instruction " + string);
            }
        } else {
            this.document.processPageGroupEnd(stringArray.length == 2 ? stringArray[1] : "");
        }
        return true;
    }

    private boolean processTLE(String string) {
        if (string.startsWith("PAGE_TLE")) {
            String[] stringArray = string.split(",(?!(?:[^',]|[^'],[^'])+')");
            if (stringArray.length == 3) {
                if (this.currentPage != null) {
                    this.currentPage.addPageTag(new Tag(this.document.genNewTleID(), stringArray[1], stringArray[2]));
                }
            } else {
                this.logger.error("Error in AFP page TLE (tag logical element) instruction " + string);
            }
            return true;
        }
        if (string.startsWith("PAGE_GROUP_TLE")) {
            String[] stringArray = string.split(",(?!(?:[^',]|[^'],[^'])+')");
            if (stringArray.length == 3) {
                this.document.addPagegroupTLE(new Tag(this.document.genNewTleID(), stringArray[1], stringArray[2]));
            } else {
                this.logger.error("Error in AFP page group TLE (tag logical element) instruction " + string);
            }
            return true;
        }
        return false;
    }

    private void processExternalObjectInstructions(String string) {
        if (string.startsWith("LOCAL_XSL") || string.startsWith("HOST_SUBSTITUTION") || string.startsWith("LOCAL_SUBSTITUTION")) {
            String[] stringArray = string.split(",");
            if (stringArray.length < 2) {
                return;
            }
            if ("HOST_SUBSTITUTION".equals(stringArray[0]) && stringArray.length < 3) {
                return;
            }
            if ("LOCAL_SUBSTITUTION".equals(stringArray[0]) && stringArray.length < 4) {
                return;
            }
            this.afpObject = Util.name8(stringArray[1]);
            this.srcOverride = null;
            this.objectFormat = null;
            boolean bl = this.afpObjectEmbed = !"HOST_SUBSTITUTION".equals(stringArray[0]);
            if ("HOST_SUBSTITUTION".equals(stringArray[0]) || "LOCAL_SUBSTITUTION".equals(stringArray[0])) {
                this.objectFormat = stringArray[2].trim().toLowerCase();
                if ("LOCAL_SUBSTITUTION".equals(stringArray[0])) {
                    this.srcOverride = stringArray[3].trim();
                }
            }
        }
    }

    private boolean shadingPatternCanBeApplied() {
        return this.currentColor instanceof Attr.Color.Grayscale;
    }

    public void error(String string) {
        this.logger.error(string);
    }

    public void exception(String string, Exception exception) {
        this.logger.exception(string, exception);
    }

    public void info(String string) {
        if (this.optionsManager.getLogLevel() >= 2) {
            this.logger.info(string);
        }
    }

    public void warning(String string) {
        if (this.optionsManager.getLogLevel() >= 1) {
            this.logger.warning(string);
        }
    }

    public static final int parseLength(String string) {
        if (string != null) {
            return Integer.parseInt(string.trim());
        }
        return 0;
    }
}

