/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.util.SeekableInput;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class SeekableByteArrayInputStream
extends ByteArrayInputStream
implements SeekableInput {
    final int offset;
    private char[] lineBuffer;

    public SeekableByteArrayInputStream(byte[] byArray) throws IOException {
        this(byArray, 0, byArray.length);
    }

    public SeekableByteArrayInputStream(byte[] byArray, int n, int n2) throws IOException {
        super(byArray, n, n2);
        this.offset = n;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public int skipBytes(int n) throws IOException {
        if (this.pos + n > this.count) {
            n = this.count - this.pos;
        }
        if (n < 0) {
            return 0;
        }
        this.pos += n;
        return n;
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        int n;
        char[] cArray = this.lineBuffer;
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        int n2 = cArray.length;
        int n3 = 0;
        block4: while (true) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = this.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    long l = this.getFilePointer();
                    this.seek(l - 1L);
                    break block4;
                }
                default: {
                    if (--n2 < 0) {
                        cArray = new char[n3 + 128];
                        n2 = cArray.length - n3 - 1;
                        System.arraycopy(this.lineBuffer, 0, cArray, 0, n3);
                        this.lineBuffer = cArray;
                    }
                    cArray[n3++] = (char)n;
                    continue block4;
                }
            }
            break;
        }
        if (n == -1 && n3 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        StringBuffer stringBuffer = new StringBuffer(n);
        byte[] byArray = new byte[n];
        int n2 = 0;
        this.readFully(byArray, 0, n);
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(stringBuffer);
    }

    public long length() {
        return this.count;
    }

    public long getFilePointer() {
        return this.pos - this.offset;
    }

    public void seek(long l) {
        this.pos = l < 0L ? this.offset : this.offset + (int)l;
    }

    public final long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }
}

