/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.util.Hashtable;
import com.renderx.util.MIMETypeParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestCase;

public class MIMEType {
    public String type = null;
    public String subtype = null;
    public Hashtable parameters = null;

    public MIMEType(String string) throws MIMETypeParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new MIMETypeParseException("\"" + string + "\" is not a valid MIME type");
        }
        String string2 = stringTokenizer.nextToken().trim();
        int n = string2.indexOf(47);
        if (n == -1 || n == 0 || n == string2.length() - 1) {
            throw new MIMETypeParseException("\"" + string2 + "\" is not a valid MIME type");
        }
        this.type = string2.substring(0, n).trim().toLowerCase();
        this.subtype = string2.substring(n + 1).trim().toLowerCase();
        if (stringTokenizer.hasMoreTokens()) {
            this.parameters = new Hashtable();
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                n = string2.indexOf(61);
                if (n == -1 || n == 0) continue;
                String string3 = string2.substring(0, n).trim().toLowerCase();
                String string4 = string2.substring(n + 1).trim();
                if (string4.charAt(0) == '\"' && string4.charAt(string4.length() - 1) == '\"' || string4.charAt(0) == '\'' && string4.charAt(string4.length() - 1) == '\'') {
                    string4 = string4.substring(1, string4.length() - 1);
                }
                this.parameters.put(string3, string4);
            }
        }
    }

    public String toString() {
        String string = this.type + "/" + this.subtype;
        if (this.parameters != null) {
            Enumeration enumeration = this.parameters.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)this.parameters.get(string2);
                string = string + "; " + string2 + "=" + string3;
            }
        }
        return string;
    }

    public boolean matches(MIMEType mIMEType) {
        if (!this.type.equals(mIMEType.type)) {
            return false;
        }
        if (!this.subtype.equals(mIMEType.subtype)) {
            return false;
        }
        if (this.parameters == null || mIMEType.parameters == null) {
            return true;
        }
        Enumeration enumeration = this.parameters.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.parameters.get(string);
            String string3 = (String)mIMEType.parameters.get(string);
            if (string3 == null || string3.equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        char[] cArray = new char[8192];
        int n = 0;
        while (true) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                n = inputStreamReader.read(cArray);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.exit(1);
            }
            if (n < 0) {
                System.exit(0);
            }
            try {
                System.out.println(new MIMEType(new String(cArray, 0, n)).toString());
                continue;
            }
            catch (MIMETypeParseException mIMETypeParseException) {
                System.err.println(mIMETypeParseException.toString());
                continue;
            }
            break;
        }
    }

    public static class Test
    extends TestCase {
        public void testParserBasic() throws MIMETypeParseException {
            MIMEType mIMEType = new MIMEType("text/plain");
            Assert.assertEquals((String)"text", (String)mIMEType.type);
            Assert.assertEquals((String)"plain", (String)mIMEType.subtype);
            mIMEType = new MIMEType("Image/SVG+XML");
            Assert.assertEquals((String)"image", (String)mIMEType.type);
            Assert.assertEquals((String)"svg+xml", (String)mIMEType.subtype);
            mIMEType = new MIMEType("image/PNG; qs=0.7");
            Assert.assertEquals((String)"image", (String)mIMEType.type);
            Assert.assertEquals((String)"png", (String)mIMEType.subtype);
            Assert.assertEquals((Object)"0.7", (Object)mIMEType.parameters.get("qs"));
            mIMEType = new MIMEType("image/CGM; Version=4; ProfileId=WebCGM");
            Assert.assertEquals((String)"image", (String)mIMEType.type);
            Assert.assertEquals((String)"cgm", (String)mIMEType.subtype);
            Assert.assertEquals((Object)"4", (Object)mIMEType.parameters.get("version"));
            Assert.assertEquals((Object)"WebCGM", (Object)mIMEType.parameters.get("profileid"));
        }

        public void testParserExtended() throws MIMETypeParseException {
            MIMEType mIMEType = new MIMEType("image/CGM; Version='4'; ProfileId=\"WebCGM\"; Custom-Data=Extra-Data");
            Assert.assertEquals((String)"image", (String)mIMEType.type);
            Assert.assertEquals((String)"cgm", (String)mIMEType.subtype);
            Assert.assertEquals((Object)"4", (Object)mIMEType.parameters.get("version"));
            Assert.assertEquals((Object)"WebCGM", (Object)mIMEType.parameters.get("profileid"));
            Assert.assertEquals((Object)"Extra-Data", (Object)mIMEType.parameters.get("custom-data"));
            String string = " I wonder what happens with punctuations... Are they stripped? preserved? ";
            String string2 = "Every decent MIME type (like this one) _must_ have a slogan!";
            mIMEType = new MIMEType(" image / X-strange ; SLOGAN = '" + string2 + "'  ;" + "Motto = \"" + string + "\" ; ");
            Assert.assertEquals((String)"image", (String)mIMEType.type);
            Assert.assertEquals((String)"x-strange", (String)mIMEType.subtype);
            Assert.assertEquals((Object)string2, (Object)mIMEType.parameters.get("slogan"));
            Assert.assertEquals((Object)string, (Object)mIMEType.parameters.get("motto"));
        }

        public void testMatch() throws MIMETypeParseException {
            MIMEType mIMEType = new MIMEType("text/plain");
            MIMEType mIMEType2 = new MIMEType("TEXT/PLAIN");
            Assert.assertTrue((boolean)mIMEType.matches(mIMEType2));
            Assert.assertTrue((boolean)mIMEType2.matches(mIMEType));
            MIMEType mIMEType3 = new MIMEType("text/xml");
            MIMEType mIMEType4 = new MIMEType("image/plain");
            Assert.assertFalse((boolean)mIMEType3.matches(mIMEType));
            Assert.assertFalse((boolean)mIMEType2.matches(mIMEType3));
            Assert.assertFalse((boolean)mIMEType4.matches(mIMEType2));
            Assert.assertFalse((boolean)mIMEType.matches(mIMEType4));
            MIMEType mIMEType5 = new MIMEType("Text/Plain; charset=koi8");
            Assert.assertTrue((boolean)mIMEType.matches(mIMEType5));
            Assert.assertTrue((boolean)mIMEType5.matches(mIMEType));
            MIMEType mIMEType6 = new MIMEType("Text/Plain; charset=KOI8");
            Assert.assertTrue((boolean)mIMEType5.matches(mIMEType6));
            Assert.assertTrue((boolean)mIMEType6.matches(mIMEType5));
            MIMEType mIMEType7 = new MIMEType("Text/Plain; charset=windows-1251");
            Assert.assertTrue((boolean)mIMEType.matches(mIMEType7));
            Assert.assertTrue((boolean)mIMEType7.matches(mIMEType));
            Assert.assertFalse((boolean)mIMEType7.matches(mIMEType5));
            Assert.assertFalse((boolean)mIMEType5.matches(mIMEType7));
            MIMEType mIMEType8 = new MIMEType("image/CGM; ProfileId=\"WebCGM\"; copyright=\"(c) 1889-2005 The Corporation\"");
            MIMEType mIMEType9 = new MIMEType("image/CGM; ProfileId=\"WEBcgm\"; license=GPL");
            Assert.assertTrue((boolean)mIMEType8.matches(mIMEType9));
            Assert.assertTrue((boolean)mIMEType9.matches(mIMEType8));
        }
    }
}

