/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontRecord;
import com.renderx.graphics.vector.GraphicGroup;
import com.renderx.graphics.vector.OpaqueColor;
import com.renderx.graphics.vector.PaintSpec;
import com.renderx.graphics.vector.StrokeSpec;
import com.renderx.svg.SVGAttrValue;
import com.renderx.svg.SVGElement;
import com.renderx.svg.SVGParseException;
import com.renderx.svg.css.Selector;
import com.renderx.svg.css.Style;
import com.renderx.svg.css.StyleSheet;
import com.renderx.util.ErrorHandler;
import com.renderx.util.List;
import com.renderx.util.URLSpec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;

public class SVGParserContext {
    private static final int P_BASELINE_SHIFT = 1;
    private static final int P_CLIP_RULE = 2;
    private static final int P_CLIP_PATH = 3;
    private static final int P_COLOR = 4;
    private static final int P_FILL = 5;
    private static final int P_FILL_RULE = 6;
    private static final int P_FONT = 7;
    private static final int P_FONT_FAMILY = 8;
    private static final int P_FONT_SIZE = 9;
    private static final int P_FONT_SIZE_ADJUST = 10;
    private static final int P_FONT_STRETCH = 11;
    private static final int P_FONT_STYLE = 12;
    private static final int P_FONT_VARIANT = 13;
    private static final int P_FONT_WEIGHT = 14;
    private static final int P_LETTER_SPACING = 15;
    private static final int P_MARKER = 16;
    private static final int P_MARKER_END = 17;
    private static final int P_MARKER_MID = 18;
    private static final int P_MARKER_START = 19;
    private static final int P_STROKE = 20;
    private static final int P_STROKE_WIDTH = 21;
    private static final int P_STROKE_LINECAP = 22;
    private static final int P_STROKE_LINEJOIN = 23;
    private static final int P_STROKE_MITERLIMIT = 24;
    private static final int P_STROKE_DASHARRAY = 25;
    private static final int P_STROKE_DASHOFFSET = 26;
    private static final int P_TEXT_ANCHOR = 27;
    private static final int P_TEXT_DECORATION = 28;
    private static final int P_VISIBILITY = 29;
    private static final int P_WORD_SPACING = 30;
    private static final int P_XML_BASE = 31;
    private static final int P_XML_SPACE = 32;
    private static final int P_FILL_OPACITY = 33;
    private static final int P_STROKE_OPACITY = 34;
    private static final int P_OPACITY = 35;
    private static final int P_XML_LANG = 36;
    private static final int P_OVERFLOW = 37;
    private static final int P_DISPLAY = 38;
    private static final int P_STOP_COLOR = 39;
    private static final int P_STOP_OPACITY = 40;
    private static final com.renderx.util.Hashtable proptab = new com.renderx.util.Hashtable();
    private static final List primaryProperties;
    private static final com.renderx.util.Hashtable primaryPropIndex;
    public GraphicGroup curGroup = null;
    public SVGElement element = null;
    public OpaqueColor currentColor = null;
    public double fillOpacity = 1.0;
    public double strokeOpacity = 1.0;
    public double opacity = 1.0;
    public PaintSpec fill = null;
    public int fillRule = 0;
    public String clipPath = null;
    public int clipRule = 0;
    public StrokeSpec stroke = null;
    public String markerStart = null;
    public String markerMid = null;
    public String markerEnd = null;
    public double baselineShift = 0.0;
    public String fontFamily = null;
    public int fontWeight = Integer.MIN_VALUE;
    public String fontStyle = null;
    public String fontVariant = null;
    public String language = null;
    public double fontSize = 0.0;
    public double fontStretch = 0.0;
    public double letterSpacing = 0.0;
    public double wordSpacing = 0.0;
    public double textRotate = 0.0;
    public boolean preserveSpace = false;
    public boolean underline = false;
    public boolean overline = false;
    public boolean linethrough = false;
    public double stopOpacity = 1.0;
    public OpaqueColor stopColor = null;
    public FontRecord[] fonts = null;
    public URLSpec baseURL = null;
    public com.renderx.util.Hashtable classes = new com.renderx.util.Hashtable();
    public String nodeID = null;
    public boolean hidden = false;
    public final FontCatalog fontCatalog;
    protected final com.renderx.util.Hashtable fontCache;
    public static final String DEFAULT_FONT_FAMILY = "Helvetica";
    public static final double DEFAULT_FONT_SIZE = 10.0;
    public static final int OVERFLOW_HIDDEN = 0;
    public static final int OVERFLOW_VISIBLE = 1;
    public int overflow = 0;
    public static final int TEXT_ANCHOR_START = 0;
    public static final int TEXT_ANCHOR_MIDDLE = 1;
    public static final int TEXT_ANCHOR_END = 2;
    public int textAnchor = Integer.MIN_VALUE;
    public double viewportX = 0.0;
    public double viewportY = 0.0;
    public double viewportXY = 0.0;
    public SVGParserContext prev = null;
    public SVGParserContext next = null;

    public SVGParserContext(SVGParserContext sVGParserContext, URLSpec uRLSpec, FontCatalog fontCatalog, com.renderx.util.Hashtable hashtable) {
        this.prev = sVGParserContext;
        this.baseURL = uRLSpec;
        this.fontCatalog = fontCatalog;
        this.fontCache = hashtable;
        if (sVGParserContext != null) {
            sVGParserContext.next = this;
        }
    }

    public void initialize(SVGElement sVGElement, ErrorHandler errorHandler) throws SVGParseException {
        this.element = sVGElement;
        this.opacity = 1.0;
        if (this.prev == null) {
            this.currentColor = new OpaqueColor.Grayscale(0.0);
            this.fill = this.currentColor;
            this.fillRule = 0;
            this.clipPath = null;
            this.clipRule = 0;
            this.stroke = new StrokeSpec(null, new SVGAttrValue.Length((String)"1").len);
            this.stroke.lineCap = 0;
            this.stroke.lineJoin = 0;
            this.stroke.miterLimit = 4.0;
            this.stroke.dashArray = null;
            this.stroke.dashPhase = 0.0;
            this.markerStart = null;
            this.markerMid = null;
            this.markerEnd = null;
            this.fontSize = 10.0;
            this.fontFamily = DEFAULT_FONT_FAMILY;
            this.fontWeight = 400;
            this.fontStyle = "normal";
            this.fontVariant = "normal";
            this.language = "none";
            this.baselineShift = 0.0;
            this.fontStretch = 1.0;
            this.letterSpacing = 0.0;
            this.wordSpacing = 0.0;
            this.preserveSpace = false;
            this.underline = false;
            this.overline = false;
            this.linethrough = false;
            this.textAnchor = 0;
            this.textRotate = 0.0;
            this.overflow = 0;
            this.hidden = false;
            this.fillOpacity = 1.0;
            this.strokeOpacity = 1.0;
            this.stopOpacity = 1.0;
            this.stopColor = new OpaqueColor.Grayscale(0.0);
            this.selectFont(errorHandler);
        } else {
            this.nodeID = null;
            this.classes.clear();
            this.curGroup = this.prev.curGroup;
            this.fill = this.prev.fill;
            this.fillRule = this.prev.fillRule;
            this.clipPath = null;
            this.clipRule = this.prev.clipRule;
            this.stroke = this.prev.stroke;
            this.currentColor = this.prev.currentColor;
            this.markerStart = this.prev.markerStart;
            this.markerMid = this.prev.markerMid;
            this.markerEnd = this.prev.markerEnd;
            this.fonts = this.prev.fonts;
            this.fontSize = this.prev.fontSize;
            this.fontFamily = this.prev.fontFamily;
            this.fontWeight = this.prev.fontWeight;
            this.fontStyle = this.prev.fontStyle;
            this.fontVariant = this.prev.fontVariant;
            this.language = this.prev.language;
            this.baselineShift = this.prev.baselineShift;
            this.fontStretch = this.prev.fontStretch;
            this.letterSpacing = this.prev.letterSpacing;
            this.wordSpacing = this.prev.wordSpacing;
            this.baseURL = this.prev.baseURL;
            this.preserveSpace = this.prev.preserveSpace;
            this.textAnchor = this.prev.textAnchor;
            this.textRotate = this.prev.textRotate;
            this.overflow = 0;
            this.hidden = this.prev.hidden;
            this.fillOpacity = this.prev.fillOpacity;
            this.strokeOpacity = this.prev.strokeOpacity;
            this.viewportX = this.prev.viewportX;
            this.viewportY = this.prev.viewportY;
            this.viewportXY = this.prev.viewportXY;
            this.stopOpacity = this.prev.stopOpacity;
            this.stopColor = this.prev.stopColor;
        }
    }

    public static SVGParserContext createContext(SVGParserContext sVGParserContext, SVGElement sVGElement, URLSpec uRLSpec, FontCatalog fontCatalog, com.renderx.util.Hashtable hashtable, ErrorHandler errorHandler) throws SVGParseException {
        SVGParserContext sVGParserContext2 = sVGParserContext == null || sVGParserContext.next == null ? new SVGParserContext(sVGParserContext, uRLSpec, fontCatalog, hashtable) : sVGParserContext.next;
        sVGParserContext2.initialize(sVGElement, errorHandler);
        return sVGParserContext2;
    }

    public void setProperties(Attributes attributes, StyleSheet styleSheet, ErrorHandler errorHandler) throws SVGParseException {
        String string;
        Object object;
        Object object2;
        String string2;
        Object object3;
        this.nodeID = attributes.getValue("", "id");
        String string3 = attributes.getValue("", "class");
        if (string3 != null) {
            object3 = new StringTokenizer(string3);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                this.classes.put(((StringTokenizer)object3).nextToken(), "dummyobject");
            }
        }
        object3 = null;
        if (styleSheet != null) {
            object3 = new Style();
            int n = 0;
            while (n < styleSheet.size()) {
                if (SVGParserContext.matches(this, styleSheet.getSelector((int)n).nodelist)) {
                    ((Style)object3).merge(styleSheet.getStyle(n));
                }
                ++n;
            }
        }
        if ((string2 = attributes.getValue("", "style")) != null) {
            object2 = new Style(string2, errorHandler);
            if (object3 == null) {
                object3 = object2;
            } else {
                object = ((Style)object2).properties();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    ((Hashtable)object3).put(string, ((Hashtable)object2).get(string));
                }
            }
        }
        object2 = primaryProperties.elements();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            string = attributes.getValue("", (String)object);
            if (string == null && object3 != null) {
                string = ((Style)object3).getCleanValue((String)object);
            }
            if (string == null) continue;
            this.processAttribute((String)object, string, errorHandler);
        }
        if (object3 != null) {
            object2 = ((Style)object3).properties();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (primaryPropIndex.get(object) != null) continue;
                this.processAttribute((String)object, ((Style)object3).getValue((String)object), errorHandler);
            }
        }
        int n = attributes.getLength();
        while (n-- > 0) {
            string = attributes.getURI(n);
            String string4 = attributes.getLocalName(n);
            String string5 = attributes.getQName(n);
            if (string5 != null && string5.startsWith("xmlns:")) continue;
            if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
                string4 = "xml:" + string4;
                this.processAttribute(string4, attributes.getValue(n), errorHandler);
                continue;
            }
            if (!"".equals(string) || "style".equals(string4) || primaryPropIndex.get(string4) != null) continue;
            this.processAttribute(string4, attributes.getValue(n), errorHandler);
        }
    }

    private static boolean matches(SVGParserContext sVGParserContext, List list) {
        return SVGParserContext.matches(sVGParserContext, list, true);
    }

    private static boolean matches(SVGParserContext sVGParserContext, List list, boolean bl) {
        if (list.isEmpty()) {
            return true;
        }
        if (sVGParserContext == null) {
            return false;
        }
        Selector.Node node = (Selector.Node)list.car();
        if (node.elementName != null && !node.elementName.equals(sVGParserContext.element.name) || node.elementID != null && !node.elementID.equals(sVGParserContext.nodeID) || node.className != null && sVGParserContext.classes.get(node.className) == null) {
            if (bl) {
                return false;
            }
            return SVGParserContext.matches(sVGParserContext.prev, list, false);
        }
        return SVGParserContext.matches(sVGParserContext.prev, list.cdr(), false);
    }

    /*
     * Unable to fully structure code
     */
    private void processAttribute(String var1_1, String var2_2, ErrorHandler var3_3) {
        block106: {
            var4_4 = (Integer)SVGParserContext.proptab.get(var1_1);
            if (var4_4 == null) {
                return;
            }
            if (var2_2.equals("inherit")) {
                return;
            }
            try {
                switch (var4_4) {
                    case 1: {
                        var5_5 = var2_2.trim();
                        v0 = var6_10 = this.prev == null ? this.fontSize : this.prev.fontSize;
                        if (var5_5.equals("baseline")) {
                            var5_5 = "0";
                        } else if (var5_5.equals("sub")) {
                            var5_5 = "-25%";
                        } else if (var5_5.equals("super")) {
                            var5_5 = "50%";
                        }
                        this.baselineShift = this.extractLength(var5_5, var6_10);
                        break;
                    }
                    case 3: {
                        this.clipPath = SVGParserContext.getIdRef(var2_2);
                        break;
                    }
                    case 2: {
                        var5_6 = var2_2.trim();
                        if (var5_6.equals("nonzero")) {
                            this.clipRule = 0;
                            break;
                        }
                        if (var5_6.equals("evenodd")) {
                            this.clipRule = 1;
                            break;
                        }
                        throw new SVGParseException("Invalid value for 'clip-rule': \"" + var5_6 + "\"");
                    }
                    case 4: {
                        var5_7 = this.currentColor;
                        this.currentColor = null;
                        this.currentColor = new SVGAttrValue.Color(var2_2).getColorSpec(var5_7);
                        break;
                    }
                    case 38: {
                        var5_8 = "none".equals(var2_2);
                        this.hidden |= var5_8;
                        break;
                    }
                    case 5: {
                        this.fill = null;
                        this.fill = new SVGAttrValue.Paint(var2_2).getPaintSpec(this.currentColor);
                        break;
                    }
                    case 6: {
                        var6_11 = var2_2.trim();
                        if (var6_11.equals("nonzero")) {
                            this.fillRule = 0;
                            break;
                        }
                        if (var6_11.equals("evenodd")) {
                            this.fillRule = 1;
                            break;
                        }
                        throw new SVGParseException("Invalid value for 'fill-rule': \"" + var6_11 + "\"");
                    }
                    case 33: {
                        this.fillOpacity = this.parseOpacityAttribute(var2_2);
                        break;
                    }
                    case 7: {
                        var6_12 = null;
                        var7_27 = null;
                        var8_32 = "normal";
                        var9_34 = "normal";
                        var10_37 = "normal";
                        var11_39 = new StringTokenizer(var2_2);
                        while (var11_39.hasMoreTokens()) {
                            var12_40 = var11_39.nextToken();
                            if ("normal".equals(var12_40)) continue;
                            if ("italic".equals(var12_40) || "oblique".equals(var12_40) || "backslant".equals(var12_40)) {
                                var8_32 = var12_40;
                                continue;
                            }
                            if ("bold".equals(var12_40) || "bolder".equals(var12_40) || "light".equals(var12_40) || "lighter".equals(var12_40) || "100".equals(var12_40) || "200".equals(var12_40) || "300".equals(var12_40) || "400".equals(var12_40) || "500".equals(var12_40) || "600".equals(var12_40) || "700".equals(var12_40) || "800".equals(var12_40) || "900".equals(var12_40)) {
                                var9_34 = var12_40;
                                continue;
                            }
                            if ("small-caps".equals(var12_40)) {
                                var10_37 = var12_40;
                                continue;
                            }
                            var13_41 = var12_40.indexOf(47);
                            if (var13_41 != -1) {
                                var12_40 = var12_40.substring(0, var13_41);
                            }
                            var6_12 = var12_40;
                            break;
                        }
                        if (!var11_39.hasMoreTokens()) {
                            return;
                        }
                        var7_27 = var11_39.nextToken();
                        while (var11_39.hasMoreTokens()) {
                            var7_27 = var7_27 + " " + var11_39.nextToken();
                        }
                        this.processAttribute("font-family", var7_27, var3_3);
                        this.processAttribute("font-size", var6_12, var3_3);
                        this.processAttribute("font-style", var8_32, var3_3);
                        this.processAttribute("font-weight", var9_34, var3_3);
                        this.processAttribute("font-variant", var10_37, var3_3);
                        break;
                    }
                    case 8: {
                        var6_13 = var2_2.trim();
                        if (this.fontFamily.equals(var6_13)) break;
                        this.fontFamily = var6_13;
                        this.selectFont(var3_3);
                        break;
                    }
                    case 9: {
                        var6_14 = this.extractLength(var2_2, this.fontSize);
                        if (this.fontSize == var6_14) break;
                        this.fontSize = var6_14;
                        this.selectFont(var3_3);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        var6_15 = new SVGAttrValue.Enum((String)var2_2).word;
                        if ("wider".equals(var6_15)) {
                            this.fontStretch *= 1.2;
                            break;
                        }
                        if ("narrower".equals(var6_15)) {
                            this.fontStretch /= 1.2;
                            break;
                        }
                        if ("ultra-condensed".equals(var6_15)) {
                            this.fontStretch /= 2.074;
                            break;
                        }
                        if ("extra-condensed".equals(var6_15)) {
                            this.fontStretch /= 1.728;
                            break;
                        }
                        if ("condensed".equals(var6_15)) {
                            this.fontStretch /= 1.44;
                            break;
                        }
                        if ("semi-condensed".equals(var6_15)) {
                            this.fontStretch /= 1.2;
                            break;
                        }
                        if ("normal".equals(var6_15)) {
                            this.fontStretch = 1.0;
                            break;
                        }
                        if ("semi-expanded".equals(var6_15)) {
                            this.fontStretch *= 1.2;
                            break;
                        }
                        if ("expanded".equals(var6_15)) {
                            this.fontStretch *= 1.44;
                            break;
                        }
                        if ("extra-expanded".equals(var6_15)) {
                            this.fontStretch *= 1.728;
                            break;
                        }
                        if ("ultra-expanded".equals(var6_15)) {
                            this.fontStretch *= 2.074;
                            break;
                        }
                        this.fontStretch = new SVGAttrValue.Numeric((String)var2_2).num;
                        break;
                    }
                    case 12: {
                        var6_16 = new SVGAttrValue.Enum((String)var2_2).word;
                        if (this.fontStyle.equals(var6_16)) break;
                        this.fontStyle = var6_16;
                        this.selectFont(var3_3);
                        break;
                    }
                    case 13: {
                        var6_17 = new SVGAttrValue.Enum((String)var2_2).word;
                        if (this.fontVariant.equals(var6_17)) break;
                        this.fontVariant = var6_17;
                        this.selectFont(var3_3);
                        break;
                    }
                    case 14: {
                        var6_18 = var2_2.trim();
                        var7_28 = this.fontWeight;
                        if (var6_18.equals("bolder")) {
                            var7_28 += 200;
                        } else if (var6_18.equals("lighter")) {
                            var7_28 -= 200;
                        } else if (var6_18.equals("normal")) {
                            var7_28 = 400;
                        } else if (var6_18.equals("bold")) {
                            var7_28 = 700;
                        } else {
                            try {
                                var7_28 = Integer.parseInt(var6_18);
                            }
                            catch (NumberFormatException var8_33) {
                                // empty catch block
                            }
                        }
                        if (var7_28 > 900) {
                            var7_28 = 900;
                        } else if (var7_28 < 100) {
                            var7_28 = 100;
                        }
                        if (this.fontWeight == var7_28) break;
                        this.fontWeight = var7_28;
                        this.selectFont(var3_3);
                        break;
                    }
                    case 15: {
                        this.letterSpacing = this.extractLength(var2_2, this.fontSize);
                        break;
                    }
                    case 35: {
                        this.opacity = this.parseOpacityAttribute(var2_2);
                        break;
                    }
                    case 37: {
                        var6_19 = var2_2.trim();
                        if (var6_19.equals("visible")) {
                            this.overflow = 1;
                            break;
                        }
                        if (var6_19.equals("hidden")) {
                            this.overflow = 0;
                            break;
                        }
                        if (var6_19.equals("scroll")) {
                            this.overflow = 0;
                            break;
                        }
                        if (var6_19.equals("auto")) {
                            this.overflow = 0;
                            break;
                        }
                        throw new SVGParseException("Invalid value for 'overflow': \"" + var6_19 + "\"");
                    }
                    case 39: {
                        this.stopColor = new SVGAttrValue.Color(var2_2).getColorSpec(this.currentColor);
                        break;
                    }
                    case 40: {
                        this.stopOpacity = this.parseOpacityAttribute(var2_2);
                        break;
                    }
                    case 20: {
                        this.stroke = this.stroke.cc();
                        this.stroke.paint = null;
                        this.stroke.paint = new SVGAttrValue.Paint(var2_2).getPaintSpec(this.currentColor);
                        break;
                    }
                    case 21: {
                        this.stroke = this.stroke.cc();
                        this.stroke.thickness = this.extractLength(var2_2, this.viewportXY);
                        break;
                    }
                    case 22: {
                        this.stroke = this.stroke.cc();
                        var6_20 = new SVGAttrValue.Enum((String)var2_2).word;
                        if (var6_20.equals("butt")) {
                            this.stroke.lineCap = 0;
                            break;
                        }
                        if (var6_20.equals("round")) {
                            this.stroke.lineCap = 1;
                            break;
                        }
                        if (!var6_20.equals("square")) break;
                        this.stroke.lineCap = 2;
                        break;
                    }
                    case 23: {
                        this.stroke = this.stroke.cc();
                        var6_21 = new SVGAttrValue.Enum((String)var2_2).word;
                        if (var6_21.equals("miter")) {
                            this.stroke.lineJoin = 0;
                            break;
                        }
                        if (var6_21.equals("round")) {
                            this.stroke.lineJoin = 1;
                            break;
                        }
                        if (!var6_21.equals("bevel")) break;
                        this.stroke.lineJoin = 2;
                        break;
                    }
                    case 24: {
                        this.stroke = this.stroke.cc();
                        var6_22 = new SVGAttrValue.Numeric((String)var2_2).num;
                        if (var6_22 < 1.0) {
                            throw new SVGParseException("Invalid value for 'stroke-miterlimit': \"" + var6_22 + "\"");
                        }
                        this.stroke.miterLimit = var6_22;
                        break;
                    }
                    case 25: {
                        var6_23 = new Vector<Double>();
                        var7_29 = 0.0;
                        if (!"none".equals(var2_2.trim())) {
                            var9_35 = new StringTokenizer(var2_2, " \t\r\n,");
                            while (var9_35.hasMoreTokens()) {
                                var10_38 = this.extractLength(var9_35.nextToken(), this.viewportXY);
                                var7_29 += var10_38;
                                var6_23.addElement(new Double(var10_38));
                            }
                        }
                        this.stroke = this.stroke.cc();
                        if (var6_23.size() > 0 && var7_29 > 0.0) {
                            this.stroke.dashArray = new double[var6_23.size()];
                            var9_36 = 0;
                            while (var9_36 < var6_23.size()) {
                                this.stroke.dashArray[var9_36] = (Double)var6_23.elementAt(var9_36);
                                ++var9_36;
                            }
                            break;
                        }
                        this.stroke.dashArray = null;
                        break;
                    }
                    case 26: {
                        this.stroke = this.stroke.cc();
                        this.stroke.dashPhase = this.extractLength(var2_2, this.viewportXY);
                        break;
                    }
                    case 34: {
                        this.strokeOpacity = this.parseOpacityAttribute(var2_2);
                        break;
                    }
                    case 16: {
                        this.markerMid = this.markerStart = SVGParserContext.getIdRef(var2_2);
                        this.markerEnd = this.markerStart;
                        break;
                    }
                    case 19: {
                        this.markerStart = SVGParserContext.getIdRef(var2_2);
                        break;
                    }
                    case 18: {
                        this.markerMid = SVGParserContext.getIdRef(var2_2);
                        break;
                    }
                    case 17: {
                        this.markerEnd = SVGParserContext.getIdRef(var2_2);
                        break;
                    }
                    case 27: {
                        var6_24 = new SVGAttrValue.Enum((String)var2_2).word;
                        if (var6_24.equals("start")) {
                            this.textAnchor = 0;
                            break;
                        }
                        if (var6_24.equals("middle")) {
                            this.textAnchor = 1;
                            break;
                        }
                        if (!var6_24.equals("end")) break;
                        this.textAnchor = 2;
                        break;
                    }
                    case 28: {
                        var6_25 = new StringTokenizer(var2_2, " \t\r\n,");
                        while (var6_25.hasMoreTokens()) {
                            var7_30 = var6_25.nextToken();
                            if (var7_30.equals("underline")) {
                                this.underline = true;
                                continue;
                            }
                            if (var7_30.equals("overline")) {
                                this.overline = true;
                                continue;
                            }
                            if (!var7_30.equals("line-through")) continue;
                            this.linethrough = true;
                        }
                        break;
                    }
                    case 29: {
                        var6_26 = "hidden".equals(var2_2) != false || "collapse".equals(var2_2) != false;
                        this.hidden |= var6_26;
                        break;
                    }
                    case 30: {
                        this.wordSpacing = this.extractLength(var2_2, this.fontSize);
                        break;
                    }
                    case 31: {
                        try {
                            this.baseURL = new URLSpec(this.baseURL, var2_2);
                        }
                        catch (Exception var7_31) {
                            if (var3_3 == null) ** GOTO lbl333
                            var3_3.error("xml:base value ignored: cannot convert '" + var2_2 + "' to a URL: " + var7_31.toString());
                        }
lbl333:
                        // 3 sources

                        this.preserveSpace = "preserve".equals(var2_2.trim());
                        break;
                    }
                    case 32: {
                        this.preserveSpace = "preserve".equals(var2_2.trim());
                        break;
                    }
                    case 36: {
                        this.language = var2_2.trim();
                    }
                }
            }
            catch (Exception var5_9) {
                if (var3_3 == null) break block106;
                var3_3.error("SVG property " + var1_1 + "=\"" + var2_2 + "\" ignored: " + var5_9.toString());
            }
        }
    }

    public double extractLength(String string, double d) throws SVGParseException {
        SVGAttrValue.Length length = new SVGAttrValue.Length(string);
        switch (length.base) {
            case 0: {
                return length.len;
            }
            case 1: {
                return length.len * this.fontSize;
            }
            case 2: {
                double d2 = this.fonts == null || this.fonts.length == 0 ? 0.5 : (double)this.fonts[0].getMetric().xHeight / 1000.0;
                return length.len * this.fontSize * d2;
            }
            case 3: {
                return length.len * d;
            }
        }
        throw new SVGParseException("Internal error: incorrect base in a length value");
    }

    public void setViewport(double d, double d2) {
        this.viewportX = d;
        this.viewportY = d2;
        this.viewportXY = Math.sqrt((d * d + d2 * d2) / 2.0);
    }

    public void selectFont(ErrorHandler errorHandler) throws SVGParseException {
        String string = this.fontFamily + ":" + this.fontWeight + ":" + this.fontStyle + ":" + this.fontVariant + ":" + this.language;
        this.fonts = (FontRecord[])this.fontCache.get(string);
        if (this.fonts != null) {
            return;
        }
        List list = this.fontCatalog.findAll(this.fontFamily, this.fontWeight, this.fontStyle, this.fontVariant, this.language, errorHandler);
        if (list == null || list.length() == 0) {
            this.fonts = null;
            return;
        }
        this.fonts = new FontRecord[list.length()];
        Enumeration enumeration = list.elements();
        int n = 0;
        while (n < this.fonts.length) {
            this.fonts[n] = (FontRecord)enumeration.nextElement();
            ++n;
        }
        this.fontCache.put(string, this.fonts);
    }

    private double parseOpacityAttribute(String string) {
        double d = 1.0;
        String string2 = string.trim();
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    static String getIdRef(String string) {
        int n;
        if ("none".equals(string = string.trim())) {
            return null;
        }
        if (string.startsWith("url")) {
            string = string.substring(3, string.length()).trim();
        }
        if (string.startsWith("(")) {
            n = string.indexOf(")");
            string = string.substring(1, n).trim();
        }
        if (string.length() == 0) {
            return null;
        }
        n = string.indexOf(" ");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        if (!string.startsWith("#")) {
            return null;
        }
        if ((string = string.substring(1).trim()).startsWith("xpointer(id(") && string.endsWith("))")) {
            string = string.substring(12, string.length() - 2).trim();
        }
        return string;
    }

    static {
        proptab.put("baseline-shift", new Integer(1));
        proptab.put("clip-path", new Integer(3));
        proptab.put("clip-rule", new Integer(2));
        proptab.put("color", new Integer(4));
        proptab.put("display", new Integer(38));
        proptab.put("fill", new Integer(5));
        proptab.put("fill-rule", new Integer(6));
        proptab.put("fill-opacity", new Integer(33));
        proptab.put("font", new Integer(7));
        proptab.put("font-family", new Integer(8));
        proptab.put("font-size", new Integer(9));
        proptab.put("font-size-adjust", new Integer(10));
        proptab.put("font-stretch", new Integer(11));
        proptab.put("font-style", new Integer(12));
        proptab.put("font-variant", new Integer(13));
        proptab.put("font-weight", new Integer(14));
        proptab.put("letter-spacing", new Integer(15));
        proptab.put("marker", new Integer(16));
        proptab.put("marker-end", new Integer(17));
        proptab.put("marker-mid", new Integer(18));
        proptab.put("marker-start", new Integer(19));
        proptab.put("opacity", new Integer(35));
        proptab.put("overflow", new Integer(37));
        proptab.put("stop-color", new Integer(39));
        proptab.put("stop-opacity", new Integer(40));
        proptab.put("stroke", new Integer(20));
        proptab.put("stroke-width", new Integer(21));
        proptab.put("stroke-linecap", new Integer(22));
        proptab.put("stroke-linejoin", new Integer(23));
        proptab.put("stroke-miterlimit", new Integer(24));
        proptab.put("stroke-dasharray", new Integer(25));
        proptab.put("stroke-dashoffset", new Integer(26));
        proptab.put("stroke-opacity", new Integer(34));
        proptab.put("text-anchor", new Integer(27));
        proptab.put("text-decoration", new Integer(28));
        proptab.put("visibility", new Integer(29));
        proptab.put("word-spacing", new Integer(30));
        proptab.put("xml:base", new Integer(31));
        proptab.put("xml:space", new Integer(32));
        proptab.put("xml:lang", new Integer(36));
        primaryProperties = new List();
        primaryPropIndex = new com.renderx.util.Hashtable();
        primaryProperties.append("font");
        primaryProperties.append("font-family");
        primaryProperties.append("font-weight");
        primaryProperties.append("font-style");
        primaryProperties.append("font-variant");
        primaryProperties.append("font-size");
        primaryProperties.append("font-size-adjust");
        primaryProperties.append("letter-spacing");
        primaryProperties.append("text-decoration");
        primaryProperties.append("word-spacing");
        primaryProperties.append("color");
        primaryProperties.append("display");
        primaryProperties.append("visibility");
        primaryProperties.append("clip-path");
        primaryProperties.append("clip-rule");
        primaryProperties.append("opacity");
        primaryProperties.append("stop-color");
        primaryProperties.append("stop-opacity");
        primaryProperties.append("fill");
        primaryProperties.append("fill-opacity");
        primaryProperties.append("fill-rule");
        primaryProperties.append("marker");
        primaryProperties.append("marker-end");
        primaryProperties.append("marker-mid");
        primaryProperties.append("marker-start");
        primaryProperties.append("stroke");
        primaryProperties.append("stroke-dasharray");
        primaryProperties.append("stroke-dashoffset");
        primaryProperties.append("stroke-linecap");
        primaryProperties.append("stroke-linejoin");
        primaryProperties.append("stroke-miterlimitt");
        primaryProperties.append("stroke-opacity");
        primaryProperties.append("stroke-width");
        primaryProperties.append("baseline-shift");
        primaryProperties.append("text-anchor");
        primaryProperties.append("xml:lang");
        primaryPropIndex.put("font", "");
        primaryPropIndex.put("font-family", "");
        primaryPropIndex.put("font-weight", "");
        primaryPropIndex.put("font-style", "");
        primaryPropIndex.put("font-variant", "");
        primaryPropIndex.put("font-size", "");
        primaryPropIndex.put("font-size-adjust", "");
        primaryPropIndex.put("color", "");
        primaryPropIndex.put("xml:lang", "");
    }
}

