/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.sax;

import com.renderx.util.Hashtable;
import com.renderx.util.Stack;
import java.util.Enumeration;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.helpers.AttributesImpl;

public class HandlerAdapter
implements ContentHandler,
DocumentHandler {
    private DocumentHandler dh = null;
    private ContentHandler ch = null;
    Stack scopes = new Stack();
    Hashtable scope = new Hashtable();

    private String getURI(String string) throws SAXException {
        Hashtable hashtable = this.scope;
        Enumeration enumeration = this.scopes.elements();
        while (!hashtable.containsKey(string)) {
            if (!enumeration.hasMoreElements()) {
                throw new SAXException("namespace prefix '" + string + "' is not defined");
            }
            hashtable = (Hashtable)enumeration.nextElement();
        }
        return (String)hashtable.get(string);
    }

    private void startScope() {
        this.scopes.push(this.scope);
        this.scope = new Hashtable();
    }

    private void endScope() {
        this.scope = (Hashtable)this.scopes.pop();
    }

    public HandlerAdapter(DocumentHandler documentHandler) {
        this.scope.put("", "");
        this.scope.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.scope.put("xmlns", "");
        this.dh = documentHandler;
    }

    public HandlerAdapter(ContentHandler contentHandler) {
        this.scope.put("", "");
        this.scope.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.scope.put("xmlns", "");
        this.ch = contentHandler;
    }

    protected void setNamespace(String string, String string2) throws SAXException {
        this.scope.put(string, string2);
        this.ch.startPrefixMapping(string, string2);
    }

    public void setDocumentLocator(Locator locator) {
        if (this.dh != null) {
            this.dh.setDocumentLocator(locator);
        } else {
            this.ch.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.dh != null) {
            this.dh.startDocument();
        } else {
            this.ch.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.dh != null) {
            this.dh.endDocument();
        } else {
            this.ch.endDocument();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.dh != null) {
            this.dh.characters(cArray, n, n2);
        } else {
            this.ch.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.dh != null) {
            this.dh.ignorableWhitespace(cArray, n, n2);
        } else {
            this.ch.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.dh != null) {
            this.dh.processingInstruction(string, string2);
        } else {
            this.ch.processingInstruction(string, string2);
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.ch != null) {
            String string2;
            int n = attributeList.getLength();
            this.startScope();
            int n2 = 0;
            while (n2 != n) {
                string2 = attributeList.getName(n2);
                int n3 = string2.indexOf(58);
                if (n3 != -1) {
                    if ("xmlns".equals(string2.substring(0, n3))) {
                        this.setNamespace(string2.substring(n3 + 1), attributeList.getValue(n2));
                    }
                } else if ("xmlns".equals(string2)) {
                    this.setNamespace("", attributeList.getValue(n2));
                }
                ++n2;
            }
            string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n4 = string.indexOf(58);
            if (n4 != -1) {
                string2 = string.substring(0, n4);
                string5 = this.getURI(string2);
                string3 = string;
                string4 = string.substring(n4 + 1);
            } else {
                string3 = string4 = string;
                string5 = this.getURI("");
            }
            AttributesImpl attributesImpl = new AttributesImpl();
            int n5 = 0;
            while (n5 != n) {
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                String string10 = attributeList.getName(n5);
                int n6 = string10.indexOf(58);
                if (n6 != -1) {
                    string6 = string10.substring(0, n6);
                    string9 = this.getURI(string6);
                    string7 = string10;
                    string8 = string10.substring(n6 + 1);
                } else {
                    string8 = string7 = string10;
                    string9 = "";
                }
                attributesImpl.addAttribute(string9, string8, string7, attributeList.getType(n5), attributeList.getValue(n5));
                ++n5;
            }
            this.ch.startElement(string5, string4, string3, attributesImpl);
        } else {
            this.dh.startElement(string, attributeList);
        }
    }

    public void endElement(String string) throws SAXException {
        if (this.ch != null) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n = string.indexOf(58);
            if (n != -1) {
                string2 = string.substring(0, n);
                string5 = this.getURI(string2);
                string3 = string;
                string4 = string.substring(n + 1);
            } else {
                string3 = string4 = string;
                string5 = this.getURI("");
            }
            this.ch.endElement(string5, string4, string3);
            Enumeration enumeration = this.scope.keys();
            while (enumeration.hasMoreElements()) {
                this.ch.endPrefixMapping((String)enumeration.nextElement());
            }
            this.endScope();
        } else {
            this.dh.endElement(string);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.ch != null) {
            this.ch.startPrefixMapping(string, string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.ch != null) {
            this.ch.endPrefixMapping(string);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.dh != null) {
            int n = attributes.getLength();
            AttributeListImpl attributeListImpl = new AttributeListImpl();
            int n2 = 0;
            while (n2 != n) {
                attributeListImpl.addAttribute(attributes.getQName(n2), attributes.getType(n2), attributes.getValue(n2));
                ++n2;
            }
            this.dh.startElement(string3, attributeListImpl);
        } else {
            this.ch.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.dh != null) {
            this.dh.endElement(string3);
        } else {
            this.ch.endElement(string, string2, string3);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.ch != null) {
            this.ch.skippedEntity(string);
        }
    }
}

