/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.ppmllib;

import com.renderx.crypto.Hex;
import com.renderx.crypto.MD5;
import com.renderx.graphics.Image;
import com.renderx.graphics.vector.GraphicObject;
import com.renderx.sax.SAXStorage;
import com.renderx.sax.Serializer;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.xep.FOTarget;
import com.renderx.xep.FormatterImpl;
import com.renderx.xep.lib.Conf;
import com.renderx.xep.lib.ConfigurationException;
import com.renderx.xep.lib.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PPMLDocument {
    private static final String PPML_FNAME = "ppml.ppml";
    private static final String RES_PREFIX = "resources/";
    private ContentHandler generator = null;
    public final SAXStorage storage = new SAXStorage();
    public final SAXStorage pistorage = new SAXStorage();
    private String TARGET_FORMAT;
    private FormatterImpl xep = null;
    private ZipOutputStream zipout = null;
    private int pgN = 0;
    private Session session;
    private PPMLPage currentpage = null;
    private Hashtable images = new Hashtable();
    private String creator;
    private Serializer serializer = null;
    private AttributesImpl attrs = new AttributesImpl();
    private static final Hashtable ga_acces = new Hashtable();
    private ByteArrayOutputStream ppmlbaos = null;
    private static final Short GALevel_0 = new Short(0);
    private static final Short GALevel_1 = new Short(1);
    private static final Short GALevel_2 = new Short(2);
    private int GA_LEVEL;
    private boolean DEBUG_ZIP_CONTENT = false;
    private static final Hashtable TARGET_FORMATS = new Hashtable();
    private static final Hashtable ga_mime_synonymes = new Hashtable();
    static final double[] identity_matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    private double[] matrix = identity_matrix;
    private MD5 cipher = new MD5();

    private String hsh(Object object) {
        MD5 mD5 = this.cipher;
        synchronized (mD5) {
            String string = Hex.toString(this.cipher.digest(object.toString().getBytes()));
            return string;
        }
    }

    private String getMIME(String string) {
        Object object = ga_mime_synonymes.get(string);
        return object == null ? string : (String)object;
    }

    public PPMLDocument(OutputStream outputStream, String string, int n, Session session) {
        this.GA_LEVEL = n;
        this.session = session;
        this.TARGET_FORMAT = string;
        try {
            this.xep = new FormatterImplProvider(session.config);
        }
        catch (Exception exception) {
            session.error("Formatter initialization failed: " + exception.getMessage());
        }
        this.pistorage.setContentHandler(this.storage);
        try {
            if (this.GA_LEVEL > 0) {
                if ("PS".equals(string) || "XEP".equals(string)) {
                    this.pistorage.processingInstruction("xep-postscript-language-level", "3");
                }
                if ("PDF".equals(string) || "XEP".equals(string)) {
                    this.pistorage.processingInstruction("xep-pdf-pdf-version", "1.3");
                }
            }
        }
        catch (SAXException sAXException) {
            session.error("Failed to add PS or PDF level constraints as PIs into a plain new pistorage: " + sAXException.getMessage());
        }
        try {
            this.ppmlbaos = new ByteArrayOutputStream();
            this.serializer = new Serializer(this.ppmlbaos, true);
        }
        catch (IOException iOException) {
            session.error("Could not open outputppml.ppml" + iOException.getMessage());
        }
        try {
            this.zipout = new ZipOutputStream(outputStream);
        }
        catch (Exception exception) {
            session.error("Could not create zip: " + exception.getMessage());
        }
    }

    public void setDebug(boolean bl) {
        this.DEBUG_ZIP_CONTENT = bl;
    }

    public void setFormat(String string) {
        this.TARGET_FORMAT = string;
    }

    public void setGA(int n) {
        this.GA_LEVEL = n;
    }

    public void startPage(Attributes attributes) {
        this.matrix = identity_matrix;
        this.currentpage = new PPMLPage(++this.pgN, this.TARGET_FORMAT, attributes.getValue("width"), attributes.getValue("height"));
    }

    public boolean isCacheableResource(Image image) {
        Object object = ga_acces.get(this.getMIME(image.mimetype));
        if (object == null) {
            return false;
        }
        return (Short)object >= this.GA_LEVEL;
    }

    private void zip(InputStream inputStream, String string) {
        try {
            int n;
            this.zipout.putNextEntry(new ZipEntry(string));
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                this.zipout.write(byArray, 0, n);
            }
            this.zipout.closeEntry();
            inputStream.close();
            this.zipout.flush();
            if (this.DEBUG_ZIP_CONTENT) {
                this.session.info(string + " added");
            }
        }
        catch (IOException iOException) {
            this.session.error("Could not add image to zip: " + iOException.getMessage());
        }
    }

    public void placeImage(Image image, String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = this.hsh(image.source == null ? image.getFactory().getSource(image) : image.source);
        if (!this.images.containsKey(string7)) {
            this.images.put(string7, RES_PREFIX + string7);
            try {
                this.zip(image.openImageStream(), RES_PREFIX + string7);
            }
            catch (IOException iOException) {
                this.session.error("Could not open image stream for " + image);
            }
        }
        double[] dArray = new double[6];
        System.arraycopy(this.matrix, 0, dArray, 0, 6);
        this.currentpage.pageimages.append(new PPMLImage(RES_PREFIX + string7, this.getMIME(image.mimetype), string, string2, string3, string4, string5, string6, dArray));
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public void startDocument() throws SAXException {
        this.serializer.startDocument();
        this.serializer.startElement("", "!DOCTYPE PPML PUBLIC \"-//PODi//DTD PPML 2.20//EN\" \"http://www.podi.org/ppml/ppml220.dtd\"", "", null);
        this.attrs.clear();
        this.attrs.addAttribute("", "xmlns", "xmlns", "CDATA", "urn://www.podi.org/ppml/ppml2");
        this.attrs.addAttribute("", "xmlns:xsi", "xmlns:xsi", "CDATA", "http://www.w3.org/2001/XMLSchema-instance");
        this.attrs.addAttribute("", "xsi:schemaLocation", "xsi:schemaLocation", "CDATA", "urn://www.podi.org/ppml/ppml2 http://www.podi.org/ppml/ppml220.xsd");
        this.attrs.addAttribute("", "Version", "", "CDATA", "2.2");
        this.attrs.addAttribute("", "Creator", "", "CDATA", this.creator);
        this.attrs.addAttribute("", "ResourcesIncluded", "", "CDATA", "Yes");
        this.serializer.startElement("", "PPML", "", this.attrs);
        if (this.GA_LEVEL > 0) {
            this.attrs.clear();
            this.attrs.addAttribute("", "Subset", "", "CDATA", "GA");
            this.attrs.addAttribute("", "Level", "", "CDATA", "" + this.GA_LEVEL);
            this.serializer.startElement("", "CONFORMANCE", "", this.attrs);
            this.serializer.endElement("", "CONFORMANCE", "");
        }
        this.serializer.startElement("", "DOCUMENT_SET", "", null);
        this.attrs.clear();
        this.attrs.addAttribute("", "DocumentCopies", "", "CDATA", "1");
        this.serializer.startElement("", "DOCUMENT", "", this.attrs);
    }

    public void endDocument() throws SAXException {
        this.serializer.endElement("", "DOCUMENT", "");
        this.serializer.endElement("", "DOCUMENT_SET", "");
        this.serializer.endElement("", "PPML", "");
        this.serializer.endDocument();
        try {
            this.ppmlbaos.close();
            this.zip(new ByteArrayInputStream(this.ppmlbaos.toByteArray()), PPML_FNAME);
            this.zipout.close();
        }
        catch (IOException iOException) {
            this.session.error("Could not close the file ppml.ppml: " + iOException.getMessage());
        }
    }

    public void endPage() throws SAXException {
        this.currentpage.print();
        this.currentpage = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = ("P-" + this.pgN + "." + this.TARGET_FORMAT).toLowerCase();
        try {
            this.generator = this.xep.createGenerator(new FOTarget(byteArrayOutputStream, this.TARGET_FORMAT));
        }
        catch (Exception exception) {
            this.session.error("Could not create " + this.TARGET_FORMAT + " generator: " + exception.getMessage());
        }
        try {
            this.storage.setContentHandler(this.generator);
        }
        catch (Exception exception) {
            this.session.error("Could not setContentHandler: " + exception.getMessage());
        }
        try {
            this.storage.play();
        }
        catch (Exception exception) {
            this.session.error("Could not play: " + exception.getMessage());
        }
        try {
            this.storage.clear();
        }
        catch (Exception exception) {
            this.session.error("Could not clear: " + exception.getMessage());
        }
        try {
            byteArrayOutputStream.close();
            this.zip(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), string);
        }
        catch (IOException iOException) {
            this.session.error("Could not close the resulting single-page document: " + iOException.getMessage());
        }
        this.generator = null;
    }

    public static final float parseFloat(String string) {
        return Float.valueOf(string).floatValue();
    }

    public static final float parseLength(String string) {
        return PPMLDocument.parseFloat(string) / 1000.0f;
    }

    public static final float parseAngle(String string) {
        return PPMLDocument.parseFloat(string);
    }

    public void translate(float f, float f2) {
        this.transform(1.0f, 0.0f, 0.0f, 1.0f, f, f2);
    }

    public void rotate(float f) {
        float f2;
        float f3;
        if (f == 0.0f) {
            return;
        }
        if (f == 90.0f) {
            f3 = 1.0f;
            f2 = 0.0f;
        } else if (f == 180.0f) {
            f3 = 0.0f;
            f2 = -1.0f;
        } else if (f == 270.0f) {
            f3 = -1.0f;
            f2 = 0.0f;
        } else {
            double d = (double)f * Math.PI / 180.0;
            f2 = (float)Math.cos(d);
            f3 = (float)Math.sin(d);
        }
        this.transform(f2, f3, -f3, f2, 0.0f, 0.0f);
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.matrix = GraphicObject.transform(this.matrix, f, f2, f3, f4, f5, f6);
    }

    private String printmx(double[] dArray) {
        String string = "";
        int n = 0;
        while (n < 6) {
            string = string + dArray[n] + " ";
            ++n;
        }
        return string;
    }

    static {
        ga_acces.put("application/postscript", GALevel_2);
        ga_acces.put("application/pdf", GALevel_2);
        ga_acces.put("application/vnd.hp-PCL", GALevel_0);
        ga_acces.put("application/vnd.hp-PCLXL", GALevel_0);
        ga_acces.put("application/vnd.ibm.modcap", GALevel_0);
        ga_acces.put("image/tiff", GALevel_2);
        ga_acces.put("image/jpeg", GALevel_2);
        ga_acces.put("image/gif", GALevel_0);
        ga_acces.put("image/svg-xml", GALevel_0);
        ga_mime_synonymes.put("image/jpg", "image/jpeg");
        ga_mime_synonymes.put("image/jpeg", "image/jpeg");
        ga_mime_synonymes.put("image/svg+xml", "image/svg-xml");
        ga_mime_synonymes.put("image/svg", "image/svg-xml");
        ga_mime_synonymes.put("image/tif", "image/tiff");
        TARGET_FORMATS.put("XEP", "application/xepout");
        TARGET_FORMATS.put("PS", "application/postscript");
        TARGET_FORMATS.put("PDF", "application/pdf");
    }

    class PPMLPage {
        float X;
        float Y;
        int pgN;
        String fmt;
        String src;
        List pageimages = new List();

        PPMLPage(int n, String string, String string2, String string3) {
            this.X = PPMLDocument.parseLength(string2);
            this.Y = PPMLDocument.parseLength(string3);
            this.pgN = n;
            this.fmt = (String)TARGET_FORMATS.get(string);
            this.src = ("P-" + n + "." + string).toLowerCase();
        }

        void print() throws SAXException {
            PPMLDocument.this.serializer.startElement("", "PAGE", "", null);
            PPMLDocument.this.attrs.clear();
            PPMLDocument.this.attrs.addAttribute("", "TrimBox", "", "CDATA", "0 0 " + this.X + " " + this.Y);
            PPMLDocument.this.serializer.startElement("", "PAGE_DESIGN", "", PPMLDocument.this.attrs);
            PPMLDocument.this.serializer.endElement("", "PAGE_DESIGN", "");
            PPMLDocument.this.attrs.clear();
            PPMLDocument.this.attrs.addAttribute("", "Position", "", "CDATA", "0 0");
            PPMLDocument.this.serializer.startElement("", "MARK", "", PPMLDocument.this.attrs);
            PPMLDocument.this.serializer.startElement("", "OBJECT", "", PPMLDocument.this.attrs);
            PPMLDocument.this.attrs.clear();
            PPMLDocument.this.attrs.addAttribute("", "Format", "", "CDATA", this.fmt);
            PPMLDocument.this.attrs.addAttribute("", "Dimensions", "", "CDATA", this.X + " " + this.Y);
            PPMLDocument.this.serializer.startElement("", "SOURCE", "", PPMLDocument.this.attrs);
            PPMLDocument.this.attrs.clear();
            PPMLDocument.this.attrs.addAttribute("", "Src", "", "CDATA", this.src);
            PPMLDocument.this.serializer.startElement("", "EXTERNAL_DATA", "", PPMLDocument.this.attrs);
            PPMLDocument.this.serializer.endElement("", "EXTERNAL_DATA", "");
            PPMLDocument.this.serializer.endElement("", "SOURCE", "");
            PPMLDocument.this.serializer.endElement("", "OBJECT", "");
            PPMLDocument.this.serializer.endElement("", "MARK", "");
            Enumeration enumeration = this.pageimages.elements();
            while (enumeration.hasMoreElements()) {
                ((PPMLImage)enumeration.nextElement()).print();
            }
            PPMLDocument.this.serializer.endElement("", "PAGE", "");
        }
    }

    class PPMLImage {
        String f_name;
        String type;
        float x_from;
        float y_from;
        float scale_x;
        float scale_y;
        float width;
        float hight;
        double[] mx;

        PPMLImage(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, double[] dArray) {
            this.f_name = string;
            this.type = string2;
            this.x_from = PPMLDocument.parseLength(string3);
            this.y_from = PPMLDocument.parseLength(string4);
            this.scale_x = Float.valueOf(string5).floatValue();
            this.scale_y = Float.valueOf(string6).floatValue();
            this.width = PPMLDocument.parseLength(string7);
            this.hight = PPMLDocument.parseLength(string8);
            this.mx = dArray;
        }

        void print() throws SAXException {
            PPMLDocument.this.attrs.clear();
            PPMLDocument.this.attrs.addAttribute("", "Position", "", "CDATA", "0 0");
            PPMLDocument.this.serializer.startElement("", "MARK", "", PPMLDocument.this.attrs);
            PPMLDocument.this.attrs.clear();
            PPMLDocument.this.serializer.startElement("", "VIEW", "", PPMLDocument.this.attrs);
            PPMLDocument.this.attrs.clear();
            PPMLDocument.this.attrs.addAttribute("", "Matrix", "", "CDATA", PPMLDocument.this.printmx(this.mx));
            PPMLDocument.this.serializer.startElement("", "TRANSFORM", "", PPMLDocument.this.attrs);
            PPMLDocument.this.serializer.endElement("", "TRANSFORM", "");
            PPMLDocument.this.serializer.endElement("", "VIEW", "");
            PPMLDocument.this.attrs.clear();
            PPMLDocument.this.attrs.addAttribute("", "Position", "", "CDATA", this.x_from + " " + this.y_from);
            PPMLDocument.this.serializer.startElement("", "OBJECT", "", PPMLDocument.this.attrs);
            PPMLDocument.this.attrs.clear();
            PPMLDocument.this.attrs.addAttribute("", "Format", "", "CDATA", this.type);
            PPMLDocument.this.attrs.addAttribute("", "Dimensions", "", "CDATA", this.width + " " + this.hight);
            PPMLDocument.this.serializer.startElement("", "SOURCE", "", PPMLDocument.this.attrs);
            PPMLDocument.this.attrs.clear();
            PPMLDocument.this.attrs.addAttribute("", "Src", "", "CDATA", this.f_name);
            PPMLDocument.this.serializer.startElement("", "EXTERNAL_DATA", "", PPMLDocument.this.attrs);
            PPMLDocument.this.serializer.endElement("", "EXTERNAL_DATA", "");
            PPMLDocument.this.serializer.endElement("", "SOURCE", "");
            if ((double)this.scale_x != 1.0 || (double)this.scale_y != 1.0) {
                PPMLDocument.this.attrs.clear();
                PPMLDocument.this.serializer.startElement("", "VIEW", "", PPMLDocument.this.attrs);
                PPMLDocument.this.attrs.clear();
                PPMLDocument.this.attrs.addAttribute("", "Matrix", "", "CDATA", this.scale_x + " 0 0 " + this.scale_y + " 0 0");
                PPMLDocument.this.serializer.startElement("", "TRANSFORM", "", PPMLDocument.this.attrs);
                PPMLDocument.this.serializer.endElement("", "TRANSFORM", "");
                PPMLDocument.this.serializer.endElement("", "VIEW", "");
            }
            PPMLDocument.this.serializer.endElement("", "OBJECT", "");
            PPMLDocument.this.serializer.endElement("", "MARK", "");
        }
    }

    private final class FormatterImplProvider
    extends FormatterImpl {
        FormatterImplProvider(Conf conf) throws ConfigurationException {
            super(conf);
        }
    }
}

