/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.graphics.TIFFFaxDecoder;
import com.renderx.util.Hashtable;
import com.renderx.util.LZWDecoderStream;
import com.renderx.util.SeekableInput;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TIFFImage
extends BitmapImage {
    public long offsetAdjustment = 0L;
    public boolean isEXIF = false;
    private long t4options = 0L;
    private long t6options = 0L;
    private int fillOrder = 1;
    private int samplesPerPixel = 1;
    private boolean isTiled = false;
    private int tileWidth = 0;
    private int tileHeight = 0;
    private int rowsPerStrip = Integer.MAX_VALUE;
    public static final Integer TIFF_TAG_IMAGE_WIDTH = new Integer(256);
    public static final Integer TIFF_TAG_IMAGE_LENGTH = new Integer(257);
    public static final Integer TIFF_TAG_BITS_PER_SAMPLE = new Integer(258);
    public static final Integer TIFF_TAG_COMPRESSION = new Integer(259);
    public static final Integer TIFF_TAG_PHOTOMETRIC_INTERPRETATION = new Integer(262);
    public static final Integer TIFF_TAG_FILL_ORDER = new Integer(266);
    public static final Integer TIFF_TAG_STRIP_OFFSETS = new Integer(273);
    public static final Integer TIFF_TAG_ORIENTATION = new Integer(274);
    public static final Integer TIFF_TAG_SAMPLES_PER_PIXEL = new Integer(277);
    public static final Integer TIFF_TAG_ROWS_PER_STRIP = new Integer(278);
    public static final Integer TIFF_TAG_STRIP_BYTE_COUNTS = new Integer(279);
    public static final Integer TIFF_TAG_X_RESOLUTION = new Integer(282);
    public static final Integer TIFF_TAG_Y_RESOLUTION = new Integer(283);
    public static final Integer TIFF_TAG_PLANAR_CONFIGURATION = new Integer(284);
    public static final Integer TIFF_TAG_T4_OPTIONS = new Integer(292);
    public static final Integer TIFF_TAG_T6_OPTIONS = new Integer(293);
    public static final Integer TIFF_TAG_RESOLUTION_UNIT = new Integer(296);
    public static final Integer TIFF_TAG_PREDICTOR = new Integer(317);
    public static final Integer TIFF_TAG_COLORMAP = new Integer(320);
    public static final Integer TIFF_TAG_TILE_WIDTH = new Integer(322);
    public static final Integer TIFF_TAG_TILE_LENGTH = new Integer(323);
    public static final Integer TIFF_TAG_TILE_OFFSETS = new Integer(324);
    public static final Integer TIFF_TAG_TILE_BYTE_COUNTS = new Integer(325);
    public static final Integer TIFF_TAG_EXTRA_SAMPLES = new Integer(338);
    public static final Integer TIFF_TAG_SAMPLE_FORMAT = new Integer(339);
    public static final Integer TIFF_TAG_S_MIN_SAMPLE_VALUE = new Integer(340);
    public static final Integer TIFF_TAG_S_MAX_SAMPLE_VALUE = new Integer(341);
    public static final Hashtable tagNames = new Hashtable();
    public static final int TIFF_DATATYPE_BYTE = 1;
    public static final int TIFF_DATATYPE_ASCII = 2;
    public static final int TIFF_DATATYPE_SHORT = 3;
    public static final int TIFF_DATATYPE_LONG = 4;
    public static final int TIFF_DATATYPE_RATIONAL = 5;
    public static final int TIFF_DATATYPE_SBYTE = 6;
    public static final int TIFF_DATATYPE_UNDEFINED = 7;
    public static final int TIFF_DATATYPE_SSHORT = 8;
    public static final int TIFF_DATATYPE_SLONG = 9;
    public static final int TIFF_DATATYPE_SRATIONAL = 10;
    public static final int TIFF_DATATYPE_FLOAT = 11;
    public static final int TIFF_DATATYPE_DOUBLE = 12;
    public static final String[] dataTypeNames;
    public static final int TIFF_COMPRESSION_NONE = 1;
    public static final int TIFF_COMPRESSION_FAX_G3_1D = 2;
    public static final int TIFF_COMPRESSION_FAX_G3_2D = 3;
    public static final int TIFF_COMPRESSION_FAX_G4_2D = 4;
    public static final int TIFF_COMPRESSION_LZW = 5;
    public static final int TIFF_COMPRESSION_PACKBITS = 32773;
    private static final int TIFF_IMAGETYPE_REVERSE_MONOCHROME = 0;
    private static final int TIFF_IMAGETYPE_MONOCHROME = 1;
    private static final int TIFF_IMAGETYPE_RGB = 2;
    private static final int TIFF_IMAGETYPE_PALETTE = 3;
    private static final int TIFF_IMAGETYPE_TRANSPARENCY_MASK = 4;
    private static final int TIFF_IMAGETYPE_SEPARATED = 5;
    private static final int TIFF_EXTRASAMPLES_UNSPECIFIED = 0;
    private static final int TIFF_EXTRASAMPLES_ASSOCIATED_ALPHA = 1;
    private static final int TIFF_EXTRASAMPLES_UNASSOCIATED_ALPHA = 2;
    public static final String[] imageTypeNames;
    public static final int UNIT_NONE = 1;
    public static final int UNIT_IN = 2;
    public static final int UNIT_CM = 3;
    public static final int INTERLEAVED_PLANES = 1;
    public static final int SEPARATE_PLANES = 2;
    public static final int TIFF_PREDICTOR_NONE = 1;
    public static final int TIFF_PREDICTOR_DIFFERENCING = 2;
    public static final int TIFF_NORMAL_FILL_ORDER = 1;
    public static final int TIFF_REVERSED_FILL_ORDER = 2;
    Hashtable ifd = new Hashtable();

    public TIFFImage() {
        this.mimetype = "image/tiff";
    }

    public TIFFImage(Image image, long l) {
        this();
        this.source = image.source;
        this.factory = image.factory;
        this.offsetAdjustment = l;
    }

    public TIFFImage(long l, boolean bl) {
        this();
        this.offsetAdjustment = l;
        this.isEXIF = bl;
    }

    public void parse() throws IOException, ImageFormatException {
        SeekableInput seekableInput = this.openSeekableImageStream();
        this.parse(seekableInput);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(SeekableInput seekableInput) throws IOException, ImageFormatException {
        try {
            block85: {
                block87: {
                    block86: {
                        int n;
                        int[] nArray;
                        int n2;
                        seekableInput.seek(this.offsetAdjustment);
                        byte[] byArray = new byte[2];
                        seekableInput.readFully(byArray);
                        if (byArray[0] == 73 && byArray[1] == 73) {
                            this.usesBigEndian = false;
                        } else {
                            if (byArray[0] != 77) throw new ImageFormatException("Invalid byte order mark in TIFF image " + this.toDisplayString());
                            if (byArray[1] != 77) throw new ImageFormatException("Invalid byte order mark in TIFF image " + this.toDisplayString());
                            this.usesBigEndian = true;
                        }
                        if (this.readShort(seekableInput) != 42) {
                            throw new ImageFormatException("Invalid signature in TIFF image " + this.toDisplayString());
                        }
                        long l = this.readUnsignedInt(seekableInput);
                        if (l == 0L) {
                            throw new ImageFormatException("No IFD in TIFF image " + this.toDisplayString());
                        }
                        seekableInput.seek(l + this.offsetAdjustment);
                        int n3 = this.readUnsignedShort(seekableInput);
                        while (true) {
                            if (n3-- <= 0) {
                                if (!this.ifd.isEmpty()) break;
                                throw new ImageFormatException("No IFD entries in TIFF image " + this.toDisplayString());
                            }
                            int n4 = this.readUnsignedShort(seekableInput);
                            int n5 = this.readUnsignedShort(seekableInput);
                            int n6 = this.readInt(seekableInput);
                            byte[] byArray2 = new byte[4];
                            seekableInput.readFully(byArray2);
                            new IFDEntry(n4, n5, n6, byArray2);
                        }
                        IFDEntry iFDEntry = null;
                        double d = 0.0;
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_X_RESOLUTION);
                        if (iFDEntry != null) {
                            d = iFDEntry.getRational(seekableInput);
                        }
                        double d2 = 0.0;
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_Y_RESOLUTION);
                        if (iFDEntry != null) {
                            d2 = iFDEntry.getRational(seekableInput);
                        }
                        if (d == 0.0) {
                            d = d2;
                        }
                        if (d2 == 0.0) {
                            d2 = d;
                        }
                        if (d != 0.0 && d2 != 0.0) {
                            n2 = 2;
                            iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_RESOLUTION_UNIT);
                            if (iFDEntry != null) {
                                n2 = (int)iFDEntry.getInteger();
                            }
                            switch (n2) {
                                case 2: {
                                    this.horzResolution = d;
                                    this.vertResolution = d2;
                                    this.noResolution = false;
                                    break;
                                }
                                case 3: {
                                    this.horzResolution = 2.54 * d;
                                    this.vertResolution = 2.54 * d2;
                                    this.noResolution = false;
                                    break;
                                }
                                case 1: {
                                    double d3 = Math.sqrt(d2 / d);
                                    this.horzResolution /= d3;
                                    this.vertResolution *= d3;
                                    this.noResolution = false;
                                    break;
                                }
                                default: {
                                    throw new ImageFormatException("Incorrect resolution unit in TIFF image " + this.toDisplayString());
                                }
                            }
                        }
                        if (this.isEXIF) break block85;
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_IMAGE_WIDTH);
                        if (iFDEntry == null) {
                            throw new ImageFormatException("Cannot read image width in TIFF image " + this.toDisplayString());
                        }
                        this.pxWidth = (int)iFDEntry.getInteger();
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_IMAGE_LENGTH);
                        if (iFDEntry == null) {
                            throw new ImageFormatException("Cannot read image length in TIFF image " + this.toDisplayString());
                        }
                        this.pxHeight = (int)iFDEntry.getInteger();
                        this.setDimensions();
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_PHOTOMETRIC_INTERPRETATION);
                        if (iFDEntry == null) {
                            throw new ImageFormatException("Cannot determine image type: no PhotometricInterpretation tag in TIFF image " + this.toDisplayString());
                        }
                        n2 = (int)iFDEntry.getInteger();
                        switch (n2) {
                            case 0: {
                                this.colorSpace = (short)5;
                                break;
                            }
                            case 1: {
                                this.colorSpace = (short)4;
                                break;
                            }
                            case 2: {
                                this.colorSpace = 1;
                                break;
                            }
                            case 3: {
                                this.colorSpace = (short)6;
                                break;
                            }
                            case 5: {
                                this.colorSpace = (short)2;
                                break;
                            }
                            default: {
                                throw new ImageFormatException("Unsupported image type (" + n2 + ") in TIFF image " + this.toDisplayString());
                            }
                        }
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_ORIENTATION);
                        if (iFDEntry != null && iFDEntry.getInteger() != 1L) {
                            throw new ImageFormatException("Cannot handle data with orientation other than top-down left-right in TIFF image " + this.toDisplayString());
                        }
                        int n7 = 1;
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_COMPRESSION);
                        if (iFDEntry != null) {
                            n7 = (int)iFDEntry.getInteger();
                        }
                        switch (n7) {
                            case 1: {
                                this.compressionMethod = 0;
                                break;
                            }
                            case 32773: {
                                this.compressionMethod = 1;
                                break;
                            }
                            case 2: {
                                this.compressionMethod = (short)4;
                                break;
                            }
                            case 3: {
                                this.compressionMethod = (short)5;
                                iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_T4_OPTIONS);
                                if (iFDEntry == null) break;
                                this.t4options = iFDEntry.getInteger();
                                break;
                            }
                            case 4: {
                                this.compressionMethod = (short)6;
                                iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_T6_OPTIONS);
                                if (iFDEntry == null) break;
                                this.t6options = iFDEntry.getInteger();
                                break;
                            }
                            case 5: {
                                this.compressionMethod = (short)8;
                                iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_PREDICTOR);
                                if (iFDEntry == null || iFDEntry.getInteger() != 2L) break;
                                this.predictor = 1;
                                break;
                            }
                            default: {
                                throw new ImageFormatException("Unsupported compression scheme (" + n7 + ") in TIFF image " + this.toDisplayString());
                            }
                        }
                        int n8 = 0;
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_EXTRA_SAMPLES);
                        if (iFDEntry != null) {
                            n8 = (int)iFDEntry.getInteger();
                        }
                        switch (n8) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                throw new ImageFormatException("Interleaved alpha channel unsupported in TIFF image " + this.toDisplayString());
                            }
                            case 2: {
                                throw new ImageFormatException("Soft matte unsupported in TIFF image " + this.toDisplayString());
                            }
                            default: {
                                throw new ImageFormatException("Unsupported extra component scheme (" + n7 + ") in TIFF image " + this.toDisplayString());
                            }
                        }
                        int n9 = 1;
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_PLANAR_CONFIGURATION);
                        if (iFDEntry != null) {
                            n9 = (int)iFDEntry.getInteger();
                        }
                        if ((iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_SAMPLES_PER_PIXEL)) != null) {
                            this.samplesPerPixel = (int)iFDEntry.getInteger();
                        }
                        int n10 = this.samplesPerPixel - n8;
                        switch (this.colorSpace) {
                            case 1: {
                                if (n10 != 3) throw new ImageFormatException("RGB image cannot have " + n10 + " samples per pixel in TIFF image " + this.toDisplayString());
                                break;
                            }
                            case 2: {
                                if (n10 != 4) throw new ImageFormatException("Non-CMYK separated image (" + n10 + " samples per pixel) in TIFF image " + this.toDisplayString());
                                break;
                            }
                            default: {
                                if (n10 != 1) throw new ImageFormatException("Don't know how to handle " + imageTypeNames[n2] + " with " + n10 + " samples per pixel in TIFF image " + this.toDisplayString());
                                break;
                            }
                        }
                        if (n9 == 2 && this.samplesPerPixel > 1) {
                            throw new ImageFormatException("Separate color planes unsupported in TIFF image " + this.toDisplayString());
                        }
                        this.bitsPerComponent = 1;
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_BITS_PER_SAMPLE);
                        if (iFDEntry == null) {
                            if (this.colorSpace != 5 && this.colorSpace != 4) {
                                throw new ImageFormatException("BitsPerSample tag is required for image type " + imageTypeNames[n2] + " in TIFF image " + this.toDisplayString());
                            }
                        } else {
                            if (iFDEntry.count != this.samplesPerPixel && this.factory.errHandler != null) {
                                this.factory.errHandler.warning("Number of BitsPerSample entries does not match SamplesPerPixel in TIFF image " + this.toDisplayString());
                            }
                            if (iFDEntry.count == 1) {
                                this.bitsPerComponent = (int)iFDEntry.getInteger();
                                if (this.bitsPerComponent != 1 && this.bitsPerComponent != 2 && this.bitsPerComponent != 4 && this.bitsPerComponent != 8) {
                                    throw new ImageFormatException("Cannot handle data with " + this.bitsPerComponent + " bits per sample in TIFF image " + this.toDisplayString());
                                }
                            } else {
                                nArray = iFDEntry.getIntegerArray(seekableInput);
                                n = 0;
                                while (true) {
                                    if (n >= nArray.length) {
                                        this.bitsPerComponent = nArray[0];
                                        break;
                                    }
                                    if (nArray[n] != 8) {
                                        throw new ImageFormatException(imageTypeNames[n2] + " with bit depth other than 8 are not supported in TIFF image " + this.toDisplayString());
                                    }
                                    ++n;
                                }
                            }
                        }
                        if ((iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_SAMPLE_FORMAT)) != null) {
                            if (iFDEntry.count != this.samplesPerPixel) {
                                throw new ImageFormatException("Number of SampleFormat entries does not match SamplesPerPixel in TIFF image " + this.toDisplayString());
                            }
                            nArray = iFDEntry.getIntegerArray(seekableInput);
                            n = 0;
                            while (n < nArray.length) {
                                if (nArray[n] != 1) {
                                    throw new ImageFormatException("Unsupported sample format in TIFF image " + this.toDisplayString());
                                }
                                ++n;
                            }
                        }
                        this.fillOrder = 1;
                        iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_FILL_ORDER);
                        if (iFDEntry != null) {
                            this.fillOrder = (int)iFDEntry.getInteger();
                        }
                        switch (this.fillOrder) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                if (this.compressionMethod == 4 || this.compressionMethod == 5) break;
                                if (this.compressionMethod != 6) throw new ImageFormatException("Non-standard FillOrder (" + this.fillOrder + ") is supported for CCITT compression schemes only; cannot process TIFF image " + this.toDisplayString());
                                break;
                            }
                            default: {
                                throw new ImageFormatException("Invalid FillOrder value (" + this.fillOrder + ") in TIFF image " + this.toDisplayString());
                            }
                        }
                        if (this.compressionMethod == 4 || this.compressionMethod == 5 || this.compressionMethod == 6) {
                            if (n2 != 1 && n2 != 0) {
                                throw new ImageFormatException(imageTypeNames[n2] + " color model is incompatible with CCITT FAX compression; cannot process TIFF image " + this.toDisplayString());
                            }
                            if (this.bitsPerComponent != 1) {
                                throw new ImageFormatException("CCITT FAX compression is incompatible with " + this.bitsPerComponent + "-bit color depth; cannot process TIFF image " + this.toDisplayString());
                            }
                        }
                        if (this.colorSpace == 6) {
                            iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_COLORMAP);
                            if (iFDEntry == null) {
                                throw new ImageFormatException("No colormap for indexed color model in TIFF image " + this.toDisplayString());
                            }
                            if (iFDEntry.count != 3 * (1 << this.bitsPerComponent)) {
                                throw new ImageFormatException("Incorrect colormap length in TIFF image " + this.toDisplayString());
                            }
                            this.colorTable = new byte[iFDEntry.count];
                            seekableInput.seek(iFDEntry.offset + this.offsetAdjustment);
                            int n11 = 0;
                            n11 = 0;
                            while (true) {
                                if (n11 >= iFDEntry.count / 3) break;
                                this.colorTable[n11 * 3] = (byte)(this.readUnsignedShort(seekableInput) >> 8);
                                ++n11;
                            }
                            n11 = 0;
                            while (true) {
                                if (n11 >= iFDEntry.count / 3) {
                                    n11 = 0;
                                    break;
                                }
                                this.colorTable[n11 * 3 + 1] = (byte)(this.readUnsignedShort(seekableInput) >> 8);
                                ++n11;
                            }
                            while (n11 < iFDEntry.count / 3) {
                                this.colorTable[n11 * 3 + 2] = (byte)(this.readUnsignedShort(seekableInput) >> 8);
                                ++n11;
                            }
                        }
                        if ((iFDEntry = (IFDEntry)this.ifd.get(TIFF_TAG_STRIP_OFFSETS)) == null || this.ifd.get(TIFF_TAG_STRIP_BYTE_COUNTS) == null && iFDEntry.count != 1) break block86;
                        this.isTiled = false;
                        if (this.ifd.get(TIFF_TAG_ROWS_PER_STRIP) != null) {
                            this.rowsPerStrip = (int)((IFDEntry)this.ifd.get(TIFF_TAG_ROWS_PER_STRIP)).getInteger();
                            if (this.rowsPerStrip < 0) {
                                this.rowsPerStrip = Integer.MAX_VALUE;
                            }
                        }
                        break block87;
                    }
                    if (this.ifd.get(TIFF_TAG_TILE_WIDTH) == null) throw new ImageFormatException("Inconsistent set of strip/tile tags in TIFF image " + this.toDisplayString());
                    if (this.ifd.get(TIFF_TAG_TILE_LENGTH) == null) throw new ImageFormatException("Inconsistent set of strip/tile tags in TIFF image " + this.toDisplayString());
                    if (this.ifd.get(TIFF_TAG_TILE_OFFSETS) == null) throw new ImageFormatException("Inconsistent set of strip/tile tags in TIFF image " + this.toDisplayString());
                    if (this.ifd.get(TIFF_TAG_TILE_BYTE_COUNTS) == null) throw new ImageFormatException("Inconsistent set of strip/tile tags in TIFF image " + this.toDisplayString());
                    this.isTiled = true;
                    this.tileWidth = (int)((IFDEntry)this.ifd.get(TIFF_TAG_TILE_WIDTH)).getInteger();
                    this.tileHeight = (int)((IFDEntry)this.ifd.get(TIFF_TAG_TILE_LENGTH)).getInteger();
                    if (this.tileWidth < 0) {
                        this.tileWidth = Integer.MAX_VALUE;
                    }
                    if (this.tileHeight < 0) {
                        this.tileHeight = Integer.MAX_VALUE;
                    }
                }
                this.canExpandData = true;
                this.canCopyData = !this.isTiled && this.compressionMethod == 0;
                Object var19_16 = null;
                seekableInput.close();
                return;
            }
            Object var19_15 = null;
        }
        catch (Throwable throwable) {
            Object var19_17 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
    }

    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        if (!this.canCopyData) {
            throw new ImageFormatException("Copying data from TIFF image " + this.toDisplayString() + " is not supported");
        }
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            seekableInput.seek(this.offsetAdjustment);
            switch (this.compressionMethod) {
                case 0: {
                    this.copyPlainStrips(outputStream, seekableInput, objectRecordCoordinator);
                    break;
                }
                default: {
                    throw new ImageFormatException("Internal error: cannot lazily copy data from TIFF image " + this.toDisplayString());
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
    }

    private void copyPlainStrips(OutputStream outputStream, SeekableInput seekableInput, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        int[] nArray = ((IFDEntry)this.ifd.get(TIFF_TAG_STRIP_OFFSETS)).getIntegerArray(seekableInput);
        int[] nArray2 = this.getStripByteCounts(seekableInput);
        int n = 0;
        while (n < nArray.length) {
            this.copyChunk(outputStream, seekableInput, nArray[n], nArray2[n], objectRecordCoordinator);
            ++n;
        }
    }

    public void expandData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            seekableInput.seek(this.offsetAdjustment);
            if (this.isTiled) {
                this.expandTiledData(outputStream, seekableInput);
            } else {
                this.expandStripData(outputStream, seekableInput);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
    }

    private void expandTiledData(OutputStream outputStream, SeekableInput seekableInput) throws IOException, ImageFormatException {
        int[] nArray = ((IFDEntry)this.ifd.get(TIFF_TAG_TILE_OFFSETS)).getIntegerArray(seekableInput);
        int[] nArray2 = ((IFDEntry)this.ifd.get(TIFF_TAG_TILE_BYTE_COUNTS)).getIntegerArray(seekableInput);
        int n = (this.pxWidth + this.tileWidth - 1) / this.tileWidth;
        int n2 = (this.pxHeight + this.tileHeight - 1) / this.tileHeight;
        int n3 = 1;
        switch (this.colorSpace) {
            case 1: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 4;
            }
        }
        int n4 = this.getWidthInBytes(n3);
        int n5 = this.getWidthInBytes(n3);
        byte[][] byArray = new byte[this.tileHeight][n5];
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            int n8 = 0;
            while (n8 < n) {
                n7 = n6 * n + n8;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ByteArrayOutputStream byteArrayOutputStream2 = this.compressionMethod == 8 && this.predictor == 1 ? new PredictorFilter(byteArrayOutputStream, this.tileWidth) : byteArrayOutputStream;
                this.expandChunk(byteArrayOutputStream2, seekableInput, nArray[n7], nArray2[n7], this.tileHeight, n4 * this.tileHeight);
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                int n9 = 0;
                while (n9 < this.tileHeight) {
                    int n10 = 0;
                    while (n10 < n4) {
                        int n11 = n9 * n4 + n10;
                        int n12 = n8 * n4 + n10;
                        if (n12 >= n5 || n11 >= byArray2.length) break;
                        byArray[n9][n12] = byArray2[n11];
                        ++n10;
                    }
                    ++n9;
                }
                ++n8;
            }
            n7 = 0;
            while (n7 < this.tileHeight && n6 * this.tileHeight + n7 < this.pxHeight) {
                outputStream.write(byArray[n7]);
                ++n7;
            }
            ++n6;
        }
    }

    private void expandStripData(OutputStream outputStream, SeekableInput seekableInput) throws IOException, ImageFormatException {
        int[] nArray = ((IFDEntry)this.ifd.get(TIFF_TAG_STRIP_OFFSETS)).getIntegerArray(seekableInput);
        int[] nArray2 = this.getStripByteCounts(seekableInput);
        int n = this.getWidthInBytes(this.samplesPerPixel);
        int n2 = this.pxHeight;
        int n3 = 0;
        while (n3 < nArray.length && n2 > 0) {
            OutputStream outputStream2 = this.compressionMethod == 8 && this.predictor == 1 ? new PredictorFilter(outputStream, this.pxWidth) : outputStream;
            int n4 = n2 < this.rowsPerStrip ? n2 : this.rowsPerStrip;
            this.expandChunk(outputStream2, seekableInput, nArray[n3], nArray2[n3], n4, n4 * n);
            n2 -= this.rowsPerStrip;
            ++n3;
        }
    }

    private void expandChunk(OutputStream outputStream, SeekableInput seekableInput, int n, int n2, int n3, int n4) throws IOException, ImageFormatException {
        switch (this.compressionMethod) {
            case 0: {
                this.copyChunk(outputStream, seekableInput, n, n2);
                break;
            }
            case 1: {
                this.expandPackBitChunk(outputStream, seekableInput, n, n2);
                break;
            }
            case 8: {
                this.expandLZWChunk(outputStream, seekableInput, n, n2, n4);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.expandFaxChunk(outputStream, seekableInput, n, n2, n3);
                break;
            }
            default: {
                throw new ImageFormatException("Internal error: invalid compression type in TIFF image " + this.toDisplayString());
            }
        }
    }

    private void copyChunk(OutputStream outputStream, SeekableInput seekableInput, int n, int n2) throws IOException {
        this.copyChunk(outputStream, seekableInput, n, n2, null);
    }

    private void copyChunk(OutputStream outputStream, SeekableInput seekableInput, int n, int n2, ObjectRecordCoordinator objectRecordCoordinator) throws IOException {
        int n3 = objectRecordCoordinator != null ? objectRecordCoordinator.getRecordLength() : 8192;
        byte[] byArray = new byte[n3];
        seekableInput.seek((long)n + this.offsetAdjustment);
        while (n2 > 0) {
            int n4 = n2 > byArray.length ? byArray.length : n2;
            seekableInput.readFully(byArray, 0, n4);
            if (objectRecordCoordinator != null) {
                objectRecordCoordinator.beginRecord(outputStream, n4);
            }
            outputStream.write(byArray, 0, n4);
            if (objectRecordCoordinator != null) {
                objectRecordCoordinator.endRecord(outputStream, n4);
            }
            n2 -= n4;
        }
    }

    private void expandPackBitStrips(OutputStream outputStream, SeekableInput seekableInput) throws IOException, ImageFormatException {
        int[] nArray = ((IFDEntry)this.ifd.get(TIFF_TAG_STRIP_OFFSETS)).getIntegerArray(seekableInput);
        int[] nArray2 = this.getStripByteCounts(seekableInput);
        int n = 0;
        while (n < nArray.length) {
            this.expandPackBitChunk(outputStream, seekableInput, nArray[n], nArray2[n]);
            ++n;
        }
    }

    private void expandPackBitChunk(OutputStream outputStream, SeekableInput seekableInput, int n, int n2) throws IOException {
        byte[] byArray = new byte[256];
        seekableInput.seek((long)n + this.offsetAdjustment);
        while (n2 > 0) {
            int n3 = seekableInput.readByte();
            --n2;
            if (0 <= n3 && n3 <= 127) {
                seekableInput.readFully(byArray, 0, ++n3);
                n2 -= n3;
                outputStream.write(byArray, 0, n3);
                continue;
            }
            if (-128 > n3 || n3 > -1) continue;
            n3 = 1 - n3;
            byte by = seekableInput.readByte();
            --n2;
            while (n3-- > 0) {
                outputStream.write(by);
            }
        }
    }

    private void expandFaxChunk(OutputStream outputStream, SeekableInput seekableInput, int n, int n2, int n3) throws IOException, ImageFormatException {
        byte[] byArray = new byte[n2];
        seekableInput.seek((long)n + this.offsetAdjustment);
        seekableInput.readFully(byArray, 0, n2);
        int n4 = this.isTiled ? this.tileWidth : this.pxWidth;
        TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(this.fillOrder, n4, n3);
        byte[] byArray2 = new byte[(n4 + 7) / 8 * n3];
        try {
            switch (this.compressionMethod) {
                case 4: {
                    tIFFFaxDecoder.decode1D(byArray2, byArray, 0, n3);
                    break;
                }
                case 5: {
                    tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n3, this.t4options);
                    break;
                }
                case 6: {
                    tIFFFaxDecoder.decodeT6(byArray2, byArray, 0, n3, this.t6options);
                    break;
                }
                default: {
                    throw new ImageFormatException("Invalid compression method");
                }
            }
        }
        catch (ImageFormatException imageFormatException) {
            throw new ImageFormatException("CCITT Decoder: " + imageFormatException.getMessage() + " in TIFF file " + this.toDisplayString());
        }
        outputStream.write(byArray2);
    }

    private void expandLZWChunk(OutputStream outputStream, SeekableInput seekableInput, int n, int n2, int n3) throws IOException {
        byte[] byArray = new byte[n2];
        LZWDecoderStream lZWDecoderStream = new LZWDecoderStream(outputStream, 8, false, true, n3);
        seekableInput.seek((long)n + this.offsetAdjustment);
        seekableInput.readFully(byArray, 0, n2);
        try {
            lZWDecoderStream.write(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + " in TIFF file " + this.toDisplayString());
        }
        lZWDecoderStream.flush();
    }

    private int getWidthInBytes(int n) {
        return n == 1 ? (this.pxWidth * this.bitsPerComponent + 7) / 8 : this.pxWidth * n;
    }

    private int[] getStripByteCounts(SeekableInput seekableInput) throws IOException, ImageFormatException {
        if (this.ifd.get(TIFF_TAG_STRIP_BYTE_COUNTS) != null) {
            return ((IFDEntry)this.ifd.get(TIFF_TAG_STRIP_BYTE_COUNTS)).getIntegerArray(seekableInput);
        }
        long l = ((IFDEntry)this.ifd.get(TIFF_TAG_STRIP_OFFSETS)).getInteger() + this.offsetAdjustment;
        long l2 = this.getWidthInBytes(this.samplesPerPixel) * this.pxHeight;
        long l3 = this.compressionMethod == 0 ? l2 : seekableInput.length() - (l + this.offsetAdjustment);
        int[] nArray = new int[]{(int)l3};
        return nArray;
    }

    short readShort(SeekableInput seekableInput) throws IOException {
        if (this.usesBigEndian) {
            return seekableInput.readShort();
        }
        int n = seekableInput.readUnsignedByte();
        int n2 = seekableInput.readUnsignedByte();
        return (short)(n2 << 8 | n);
    }

    int readUnsignedShort(SeekableInput seekableInput) throws IOException {
        if (this.usesBigEndian) {
            return seekableInput.readUnsignedShort();
        }
        int n = seekableInput.readUnsignedByte();
        int n2 = seekableInput.readUnsignedByte();
        return n2 << 8 | n;
    }

    int readInt(SeekableInput seekableInput) throws IOException {
        if (this.usesBigEndian) {
            return seekableInput.readInt();
        }
        int n = seekableInput.readUnsignedByte();
        int n2 = seekableInput.readUnsignedByte();
        int n3 = seekableInput.readUnsignedByte();
        int n4 = seekableInput.readUnsignedByte();
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    long readUnsignedInt(SeekableInput seekableInput) throws IOException {
        if (this.usesBigEndian) {
            return seekableInput.readUnsignedInt();
        }
        return (long)this.readInt(seekableInput) & 0xFFFFFFFFL;
    }

    static {
        tagNames.put(TIFF_TAG_IMAGE_WIDTH, "ImageWidth");
        tagNames.put(TIFF_TAG_IMAGE_LENGTH, "ImageLength");
        tagNames.put(TIFF_TAG_BITS_PER_SAMPLE, "BitsPerSample");
        tagNames.put(TIFF_TAG_COMPRESSION, "Compression");
        tagNames.put(TIFF_TAG_PHOTOMETRIC_INTERPRETATION, "PhotometricInterpretation");
        tagNames.put(TIFF_TAG_FILL_ORDER, "FillOrder");
        tagNames.put(TIFF_TAG_STRIP_OFFSETS, "StripOffsets");
        tagNames.put(TIFF_TAG_ORIENTATION, "Orientation");
        tagNames.put(TIFF_TAG_SAMPLES_PER_PIXEL, "SamplesPerPixel");
        tagNames.put(TIFF_TAG_ROWS_PER_STRIP, "RowsPerStrip");
        tagNames.put(TIFF_TAG_STRIP_BYTE_COUNTS, "StripByteCounts");
        tagNames.put(TIFF_TAG_X_RESOLUTION, "XResolution");
        tagNames.put(TIFF_TAG_Y_RESOLUTION, "YResolution");
        tagNames.put(TIFF_TAG_PLANAR_CONFIGURATION, "PlanarConfiguration");
        tagNames.put(TIFF_TAG_T4_OPTIONS, "T4Options");
        tagNames.put(TIFF_TAG_T6_OPTIONS, "T6Options");
        tagNames.put(TIFF_TAG_RESOLUTION_UNIT, "ResolutionUnit");
        tagNames.put(TIFF_TAG_PREDICTOR, "Predictor");
        tagNames.put(TIFF_TAG_COLORMAP, "Colormap");
        tagNames.put(TIFF_TAG_TILE_WIDTH, "TileWidth");
        tagNames.put(TIFF_TAG_TILE_LENGTH, "TileLength");
        tagNames.put(TIFF_TAG_TILE_OFFSETS, "TileOffsets");
        tagNames.put(TIFF_TAG_TILE_BYTE_COUNTS, "TileByteCounts");
        tagNames.put(TIFF_TAG_EXTRA_SAMPLES, "ExtraSamples");
        tagNames.put(TIFF_TAG_SAMPLE_FORMAT, "SampleFormat");
        tagNames.put(TIFF_TAG_S_MIN_SAMPLE_VALUE, "SMinSampleValue");
        tagNames.put(TIFF_TAG_S_MAX_SAMPLE_VALUE, "SMaxSampleValue");
        dataTypeNames = new String[]{"Error", "BYTE", "ASCII", "SHORT", "LONG", "RATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "FLOAT", "DOUBLE"};
        imageTypeNames = new String[]{"Reverse Monochrome", "Monochrome", "RGB", "Palette", "Transparency Mask", "Separated (CMYK)"};
    }

    protected class PredictorFilter
    extends FilterOutputStream {
        int code = 0;
        int codeMask = 0;
        int inBits = 0;
        int outBits = 0;
        int bitsPerPixel = 0;
        int inBitCount = 0;
        int outBitCount = 0;
        int fragWidth = 0;
        int xpos = 0;
        int[] components = null;

        PredictorFilter(OutputStream outputStream, int n) {
            super(outputStream);
            this.fragWidth = n;
            this.components = new int[TIFFImage.this.samplesPerPixel];
            this.bitsPerPixel = TIFFImage.this.samplesPerPixel * TIFFImage.this.bitsPerComponent;
            this.codeMask = (1 << TIFFImage.this.bitsPerComponent) - 1;
        }

        public void write(byte[] byArray) throws IOException {
            int n = 0;
            while (n < byArray.length) {
                this.write(byArray[n] & 0xFF);
                ++n;
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                this.write(byArray[n + n3] & 0xFF);
                ++n3;
            }
        }

        public void write(int n) throws IOException {
            this.inBits = this.inBits << 8 | n;
            this.inBitCount += 8;
            while (this.inBitCount >= this.bitsPerPixel) {
                int n2 = 0;
                while (n2 < TIFFImage.this.samplesPerPixel) {
                    this.code = this.inBits >> this.inBitCount - TIFFImage.this.bitsPerComponent;
                    this.inBitCount -= TIFFImage.this.bitsPerComponent;
                    this.inBits &= (1 << this.inBitCount) - 1;
                    this.components[n2] = this.xpos == 0 ? this.code : this.components[n2] + this.code;
                    this.outBits |= this.outBits << TIFFImage.this.bitsPerComponent | this.components[n2];
                    this.outBitCount += TIFFImage.this.bitsPerComponent;
                    if (this.outBitCount == 8) {
                        this.out.write(this.outBits);
                        this.outBits = 0;
                        this.outBitCount = 0;
                    }
                    ++n2;
                }
                if (++this.xpos != this.fragWidth) continue;
                this.xpos = 0;
            }
        }
    }

    class IFDEntry {
        int tag;
        int type;
        int count;
        long offset;
        byte[] value;

        public IFDEntry(int n, int n2, int n3, byte[] byArray) {
            this.tag = n;
            this.type = n2;
            this.count = n3;
            this.value = byArray;
            this.offset = TIFFImage.this.usesBigEndian ? (long)((byArray[0] << 24 & 0xFF000000) + (byArray[1] << 16 & 0xFF0000) + (byArray[2] << 8 & 0xFF00) + (byArray[3] & 0xFF)) : (long)((byArray[3] << 24 & 0xFF000000) + (byArray[2] << 16 & 0xFF0000) + (byArray[1] << 8 & 0xFF00) + (byArray[0] & 0xFF));
            this.offset &= 0xFFFFFFFFL;
            TIFFImage.this.ifd.put(new Integer(n), this);
        }

        public long getInteger() throws ImageFormatException {
            if (this.count != 1) {
                throw new ImageFormatException("Array found instead of scalar in TIFF image " + TIFFImage.this.toDisplayString() + ", tag " + tagNames.get(new Integer(this.tag)) + " [" + this.tag + "]");
            }
            switch (this.type) {
                case 1: {
                    return (TIFFImage.this.usesBigEndian ? this.offset >> 24 : this.offset) & 0xFFL;
                }
                case 3: {
                    return (TIFFImage.this.usesBigEndian ? this.offset >> 16 : this.offset) & 0xFFFFL;
                }
                case 4: {
                    return this.offset & 0xFFFFFFFFL;
                }
            }
            throw new ImageFormatException("Unexpected data type " + dataTypeNames[this.type] + " (" + this.type + ") in TIFF image " + TIFFImage.this.toDisplayString() + ", tag " + tagNames.get(new Integer(this.tag)) + " [" + this.tag + "]");
        }

        public double getRational(SeekableInput seekableInput) throws IOException, ImageFormatException {
            if (this.count != 1) {
                throw new ImageFormatException("Array found instead of scalar in TIFF image " + TIFFImage.this.toDisplayString() + ", tag " + tagNames.get(new Integer(this.tag)) + " [" + this.tag + "]");
            }
            if (this.type != 5) {
                throw new ImageFormatException("Unexpected data type " + dataTypeNames[this.type] + " (" + this.type + ") in TIFF image " + TIFFImage.this.toDisplayString() + ", tag " + tagNames.get(new Integer(this.tag)) + " [" + this.tag + "]");
            }
            seekableInput.seek(this.offset + TIFFImage.this.offsetAdjustment);
            long l = TIFFImage.this.readUnsignedInt(seekableInput);
            long l2 = TIFFImage.this.readUnsignedInt(seekableInput);
            if (l2 == 0L) {
                throw new ImageFormatException("Division by zero in RATIONAL data in TIFF image " + TIFFImage.this.toDisplayString() + ", tag " + tagNames.get(new Integer(this.tag)) + " [" + this.tag + "]");
            }
            return (double)l / (double)l2;
        }

        public int[] getIntegerArray(SeekableInput seekableInput) throws IOException, ImageFormatException {
            int[] nArray = new int[this.count];
            switch (this.type) {
                case 1: {
                    if (this.count <= 4) {
                        int n = 0;
                        while (n < this.count) {
                            nArray[n] = this.value[n] & 0xFF;
                            ++n;
                        }
                    } else {
                        seekableInput.seek(this.offset + TIFFImage.this.offsetAdjustment);
                        int n = 0;
                        while (n < this.count) {
                            nArray[n] = seekableInput.readUnsignedByte();
                            ++n;
                        }
                    }
                    break;
                }
                case 3: {
                    if (this.count <= 2) {
                        int n = 0;
                        while (n < this.count) {
                            nArray[n] = TIFFImage.this.usesBigEndian ? (this.value[2 * n] << 8 & 0xFF00) + (this.value[2 * n + 1] & 0xFF) : (this.value[2 * n + 1] << 8 & 0xFF00) + (this.value[2 * n] & 0xFF);
                            ++n;
                        }
                    } else {
                        seekableInput.seek(this.offset + TIFFImage.this.offsetAdjustment);
                        int n = 0;
                        while (n < this.count) {
                            nArray[n] = TIFFImage.this.readUnsignedShort(seekableInput);
                            ++n;
                        }
                    }
                    break;
                }
                case 4: {
                    if (this.count == 1) {
                        nArray[0] = (int)this.offset;
                        break;
                    }
                    seekableInput.seek(this.offset + TIFFImage.this.offsetAdjustment);
                    int n = 0;
                    while (n < this.count) {
                        nArray[n] = TIFFImage.this.readInt(seekableInput);
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new ImageFormatException("Not an integer data type in TIFF image " + TIFFImage.this.toDisplayString() + ", tag " + tagNames.get(new Integer(this.tag)) + " [" + this.tag + "]");
                }
            }
            return nArray;
        }
    }
}

