/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.Media;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.util.SeekableInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AVI
extends Media {
    public AVI() {
        this.mimetype = "video/avi";
    }

    public void parse() throws IOException, ImageFormatException {
        this.canCopyData = true;
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            try {
                seekableInput.seek(0L);
                byte[] byArray = new byte[4];
                seekableInput.readFully(byArray);
                if (byArray[0] != 82 || byArray[1] != 73 || byArray[2] != 70 || byArray[3] != 70) {
                    throw new ImageFormatException("Invalid AVI signature in file '" + this.toDisplayString() + "'");
                }
                int n = seekableInput.readInt();
                byArray = new byte[4];
                seekableInput.readFully(byArray);
                String string = new String(byArray);
                if (!string.equals("AVI ")) {
                    throw new ImageFormatException("Invalid AVI file structure'" + this.toDisplayString() + "'");
                }
                byArray = new byte[4];
                seekableInput.readFully(byArray);
                string = new String(byArray);
                if (!string.equals("LIST")) {
                    throw new ImageFormatException("Invalid AVI file structure'" + this.toDisplayString() + "'");
                }
                int n2 = seekableInput.readInt();
                byArray = new byte[4];
                seekableInput.readFully(byArray);
                string = new String(byArray);
                if (!string.equals("hdrl")) {
                    throw new ImageFormatException("Invalid AVI file structure'" + this.toDisplayString() + "'");
                }
                byArray = new byte[4];
                seekableInput.readFully(byArray);
                string = new String(byArray);
                if (!string.equals("avih")) {
                    throw new ImageFormatException("Invalid AVI file structure'" + this.toDisplayString() + "'");
                }
                seekableInput.skipBytes(36);
                this.pxWidth = this.readLittleEndian(seekableInput);
                this.pxHeight = this.readLittleEndian(seekableInput);
            }
            catch (EOFException eOFException) {
                throw new ImageFormatException("Premature end of file or corrupt data in AVI media " + this.toDisplayString(), this.mimetype);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
        this.setDimensions();
    }

    public int readLittleEndian(SeekableInput seekableInput) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = seekableInput.read();
        if ((n4 | (n3 = seekableInput.read()) | (n2 = seekableInput.read()) | (n = seekableInput.read())) < 0) {
            throw new EOFException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        InputStream inputStream = this.openImageStream();
        try {
            int n;
            byte[] byArray = new byte[objectRecordCoordinator != null ? objectRecordCoordinator.getRecordLength() : 8192];
            while ((n = inputStream.read(byArray)) != -1) {
                if (objectRecordCoordinator != null) {
                    objectRecordCoordinator.beginRecord(outputStream, n);
                }
                outputStream.write(byArray, 0, n);
                if (objectRecordCoordinator == null) continue;
                objectRecordCoordinator.endRecord(outputStream, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }
}

