<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://docbook.org/ns/docbook"
	exclude-result-prefixes="d"
  	version="1.0">
	
	<!-- no namespace is specified (i.e., there is no <xsl:stylesheet xmlns="..."/> attribute supplied) -->
	
	<xsl:strip-space elements="*" />
	
	<xsl:output omit-xml-declaration="no" method="xml" indent="yes" encoding="UTF-8" />
	
	<xsl:template match="d:book">
		<DataElements>
			<xsl:apply-templates/>
		</DataElements>
	</xsl:template>
	
	<!-- match the selected tables the same way, whether they be the top level context group, or one that is known to be included (not worth the effort of automatically detecting the include directive) -->
	<xsl:template match="d:table[@label = 'E.1-1']">
		<xsl:message>Processing <xsl:value-of select="@label"/></xsl:message>
		<xsl:choose>
		<xsl:when test="d:thead/d:tr/d:th[1] = 'Attribute Name'
			and d:thead/d:tr/d:th[2] = 'Tag'
			and d:thead/d:tr/d:th[5] = 'Basic Prof.'">
			<xsl:for-each select="d:tbody/d:tr">
				<xsl:variable name="name" select="normalize-space(d:td[1])"/>
				<xsl:variable name="tag" select="normalize-space(d:td[2])"/>
				<xsl:variable name="group" select="substring($tag,2,4)"/>
				<xsl:variable name="element" select="substring($tag,7,4)"/>
				<xsl:variable name="action" select="normalize-space(d:td[5])"/>
				<xsl:choose>
					<xsl:when test="string-length($action) &gt; 0">
						<DataElement name="{$name}" group="{$group}" element="{$element}" action="{$action}"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:message>No action for <xsl:value-of select="$name"/></xsl:message>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:when>
		<xsl:otherwise>
			<xsl:message>No matching table pattern for <xsl:value-of select="@label"/></xsl:message>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="node()|@*">
		<xsl:apply-templates/>
	</xsl:template>
	
</xsl:stylesheet>
