/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.util.Array;
import com.renderx.util.Hashtable;
import com.renderx.util.URLSpec;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Elem;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.WritingMode;

public class ParserContext
implements Cloneable {
    public final Session session;
    public URLSpec baseURL = null;
    public Elem.Descriptor element = null;
    public WritingMode activeMode = null;
    public WritingMode inheritedMode = null;
    public Hashtable specified = new Hashtable();
    public Hashtable inherited = null;
    private boolean independent = false;
    public Attr.Length fontSize;
    public Attr.Color color;
    public int refOrientation;
    public Attr direction;
    public boolean bidiOverride;
    public int listid;
    public boolean extraFlowSection;
    public boolean extraTableRow;
    public Hashtable markerInfo;
    public Array busyCells;
    public Array tableColumns;
    public int nextColumn;
    public int tableid;
    public int bodyNumber;
    public int rowNumber;
    public int columnNumber;
    public Attr proportionalColumnWidth;
    public boolean endsRow;
    public boolean collapseBorders;
    public boolean useCollapsePrecedence;
    public final ParserContext prev;
    public ParserContext next;

    public ParserContext(ParserContext parserContext, Session session) {
        this.fontSize = (Attr.Length)Attn.$font_size.defaultValue;
        this.color = (Attr.Color)Attn.$color.defaultValue;
        this.refOrientation = 0;
        this.direction = Attn.$direction.defaultValue;
        this.bidiOverride = false;
        this.listid = 0;
        this.extraFlowSection = false;
        this.extraTableRow = false;
        this.markerInfo = null;
        this.busyCells = null;
        this.tableColumns = null;
        this.proportionalColumnWidth = null;
        this.collapseBorders = true;
        this.useCollapsePrecedence = false;
        this.next = null;
        this.prev = parserContext;
        this.session = session;
        if (parserContext != null) {
            parserContext.next = this;
        }
    }

    public Object clone() {
        ParserContext parserContext = new ParserContext(null, this.session);
        parserContext.baseURL = this.baseURL;
        parserContext.element = this.element;
        parserContext.activeMode = this.activeMode;
        parserContext.inheritedMode = this.inheritedMode;
        parserContext.refOrientation = this.refOrientation;
        parserContext.bidiOverride = this.bidiOverride;
        parserContext.direction = this.direction;
        parserContext.fontSize = this.fontSize;
        parserContext.color = this.color;
        parserContext.listid = this.listid;
        parserContext.extraFlowSection = this.extraFlowSection;
        parserContext.extraTableRow = this.extraTableRow;
        parserContext.nextColumn = this.nextColumn;
        parserContext.endsRow = this.endsRow;
        parserContext.collapseBorders = this.collapseBorders;
        parserContext.useCollapsePrecedence = this.useCollapsePrecedence;
        parserContext.specified = this.specified == null ? null : (Hashtable)this.specified.clone();
        parserContext.inherited = this.inherited == null ? null : (Hashtable)this.inherited.clone();
        parserContext.markerInfo = this.markerInfo == null ? null : (Hashtable)this.markerInfo.clone();
        parserContext.tableColumns = this.tableColumns == null ? null : (Array)this.tableColumns.clone();
        parserContext.busyCells = this.busyCells == null ? null : (Array)this.busyCells.clone();
        parserContext.independent = true;
        parserContext.next = null;
        return parserContext;
    }

    public void initialize(Elem.Descriptor descriptor, String string) throws ParserException {
        this.element = descriptor;
        if (this.prev == null) {
            this.inherited = new Hashtable();
            this.independent = true;
            this.activeMode = this.inheritedMode = WritingMode.$defaultmode;
            return;
        }
        this.baseURL = this.prev.baseURL;
        ParserContext parserContext = this.prev;
        if (this.element.isOutOfLine && this.session.config.XEP2_COMPATIBLE_MODE) {
            while (parserContext.element.id != 19) {
                parserContext = parserContext.prev;
                if (parserContext != null) continue;
                parserContext = this.prev;
                break;
            }
        } else if (this.element.id == 50) {
            if (string == null) {
                throw new ParserException("fo:marker element has no marker-class-name attribute; element ignored");
            }
            ParserContext parserContext2 = this.prev;
            while (parserContext2.element.id != 16) {
                parserContext2 = parserContext2.prev;
                if (parserContext2 != null) continue;
                throw new ParserException("fo:marker element outside fo:page-sequence; element ignored");
            }
            if (string.startsWith("[ghost]")) {
                string = string.substring("[ghost]".length());
            }
            if ((parserContext = (ParserContext)parserContext2.markerInfo.get(string)) == null) {
                throw new ParserException("fo:marker element with no corresponding fo:retrieve_marker; element ignored");
            }
        }
        this.inherited = parserContext.inherited;
        this.independent = false;
        this.listid = parserContext.listid;
        this.nextColumn = 1;
        this.fontSize = parserContext.fontSize;
        this.color = parserContext.color;
        this.extraFlowSection = false;
        this.extraTableRow = false;
        this.endsRow = false;
        this.collapseBorders = parserContext.collapseBorders;
        this.useCollapsePrecedence = parserContext.useCollapsePrecedence;
        if (parserContext.element.resetIndents && this.session.config.XEP2_COMPATIBLE_MODE && (this.inherited.containsKey(Attn.$start_indent) || this.inherited.containsKey(Attn.$end_indent))) {
            this.inherited = (Hashtable)this.inherited.clone();
            this.independent = true;
            this.inherited.remove(Attn.$start_indent);
            this.inherited.remove(Attn.$end_indent);
        }
        this.inheritedMode = parserContext.inheritedMode;
        if (this.element.changeWritingMode) {
            this.activeMode = this.inheritedMode;
            this.bidiOverride = false;
            this.direction = this.activeMode.direction;
        } else {
            this.activeMode = parserContext.activeMode;
            this.bidiOverride = parserContext.bidiOverride;
            this.direction = parserContext.direction;
        }
        if (this.element.id == 16) {
            this.markerInfo = new Hashtable();
        }
        if (this.element.id == 34) {
            this.tableColumns = new Array();
        }
        if (this.element.id == 38 || this.element.id == 36 || this.element.id == 37) {
            this.busyCells = new Array();
        }
    }

    public void clear() {
        this.baseURL = null;
        this.inheritedMode = null;
        this.activeMode = null;
        if (this.independent) {
            this.inherited.clear();
        }
        this.inherited = null;
        this.independent = false;
        this.specified.clear();
        this.markerInfo = null;
        this.tableColumns = null;
        this.busyCells = null;
        this.nextColumn = 1;
        this.refOrientation = 0;
        this.bidiOverride = false;
    }

    public void addAttribute(Attn attn, Attr attr) throws ParserException {
        this.specified.put(attn, attr);
        if (attn.inheritable) {
            if (!this.independent) {
                this.inherited = (Hashtable)this.inherited.clone();
                this.independent = true;
            }
            this.inherited.put(attn, attr);
        }
    }

    public void removeAttribute(Attn attn) throws ParserException {
        this.specified.remove(attn);
        if (this.inherited.get(attn) != null) {
            if (!this.independent) {
                this.inherited = (Hashtable)this.inherited.clone();
                this.independent = true;
            }
            this.inherited.remove(attn);
        }
    }

    public void setWritingMode(String string) throws ParserException {
        this.inheritedMode = WritingMode.byName(string);
        if (this.element.changeWritingMode) {
            this.activeMode = this.inheritedMode;
            this.bidiOverride = false;
            this.direction = this.activeMode.direction;
        }
    }

    public void decreaseBusyCells() throws ParserException {
        if (this.busyCells == null) {
            throw new ParserException("Misplaced table row element ignored");
        }
        int n = 0;
        while (n < this.busyCells.length()) {
            Integer n2 = (Integer)this.busyCells.get(n);
            if (n2 != null) {
                int n3 = n2;
                this.busyCells.put(n, n3 <= 1 ? null : new Integer(n3 - 1));
            }
            ++n;
        }
    }

    public void setCollapsedBorderModel(Attr attr) throws ParserException {
        this.collapseBorders = true;
        this.useCollapsePrecedence = false;
        this.addAttribute(Attn.$border_collapse, attr);
        if ("separate".equals(attr.word())) {
            this.collapseBorders = false;
        } else if ("collapse-with-precedence".equals(attr.word())) {
            this.useCollapsePrecedence = true;
        }
    }

    public void copySpecifiedValue(Attn attn, Attn attn2) {
        Attr attr = (Attr)this.specified.get(attn);
        if (attr != null) {
            this.specified.put(attn2, attr);
        }
    }

    public static class TableColumn {
        public int colspan = 1;
        public ParserContext context = null;

        public TableColumn(int n, ParserContext parserContext) {
            this.colspan = n;
            this.context = (ParserContext)parserContext.clone();
        }
    }
}

