/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.lib;

public class NumStr {
    private String prefix;
    private String suffix;
    private NumFormat nf;

    public NumStr(String string, int n, String string2) {
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 != cArray.length) {
            if (Character.isLetterOrDigit(cArray[n2])) break;
            ++n2;
        }
        this.prefix = string.substring(0, n2);
        int n3 = n2;
        while (n2 != cArray.length) {
            if (!Character.isLetterOrDigit(cArray[n2])) break;
            ++n2;
        }
        this.suffix = string.substring(n2, cArray.length);
        String string3 = string.substring(n3, n2);
        if (string3.length() > 0) {
            switch (string3.charAt(string3.length() - 1)) {
                case '1': {
                    this.nf = new WesternArabic(string3, n, string2);
                    break;
                }
                case 'A': 
                case 'a': {
                    this.nf = new EnglishAlphabetic(string3);
                    break;
                }
                case 'I': 
                case 'i': {
                    this.nf = new EnglishTraditional(string3);
                    break;
                }
                case '\u0661': {
                    this.nf = new IndicArabic(string3, n, string2);
                    break;
                }
                case '\u06f1': {
                    this.nf = new ExtendedIndicArabic(string3, n, string2);
                    break;
                }
                case '\u30a2': {
                    this.nf = new KatakanaAlphabetic(string3);
                    break;
                }
                case '\u30a4': {
                    this.nf = new KatakanaIroha(string3);
                    break;
                }
                case '\u3042': {
                    this.nf = new HiraganaAlphabetic(string3);
                    break;
                }
                case '\u3044': {
                    this.nf = new HiraganaIroha(string3);
                    break;
                }
                case '\u4e00': {
                    this.nf = new CanjiNumeric(string3, n, string2);
                    break;
                }
                case '\u0410': 
                case '\u0430': {
                    this.nf = new CyrillicAlphabetic(string3);
                    break;
                }
                case '\u0531': {
                    this.nf = new ArmenianTraditional();
                }
            }
        }
        if (this.nf == null) {
            this.nf = new DefaultFormat();
        }
    }

    public String format(int n) {
        if (n < 0) {
            n = -n;
        }
        if (n == 0) {
            n = 1;
        }
        return this.prefix + this.nf.format(n) + this.suffix;
    }

    private static class ArmenianTraditional
    extends NumFormat {
        private static char[][] registers = new char[][]{"\u0531\u0532\u0533\u0534\u0535\u0536\u0537\u0538\u0539".toCharArray(), "\u053a\u053b\u053c\u053d\u053e\u053f\u0540\u0541\u0542".toCharArray(), "\u0543\u0544\u0545\u0546\u0547\u0548\u0549\u054a\u054b".toCharArray(), "\u054c\u054d\u054e\u054f\u0550\u0551\u0552\u0553\u0554".toCharArray()};

        private ArmenianTraditional() {
        }

        String format(int n) {
            if (n > 9999) {
                n = 9999;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (true) {
                if (n % 10 == 0) {
                    n /= 10;
                    ++n2;
                    continue;
                }
                stringBuffer.append(registers[n2++][n % 10 - 1]);
                if ((n /= 10) <= 0) break;
            }
            return stringBuffer.reverse().toString();
        }
    }

    private static class EnglishTraditional
    extends NumFormat {
        private boolean lcase;

        EnglishTraditional(String string) {
            this.lcase = string.charAt(string.length() - 1) == 'i';
        }

        String format(int n) {
            char[] cArray = new char[]{'M', 'D', 'C', 'L', 'X', 'V', 'I'};
            int n2 = 0;
            int n3 = 1000;
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                int n4;
                if (n >= (n4 = n3)) {
                    int n5 = 0;
                    while (n5 != n / n4) {
                        stringBuffer.append(cArray[2 * n2]);
                        ++n5;
                    }
                    if (n4 == 1) break;
                    n %= n4;
                }
                if (n >= (n4 = 9 * (n3 /= 10))) {
                    stringBuffer.append(cArray[2 * n2 + 2]).append(cArray[2 * n2]);
                    n %= n4;
                }
                if (n >= (n4 = 5 * n3)) {
                    stringBuffer.append(cArray[2 * n2 + 1]);
                    n %= n4;
                }
                if (n >= (n4 = 4 * n3)) {
                    stringBuffer.append(cArray[2 * n2 + 2]).append(cArray[2 * n2 + 1]);
                    n %= n4;
                }
                if (n == 0) break;
                ++n2;
            }
            String string = stringBuffer.toString();
            if (this.lcase) {
                string = string.toLowerCase();
            }
            return string;
        }
    }

    private static class CyrillicAlphabetic
    extends AlphabeticFormat {
        private static char[][] letters = new char[][]{"\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f".toCharArray(), "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f".toCharArray()};

        CyrillicAlphabetic(String string) {
            super(string);
        }

        char[] setupLetters(char c) {
            return letters[c == '\u0410' ? 0 : 1];
        }
    }

    private static class HiraganaIroha
    extends AlphabeticFormat {
        private static char[] letters = "\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3061\u308a\u306c\u308b\u3092\u308f\u304b\u3088\u305f\u308c\u305d\u3064\u306d\u306a\u3089\u3080\u3046\u3090\u306e\u304a\u304f\u3084\u307e\u3051\u3075\u3053\u3048\u3066\u3042\u3055\u304d\u3086\u3081\u307f\u3057\u3091\u3072\u3082\u305b\u3059".toCharArray();

        HiraganaIroha(String string) {
            super(string);
        }

        char[] setupLetters(char c) {
            return letters;
        }
    }

    private static class HiraganaAlphabetic
    extends AlphabeticFormat {
        private static char[] letters = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093".toCharArray();

        HiraganaAlphabetic(String string) {
            super(string);
        }

        char[] setupLetters(char c) {
            return letters;
        }
    }

    private static class KatakanaIroha
    extends AlphabeticFormat {
        private static char[] letters = "\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8\u30c1\u30ea\u30cc\u30eb\u30f2\u30ef\u30ab\u30e8\u30bf\u30ec\u30bd\u30c4\u30cd\u30ca\u30e9\u30e0\u30a6\u30f0\u30ce\u30aa\u30af\u30e4\u30de\u30b1\u30d5\u30b3\u30a8\u30c6\u30a2\u30b5\u30ad\u30e6\u30e1\u30df\u30b7\u30f1\u30d2\u30e2\u30bb\u30b9".toCharArray();

        KatakanaIroha(String string) {
            super(string);
        }

        char[] setupLetters(char c) {
            return letters;
        }
    }

    private static class KatakanaAlphabetic
    extends AlphabeticFormat {
        private static char[] letters = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30f3".toCharArray();

        KatakanaAlphabetic(String string) {
            super(string);
        }

        char[] setupLetters(char c) {
            return letters;
        }
    }

    private static class EnglishAlphabetic
    extends AlphabeticFormat {
        private static char[][] letters = new char[][]{"ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray(), "abcdefghijklmnopqrstuvwxyz".toCharArray()};

        EnglishAlphabetic(String string) {
            super(string);
        }

        char[] setupLetters(char c) {
            return letters[c == 'A' ? 0 : 1];
        }
    }

    private static abstract class AlphabeticFormat
    extends NumFormat {
        private char[] letters;

        AlphabeticFormat(String string) {
            this.letters = this.setupLetters(string.charAt(string.length() - 1));
        }

        String format(int n) {
            int n2 = this.letters.length;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                stringBuffer.append(this.letters[(n - 1) % n2]);
            } while ((n = (n - 1) / n2) != 0);
            return stringBuffer.reverse().toString();
        }

        abstract char[] setupLetters(char var1);
    }

    private static class CanjiNumeric
    extends RadicalFormat {
        CanjiNumeric(String string, int n, String string2) {
            super(string, n, string2);
        }

        char[] setupDigits() {
            return "\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d".toCharArray();
        }
    }

    private static class ExtendedIndicArabic
    extends RadicalFormat {
        ExtendedIndicArabic(String string, int n, String string2) {
            super(string, n, string2);
        }

        char[] setupDigits() {
            return "\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9".toCharArray();
        }
    }

    private static class IndicArabic
    extends RadicalFormat {
        IndicArabic(String string, int n, String string2) {
            super(string, n, string2);
        }

        char[] setupDigits() {
            return "\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669".toCharArray();
        }
    }

    private static class WesternArabic
    extends RadicalFormat {
        WesternArabic(String string, int n, String string2) {
            super(string, n, string2);
        }

        char[] setupDigits() {
            return "0123456789".toCharArray();
        }
    }

    private static abstract class RadicalFormat
    extends NumFormat {
        private int gsize;
        private String gsep;
        private char[] digits;
        private String padding = null;

        RadicalFormat(String string, int n, String string2) {
            this.gsize = n;
            this.gsep = string2;
            this.digits = this.setupDigits();
            if (string.length() > 1) {
                this.padding = string.substring(0, string.length() - 1);
            }
        }

        String format(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.digits.length;
            do {
                stringBuffer.append(this.digits[n % n2]);
            } while ((n /= n2) != 0);
            if (this.padding != null && stringBuffer.length() < this.padding.length() + 1) {
                stringBuffer.append((Object)new StringBuffer(this.padding.substring(0, this.padding.length() + 1 - stringBuffer.length())).reverse());
            }
            if (this.gsize > 0 && this.gsep.length() > 0) {
                int n3 = 0;
                int n4 = 0;
                int n5 = stringBuffer.length();
                while (n3 < n5) {
                    if (n3 > 0 && n3 % this.gsize == 0) {
                        stringBuffer.insert(n4, this.gsep);
                        n4 += this.gsep.length();
                    }
                    ++n3;
                    ++n4;
                }
            }
            return stringBuffer.reverse().toString();
        }

        abstract char[] setupDigits();
    }

    private static class DefaultFormat
    extends NumFormat {
        private static NumFormat df = new WesternArabic("1", Integer.MIN_VALUE, "");

        private DefaultFormat() {
        }

        String format(int n) {
            return df.format(n);
        }
    }

    private static abstract class NumFormat {
        private NumFormat() {
        }

        abstract String format(int var1);
    }
}

