/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

public class Array
implements Cloneable {
    protected static final int INITIAL_LENGTH = 4;
    protected Object[] data;
    private int length = 0;

    public Array() {
        this(4);
    }

    public Array(int n) {
        this.data = new Object[n];
        int n2 = 0;
        while (n2 != n) {
            this.data[n2] = null;
            ++n2;
        }
    }

    protected void resize(int n) {
        Object[] objectArray = new Object[(n + 1) * 2];
        System.arraycopy(this.data, 0, objectArray, 0, this.data.length);
        int n2 = this.data.length;
        while (n2 != objectArray.length) {
            objectArray[n2] = null;
            ++n2;
        }
        this.data = objectArray;
    }

    public final int length() {
        return this.length;
    }

    public final Object get(int n) {
        return this.data.length <= n || n < 0 ? null : this.data[n];
    }

    public final void put(int n, Object object) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.data.length <= n) {
            this.resize(n);
        }
        this.data[n] = object;
        if (n >= this.length) {
            this.length = n + 1;
        }
    }

    public Object clone() {
        try {
            Array array = (Array)super.clone();
            array.data = this.datacopy();
            return array;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object[] datacopy() {
        Object[] objectArray = new Object[this.length];
        System.arraycopy(this.data, 0, objectArray, 0, this.length);
        return objectArray;
    }

    public int indexOf(Object object) {
        if (object == null) {
            int n = 0;
            while (n < this.length) {
                if (this.data[n] == null) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.length) {
                if (object.equals(this.data[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }
}

