/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib.parser;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.PNGPredictor;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.parser.ElementParser;
import com.renderx.pdflib.parser.Lexer;
import com.renderx.pdflib.parser.PDFArray;
import com.renderx.pdflib.parser.PDFDictionary;
import com.renderx.pdflib.parser.PDFElement;
import com.renderx.pdflib.parser.PDFNumeric;
import com.renderx.pdflib.parser.PDFStream;
import com.renderx.pdflib.parser.ParseUtils;
import com.renderx.util.Array;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestCase;

public class XRefTable {
    private static final int EOF_TAIL_SIZE = 1024;
    private static final byte[] EOF_MARKER = new byte[]{37, 37, 69, 79, 70};
    private static final short CROSS_STREAM_NONE_PREDICTOR = 0;
    private static final short CROSS_STREAM_PNG_PREDICTOR = 1;
    private static final short CROSS_STREAM_TIFF_PREDICTOR = 2;
    private short crossStreamPredictor = 0;
    int root_id = 0;
    int info_id = 0;
    Hashtable compressed_objects = new Hashtable();
    public Hashtable obj_offset = new Hashtable();

    public XRefTable(SeekableInput seekableInput) throws IOException, ImageFormatException {
        this.readCrossTables(this.getStartXref(seekableInput), seekableInput);
    }

    public int getRoot() {
        return this.root_id;
    }

    public int getInfo() {
        return this.info_id;
    }

    public long getOffset(String string) throws ImageFormatException {
        return this.getOffset(Integer.parseInt(string));
    }

    public long getOffset(int n) throws ImageFormatException {
        long l = -1L;
        try {
            l = this.getLongFromHash(this.obj_offset, n);
        }
        catch (ImageFormatException imageFormatException) {
            List list = (List)this.compressed_objects.get(new Integer(n));
            l = this.getLongFromHash(this.obj_offset, (Integer)list.car());
        }
        return l;
    }

    public int getIndex(int n) throws ImageFormatException {
        int n2 = Integer.MIN_VALUE;
        try {
            this.getLongFromHash(this.obj_offset, n);
        }
        catch (ImageFormatException imageFormatException) {
            List list = (List)this.compressed_objects.get(new Integer(n));
            n2 = (Integer)list.last();
        }
        return n2;
    }

    private int getEOFMarker(byte[] byArray) {
        int n = byArray.length - 1;
        int n2 = EOF_MARKER.length - 1;
        while (n >= 0) {
            if (byArray[n - (EOF_MARKER.length - 1 - n2)] == EOF_MARKER[n2]) {
                if (n2 == 0) {
                    n -= EOF_MARKER.length - 1;
                    break;
                }
                --n2;
                continue;
            }
            if (n2 != EOF_MARKER.length - 1) {
                n -= EOF_MARKER.length - 1 - n2;
                n2 = EOF_MARKER.length - 1;
                continue;
            }
            --n;
        }
        return n;
    }

    private int getStartXref(SeekableInput seekableInput) throws IOException, ImageFormatException {
        long l = seekableInput.length();
        long l2 = l < 1024L ? 0L : l - 1024L;
        byte[] byArray = new byte[1024];
        seekableInput.seek(l2);
        seekableInput.read(byArray);
        int n = this.getEOFMarker(byArray);
        if (n == -1) {
            throw new ImageFormatException("%%EOF marker has not been found");
        }
        int n2 = this.getEOFMarker(byArray) - 1;
        while (n2 >= 0 && (byArray[n2] < 48 || byArray[n2] > 57)) {
            --n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 >= 0 && byArray[n2] >= 48 && byArray[n2] <= 57) {
            stringBuffer.append((char)byArray[n2]);
            --n2;
        }
        stringBuffer = stringBuffer.reverse();
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<getStartXref value=\"" + stringBuffer.toString() + "\"/>");
        }
        return Integer.parseInt(stringBuffer.toString());
    }

    private void readCrossStreamEntry(byte[] byArray, int n, int[] nArray) throws ImageFormatException {
        if (0 == n) {
            return;
        }
        int n2 = 0;
        if (0 == nArray[0]) {
            n2 = 1;
        } else {
            int n3 = 0;
            while (n3 < nArray[0]) {
                n2 = n2 << 8 | byArray[n3] & 0xFF;
                ++n3;
            }
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                long l = 0L;
                int n4 = 0;
                while (n4 < nArray[1]) {
                    l = l << 8 | (long)(byArray[nArray[0] + n4] & 0xFF);
                    ++n4;
                }
                if (this.obj_offset.containsKey(new Integer(n))) break;
                this.obj_offset.put(new Integer(n), new Long(l));
                if (PDFOutputStream.dump == null) break;
                PDFOutputStream.dumpprintln("<object number=\"" + n + "\" offset=\"" + l + "\"/>");
                break;
            }
            case 2: {
                int n5 = 0;
                int n6 = 0;
                while (n6 < nArray[1]) {
                    n5 = n5 << 8 | byArray[nArray[0] + n6] & 0xFF;
                    ++n6;
                }
                int n7 = 0;
                int n8 = 0;
                while (n8 < nArray[2]) {
                    n7 = n7 << 8 | byArray[nArray[0] + nArray[1] + n8] & 0xFF;
                    ++n8;
                }
                this.compressed_objects.put(new Integer(n), new List().append(new Integer(n5)).append(new Integer(n7)));
                break;
            }
            default: {
                throw new ImageFormatException("Unsupported type (" + n2 + ") of entries in a cross-reference stream.");
            }
        }
    }

    private void readCrossStreamEntries(PDFStream pDFStream) throws IOException, ImageFormatException {
        Object object;
        PNGPredictor pNGPredictor = null;
        int n = 0;
        Array array = ((PDFArray)pDFStream.dict.get((Object)"/W")).array;
        int[] nArray = new int[array.length()];
        int n2 = 0;
        while (n2 < array.length()) {
            int n3;
            nArray[n2] = n3 = Integer.parseInt(((PDFNumeric)array.get((int)n2)).value);
            n += n3;
            ++n2;
        }
        Array array2 = new Array();
        array2.put(0, new PDFNumeric("0", false));
        array2.put(1, (PDFNumeric)pDFStream.dict.get("/Size"));
        if (pDFStream.dict.containsKey("/Index")) {
            array2 = ((PDFArray)pDFStream.dict.get((Object)"/Index")).array;
        }
        int n4 = 0;
        if (pDFStream.dict.containsKey("/DecodeParms")) {
            object = (PDFDictionary)pDFStream.dict.get("/DecodeParms");
            int n5 = object.dict.containsKey("/Predictor") ? Integer.parseInt(((PDFNumeric)object.dict.get((Object)"/Predictor")).value) : 1;
            n4 = object.dict.containsKey("/Columns") ? Integer.parseInt(((PDFNumeric)object.dict.get((Object)"/Columns")).value) : n;
            switch (n5) {
                case 1: {
                    break;
                }
                case 2: {
                    throw new ImageFormatException("TIFF predictor inside a cross-reference stream is unsupported.");
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.crossStreamPredictor = 1;
                    break;
                }
                default: {
                    throw new ImageFormatException("Unsupported predictor type (" + n5 + ") inside a cross-reference stream.");
                }
            }
        }
        object = new byte[n];
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        int n6 = 0;
        while (n6 < byArray2.length) {
            byArray2[n6] = 0;
            ++n6;
        }
        int n7 = 0;
        while (n7 < array2.length()) {
            int n8 = Integer.parseInt(((PDFNumeric)array2.get((int)n7)).value);
            int n9 = Integer.parseInt(((PDFNumeric)array2.get((int)(++n7))).value);
            int n10 = 0;
            while (n10 < n9) {
                switch (this.crossStreamPredictor) {
                    case 0: {
                        System.arraycopy(pDFStream.array, n10 * n, object, 0, n);
                        break;
                    }
                    case 1: {
                        pNGPredictor = PNGPredictor.getPredictor(pDFStream.array[n10 * (n4 + 1)] & 0xFF);
                        System.arraycopy(pDFStream.array, n10 * (n4 + 1) + 1, byArray, 0, n4);
                        int n11 = 0;
                        while (n11 < byArray.length) {
                            byArray[n11] = pNGPredictor.decode(byArray[n11], n11, byArray2, byArray, 0);
                            ++n11;
                        }
                        object = byArray;
                        byArray2 = byArray;
                        byArray = new byte[n4];
                        break;
                    }
                }
                this.readCrossStreamEntry((byte[])object, n8 + n10, nArray);
                ++n10;
            }
            ++n7;
        }
    }

    private void readCrossRefDictionary(PDFDictionary pDFDictionary, SeekableInput seekableInput) throws IOException, ImageFormatException {
        if (pDFDictionary.dict.containsKey("/Encrypt")) {
            throw new ImageFormatException("Encrypted pdf files weren`t supported");
        }
        if (pDFDictionary.dict.containsKey("/Root") && this.root_id == 0) {
            this.root_id = ParseUtils.getIntFromIndirectObject((PDFElement)pDFDictionary.dict.get("/Root"));
            if (PDFOutputStream.dump != null) {
                PDFOutputStream.dumpprintln("<Root number=\"" + this.root_id + "\"/>");
            }
        }
        if (pDFDictionary.dict.containsKey("/Info") && this.info_id == 0) {
            this.info_id = ParseUtils.getIntFromIndirectObject((PDFElement)pDFDictionary.dict.get("/Info"));
            if (PDFOutputStream.dump != null) {
                PDFOutputStream.dumpprintln("<Info number=\"" + this.info_id + "\"/>");
            }
        }
        if (pDFDictionary.dict.containsKey("/Prev")) {
            this.readCrossTables(Integer.parseInt(((PDFNumeric)pDFDictionary.dict.get((Object)"/Prev")).value), seekableInput);
        }
    }

    private void readCrossStream(int n, SeekableInput seekableInput) throws IOException, ImageFormatException {
        seekableInput.seek(n);
        try {
            PDFStream pDFStream = (PDFStream)ElementParser.parse(new Lexer(seekableInput));
            if (!"/XRef".equals(pDFStream.getType())) {
                throw new ImageFormatException("Wrong offset of a cross-reference stream " + n);
            }
            pDFStream.filters = (PDFElement)pDFStream.dict.get("/Filter");
            pDFStream.streamLength = ParseUtils.readDigits(((PDFNumeric)pDFStream.dict.get((Object)"/Length")).value);
            pDFStream.array = ParseUtils.getStreamData(seekableInput, pDFStream.streamOffset, pDFStream.streamLength);
            pDFStream.decompress();
            this.readCrossStreamEntries(pDFStream);
            this.readCrossRefDictionary(pDFStream, seekableInput);
        }
        catch (ClassCastException classCastException) {
            throw new ImageFormatException("Wrong offset of a cross-reference stream " + n);
        }
    }

    private void readCrossTables(int n, SeekableInput seekableInput) throws IOException, ImageFormatException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<readCrossTable offset=\"" + n + "\">");
        }
        seekableInput.seek(n);
        if (!seekableInput.readLine().equals("xref")) {
            this.readCrossStream(n, seekableInput);
            return;
        }
        String string = null;
        long l = seekableInput.getFilePointer();
        while (!(string = seekableInput.readLine()).trim().startsWith("trailer")) {
            int n2 = (int)ParseUtils.readDigits(string);
            int n3 = (int)ParseUtils.readDigits(string.substring(string.indexOf(" ") + 1));
            int n4 = 0;
            while (n4 < n3) {
                StringTokenizer stringTokenizer = new StringTokenizer(seekableInput.readLine(), " ");
                long l2 = ParseUtils.readDigits(stringTokenizer.nextToken());
                ParseUtils.readDigits(stringTokenizer.nextToken());
                if (stringTokenizer.nextToken().startsWith("n") && !this.obj_offset.containsKey(new Integer(n2 + n4))) {
                    this.obj_offset.put(new Integer(n2 + n4), new Long(l2));
                    if (PDFOutputStream.dump != null) {
                        PDFOutputStream.dumpprintln("<object number=\"" + (n2 + n4) + "\" offset=\"" + l2 + "\"/>");
                    }
                }
                ++n4;
            }
            l = seekableInput.getFilePointer();
        }
        seekableInput.seek(l);
        Lexer lexer = new Lexer(seekableInput);
        try {
            lexer.nextToken();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PDFDictionary pDFDictionary = (PDFDictionary)ElementParser.parse(lexer);
        this.readCrossRefDictionary(pDFDictionary, seekableInput);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("</readCrossTable>");
        }
    }

    public long getLongFromHash(Hashtable hashtable, int n) throws ImageFormatException {
        Integer n2 = new Integer(n);
        if (hashtable.containsKey(n2)) {
            return (Long)hashtable.get(n2);
        }
        throw new ImageFormatException("Object " + n + " 0 R is missing in cross-reference table.");
    }

    public String toString() {
        if (this.obj_offset == null) {
            return null;
        }
        String string = "<xref>\n";
        try {
            Enumeration enumeration = this.obj_offset.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                string = string + "<object number=\"" + n + "\" offset=\"" + this.getOffset(n) + "\">\n";
            }
        }
        catch (ImageFormatException imageFormatException) {
            // empty catch block
        }
        string = string + "</xref>\n";
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(new XRefTable(new SeekableFileInputStream(stringArray[0])));
    }

    public static final class Test
    extends TestCase {
        protected void setUp() {
        }

        public void testOneXrefHashtable() {
            try {
                this.resourceToFile("com/renderx/pdflib/parser/TEST_DATA/oneXRT.pdf", "1.tst");
                XRefTable xRefTable = new XRefTable(new SeekableFileInputStream("1.tst"));
                IntegerHashtable integerHashtable = new IntegerHashtable("com/renderx/pdflib/parser/TEST_DATA/oneXRT.test");
                Assert.assertTrue((boolean)integerHashtable.equals(xRefTable.obj_offset));
                xRefTable = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                Assert.assertTrue((boolean)false);
            }
        }

        public void testOneXrefRoot() {
            try {
                this.resourceToFile("com/renderx/pdflib/parser/TEST_DATA/oneXRT.pdf", "1.tst");
                XRefTable xRefTable = new XRefTable(new SeekableFileInputStream("1.tst"));
                NameHashtable nameHashtable = new NameHashtable("com/renderx/pdflib/parser/TEST_DATA/oneRoot.test");
                Hashtable hashtable = new Hashtable();
                hashtable.put("Root", "" + xRefTable.getRoot());
                Assert.assertTrue((boolean)nameHashtable.equals(hashtable));
                xRefTable = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                Assert.assertTrue((boolean)false);
            }
        }

        public void testManyXrefHashtable() {
            try {
                this.resourceToFile("com/renderx/pdflib/parser/TEST_DATA/manyXRT.pdf", "1.tst");
                XRefTable xRefTable = new XRefTable(new SeekableFileInputStream("1.tst"));
                IntegerHashtable integerHashtable = new IntegerHashtable("com/renderx/pdflib/parser/TEST_DATA/manyXRT.test");
                Assert.assertTrue((boolean)integerHashtable.equals(xRefTable.obj_offset));
                xRefTable = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                Assert.assertTrue((boolean)false);
            }
        }

        public void testGarbageAfterEOF() {
            try {
                this.resourceToFile("com/renderx/pdflib/parser/TEST_DATA/garbageAfterEOF.pdf", "1.tst");
                XRefTable xRefTable = new XRefTable(new SeekableFileInputStream("1.tst"));
                IntegerHashtable integerHashtable = new IntegerHashtable("com/renderx/pdflib/parser/TEST_DATA/garbageAfterEOF.test");
                Assert.assertTrue((boolean)integerHashtable.equals(xRefTable.obj_offset));
                xRefTable = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                Assert.assertTrue((boolean)false);
            }
        }

        private void resourceToFile(String string, String string2) throws IOException {
            int n;
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, 1024)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }

        class IntegerHashtable {
            Hashtable ht;

            IntegerHashtable(String string) throws Exception {
                String string2;
                DataInputStream dataInputStream = new DataInputStream(ClassLoader.getSystemResourceAsStream(string));
                this.ht = new Hashtable();
                while ((string2 = dataInputStream.readLine()) != null) {
                    this.ht.put(new Integer(string2.substring(0, string2.indexOf(" "))), new Long(string2.substring(string2.indexOf(" ") + 1)));
                }
                dataInputStream.close();
            }

            boolean equals(Hashtable hashtable) {
                if (this.ht.size() != hashtable.size()) {
                    return false;
                }
                Enumeration enumeration = this.ht.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n = (Integer)enumeration.nextElement();
                    if (!hashtable.containsKey(n)) {
                        return false;
                    }
                    Long l = (Long)this.ht.get(n);
                    Long l2 = (Long)hashtable.get(n);
                    if (l.longValue() == l2.longValue()) continue;
                    return false;
                }
                return true;
            }
        }

        class NameHashtable {
            Hashtable ht;

            NameHashtable(String string) throws Exception {
                String string2;
                DataInputStream dataInputStream = new DataInputStream(ClassLoader.getSystemResourceAsStream(string));
                this.ht = new Hashtable();
                while ((string2 = dataInputStream.readLine()) != null) {
                    this.ht.put(string2.substring(0, string2.indexOf(" ")), string2.substring(string2.indexOf(" ") + 1));
                }
                dataInputStream.close();
            }

            boolean equals(Hashtable hashtable) {
                if (this.ht.size() != hashtable.size()) {
                    return false;
                }
                Enumeration enumeration = this.ht.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (!hashtable.containsKey(string2)) {
                        return false;
                    }
                    String string3 = (String)this.ht.get(string2);
                    if (string3.equals(string = (String)hashtable.get(string2))) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

