/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFIOException;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.List;

public abstract class PDFObject {
    List indirectObjects = null;
    IndirectObject obj_id = null;
    long start_offset;

    PDFObject(IndirectObject indirectObject) {
        this.obj_id = indirectObject;
    }

    IndirectObject getID() {
        return this.obj_id;
    }

    String getType() {
        return null;
    }

    abstract void writeBody(PDFOutputStream var1) throws PDFIOException;

    public void write(PDFOutputStream pDFOutputStream) throws PDFIOException {
        if (this.obj_id == null) {
            throw new PDFIOException("Object " + this.getType() + " don`t have obj_id");
        }
        pDFOutputStream.trailer.xref.addObjectOffset(this.obj_id, pDFOutputStream.size());
        pDFOutputStream.generateCurrentKey(this.getID().num);
        this.writeHead(pDFOutputStream);
        this.writeBody(pDFOutputStream);
        this.writeTail(pDFOutputStream);
        this.writeSubObjects(pDFOutputStream);
    }

    public void writeHead(PDFOutputStream pDFOutputStream) throws PDFIOException {
        this.start_offset = pDFOutputStream.size();
        pDFOutputStream.println(this.obj_id + " obj");
        pDFOutputStream.print("<<");
        if (this.getType() != null) {
            pDFOutputStream.println("/Type/" + this.getType());
        }
    }

    void writeTail(PDFOutputStream pDFOutputStream) throws PDFIOException {
        pDFOutputStream.println(">>\nendobj");
    }

    abstract void writeSubObjects(PDFOutputStream var1) throws PDFIOException;
}

