/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.graphics.Image;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFException;
import com.renderx.pdflib.PDFImage;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.Hashtable;
import com.renderx.util.URLSpec;

public class Images {
    private final Hashtable images = new Hashtable();
    private int count = 0;

    void addImage(IndirectObject indirectObject, Image image) {
        Hashtable hashtable = this.images;
        synchronized (hashtable) {
            this.images.put(image.getFactory().getKey(image), new Object[]{image, "I" + this.count, indirectObject});
        }
        ++this.count;
    }

    Object[] getImageNameAndOID(Image image) {
        Object[] objectArray = null;
        try {
            objectArray = (Object[])this.images.get(image.getFactory().getKey(image));
        }
        catch (Exception exception) {
            return null;
        }
        return objectArray;
    }

    void write(PDFOutputStream pDFOutputStream) {
        Object object;
        while (!this.images.isEmpty()) {
            Image image;
            object = (String)this.images.keys().nextElement();
            Object[] objectArray = (Object[])this.images.get(object);
            Image image2 = image = (Image)objectArray[0];
            synchronized (image2) {
                boolean bl = false;
                URLSpec uRLSpec = null;
                if (image.source == null) {
                    uRLSpec = image.getFactory().getSource(image);
                    if (image.source == null) {
                        bl = true;
                        image.source = uRLSpec;
                    }
                }
                IndirectObject indirectObject = (IndirectObject)objectArray[2];
                PDFImage pDFImage = null;
                try {
                    pDFImage = new PDFImage(indirectObject, image);
                    if (pDFOutputStream.doc.hasPDFX() && !"none".equals(pDFOutputStream.doc.pdfxConformanceStatus)) {
                        try {
                            pDFImage.checkPDFXColorSpace();
                        }
                        catch (PDFException pDFException) {
                            pDFOutputStream.error("" + pDFException.getMessage() + "; PDF/X status reverted to 'none'.");
                            pDFOutputStream.doc.pdfxConformanceStatus = "none";
                        }
                    }
                    pDFImage.write(pDFOutputStream);
                }
                catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
                    try {
                        pDFOutputStream.error("Cannot parse image '" + image.toDisplayString() + "': " + unregisteredMIMETypeException.getMessage());
                        Image image3 = pDFOutputStream.doc.imageFactory.makeImage(pDFOutputStream.doc.imageFactory.brokenimage);
                        if (this.getImageNameAndOID(image3) == null) {
                            this.addImage(indirectObject, image3);
                        }
                    }
                    catch (Exception exception) {
                        throw new PDFException(exception);
                    }
                }
                if (bl) {
                    image.source = null;
                }
            }
            this.images.remove(object);
            --this.count;
        }
        object = this.images;
        synchronized (object) {
            this.images.clear();
        }
    }

    boolean isEmpty() {
        return this.images.isEmpty();
    }
}

