<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://docbook.org/ns/docbook"
	xmlns="http://www.pixelmed.com/namespaces/srttosctmapping"
	exclude-result-prefixes="d"
  	version="1.0">

<xsl:strip-space elements="*" />

<xsl:output omit-xml-declaration="no" method="xml" indent="yes" encoding="UTF-8" />

<xsl:template match="d:book">
	<definesrttosctmappingtable>
		<xsl:apply-templates/>
	</definesrttosctmappingtable>
</xsl:template>

<xsl:template match="d:table[@label = 'O-1']">
		<xsl:if test="d:thead/d:tr/d:th[1] = 'Concept ID (SCT)'
				  and d:thead/d:tr/d:th[2] = 'SNOMED ID (SRT)'
				  and d:thead/d:tr/d:th[3] = 'SNOMED Fully Specified Name'">
			<xsl:for-each select="d:tbody/d:tr[string-length(normalize-space(d:td[1])) &gt; 0]">	<!-- ignore empty rows -->
				<xsl:if test="count(d:td) &gt; 2">
					<!--<mapping sct="{normalize-space(d:td[1])}" srt="{normalize-space(d:td[2])}" cm="{normalize-space(d:td[3])}"/>-->
					<mapping sct="{normalize-space(d:td[1])}" srt="{normalize-space(d:td[2])}"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
</xsl:template>

<xsl:template match="node()|@*">
		<xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet>
