<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://docbook.org/ns/docbook"
	xmlns="http://www.pixelmed.com/namespaces/contextgroups"
	exclude-result-prefixes="d"
  	version="1.0">

<xsl:strip-space elements="*" />

<xsl:output method="text" encoding="UTF-8" />

 <xsl:variable name='newline'><xsl:text>
</xsl:text></xsl:variable>


<xsl:template match="d:book">
	<xsl:message>Matching book</xsl:message>
	<definetemplates
			xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xmlns="http://www.pixelmed.com/namespaces/contextgroups"
			xsi:schemaLocation="http://www.pixelmed.com/namespaces/contextgroups http://www.pixelmed.com/schemas/contextgroups.xsd">
		<xsl:apply-templates match=""/>
	</definetemplates>
</xsl:template>

<!-- do not want to match Section 7 explanatory tables -->
<xsl:template match="d:table[@label[starts-with(.,'TID ')] and not(@label[contains(.,'&lt;')]) and not(d:caption='Parameters')]">
	<xsl:message>Template <xsl:value-of select="@label"/></xsl:message>
	<xsl:choose>
		<xsl:when test="d:thead/d:tr/d:th[1] = ''
				    and d:thead/d:tr/d:th[2] = 'NL'
				    and d:thead/d:tr/d:th[3] = 'Rel with Parent'
				    and d:thead/d:tr/d:th[4] = 'VT'
				    and d:thead/d:tr/d:th[5] = 'Concept Name'
				    and d:thead/d:tr/d:th[6] = 'VM'
				    and d:thead/d:tr/d:th[7] = 'Req Type'
				    and d:thead/d:tr/d:th[8] = 'Condition'
				    and d:thead/d:tr/d:th[9] = 'Value Set Constraint'">
			
			<xsl:variable name="tid"><xsl:value-of select="substring(@label,5)"/></xsl:variable>
			<xsl:variable name="templatename"><xsl:value-of select="translate(d:caption,' -','')"/></xsl:variable>
			<!-- process only top level content items, since each will then iterate through its own children, and so on recursively -->
			<xsl:for-each select="d:tbody/d:tr[string-length(normalize-space(d:td[2])) = 0]">
				<xsl:apply-templates select="." mode="groupnestinglevels">
					<xsl:with-param name="tid"><xsl:value-of select="$tid"/></xsl:with-param>
					<xsl:with-param name="templatename"><xsl:value-of select="$templatename"/></xsl:with-param>
				</xsl:apply-templates>
			</xsl:for-each>
		</xsl:when>
		<xsl:when test="d:thead/d:tr/d:th[1] = ''
				    and d:thead/d:tr/d:th[2] = 'NL'
				    and d:thead/d:tr/d:th[3] = 'VT'
				    and d:thead/d:tr/d:th[4] = 'Concept Name'
				    and d:thead/d:tr/d:th[5] = 'VM'
				    and d:thead/d:tr/d:th[6] = 'Req Type'
				    and d:thead/d:tr/d:th[7] = 'Condition'
				    and d:thead/d:tr/d:th[8] = 'Value Set Constraint'">
		</xsl:when>
		<xsl:when test="d:thead/d:tr/d:th[1] = ''
				    and d:thead/d:tr/d:th[2] = 'VT'
				    and d:thead/d:tr/d:th[3] = 'Concept Name'
				    and d:thead/d:tr/d:th[4] = 'VM'
				    and d:thead/d:tr/d:th[5] = 'Req Type'
				    and d:thead/d:tr/d:th[6] = 'Condition'
				    and d:thead/d:tr/d:th[7] = 'Value Set Constraint'">
		</xsl:when>
		<xsl:otherwise>
			<xsl:message>No heading match <xsl:value-of select="@label"/></xsl:message>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="d:tr" mode="groupnestinglevels">
	<xsl:param name="tid"/>
	<xsl:param name="templatename"/>
	
	<xsl:variable name="row"><xsl:value-of select="d:td[1]"/></xsl:variable>
	<xsl:if test="name(parent::node()) = 'tbody' and $row != ''">	<!-- untidy way to check not header, but it works :(; also excludes unlabelled rows-->
		<xsl:variable name="ourNestingLevel"><xsl:value-of select="string-length(normalize-space(d:td[2]))"/></xsl:variable>
		<xsl:variable name="relationship"><xsl:value-of select="normalize-space(d:td[3])"/></xsl:variable>
		<xsl:variable name="valueType"><xsl:value-of select="normalize-space(d:td[4])"/></xsl:variable>
		<xsl:variable name="conceptName"><xsl:value-of select="normalize-space(d:td[5])"/></xsl:variable>
		<xsl:variable name="vm"><xsl:value-of select="normalize-space(d:td[6])"/></xsl:variable>
		<xsl:variable name="requiredType"><xsl:value-of select="normalize-space(d:td[7])"/></xsl:variable>
		<xsl:variable name="condition"><xsl:value-of select="normalize-space(d:td[8])"/></xsl:variable>
		<xsl:variable name="valueSetConstraint"><xsl:value-of select="normalize-space(d:td[9])"/></xsl:variable>
		
		<xsl:variable name="vmmin">
			<xsl:choose>
				<xsl:when test="contains($vm,'-')">
					 <xsl:value-of select="substring-before($vm,'-')"/>
				</xsl:when>
				<xsl:otherwise>
					 <xsl:value-of select="$vm"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="vmmax">
			<xsl:choose>
				<xsl:when test="contains($vm,'-')">
					 <xsl:value-of select="substring-after($vm,'-')"/>
				</xsl:when>
				<xsl:otherwise>
					 <xsl:value-of select="$vm"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="vmminforcardinality">
			<xsl:choose>
				<xsl:when test="$requiredType = 'U'">
					 <xsl:value-of select="0"/>
				</xsl:when>
				<xsl:otherwise>
					 <xsl:value-of select="$vmmin"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="vmmaxforcardinality">
			<xsl:choose>
				<xsl:when test="$vmmax = 'n'">
					 <xsl:value-of select="'*'"/>
				</xsl:when>
				<xsl:otherwise>
					 <xsl:value-of select="$vmmax"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$valueType = 'INCLUDE'">
				<!-- ignore -->
			</xsl:when>
			<xsl:otherwise>
				<templatecontentitem>
					<xsl:choose>
						<xsl:when test="starts-with($conceptName,'EV') or starts-with($conceptName,'DT')">	<!-- do not need to worry about "DTID", since that only occurs with INCLUDE handled elsewhere -->
							<xsl:variable name="tupleForConceptName">
								<xsl:choose>
									<xsl:when test="starts-with($conceptName,'EV')">
										<xsl:value-of select="normalize-space(substring-after($conceptName,'EV'))"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="normalize-space(substring-after($conceptName,'DT'))"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:variable name="cvConceptName"><xsl:value-of select="normalize-space(substring-before(substring-after($tupleForConceptName,'('),','))"/></xsl:variable>
							<xsl:variable name="remainderConceptNameAfterCV"><xsl:value-of select="normalize-space(substring-after(substring-after($tupleForConceptName,'('),','))"/></xsl:variable>
							<xsl:variable name="csdConceptName"><xsl:value-of select="normalize-space(substring-before($remainderConceptNameAfterCV,','))"/></xsl:variable>
							<xsl:variable name="remainderConceptNameAfterCSD"><xsl:value-of select="normalize-space(substring-after($remainderConceptNameAfterCV,','))"/></xsl:variable>
							<xsl:variable name="cmConceptName"><xsl:value-of select="normalize-space(translate(substring-before($remainderConceptNameAfterCSD,')'),'&quot;',''))"/></xsl:variable>
							
							<xsl:text>"</xsl:text><xsl:value-of select="$cmConceptName"/><xsl:text>",</xsl:text><xsl:value-of select="$cvConceptName"/><xsl:text>,</xsl:text><xsl:value-of select="$csdConceptName"/><xsl:text>,</xsl:text><xsl:value-of select="$valueType"/><xsl:text>,</xsl:text><xsl:value-of select="$requiredType"/><xsl:value-of select="$newline"/>

						</xsl:when>
						<xsl:otherwise>
							<!-- ignore CID for concept name-->
						</xsl:otherwise>
					</xsl:choose>
					
					<!-- now recurse through all our immediate (only) children, so that they are enclosed with this templatecontentitem node -->
					<!--<xsl:message>Parent is <xsl:value-of select="preceding-sibling::d:tr[string-length(normalize-space(d:td[2])) &lt; string-length(normalize-space(current()/d:td[2]))][1]/d:td[1]"/></xsl:message>-->
					<!-- for-each d:tr that is an immediate child AND whose parent is us -->
					<xsl:variable name="ourid"><xsl:value-of select="generate-id(.)"/></xsl:variable>
					<xsl:for-each select="following-sibling::d:tr[string-length(normalize-space(d:td[2])) = ($ourNestingLevel + 1) and generate-id(preceding-sibling::d:tr[string-length(normalize-space(d:td[2])) = $ourNestingLevel][1]) = $ourid]">
						<!--<xsl:message>Have child row <xsl:value-of select="d:td[1]"/></xsl:message>-->
						<xsl:apply-templates select="." mode="groupnestinglevels">
							<xsl:with-param name="tid"><xsl:value-of select="$tid"/></xsl:with-param>
							<xsl:with-param name="templatename"><xsl:value-of select="$templatename"/></xsl:with-param>
						</xsl:apply-templates>
					</xsl:for-each>
					<!--<xsl:message>Closing row</xsl:message>-->
				</templatecontentitem>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>

<xsl:template match="node()|@*|">
		<xsl:apply-templates match=""/>
</xsl:template>

<xsl:template match="text()"/>

</xsl:stylesheet>
