/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xepout;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontConfigurationException;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import com.renderx.xepout.ParseTerminationException;
import com.renderx.xepout.XEPOUTParserHandler;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Parser {
    private final ImageFactory imageFactory;
    private final ErrorHandler errHandler;
    private final FontCatalog fontCatalog;

    public Parser(ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler) throws IOException, SAXException {
        this.imageFactory = imageFactory;
        this.fontCatalog = fontCatalog;
        this.errHandler = errorHandler;
    }

    protected Parser() throws IOException, SAXException, FontConfigurationException {
        this(new URLCache(new DefaultErrorHandler()), new DefaultErrorHandler());
    }

    private Parser(URLCache uRLCache, ErrorHandler errorHandler) throws IOException, SAXException, FontConfigurationException {
        this(new FontCatalog(uRLCache, errorHandler), uRLCache, errorHandler);
    }

    private Parser(FontCatalog fontCatalog, URLCache uRLCache, ErrorHandler errorHandler) throws IOException, SAXException {
        this(new ImageFactory(fontCatalog, uRLCache, errorHandler), fontCatalog, errorHandler);
    }

    public ImageTree parse(XMLReader xMLReader, org.xml.sax.InputSource inputSource, URLSpec uRLSpec, double d, double d2) throws IOException, ImageFormatException, SAXException {
        XEPOUTParserHandler xEPOUTParserHandler = new XEPOUTParserHandler(this.imageFactory, this.fontCatalog, this.errHandler, d, d2);
        try {
            xMLReader.setContentHandler(xEPOUTParserHandler);
            xMLReader.parse(inputSource);
        }
        catch (ParseTerminationException parseTerminationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return xEPOUTParserHandler.tree;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0] + ".ps";
            System.out.println("Dumping graphic tree to " + string);
        } else if (stringArray.length == 2) {
            string = stringArray[1];
        } else {
            System.out.println("Usage: com.renderx.xepout.Parser <input file name> [<output file name>]");
            System.exit(0);
        }
        URLSpec uRLSpec = new URLSpec(stringArray[0]);
        new Parser().parse(XMLReaderFactory.createXMLReader(), new InputSource(uRLSpec), uRLSpec, 57.0, 25.0).dump(new PrintStream(new FileOutputStream(string)), "");
    }
}

