/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.Encoding;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.Metric;
import com.renderx.fonts.PFxFont;
import com.renderx.pslib.PSOutputStream;
import com.renderx.util.SeekableInput;
import java.io.IOException;

public class T1Font {
    FontDescriptor fdesc;

    public T1Font(FontDescriptor fontDescriptor) {
        this.fdesc = fontDescriptor;
    }

    public void write(PSOutputStream pSOutputStream) {
        if (this.fdesc.record.fontfile == null) {
            pSOutputStream.doc.errorHandler.error("No PFA/PFB file found for font " + this.fdesc.record.getMetric().fontName);
            return;
        }
        try {
            SeekableInput seekableInput = this.fdesc.record.openSeekableFontStream();
            try {
                PFxFont pFxFont = new PFxFont(seekableInput);
                if (this.fdesc.record.subset) {
                    Metric metric = this.fdesc.record.getMetric();
                    pFxFont.newSubset();
                    int n = 0;
                    while (n < 65536) {
                        CharMetrics charMetrics;
                        if (this.fdesc.used.checkGlyph((char)n) && (charMetrics = metric.ucm((char)n)) != null) {
                            pFxFont.addGlyph(charMetrics.n, (Encoding)this.fdesc.encodingTable.get(0));
                        }
                        ++n;
                    }
                    pFxFont.endSubset();
                }
                pSOutputStream.print(pFxFont.head);
                if (this.fdesc.record.subset) {
                    pSOutputStream.writeHexArray(pFxFont.subsetbody);
                } else {
                    pSOutputStream.writeHexArray(pFxFont.body);
                }
                pSOutputStream.println("\n" + pFxFont.tail);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                seekableInput.close();
                throw throwable;
            }
            seekableInput.close();
            {
            }
        }
        catch (IOException iOException) {
            pSOutputStream.doc.errorHandler.exception("Cannot read font file '" + this.fdesc.record.fontfile + "'", iOException);
        }
    }
}

