/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.util.LZWDecoderStream;
import com.renderx.util.SeekableInput;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;

public class GIFImage
extends BitmapImage {
    private long dataOffset = -1L;
    private int minimumCodeSize = -1;
    private boolean interlaced = false;

    public GIFImage() {
        this.mimetype = "image/gif";
    }

    public void parse() throws IOException, ImageFormatException {
        this.colorSpace = (short)6;
        this.compressionMethod = (short)7;
        this.canCopyData = false;
        this.canExpandData = true;
        this.usesBigEndian = false;
        this.bitsPerComponent = 8;
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            block19: {
                int n;
                seekableInput.seek(0L);
                byte[] byArray = new byte[6];
                seekableInput.readFully(byArray);
                if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 70) {
                    throw new ImageFormatException("Invalid GIF signature in file '" + this.toDisplayString() + "'");
                }
                if (byArray[3] != 56 || byArray[4] != 55 && byArray[4] != 57 || byArray[5] != 97) {
                    throw new ImageFormatException("Unknown GIF version in file '" + this.toDisplayString() + "'");
                }
                this.colorTable = null;
                seekableInput.skipBytes(4);
                int n2 = seekableInput.readUnsignedByte();
                seekableInput.skipBytes(1);
                int n3 = seekableInput.readUnsignedByte();
                if (n3 != 0) {
                    double d = Math.sqrt(((double)n3 + 15.0) / 64.0);
                    this.horzResolution /= d;
                    this.vertResolution *= d;
                    this.noResolution = false;
                }
                if ((n2 & 0x80) != 0) {
                    int n4 = 2 << (n2 & 7);
                    this.colorTable = new byte[3 * n4];
                    seekableInput.readFully(this.colorTable);
                }
                while (true) {
                    int n5;
                    if ((n = seekableInput.readUnsignedByte()) == 59) {
                        throw new ImageFormatException("No raster data found in GIF image '" + this.toDisplayString() + "'");
                    }
                    if (n == 44) {
                        seekableInput.skipBytes(4);
                        this.pxWidth = this.readUnsignedShortLE(seekableInput);
                        this.pxHeight = this.readUnsignedShortLE(seekableInput);
                        this.setDimensions();
                        n2 = seekableInput.readUnsignedByte();
                        if ((n2 & 0x40) != 0) {
                            this.interlaced = true;
                        }
                        if ((n2 & 0x80) != 0) {
                            n5 = 2 << (n2 & 7);
                            this.colorTable = new byte[3 * n5];
                            seekableInput.readFully(this.colorTable);
                        }
                        if (this.colorTable == null) {
                            throw new ImageFormatException("Invalid GIF image '" + this.toDisplayString() + "': color table not found");
                        }
                        this.minimumCodeSize = seekableInput.readUnsignedByte();
                        if (this.minimumCodeSize < 2 || this.minimumCodeSize > 12) {
                            throw new ImageFormatException("GIF image '" + this.toDisplayString() + "' has incorrect value for initial LZW code: " + this.minimumCodeSize);
                        }
                        break block19;
                    }
                    if (n != 33) break;
                    n5 = seekableInput.readUnsignedByte();
                    if (n5 == 249) {
                        seekableInput.read();
                        n2 = seekableInput.readUnsignedByte();
                        seekableInput.skipBytes(2);
                        if ((n2 & 1) != 0) {
                            this.transparentColor = new byte[1];
                            seekableInput.readFully(this.transparentColor);
                        } else {
                            seekableInput.skipBytes(1);
                        }
                        seekableInput.skipBytes(1);
                        continue;
                    }
                    if (n5 == 1) {
                        seekableInput.skipBytes(13);
                        this.skipBlocks(seekableInput);
                        continue;
                    }
                    if (n5 == 254) {
                        this.skipBlocks(seekableInput);
                        continue;
                    }
                    if (n5 == 255) {
                        seekableInput.skipBytes(12);
                        this.skipBlocks(seekableInput);
                        continue;
                    }
                    this.skipBlocks(seekableInput);
                }
                throw new ImageFormatException("Unexpected block type: " + n);
            }
            this.dataOffset = seekableInput.getFilePointer();
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
    }

    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        throw new ImageFormatException("Cannot copy LZW compressed data in GIF image. LZW stream should be uncompressed.");
    }

    public void expandData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoderStream lZWDecoderStream = null;
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            int n;
            seekableInput.seek(this.dataOffset);
            lZWDecoderStream = this.interlaced ? new LZWDecoderStream(byteArrayOutputStream, this.minimumCodeSize, true, false, -1) : new LZWDecoderStream(outputStream, this.minimumCodeSize, true, false, -1);
            byte[] byArray = new byte[260];
            boolean bl = false;
            while ((n = seekableInput.readUnsignedByte()) != 0) {
                seekableInput.readFully(byArray, 0, n);
                try {
                    lZWDecoderStream.write(byArray, 0, n);
                }
                catch (IOException iOException) {
                    throw new IOException("GIF image '" + this.toDisplayString() + "': " + iOException.getMessage());
                }
            }
            lZWDecoderStream.flush();
            if (this.interlaced) {
                int n2;
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                int[] nArray = new int[this.pxHeight];
                if (byArray2.length != this.pxHeight * this.pxWidth) {
                    throw new ImageFormatException("Number of pixels is: " + byArray2.length + " while image dimensions are: " + this.pxHeight + "x" + this.pxWidth);
                }
                int[] nArray2 = new int[]{(int)Math.ceil((double)this.pxHeight / 8.0), (int)Math.ceil(((double)this.pxHeight - 4.0) / 8.0), (int)Math.ceil(((double)this.pxHeight - 2.0) / 4.0), (int)Math.ceil(((double)this.pxHeight - 1.0) / 2.0)};
                int n3 = 0;
                int n4 = 0;
                while (n4 < 4) {
                    n2 = 0;
                    while (n2 < nArray2[n4]) {
                        switch (n4) {
                            case 3: {
                                nArray[1 + n2 * 2] = n3 + n2;
                                break;
                            }
                            case 2: {
                                nArray[2 + n2 * 4] = n3 + n2;
                                break;
                            }
                            case 1: {
                                nArray[4 + n2 * 8] = n3 + n2;
                                break;
                            }
                            case 0: {
                                nArray[0 + n2 * 8] = n3 + n2;
                            }
                        }
                        ++n2;
                    }
                    n3 += n2;
                    ++n4;
                }
                n2 = 0;
                while (n2 < this.pxHeight) {
                    outputStream.write(byArray2, nArray[n2] * this.pxWidth, this.pxWidth);
                    ++n2;
                }
                outputStream.flush();
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
    }

    private final int readUnsignedShortLE(SeekableInput seekableInput) throws IOException {
        int n;
        int n2 = seekableInput.read();
        if ((n2 | (n = seekableInput.read())) < 0) {
            throw new EOFException();
        }
        return (n << 8) + (n2 << 0);
    }

    private int skipBlocks(SeekableInput seekableInput) throws IOException {
        int n;
        int n2 = 0;
        while ((n = seekableInput.readUnsignedByte()) != 0) {
            n2 += n;
            seekableInput.skipBytes(n);
        }
        return n2;
    }
}

