/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.CFFMetric;
import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.Diacritics;
import com.renderx.fonts.FontFileFormatError;
import com.renderx.fonts.KernVector;
import com.renderx.fonts.Metric;
import com.renderx.util.Array;
import com.renderx.util.Hashtable;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import com.renderx.util.SeekableInputOffsetFilter;
import com.renderx.util.UnicodeTable;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;

public class TTMetric
extends Metric {
    private static final char[] macTable = new char[256];
    boolean restrictEmbedding = false;
    boolean readOnlyEmbedding = true;
    boolean editableEmbedding = true;
    boolean disableSubsetting = false;
    boolean bitmapOnlyEmbedding = false;
    Hashtable glyphIndexTable = null;
    Hashtable table_offsets;
    Hashtable table_length;
    protected CFFMetric cffMetric = null;
    public long cff_offset = 0L;
    public long cff_length = 0L;
    public int subfontNumber = 1;
    public int subfontsTotal = 1;
    public static String[] DEFAULT_CHARSET_TO_UGL;

    public boolean embeddable() {
        return !this.bitmapOnlyEmbedding && (this.readOnlyEmbedding || this.editableEmbedding || !this.restrictEmbedding);
    }

    public boolean subsettable() {
        return !this.disableSubsetting;
    }

    public TTMetric(SeekableInput seekableInput, int n) throws IOException, FontFileFormatError {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        long l;
        this.isTrueType = true;
        this.isCIDFont = true;
        this.glyphIndexTable = new Hashtable();
        byte[] byArray = new byte[4];
        seekableInput.readFully(byArray);
        if (byArray[0] == 116 && byArray[1] == 116 && byArray[2] == 99 && byArray[3] == 102) {
            this.isTTC = true;
            this.seekSubfont(seekableInput, n);
            seekableInput.readFully(byArray);
        } else if (n != 1) {
            throw new FontFileFormatError("Font is not a TrueType Collection; cannot extract multiple fonts");
        }
        this.parseTablesAndNames(seekableInput, byArray);
        long l2 = TTMetric.getTableOffset(this.table_offsets, "maxp");
        seekableInput.seek(l2 + 4L);
        this.numGlyphs = seekableInput.readUnsignedShort();
        long l3 = TTMetric.getTableOffset(this.table_offsets, "head");
        seekableInput.seek(l3 + 12L);
        if (seekableInput.readUnsignedInt() != 1594834165L) {
            throw new FontFileFormatError("Magic number in the font header does not match the spec: file probably corrupt");
        }
        seekableInput.skipBytes(2);
        double d = 1.0 * (double)seekableInput.readUnsignedShort();
        seekableInput.skipBytes(16);
        this.fontBBox = new float[4];
        this.fontBBox[0] = TTMetric.readLength(seekableInput, d);
        this.fontBBox[1] = TTMetric.readLength(seekableInput, d);
        this.fontBBox[2] = TTMetric.readLength(seekableInput, d);
        this.fontBBox[3] = TTMetric.readLength(seekableInput, d);
        long l4 = TTMetric.getTableOffset(this.table_offsets, "OS/2");
        seekableInput.seek(l4);
        int n11 = seekableInput.readUnsignedShort();
        this.wx = TTMetric.readLength(seekableInput, d);
        switch (seekableInput.readUnsignedShort()) {
            case 100: {
                this.weight = "Thin";
                break;
            }
            case 200: {
                this.weight = "Extra-light";
                break;
            }
            case 300: {
                this.weight = "Light";
                break;
            }
            case 400: {
                this.weight = "Normal";
                break;
            }
            case 500: {
                this.weight = "Medium";
                break;
            }
            case 600: {
                this.weight = "Demi-bold";
                break;
            }
            case 700: {
                this.weight = "Bold";
                break;
            }
            case 800: {
                this.weight = "Extra-Bold";
                break;
            }
            case 900: {
                this.weight = "Black";
            }
        }
        seekableInput.skipBytes(2);
        int n12 = seekableInput.readUnsignedShort();
        this.restrictEmbedding = (n12 & 2) != 0;
        this.readOnlyEmbedding = (n12 & 4) != 0;
        this.editableEmbedding = (n12 & 8) != 0;
        this.disableSubsetting = (n12 & 0x100) != 0;
        this.bitmapOnlyEmbedding = (n12 & 0x200) != 0;
        seekableInput.skipBytes(58);
        this.ascender = TTMetric.readLength(seekableInput, d);
        this.descender = TTMetric.readLength(seekableInput, d);
        char c = '\u0000';
        if (n11 == 2) {
            float f;
            seekableInput.skipBytes(14);
            float f2 = TTMetric.readLength(seekableInput, d);
            if (f2 != 0.0f) {
                this.xHeight = f2;
            }
            if ((f = TTMetric.readLength(seekableInput, d)) != 0.0f) {
                this.capHeight = f;
            }
            c = (char)seekableInput.readUnsignedShort();
        }
        int n13 = 65536;
        int[] nArray = null;
        Array array = null;
        if (this.table_offsets.get("post") != null) {
            l = TTMetric.getTableOffset(this.table_offsets, "post");
            seekableInput.seek(l);
            n13 = seekableInput.readInt();
            this.italicAngle = seekableInput.readShort();
            seekableInput.skipBytes(2);
            this.underlinePosition = TTMetric.readLength(seekableInput, d);
            this.underlineThickness = TTMetric.readLength(seekableInput, d);
            this.isFixedPitch = seekableInput.readUnsignedInt() != 0L;
            seekableInput.readInt();
            seekableInput.readInt();
            seekableInput.readInt();
            seekableInput.readInt();
            switch (n13) {
                case 65536: 
                case 196608: {
                    break;
                }
                case 131072: {
                    n10 = seekableInput.readUnsignedShort();
                    nArray = new int[this.numGlyphs];
                    int n14 = 0;
                    while (n14 < this.numGlyphs) {
                        nArray[n14] = 0;
                        ++n14;
                    }
                    int n15 = 0;
                    int n16 = 0;
                    while (n16 < n10) {
                        nArray[n16] = seekableInput.readUnsignedShort();
                        if (n15 < nArray[n16]) {
                            n15 = nArray[n16];
                        }
                        ++n16;
                    }
                    if (n15 <= 257) break;
                    array = new Array();
                    n15 -= 257;
                    n9 = 0;
                    while (n9 < n15) {
                        int n17 = seekableInput.readUnsignedByte();
                        String string = "";
                        int n18 = 0;
                        while (n18 < n17) {
                            string = string + (char)seekableInput.readUnsignedByte();
                            ++n18;
                        }
                        array.put(n9 + 258, string);
                        ++n9;
                    }
                    break;
                }
                case 163840: {
                    nArray = new int[this.numGlyphs];
                    n9 = 0;
                    while (n9 < this.numGlyphs) {
                        nArray[n9] = seekableInput.readShort() + n9;
                        ++n9;
                    }
                    break;
                }
                default: {
                    throw new FontFileFormatError("Wrong Format Type into post table");
                }
            }
        }
        l = TTMetric.getTableOffset(this.table_offsets, "hhea");
        seekableInput.seek(l + 34L);
        n10 = seekableInput.readUnsignedShort();
        float[] fArray = new float[n10];
        long l5 = TTMetric.getTableOffset(this.table_offsets, "hmtx");
        seekableInput.seek(l5);
        n9 = 0;
        while (n9 < n10) {
            fArray[n9] = TTMetric.readLength(seekableInput, d);
            seekableInput.skipBytes(2);
            ++n9;
        }
        float[] fArray2 = null;
        int n19 = 0;
        if (this.table_offsets.get("vmtx") != null) {
            long l6 = TTMetric.getTableOffset(this.table_offsets, "vhea");
            seekableInput.seek(l6 + 34L);
            n19 = seekableInput.readUnsignedShort();
            long l7 = TTMetric.getTableOffset(this.table_offsets, "vmtx");
            seekableInput.seek(l7);
            fArray2 = new float[n19];
            n8 = 0;
            while (n8 < n19) {
                fArray2[n8] = TTMetric.readLength(seekableInput, d);
                seekableInput.skipBytes(2);
                ++n8;
            }
        }
        long[] lArray = null;
        if (!this.isCFF) {
            seekableInput.seek(l3 + 50L);
            boolean bl = seekableInput.readUnsignedShort() == 0;
            lArray = new long[this.numGlyphs];
            seekableInput.seek(TTMetric.getTableOffset(this.table_offsets, "loca"));
            if (bl) {
                int n20 = 0;
                while (n20 < this.numGlyphs) {
                    lArray[n20] = seekableInput.readUnsignedShort() * 2;
                    ++n20;
                }
            } else {
                n7 = 0;
                while (n7 < this.numGlyphs) {
                    lArray[n7] = seekableInput.readUnsignedInt();
                    ++n7;
                }
            }
        } else {
            this.cff_offset = TTMetric.getTableOffset(this.table_offsets, "CFF ");
            this.cff_length = TTMetric.getTableOffset(this.table_length, "CFF ");
            this.cffMetric = new CFFMetric(new SeekableInputOffsetFilter(seekableInput, this.cff_offset), this.fontName);
            this.isCIDFont = this.cffMetric.isCIDFont;
        }
        long l8 = TTMetric.getTableOffset(this.table_offsets, "cmap");
        seekableInput.seek(l8 + 2L);
        n7 = seekableInput.readUnsignedShort();
        while (n7-- > 0) {
            n8 = seekableInput.readUnsignedShort();
            int n21 = seekableInput.readUnsignedShort();
            if (n8 == 3 && n21 == 1 || n8 == 0 && n21 == 3) break;
            seekableInput.skipBytes(4);
        }
        if (n7 < 0) {
            throw new FontFileFormatError("Cannot use TrueType/OpenType font: no Unicode mapping table found");
        }
        long l9 = seekableInput.readUnsignedInt();
        seekableInput.seek(l8 + l9);
        if (seekableInput.readUnsignedShort() != 4) {
            throw new FontFileFormatError("Cannot use TrueType/OpenType font: unknown format of Unicode 'cmap' table");
        }
        int n22 = seekableInput.readUnsignedShort();
        seekableInput.skipBytes(2);
        int n23 = seekableInput.readUnsignedShort() / 2;
        seekableInput.skipBytes(6);
        while (n22 < 16 + 8 * n23) {
            n22 += 65536;
        }
        int n24 = n22 / 2 - (8 + n23 * 4);
        int[] nArray2 = TTMetric.readUnsignedShortArray(seekableInput, n23);
        seekableInput.skipBytes(2);
        int[] nArray3 = TTMetric.readUnsignedShortArray(seekableInput, n23);
        int[] nArray4 = TTMetric.readUnsignedShortArray(seekableInput, n23);
        int[] nArray5 = TTMetric.readUnsignedShortArray(seekableInput, n23);
        int[] nArray6 = TTMetric.readUnsignedShortArray(seekableInput, n24);
        long l10 = this.isCFF ? 0L : TTMetric.getTableOffset(this.table_offsets, "glyf");
        this.missingGlyph = new CharMetrics();
        this.missingGlyph.uc = '\u0000';
        this.missingGlyph.c = 0;
        this.missingGlyph.b = this.fontBBox;
        this.missingGlyph.wx = fArray != null ? fArray[0] : 1000.0f;
        this.missingGlyph.wy = fArray2 != null ? fArray2[0] : 1000.0f;
        this.uniTable.put('\u0000', this.missingGlyph);
        int n25 = 0;
        while (n25 < n23) {
            int n26 = nArray3[n25];
            int n27 = nArray2[n25];
            n6 = nArray4[n25];
            n5 = nArray5[n25];
            n4 = n26;
            while (n4 <= n27 && n4 < 65534) {
                CharMetrics charMetrics = new CharMetrics();
                charMetrics.uc = (char)n4;
                n3 = 0;
                if (n5 == 0) {
                    n3 = n4 + n6 & 0xFFFF;
                } else {
                    n2 = n4 - n26 + n5 / 2 - (n23 - n25);
                    if (n2 < 0 || n2 >= nArray6.length) {
                        throw new FontFileFormatError("Error in TrueType font: Glyph ID for U+" + Integer.toHexString(n4) + " not found in cmap table");
                    }
                    n3 = nArray6[n2];
                }
                if (n3 > this.numGlyphs) {
                    throw new FontFileFormatError("Error in TrueType font: Glyph ID " + n3 + "exceeds max number of glyphs (" + this.numGlyphs + ")");
                }
                if (fArray != null) {
                    float f = charMetrics.wx = n3 < fArray.length ? fArray[n3] : fArray[fArray.length - 1];
                }
                if (fArray2 != null) {
                    float f = charMetrics.wy = n3 < fArray2.length ? fArray2[n3] : fArray2[fArray2.length - 1];
                }
                if (Diacritics.diacritics[charMetrics.uc]) {
                    charMetrics.wx = 0.0f;
                }
                if (this.isCFF) {
                    charMetrics.b = this.fontBBox;
                } else {
                    charMetrics.b = new float[4];
                    seekableInput.seek(l10 + lArray[n3]);
                    seekableInput.skipBytes(2);
                    charMetrics.b[0] = TTMetric.readLength(seekableInput, d);
                    charMetrics.b[1] = TTMetric.readLength(seekableInput, d);
                    charMetrics.b[2] = TTMetric.readLength(seekableInput, d);
                    charMetrics.b[3] = TTMetric.readLength(seekableInput, d);
                    if (this.capHeight == Float.MIN_VALUE && charMetrics.uc == 'H') {
                        this.capHeight = charMetrics.b[3];
                    }
                    if (this.xHeight == Float.MIN_VALUE && charMetrics.uc == 'x') {
                        this.xHeight = charMetrics.b[3];
                    }
                }
                charMetrics.c = n3;
                charMetrics.n = new String(this.getName(n3, n13, nArray, array));
                if (this.isCFF) {
                    if (this.cffMetric.isCIDFont) {
                        charMetrics.c = this.cffMetric.getGlyphCID(n3);
                    } else {
                        charMetrics.n = this.cffMetric.getGlyphName(n3);
                    }
                }
                if (c == charMetrics.uc && n3 != 0) {
                    this.missingGlyph = charMetrics;
                }
                this.uniTable.put(charMetrics.uc, charMetrics);
                this.glyphIndexTable.put(new Integer(charMetrics.c), charMetrics);
                ++n4;
            }
            ++n25;
        }
        if (this.table_offsets.get("kern") != null) {
            long l11 = TTMetric.getTableOffset(this.table_offsets, "kern");
            seekableInput.seek(l11 + 2L);
            n6 = seekableInput.readUnsignedShort();
            while (n6-- > 0) {
                seekableInput.skipBytes(2);
                n5 = seekableInput.readUnsignedShort();
                n4 = seekableInput.readUnsignedShort();
                if (((n4 | 0xB0000000) ^ 0xB0000000) > 1) {
                    seekableInput.skipBytes(n5 - 6);
                    continue;
                }
                int n28 = n4 & Integer.MIN_VALUE;
                n3 = n4 & 0x20000000;
                n2 = (n4 & 0x10000000) > 0 ? 1 : 0;
                int n29 = seekableInput.readUnsignedShort();
                seekableInput.skipBytes(6);
                while (n29-- > 0) {
                    KernVector kernVector;
                    Integer n30 = new Integer(seekableInput.readUnsignedShort());
                    Integer n31 = new Integer(seekableInput.readUnsignedShort());
                    double d2 = TTMetric.readLength(seekableInput, d);
                    CharMetrics charMetrics = (CharMetrics)this.glyphIndexTable.get(n30);
                    CharMetrics charMetrics2 = (CharMetrics)this.glyphIndexTable.get(n31);
                    if (charMetrics == null || charMetrics2 == null) continue;
                    char c2 = charMetrics2.uc;
                    if (charMetrics.kernTable == null) {
                        charMetrics.kernTable = new UnicodeTable();
                    }
                    KernVector kernVector2 = kernVector = charMetrics.kernTable.get(c2) == null ? new KernVector() : (KernVector)charMetrics.kernTable.get(c2);
                    if (n28 == n3 && (kernVector.X == 0.0 || n2 != 0)) {
                        kernVector.X = d2;
                    } else if (n28 != n3 && (kernVector.Y == 0.0 || n2 != 0)) {
                        kernVector.Y = d2;
                    }
                    charMetrics.kernTable.put(c2, kernVector);
                }
            }
        }
        this.checkData();
        this.table_offsets = null;
        this.table_length = null;
    }

    private static float readLength(SeekableInput seekableInput, double d) throws IOException {
        return (float)(1000.0 * (double)seekableInput.readShort() / d);
    }

    private static int[] readUnsignedShortArray(DataInput dataInput, int n) throws IOException {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = dataInput.readUnsignedShort();
            ++n2;
        }
        return nArray;
    }

    private static String readName(SeekableInput seekableInput, long l, int n, long l2, int n2) throws IOException {
        if (n > 0) {
            return TTMetric.readUnicodeString(seekableInput, l, n);
        }
        if (n2 > 0) {
            return TTMetric.readMacRomanString(seekableInput, l2, n2);
        }
        return "";
    }

    private static String readUnicodeString(SeekableInput seekableInput, long l, int n) throws IOException {
        seekableInput.seek(l);
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)seekableInput.readUnsignedShort();
            ++n2;
        }
        return new String(cArray);
    }

    private static String readMacRomanString(SeekableInput seekableInput, long l, int n) throws IOException {
        seekableInput.seek(l);
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = macTable[seekableInput.readUnsignedByte()];
            ++n2;
        }
        return new String(cArray);
    }

    private static long getTableOffset(Hashtable hashtable, String string) throws FontFileFormatError {
        Long l = (Long)hashtable.get(string);
        if (l == null) {
            throw new FontFileFormatError("Invalid TrueType/OpenType file structure: no '" + string + "' table found");
        }
        return l;
    }

    private String getName(int n, int n2, int[] nArray, Array array) {
        switch (n2) {
            case 65536: 
            case 196608: {
                if (n < DEFAULT_CHARSET_TO_UGL.length) {
                    return DEFAULT_CHARSET_TO_UGL[n];
                }
                return "uni" + n;
            }
            case 131072: 
            case 163840: {
                int n3 = nArray[n];
                if (n3 < 258) {
                    return DEFAULT_CHARSET_TO_UGL[n3];
                }
                return (String)array.get(n3);
            }
        }
        return ".notdef";
    }

    private void seekSubfont(SeekableInput seekableInput, int n) throws IOException, FontFileFormatError {
        byte[] byArray = new byte[4];
        seekableInput.readFully(byArray);
        int n2 = byArray[0] * 256 + byArray[1];
        int n3 = byArray[2] * 256 + byArray[3];
        if (n2 != 1 && n2 != 2 || n3 != 0) {
            throw new FontFileFormatError("Unsupported version of TrueType Collection header: " + n2 + "." + n3);
        }
        this.subfontsTotal = seekableInput.readInt();
        if (n > this.subfontsTotal || n < 1) {
            throw new FontFileFormatError("Invalid font number " + n + " in TrueType collection: should be in the range from 1 to " + this.subfontsTotal + ".");
        }
        this.subfontNumber = n;
        int[] nArray = new int[this.subfontsTotal];
        int n4 = 0;
        while (n4 < this.subfontsTotal) {
            nArray[n4] = seekableInput.readInt();
            ++n4;
        }
        seekableInput.seek(nArray[this.subfontNumber - 1]);
    }

    private void parseTablesAndNames(SeekableInput seekableInput, byte[] byArray) throws IOException, FontFileFormatError {
        int n;
        if (byArray[0] == 79 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 79) {
            this.isCFF = true;
        } else {
            n = byArray[0] * 256 + byArray[1];
            int n2 = byArray[2] * 256 + byArray[3];
            if (n != 1 || n2 != 0) {
                throw new FontFileFormatError("Not a TrueType/OpenType file, or unsupported TrueType version: " + n + "." + n2);
            }
            this.isCFF = false;
        }
        n = seekableInput.readUnsignedShort();
        seekableInput.skipBytes(6);
        this.table_offsets = new Hashtable();
        this.table_length = new Hashtable();
        while (n-- > 0) {
            byte[] byArray2 = new byte[4];
            seekableInput.readFully(byArray2);
            String string = new String(byArray2);
            seekableInput.skipBytes(4);
            long l = seekableInput.readUnsignedInt();
            long l2 = seekableInput.readUnsignedInt();
            this.table_offsets.put(string, new Long(l));
            this.table_length.put(string, new Long(l2));
        }
        long l = TTMetric.getTableOffset(this.table_offsets, "name");
        seekableInput.seek(l + 2L);
        int n3 = seekableInput.readUnsignedShort();
        int n4 = seekableInput.readUnsignedShort();
        long[] lArray = new long[21];
        int[] nArray = new int[21];
        long[] lArray2 = new long[21];
        int[] nArray2 = new int[21];
        int n5 = 0;
        while (n5 <= 20) {
            lArray[n5] = 0L;
            nArray[n5] = 0;
            lArray2[n5] = 0L;
            nArray2[n5] = 0;
            ++n5;
        }
        while (n3-- > 0) {
            int n6 = seekableInput.readUnsignedShort();
            int n7 = seekableInput.readUnsignedShort();
            seekableInput.skipBytes(2);
            int n8 = seekableInput.readUnsignedShort();
            int n9 = seekableInput.readUnsignedShort();
            long l3 = l + (long)n4 + (long)seekableInput.readUnsignedShort();
            if (n8 > 20) continue;
            if (n6 == 0 || n6 == 3 && n7 == 1) {
                lArray[n8] = l3;
                nArray[n8] = n9 / 2;
                continue;
            }
            if (n6 != 1 || n7 != 0) continue;
            lArray2[n8] = l3;
            nArray2[n8] = n9;
        }
        this.notice = TTMetric.readName(seekableInput, lArray[0], nArray[0], lArray2[0], nArray2[0]);
        this.family = TTMetric.readName(seekableInput, lArray[1], nArray[1], lArray2[1], nArray2[1]);
        this.fullName = TTMetric.readName(seekableInput, lArray[4], nArray[4], lArray2[4], nArray2[4]);
        this.version = TTMetric.readName(seekableInput, lArray[5], nArray[5], lArray2[5], nArray2[5]);
        this.fontName = TTMetric.readName(seekableInput, lArray[6], nArray[6], lArray2[6], nArray2[6]);
    }

    public CFFMetric getCFFMetric() throws FontFileFormatError {
        if (this.isCFF) {
            if (this.cffMetric != null) {
                return this.cffMetric;
            }
            throw new FontFileFormatError("Unparsed a OpenType file");
        }
        throw new FontFileFormatError("Not a OpenType/CFF file");
    }

    public void dump(PrintStream printStream) {
        super.dump(printStream);
        printStream.println("\nTrueType-specific font data:");
        if (this.isTTC) {
            printStream.println("  Font is a subfont in a TrueType Collection file (font number " + this.subfontNumber + ", total " + this.subfontsTotal + ")");
        }
        printStream.println(this.restrictEmbedding ? "  Embedding subject to restrictions" : "  No embedding restrictions");
        if (this.readOnlyEmbedding) {
            printStream.println("  Print & Preview embedding allowed");
        }
        if (this.editableEmbedding) {
            printStream.println("  Editable embedding allowed");
        }
        if (this.bitmapOnlyEmbedding) {
            printStream.println("  Only bitmap embedding allowed (no outline data)");
        }
        printStream.println(this.disableSubsetting ? "  Subsetting not allowed" : "  Subsetting allowed");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 1) {
            new TTMetric(new SeekableFileInputStream(stringArray[0]), 1).dump(System.out);
        } else if (stringArray.length == 2) {
            new TTMetric(new SeekableFileInputStream(stringArray[0]), Integer.parseInt(stringArray[1])).dump(System.out);
        } else {
            System.err.println("Usage: java com.renderx.fonts.TTMetric <TTF/OTF/TTC font filename> (<TTC subfont number>)");
        }
    }

    static {
        int n = 0;
        while (n < macTable.length) {
            TTMetric.macTable[n] = '\u0000';
            ++n;
        }
        TTMetric.macTable[32] = 32;
        TTMetric.macTable[33] = 33;
        TTMetric.macTable[34] = 34;
        TTMetric.macTable[35] = 35;
        TTMetric.macTable[36] = 36;
        TTMetric.macTable[37] = 37;
        TTMetric.macTable[38] = 38;
        TTMetric.macTable[39] = 39;
        TTMetric.macTable[40] = 40;
        TTMetric.macTable[41] = 41;
        TTMetric.macTable[42] = 42;
        TTMetric.macTable[43] = 43;
        TTMetric.macTable[44] = 44;
        TTMetric.macTable[45] = 45;
        TTMetric.macTable[46] = 46;
        TTMetric.macTable[47] = 47;
        TTMetric.macTable[48] = 48;
        TTMetric.macTable[49] = 49;
        TTMetric.macTable[50] = 50;
        TTMetric.macTable[51] = 51;
        TTMetric.macTable[52] = 52;
        TTMetric.macTable[53] = 53;
        TTMetric.macTable[54] = 54;
        TTMetric.macTable[55] = 55;
        TTMetric.macTable[56] = 56;
        TTMetric.macTable[57] = 57;
        TTMetric.macTable[58] = 58;
        TTMetric.macTable[59] = 59;
        TTMetric.macTable[60] = 60;
        TTMetric.macTable[61] = 61;
        TTMetric.macTable[62] = 62;
        TTMetric.macTable[63] = 63;
        TTMetric.macTable[64] = 64;
        TTMetric.macTable[65] = 65;
        TTMetric.macTable[66] = 66;
        TTMetric.macTable[67] = 67;
        TTMetric.macTable[68] = 68;
        TTMetric.macTable[69] = 69;
        TTMetric.macTable[70] = 70;
        TTMetric.macTable[71] = 71;
        TTMetric.macTable[72] = 72;
        TTMetric.macTable[73] = 73;
        TTMetric.macTable[74] = 74;
        TTMetric.macTable[75] = 75;
        TTMetric.macTable[76] = 76;
        TTMetric.macTable[77] = 77;
        TTMetric.macTable[78] = 78;
        TTMetric.macTable[79] = 79;
        TTMetric.macTable[80] = 80;
        TTMetric.macTable[81] = 81;
        TTMetric.macTable[82] = 82;
        TTMetric.macTable[83] = 83;
        TTMetric.macTable[84] = 84;
        TTMetric.macTable[85] = 85;
        TTMetric.macTable[86] = 86;
        TTMetric.macTable[87] = 87;
        TTMetric.macTable[88] = 88;
        TTMetric.macTable[89] = 89;
        TTMetric.macTable[90] = 90;
        TTMetric.macTable[91] = 91;
        TTMetric.macTable[92] = 92;
        TTMetric.macTable[93] = 93;
        TTMetric.macTable[94] = 94;
        TTMetric.macTable[95] = 95;
        TTMetric.macTable[96] = 96;
        TTMetric.macTable[97] = 97;
        TTMetric.macTable[98] = 98;
        TTMetric.macTable[99] = 99;
        TTMetric.macTable[100] = 100;
        TTMetric.macTable[101] = 101;
        TTMetric.macTable[102] = 102;
        TTMetric.macTable[103] = 103;
        TTMetric.macTable[104] = 104;
        TTMetric.macTable[105] = 105;
        TTMetric.macTable[106] = 106;
        TTMetric.macTable[107] = 107;
        TTMetric.macTable[108] = 108;
        TTMetric.macTable[109] = 109;
        TTMetric.macTable[110] = 110;
        TTMetric.macTable[111] = 111;
        TTMetric.macTable[112] = 112;
        TTMetric.macTable[113] = 113;
        TTMetric.macTable[114] = 114;
        TTMetric.macTable[115] = 115;
        TTMetric.macTable[116] = 116;
        TTMetric.macTable[117] = 117;
        TTMetric.macTable[118] = 118;
        TTMetric.macTable[119] = 119;
        TTMetric.macTable[120] = 120;
        TTMetric.macTable[121] = 121;
        TTMetric.macTable[122] = 122;
        TTMetric.macTable[123] = 123;
        TTMetric.macTable[124] = 124;
        TTMetric.macTable[125] = 125;
        TTMetric.macTable[126] = 126;
        TTMetric.macTable[127] = 127;
        TTMetric.macTable[128] = 196;
        TTMetric.macTable[129] = 197;
        TTMetric.macTable[130] = 199;
        TTMetric.macTable[131] = 201;
        TTMetric.macTable[132] = 209;
        TTMetric.macTable[133] = 214;
        TTMetric.macTable[134] = 220;
        TTMetric.macTable[135] = 225;
        TTMetric.macTable[136] = 224;
        TTMetric.macTable[137] = 226;
        TTMetric.macTable[138] = 228;
        TTMetric.macTable[139] = 227;
        TTMetric.macTable[140] = 229;
        TTMetric.macTable[141] = 231;
        TTMetric.macTable[142] = 233;
        TTMetric.macTable[143] = 232;
        TTMetric.macTable[144] = 234;
        TTMetric.macTable[145] = 235;
        TTMetric.macTable[146] = 237;
        TTMetric.macTable[147] = 236;
        TTMetric.macTable[148] = 238;
        TTMetric.macTable[149] = 239;
        TTMetric.macTable[150] = 241;
        TTMetric.macTable[151] = 243;
        TTMetric.macTable[152] = 242;
        TTMetric.macTable[153] = 244;
        TTMetric.macTable[154] = 246;
        TTMetric.macTable[155] = 245;
        TTMetric.macTable[156] = 250;
        TTMetric.macTable[157] = 249;
        TTMetric.macTable[158] = 251;
        TTMetric.macTable[159] = 252;
        TTMetric.macTable[160] = 8224;
        TTMetric.macTable[161] = 176;
        TTMetric.macTable[162] = 162;
        TTMetric.macTable[163] = 163;
        TTMetric.macTable[164] = 167;
        TTMetric.macTable[165] = 8226;
        TTMetric.macTable[166] = 182;
        TTMetric.macTable[167] = 223;
        TTMetric.macTable[168] = 174;
        TTMetric.macTable[169] = 169;
        TTMetric.macTable[170] = 8482;
        TTMetric.macTable[171] = 180;
        TTMetric.macTable[172] = 168;
        TTMetric.macTable[173] = 8800;
        TTMetric.macTable[174] = 198;
        TTMetric.macTable[175] = 216;
        TTMetric.macTable[176] = 8734;
        TTMetric.macTable[177] = 177;
        TTMetric.macTable[178] = 8804;
        TTMetric.macTable[179] = 8805;
        TTMetric.macTable[180] = 165;
        TTMetric.macTable[181] = 181;
        TTMetric.macTable[182] = 8706;
        TTMetric.macTable[183] = 8721;
        TTMetric.macTable[184] = 8719;
        TTMetric.macTable[185] = 960;
        TTMetric.macTable[186] = 8747;
        TTMetric.macTable[187] = 170;
        TTMetric.macTable[188] = 186;
        TTMetric.macTable[189] = 937;
        TTMetric.macTable[190] = 230;
        TTMetric.macTable[191] = 248;
        TTMetric.macTable[192] = 191;
        TTMetric.macTable[193] = 161;
        TTMetric.macTable[194] = 172;
        TTMetric.macTable[195] = 8730;
        TTMetric.macTable[196] = 402;
        TTMetric.macTable[197] = 8776;
        TTMetric.macTable[198] = 8710;
        TTMetric.macTable[199] = 171;
        TTMetric.macTable[200] = 187;
        TTMetric.macTable[201] = 8230;
        TTMetric.macTable[202] = 160;
        TTMetric.macTable[203] = 192;
        TTMetric.macTable[204] = 195;
        TTMetric.macTable[205] = 213;
        TTMetric.macTable[206] = 338;
        TTMetric.macTable[207] = 339;
        TTMetric.macTable[208] = 8211;
        TTMetric.macTable[209] = 8212;
        TTMetric.macTable[210] = 8220;
        TTMetric.macTable[211] = 8221;
        TTMetric.macTable[212] = 8216;
        TTMetric.macTable[213] = 8217;
        TTMetric.macTable[214] = 247;
        TTMetric.macTable[215] = 9674;
        TTMetric.macTable[216] = 255;
        TTMetric.macTable[217] = 376;
        TTMetric.macTable[218] = 8260;
        TTMetric.macTable[219] = 8364;
        TTMetric.macTable[220] = 8249;
        TTMetric.macTable[221] = 8250;
        TTMetric.macTable[222] = 64257;
        TTMetric.macTable[223] = 64258;
        TTMetric.macTable[224] = 8225;
        TTMetric.macTable[225] = 183;
        TTMetric.macTable[226] = 8218;
        TTMetric.macTable[227] = 8222;
        TTMetric.macTable[228] = 8240;
        TTMetric.macTable[229] = 194;
        TTMetric.macTable[230] = 202;
        TTMetric.macTable[231] = 193;
        TTMetric.macTable[232] = 203;
        TTMetric.macTable[233] = 200;
        TTMetric.macTable[234] = 205;
        TTMetric.macTable[235] = 206;
        TTMetric.macTable[236] = 207;
        TTMetric.macTable[237] = 204;
        TTMetric.macTable[238] = 211;
        TTMetric.macTable[239] = 212;
        TTMetric.macTable[240] = 63743;
        TTMetric.macTable[241] = 210;
        TTMetric.macTable[242] = 218;
        TTMetric.macTable[243] = 219;
        TTMetric.macTable[244] = 217;
        TTMetric.macTable[245] = 305;
        TTMetric.macTable[246] = 710;
        TTMetric.macTable[247] = 732;
        TTMetric.macTable[248] = 175;
        TTMetric.macTable[249] = 728;
        TTMetric.macTable[250] = 729;
        TTMetric.macTable[251] = 730;
        TTMetric.macTable[252] = 184;
        TTMetric.macTable[253] = 733;
        TTMetric.macTable[254] = 731;
        TTMetric.macTable[255] = 711;
        DEFAULT_CHARSET_TO_UGL = new String[]{".notdef", ".null", "CR", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu1", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Ohm", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "increment", "guillemotleft", "guillemotright", "ellipsis", "nbspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "applelogo", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "overscore", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idot", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dmacron"};
    }
}

