/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.crypto;

import com.renderx.crypto.ISOLatin1;
import com.renderx.crypto.MD5;
import com.renderx.crypto.PGPCRC;
import com.renderx.crypto.PGPSignature;
import com.renderx.crypto.RSAPublicKey;
import com.renderx.util.Args;
import com.renderx.util.Base64InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public final class CheckSigned {
    private static final int WAITING = 0;
    private static final int DATA_INFO = 1;
    private static final int DATA_FIRST = 2;
    private static final int DATA = 3;
    private static final int SIGNATURE_INFO = 4;
    private static final int SIGNATURE = 5;
    private static final int SIGNATURE_END = 6;
    private static final int END = 7;
    private byte[] PGPendOfLineData = new byte[]{13, 10};
    private PGPSignature signature;
    private byte[] pgpHash;
    private int cr_count = 0;
    private int nextbyte = -1;

    public boolean checkSignature(RSAPublicKey rSAPublicKey) {
        if (this.signature != null) {
            return this.signature.check(rSAPublicKey, this.pgpHash);
        }
        return false;
    }

    private String readLine(InputStream inputStream) throws IOException {
        if (this.cr_count > 0) {
            if (--this.cr_count > 0) {
                return "";
            }
        } else {
            this.nextbyte = inputStream.read();
        }
        if (this.nextbyte == -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.nextbyte != 10 && this.nextbyte != -1) {
            if (this.nextbyte == 13) {
                ++this.cr_count;
            } else {
                if (this.cr_count > 0) break;
                stringBuffer.append((char)(this.nextbyte & 0xFF));
            }
            this.nextbyte = inputStream.read();
            if (this.nextbyte != 10) continue;
            this.cr_count = 0;
        }
        return stringBuffer.toString();
    }

    public void load(InputStream inputStream) throws IOException {
        String string;
        int n = 0;
        MD5 mD5 = new MD5();
        Object var5_4 = null;
        Object var6_5 = null;
        String string2 = "";
        this.cr_count = 0;
        this.nextbyte = -1;
        block8: while ((string = this.readLine(inputStream)) != null) {
            switch (n) {
                case 0: {
                    if (!string.startsWith("-----BEGIN ")) continue block8;
                    if (string.startsWith("-----BEGIN PGP SIGNED MESSAGE")) {
                        n = 1;
                        break;
                    }
                    throw new IOException("Bad begin : " + string);
                }
                case 1: {
                    if (string.length() != 0) continue block8;
                    n = 2;
                    break;
                }
                case 2: 
                case 3: {
                    if (string.startsWith("-----END ")) {
                        throw new IOException("Bad end : " + string);
                    }
                    if (string.startsWith("-----BEGIN ")) {
                        if (string.startsWith("-----BEGIN PGP SIGNATURE")) {
                            n = 4;
                            break;
                        }
                        throw new IOException("unexpected begin : " + string);
                    }
                    if (string.length() > 2 && string.charAt(0) == '-') {
                        string = string.substring(2);
                    }
                    if (n != 3) {
                        n = 3;
                    } else {
                        mD5.update(this.PGPendOfLineData);
                    }
                    mD5.update(ISOLatin1.toByteArray(string, 0, string.length()));
                    break;
                }
                case 4: {
                    if (string.length() != 0) continue block8;
                    n = 5;
                    break;
                }
                case 5: {
                    if (string.startsWith("=")) {
                        byte[] byArray;
                        int n2;
                        if (string.length() != 5) {
                            throw new IOException("checksum length incorrect");
                        }
                        byte[] byArray2 = this.base64decode(string.substring(1, 5));
                        int n3 = (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF;
                        if (n3 != (n2 = PGPCRC.checksum(byArray = this.base64decode(string2)))) {
                            throw new IOException("Incorrect checksum");
                        }
                        this.signature = new PGPSignature(new DataInputStream(new ByteArrayInputStream(byArray)));
                        this.signature.addExtasToHash(mD5);
                        this.pgpHash = mD5.digest();
                        n = 6;
                        break;
                    }
                    string2 = string2 + string;
                    break;
                }
                case 6: {
                    if (string.startsWith("-----END ")) break block8;
                    throw new IOException("End excected." + string);
                }
                default: {
                    throw new IOException("State machine failure.");
                }
            }
        }
    }

    public byte[] base64decode(String string) throws IOException {
        Base64InputStream base64InputStream = new Base64InputStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = null;
        try {
            byte[] byArray2 = new byte[1024];
            int n = 0;
            while ((n = base64InputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            base64InputStream.close();
            byteArrayOutputStream.close();
            throw throwable;
        }
        base64InputStream.close();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static void main(String[] stringArray) throws IOException {
        Args args = new Args(stringArray);
        if (args.arguments.length() != 1) {
            System.err.println("call: java com.renderx.crypto.CheckSigned publickey\n");
            System.exit(1);
        }
        CheckSigned checkSigned = new CheckSigned();
        checkSigned.load(System.in);
        String string = (String)args.arguments.car();
        int n = string.indexOf(58);
        RSAPublicKey rSAPublicKey = new RSAPublicKey(new BigInteger(string.substring(0, n), 16), new BigInteger(string.substring(n + 1), 16));
        boolean bl = checkSigned.checkSignature(rSAPublicKey);
        System.out.println(bl ? "OK" : "ERROR");
    }
}

