/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib.barcodes;

import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.XBarcode;
import com.renderx.afplib.barcodes.BarcodeParams;
import java.io.IOException;
import org.xml.sax.Attributes;

public class RM4SCC
extends XBarcode {
    boolean isKIX = false;

    public RM4SCC(BarcodeParams barcodeParams, ConfigManager configManager) throws IOException {
        super(barcodeParams, configManager);
        this.isKIX = this.getBooleanAttribute(barcodeParams, "KIX");
        if (this.isKIX) {
            this.standardSymbols = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
            this.typeModifier = 1;
        } else {
            this.standardSymbols = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            this.typeModifier = 0;
        }
        this.heightMultipler = 1;
        String string = this.barcode.getCode();
        this.encBarcode = this.encodeBarcode(string, Math.min(string.length(), 50));
        this.nameBarcode = "RM4SCC";
    }

    private boolean getBooleanAttribute(BarcodeParams barcodeParams, String string) {
        boolean bl = false;
        Attributes attributes = barcodeParams.getBarcode().attributes;
        String string2 = attributes.getValue("", string);
        if (string2 != null && string2.toLowerCase().equals("true")) {
            bl = true;
        }
        return bl;
    }

    protected byte[] encodeBarcode(String string, int n) throws IOException {
        return string.substring(0, n).getBytes("Cp500");
    }
}

