package com.renderx.xepx.x4u.ct;

/**
 * <p>Description: Table model for Languages, font-data and Font-aliases support
 * <p>Usage: someJTable = new JTable(someLngTableModel(rootNode))
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Zenteq.am</p>
 * @author: Boris Karapetyan, Angelina Andriasyan
 * @version 1.0
 */

import javax.swing.table.*;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Attr;
import java.util.*;

public class DomToTableModel extends AbstractTableModel{
  private String[] columnNames = {"Alias","Font Family"}; // for font aliase only
  Vector rowData; // vector of DOM-Elements
  int colCnt;  // 1 for Languages-Table, 2 for Font-aliases
  Element root; // parent node for table elements (for add/remove action)
  String  child; // Element name (languages, font-data or font-alias)
  boolean attrib; // fill rowData from attributes (for font-data) or from subchildren

  public DomToTableModel(Element root, boolean attr) {
    this.root   = root;
    this.attrib = attr;
    if(root.getTagName().equalsIgnoreCase("languages")) {
      colCnt = 1;
      child = "language";
    }
    else {
      colCnt = 2;
      child = (attrib)?"font":"font-alias";
    }
    rowData =  new Vector();
    if(attrib){
      NodeList children = root.getElementsByTagName("font-data");
      Element font_data;
      if(children.getLength() == 0){
          font_data = root.getOwnerDocument().createElement("font-data");
          root.appendChild(font_data);
      }
      else{
        font_data = (Element) children.item(0);
        NamedNodeMap lst = font_data.getAttributes();
        for (int i = 0; i < lst.getLength(); i++) {
          rowData.add(lst.item(i));
        }
      }
    }
    else{
      NodeList lst = root.getChildNodes(); // getElementsByTagName(child) gives all desendet - dont worked
      if (lst != null) {
        for (int i = 0; i < lst.getLength(); i++) {
          if (lst.item(i).getNodeName().equals(child))
            rowData.add(lst.item(i));
        }
      }
    }
  }

  public String getColumnName(int col) {
    if(colCnt == 1 || attrib) return null;
    else  return columnNames[col].toString();
  }

  public int getRowCount() { return rowData.size();}

  public Class getColumnClass(int c) {
     return getValueAt(0, c).getClass();
  }
  public int getColumnCount() { return colCnt; }

  public Object getValueAt(int row, int col) {
    if (attrib){
      Attr t = (Attr)rowData.get(row);
      return (col ==0) ? t.getNodeName(): t.getNodeValue();
    }
    else{
      Element t = (Element)rowData.get(row);
      if (col == 0)return t.getAttributes().getNamedItem("name").getNodeValue();
      else return t.getAttributes().getNamedItem("value").getNodeValue();
    }
  }

  public Object getNodeAt(int row){
    if(attrib) return (Attr) rowData.get(row);
    else return  (Element)rowData.get(row);
  }

  public boolean isCellEditable(int row, int col) { return true; }

  public void setValueAt(Object value, int row, int col) {

    if(attrib){
      Attr t = (Attr)rowData.get(row);
      Element font_data = (Element)root.getElementsByTagName("font-data").item(0);
      if (col == 0) {
        rowData.remove(row);
        font_data.removeAttribute(t.getNodeName());
        font_data.setAttribute(value.toString(), t.getNodeValue());
        rowData.add(row,font_data.getAttributeNode(value.toString()));
      }
      else
        font_data.setAttribute(t.getNodeName(), value.toString());
    }
    else{
      Element t = (Element)rowData.get(row);
        if (col == 0)
          t.setAttribute("name", value.toString());
        else
          t.setAttribute("value", value.toString());
      }
    fireTableCellUpdated(row, col);
  }

  public void addRow(Element element){
    if(attrib){
      NodeList ch = element.getElementsByTagName("font-data");
      Element prnt; //= root.getOwnerDocument().createElement("font-data");
      if(ch == null){
        prnt = root.getOwnerDocument().createElement("font-data");
        element.appendChild(prnt);
      }
      else
        prnt = (Element)ch.item(0);

      prnt.setAttribute("NEW","VALUE");
      Attr t = (Attr)prnt.getAttributes().getNamedItem("NEW");
      rowData.add(t);
    }
    else rowData.add(element);
    fireTableDataChanged();
  }
  public void deleteRow(int row){
    rowData.remove(row);
    fireTableDataChanged()    ;
  }

}
