/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xepout;

import com.renderx.fonts.FontCatalog;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.vector.ExternalImage;
import com.renderx.graphics.vector.FontSpec;
import com.renderx.graphics.vector.GraphicGroup;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.graphics.vector.Link;
import com.renderx.graphics.vector.StrokeSpec;
import com.renderx.graphics.vector.Text;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.URLSpec;
import com.renderx.xepout.ParseTerminationException;
import com.renderx.xepout.XEPOUTElement;
import com.renderx.xepout.XEPOUTParserContext;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XEPOUTParserHandler
extends DefaultHandler {
    ImageTree tree = null;
    public static final int SCALE = 1000;
    private final ImageFactory imageFactory;
    private final ErrorHandler errHandler;
    private final FontCatalog fontCatalog;
    protected final Hashtable fontCache = new Hashtable();
    private XEPOUTParserContext context = null;
    private boolean polygon = false;
    public ArrayList points = new ArrayList();

    public XEPOUTParserHandler(ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler, double d, double d2) {
        this.imageFactory = imageFactory;
        this.fontCatalog = fontCatalog;
        this.errHandler = errorHandler;
        this.tree = new ImageTree(d, d2);
    }

    private static String getAttrValue(Attributes attributes, String string) {
        String string2 = "";
        if (string.startsWith("xml:")) {
            string2 = "http://www.w3.org/XML/1998/namespace";
            string = string.substring(4);
        } else if (string.startsWith("xlink:")) {
            string2 = "http://www.w3.org/1999/xlink";
            string = string.substring(6);
        }
        return attributes.getValue(string2, string);
    }

    private static final boolean hasAttribute(Attributes attributes, String string) {
        return null != XEPOUTParserHandler.getAttrValue(attributes, string);
    }

    private static final double getLength(Attributes attributes, String string) {
        String string2 = XEPOUTParserHandler.getAttrValue(attributes, string);
        return Double.parseDouble(string2);
    }

    private static final double getExactLength(Attributes attributes, String string) {
        String string2 = XEPOUTParserHandler.getAttrValue(attributes, string);
        return Double.parseDouble(string2) / 1000.0;
    }

    private int getFontNumber(char c) {
        int n = 0;
        while (n < this.context.fonts.length) {
            if (this.context.fonts[n].getMetric().exists(c)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private void addPoint(double d, double d2) {
        this.points.add(new double[]{d, d2});
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block41: {
            XEPOUTElement xEPOUTElement = XEPOUTElement.get(string, string2);
            if (xEPOUTElement == null) {
                return;
            }
            try {
                switch (xEPOUTElement.id) {
                    case 3: {
                        this.context = new XEPOUTParserContext(this.fontCatalog, this.fontCache, this.errHandler);
                        this.context.curGroup = this.context.prevGroup = new GraphicGroup();
                        this.tree.root = this.context.prevGroup;
                        break;
                    }
                    case 14: {
                        this.tree.width = XEPOUTParserHandler.getExactLength(attributes, "width");
                        this.tree.height = XEPOUTParserHandler.getExactLength(attributes, "height");
                        this.context.pushGroup();
                        break;
                    }
                    case 23: {
                        String string4 = XEPOUTParserHandler.getAttrValue(attributes, "value");
                        double d = XEPOUTParserHandler.getExactLength(attributes, "x");
                        double d2 = XEPOUTParserHandler.getExactLength(attributes, "y");
                        int n = this.getFontNumber(string4.charAt(0));
                        this.context.addGraphicObject(new Text(this.context.currentColor, new StrokeSpec(null, 1.0), 0, 0, 1.0, 1.0, new FontSpec(this.context.fonts[n].familyName, this.context.fontWeight, this.context.fontStyle, this.context.fontVariant, this.context.fontSize, this.context.fontStretch), string4, d, d2));
                        break;
                    }
                    case 8: {
                        this.context.setColor(XEPOUTParserContext.Color.setGrayscale(XEPOUTParserHandler.getLength(attributes, "gray")));
                        break;
                    }
                    case 19: {
                        this.context.setColor(XEPOUTParserContext.Color.setRGB(XEPOUTParserHandler.getLength(attributes, "red"), XEPOUTParserHandler.getLength(attributes, "green"), XEPOUTParserHandler.getLength(attributes, "blue")));
                        break;
                    }
                    case 2: {
                        this.context.setColor(XEPOUTParserContext.Color.setCMYK(XEPOUTParserHandler.getLength(attributes, "cyan"), XEPOUTParserHandler.getLength(attributes, "magenta"), XEPOUTParserHandler.getLength(attributes, "yellow"), XEPOUTParserHandler.getLength(attributes, "black")));
                        break;
                    }
                    case 18: {
                        this.context.setColor(XEPOUTParserContext.Color.setRegistration(XEPOUTParserHandler.getLength(attributes, "tint")));
                        break;
                    }
                    case 21: {
                        if (XEPOUTParserHandler.hasAttribute(attributes, "alt-red") || XEPOUTParserHandler.hasAttribute(attributes, "alt-green") || XEPOUTParserHandler.hasAttribute(attributes, "alt-blue")) {
                            this.errHandler.warning("XEPOUT doesn't support spot-color with alt-RGB");
                            break;
                        }
                        this.context.setColor(XEPOUTParserContext.Color.setSpotColor(attributes));
                        break;
                    }
                    case 25: {
                        this.context.wordSpacing = XEPOUTParserHandler.getLength(attributes, "value");
                        break;
                    }
                    case 12: {
                        this.context.letterSpacing = XEPOUTParserHandler.getLength(attributes, "value");
                        break;
                    }
                    case 7: {
                        this.context.fontStretch = XEPOUTParserHandler.getLength(attributes, "value");
                        break;
                    }
                    case 6: {
                        this.context.fontFamily = XEPOUTParserHandler.getAttrValue(attributes, "family").trim();
                        this.context.fontSize = XEPOUTParserHandler.getExactLength(attributes, "size");
                        String string5 = XEPOUTParserHandler.getAttrValue(attributes, "style");
                        int n = (int)XEPOUTParserHandler.getLength(attributes, "weight");
                        String string6 = XEPOUTParserHandler.getAttrValue(attributes, "variant");
                        if ("normal".equals(string5) || "italic".equals(string5) || "oblique".equals(string5) || "backslant".equals(string5)) {
                            this.context.fontStyle = string5;
                        }
                        if (100 == n || 200 == n || 300 == n || 400 == n || 500 == n || 600 == n || 700 == n || 800 == n || 900 == n) {
                            this.context.fontWeight = n;
                        }
                        if ("small-caps".equals(string6) || "normal".equals(string6)) {
                            this.context.fontVariant = string6;
                        }
                        this.context.selectFont(this.errHandler);
                        break;
                    }
                    case 20: {
                        this.context.pushGroup();
                        this.context.rotate(XEPOUTParserHandler.getLength(attributes, "phi"));
                        break;
                    }
                    case 24: {
                        this.context.pushGroup();
                        this.context.translate(XEPOUTParserHandler.getExactLength(attributes, "x"), XEPOUTParserHandler.getExactLength(attributes, "y"));
                        break;
                    }
                    case 13: {
                        this.context.addGraphicObject(this.context.drawLine(XEPOUTParserHandler.getExactLength(attributes, "x-from"), XEPOUTParserHandler.getExactLength(attributes, "y-from"), XEPOUTParserHandler.getExactLength(attributes, "x-till"), XEPOUTParserHandler.getExactLength(attributes, "y-till"), XEPOUTParserHandler.getAttrValue(attributes, "style"), XEPOUTParserHandler.getExactLength(attributes, "thickness")));
                        break;
                    }
                    case 15: {
                        if (!this.polygon) break;
                        this.addPoint(XEPOUTParserHandler.getExactLength(attributes, "x-till"), XEPOUTParserHandler.getExactLength(attributes, "y-till"));
                        break;
                    }
                    case 16: {
                        if (!this.polygon) {
                            this.polygon = true;
                            this.addPoint(XEPOUTParserHandler.getExactLength(attributes, "x-from"), XEPOUTParserHandler.getExactLength(attributes, "y-from"));
                            break;
                        }
                        this.points.clear();
                        this.polygon = false;
                        break;
                    }
                    case 17: {
                        this.context.addGraphicObject(this.context.drawRectangle(XEPOUTParserHandler.getExactLength(attributes, "x-from"), XEPOUTParserHandler.getExactLength(attributes, "y-from"), XEPOUTParserHandler.getExactLength(attributes, "x-till"), XEPOUTParserHandler.getExactLength(attributes, "y-till")));
                        break;
                    }
                    case 9: {
                        URLSpec uRLSpec;
                        String string7 = XEPOUTParserHandler.getAttrValue(attributes, "src");
                        String string8 = XEPOUTParserHandler.getAttrValue(attributes, "type");
                        double d = XEPOUTParserHandler.getExactLength(attributes, "x-from");
                        double d3 = XEPOUTParserHandler.getExactLength(attributes, "y-from");
                        double d4 = XEPOUTParserHandler.getLength(attributes, "scale-x");
                        double d5 = XEPOUTParserHandler.getLength(attributes, "scale-y");
                        if (attributes.getIndex("base") != -1) {
                            try {
                                uRLSpec = new URLSpec(new URLSpec(XEPOUTParserHandler.getAttrValue(attributes, "base")), string7);
                            }
                            catch (MalformedURLException malformedURLException) {
                                throw new SAXException(malformedURLException.toString());
                            }
                        }
                        try {
                            uRLSpec = new URLSpec(string7);
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new SAXException(malformedURLException.toString());
                        }
                        ExternalImage externalImage = null;
                        try {
                            externalImage = new ExternalImage(this.imageFactory.makeImage(uRLSpec, string8));
                        }
                        catch (IOException iOException) {
                            throw new SAXException(iOException.toString());
                        }
                        catch (ImageFormatException imageFormatException) {
                            throw new SAXException(imageFormatException.toString());
                        }
                        catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
                            throw new SAXException(unregisteredMIMETypeException.toString());
                        }
                        this.context.pushGroup();
                        this.context.translate(d, d3);
                        this.context.scale(d4, d5);
                        this.context.addGraphicObject(externalImage);
                        break;
                    }
                    case 1: {
                        this.context.pushGroup();
                        double d = XEPOUTParserHandler.getExactLength(attributes, "x-from");
                        double d6 = XEPOUTParserHandler.getExactLength(attributes, "y-from");
                        double d7 = XEPOUTParserHandler.getExactLength(attributes, "x-till") - d;
                        double d8 = XEPOUTParserHandler.getExactLength(attributes, "y-till") - d6;
                        this.context.curGroup.clipRect(d, d6, d7, d8);
                        break;
                    }
                    case 26: {
                        this.context.pushGroup();
                        this.context.transform(XEPOUTParserHandler.getLength(attributes, "a"), XEPOUTParserHandler.getLength(attributes, "b"), XEPOUTParserHandler.getLength(attributes, "c"), XEPOUTParserHandler.getLength(attributes, "d"), XEPOUTParserHandler.getLength(attributes, "e"), XEPOUTParserHandler.getLength(attributes, "f"));
                        break;
                    }
                    case 5: {
                        String string9 = XEPOUTParserHandler.getAttrValue(attributes, "show-destination");
                        this.context.addGraphicObject(new Link(XEPOUTParserHandler.getExactLength(attributes, "x-from"), XEPOUTParserHandler.getExactLength(attributes, "y-from"), XEPOUTParserHandler.getExactLength(attributes, "x-till"), XEPOUTParserHandler.getExactLength(attributes, "y-till"), XEPOUTParserHandler.getAttrValue(attributes, "destination"), string9.equals("new")));
                    }
                }
            }
            catch (Exception exception) {
                if (this.errHandler == null) break block41;
                this.errHandler.error("XEPOUT's image element '" + xEPOUTElement.name + "' ignored: " + exception.toString());
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        XEPOUTElement xEPOUTElement = XEPOUTElement.get(string, string2);
        switch (xEPOUTElement.id) {
            case 3: {
                throw new SAXException("There is no closing \"page\" element");
            }
            case 14: {
                this.context.popGroup();
                throw new ParseTerminationException();
            }
            case 1: 
            case 9: {
                this.context.popGroup();
                break;
            }
            case 16: {
                if (this.polygon && this.points.size() > 1) {
                    this.context.addGraphicObject(this.context.drawPolygon(this.points));
                }
                this.points.clear();
                this.polygon = false;
                break;
            }
        }
    }
}

