/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.exp;

import com.renderx.graphics.SpotColorList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Expr;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.exp.CMYK_Color;
import com.renderx.xep.pre.exp.Grayscale_Color;

public class Spot_Color
extends Expr {
    protected Attr C = null;
    protected Attr T = null;
    protected Attr A = null;

    public String toString() {
        return "spotcolor(" + this.C + ", " + this.T + ", " + this.A + ")";
    }

    public Spot_Color() {
    }

    public Spot_Color(Attr attr, Attr attr2, Attr attr3) {
        this.C = attr;
        this.T = attr2;
        this.A = attr3;
    }

    public Attr initialize(Attr[] attrArray) throws ParserException {
        if (attrArray == null) {
            throw new ParserException("spotcolor() function requires 2 or more arguments");
        }
        if (attrArray.length < 2) {
            throw new ParserException("spotcolor() function requires 2 or more arguments");
        }
        this.C = attrArray[0];
        this.T = attrArray[1];
        this.A = this.selectAlternateColor(attrArray);
        return this.preevaluate();
    }

    public final Attr preevaluate() throws ParserException {
        return this.calculate(this.C.preevaluate(), this.T.preevaluate(), this.A == null ? null : this.A.preevaluate());
    }

    public final Attr evaluate(ParserContext parserContext, Attn attn) throws ParserException {
        return this.calculate(this.C.evaluate(parserContext, attn), this.T.evaluate(parserContext, attn), this.A == null ? null : this.A.evaluate(parserContext, attn));
    }

    protected final Attr calculate(Attr attr, Attr attr2, Attr attr3) throws ParserException {
        if (attr instanceof Expr || attr2 != null && attr2 instanceof Expr) {
            return attr == this.C && attr2 == this.A && attr3 == this.T ? this : new Spot_Color(attr, attr2, attr3);
        }
        if (!(attr instanceof Attr.Word)) {
            throw new ParserException("Argument of spotcolor() function cannot be of type " + attr.getTypeName());
        }
        if (attr3 != null && !(attr3 instanceof Attr.Color.Grayscale) && !(attr3 instanceof Attr.Color.CMYK)) {
            throw new ParserException("Argument of spotcolor() function cannot be of type " + attr2.getTypeName());
        }
        String string = attr.word();
        Attr.Color.Opaque opaque = (Attr.Color.Opaque)attr3;
        if (opaque == null) {
            double[] dArray = SpotColorList.dflt.getCMYK(string);
            opaque = dArray != null ? Attr.Color.CMYK.create(dArray[0], dArray[1], dArray[2], dArray[3]) : Attr.Color.Grayscale.create(0);
        }
        return Attr.Color.SpotColor.create(string, opaque, this.extractColorComponent(attr2));
    }

    private double extractColorComponent(Attr attr) throws ParserException {
        double d = 0.0;
        if (attr instanceof Attr.Percentage) {
            d = attr.percentage() / 100.0;
        } else if (attr instanceof Attr.Ratio) {
            d = attr.ratio();
        } else if (attr instanceof Attr.Count) {
            d = attr.count();
        } else {
            throw new ParserException("Argument of spotcolor() function cannot be of type " + attr.getTypeName());
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    protected final Attr selectAlternateColor(Attr[] attrArray) throws ParserException {
        if (attrArray.length < 3) {
            return null;
        }
        Attr attr = attrArray[2];
        if (attr instanceof Attr.Word) {
            if ("#Grayscale".equals(attr.word())) {
                if (attrArray.length != 4) {
                    throw new ParserException("Built-in #Grayscale profile takes 1 argument");
                }
                return new Grayscale_Color().initialize(new Attr[]{attrArray[3]});
            }
            if ("#CMYK".equals(attr.word())) {
                if (attrArray.length != 7) {
                    throw new ParserException("Built-in #CMYK profile takes 4 arguments");
                }
                return new CMYK_Color().initialize(new Attr[]{attrArray[3], attrArray[4], attrArray[5], attrArray[6]});
            }
            throw new ParserException("Invalid profile name for alternate color (should be #Grayscale or #CMYK): " + attr.word());
        }
        throw new ParserException("Color profile name in spotcolor() function cannot be of type " + attr.getTypeName());
    }
}

