/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.att;

import com.renderx.util.Hashtable;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.AttributeParser;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.Token;
import com.renderx.xep.pre.att.Parsed;
import java.util.Enumeration;
import java.util.Stack;

public class FontSpec
extends Attn {
    static final Hashtable sysFonts = new Hashtable();

    public FontSpec(String string) throws ParserException {
        super(string);
    }

    public void process(String string, ParserContext parserContext) throws ParserException {
        String string2;
        if (string.trim().equals("inherit")) {
            return;
        }
        String string3 = (String)sysFonts.get(string.trim());
        if (string3 != null) {
            this.process(string3, parserContext);
            return;
        }
        Attn.$font_size_adjust.process("none", parserContext);
        Attn.$font_stretch.process("normal", parserContext);
        Attn.$font_style.process("normal", parserContext);
        Attn.$font_weight.process("normal", parserContext);
        Attn.$font_variant.process("normal", parserContext);
        Attn.$line_height.process("normal", parserContext);
        Stack stack = AttributeParser.parseShorthand(string);
        Enumeration enumeration = stack.elements();
        Token token = null;
        while (true) {
            int n;
            if (!enumeration.hasMoreElements()) {
                throw new ParserException("Invalid shorthand structure - cannot find font size specifier: " + this.name + "=\"" + string + "\"");
            }
            token = (Token)enumeration.nextElement();
            if (token.type != 8192) {
                throw new ParserException("Invalid shorthand structure - unexpected token type " + token.getTypeName() + " in shorthand '" + this.name + "'");
            }
            if (token.value instanceof Attr.Word) {
                string2 = token.value.word();
                if (string2.equals("normal")) continue;
                if (string2.equals("italic") || string2.equals("oblique") || string2.equals("backslant")) {
                    ((Parsed)Attn.$font_style).process(token.value, parserContext);
                    continue;
                }
                if (string2.equals("bold") || string2.equals("lighter") || string2.equals("bolder")) {
                    ((Parsed)Attn.$font_weight).process(token.value, parserContext);
                    continue;
                }
                if (!string2.equals("small-caps")) break;
                ((Parsed)Attn.$font_variant).process(token.value, parserContext);
                continue;
            }
            if (!(token.value instanceof Attr.Count) || (n = token.value.count()) != 100 && n != 200 && n != 300 && n != 400 && n != 500 && n != 600 && n != 700 && n != 800 && n != 900) break;
            ((Parsed)Attn.$font_weight).process(token.value, parserContext);
        }
        ((Parsed)Attn.$font_size).process(token.value, parserContext);
        if (!enumeration.hasMoreElements()) {
            throw new ParserException("Invalid shorthand structure - two or more tokens expected: " + this.name + "=\"" + string + "\"");
        }
        token = (Token)enumeration.nextElement();
        if (token.type == 128) {
            if (!enumeration.hasMoreElements()) {
                throw new ParserException("Invalid shorthand structure - slash should be followed by a line height specifier: " + this.name + "=\"" + string + "\"");
            }
            token = (Token)enumeration.nextElement();
            ((Parsed)Attn.$line_height_optimum).process(token.value, parserContext);
            ((Parsed)Attn.$line_height_minimum).process(token.value, parserContext);
            ((Parsed)Attn.$line_height_maximum).process(token.value, parserContext);
            if (!enumeration.hasMoreElements()) {
                throw new ParserException("Invalid shorthand structure - cannot find font family definition: " + this.name + "=\"" + string + "\"");
            }
            token = (Token)enumeration.nextElement();
        }
        string2 = token.value.toString();
        while (enumeration.hasMoreElements()) {
            token = (Token)enumeration.nextElement();
            if (token.type == 8) {
                string2 = string2 + ", ";
                continue;
            }
            if (token.value == null) continue;
            string2 = string2 + " " + token.value.toString();
        }
        Attn.$font_family.process(string2, parserContext);
    }

    static {
        sysFonts.put("caption", "bold 10pt Helvetica");
        sysFonts.put("icon", "8pt Helvetica");
        sysFonts.put("menu", "8pt Helvetica");
        sysFonts.put("message-box", "9pt Helvetica");
        sysFonts.put("small-caption", "bold 8pt Helvetica");
        sysFonts.put("status-bar", "8pt Helvetica");
    }
}

