/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.util.List;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Bidi;
import com.renderx.xep.pre.CompilerException;
import com.renderx.xep.pre.ElementHandler;
import com.renderx.xep.pre.PIHandler;
import com.renderx.xep.pre.ParserContext;

public class BidiResolver
implements ElementHandler,
PIHandler {
    private final Session session;
    private final ElementHandler handler;
    private boolean delayed = false;
    private final List queue = new List();

    public BidiResolver(ElementHandler elementHandler, Session session) {
        this.handler = elementHandler;
        this.session = session;
    }

    public void reset() {
        this.queue.clear();
    }

    public void startElement(short s, AttList attList) throws CompilerException {
        if (this.delayed) {
            this.queue.append(new StartRecord(s, attList));
        } else {
            this.handler.startElement(s, attList);
        }
    }

    public void endElement(short s) throws CompilerException {
        if (this.delayed) {
            this.queue.append(new EndRecord(s));
        } else {
            this.handler.endElement(s);
        }
    }

    public void processingInstruction(String string, String string2) throws CompilerException {
        if (this.handler instanceof PIHandler) {
            ((PIHandler)((Object)this.handler)).processingInstruction(string, string2);
        }
    }

    public void characters(String string, AttList attList, Attr attr, ParserContext parserContext) {
        try {
            boolean bl = attr != parserContext.direction && attr != Bidi.NEUTRAL;
            boolean bl2 = attr == Bidi.RIGHTTOLEFT || parserContext.direction == Bidi.RIGHTTOLEFT && attr == Bidi.NEUTRAL;
            string = Bidi.shape(string, bl2);
            if (bl) {
                AttList attList2 = (AttList)attList.clone();
                attList2.put(Attn.$direction, attr);
                this.startElement((short)22, attList2);
            }
            if (this.delayed) {
                this.queue.append(new TextRecord(string, attList));
            } else {
                attList.put(Attn.$TEXT, Attr.Word.createUncached(string));
                this.startElement((short)0, attList);
                this.endElement((short)0);
            }
            if (bl) {
                this.endElement((short)22);
            }
        }
        catch (CompilerException compilerException) {
            this.session.error("Error while processing text node: " + compilerException);
        }
    }

    public class TextRecord
    implements Record {
        public String text;
        public AttList attributes;

        public TextRecord(String string, AttList attList) {
            this.text = string;
            this.attributes = attList;
        }

        public void play() throws CompilerException {
            this.attributes.put(Attn.$TEXT, Attr.Word.createUncached(this.text));
            BidiResolver.this.startElement((short)0, this.attributes);
            BidiResolver.this.endElement((short)0);
        }
    }

    public class EndRecord
    implements Record {
        public short element;

        public EndRecord(short s) {
            this.element = s;
        }

        public void play() throws CompilerException {
            BidiResolver.this.handler.endElement(this.element);
        }
    }

    public class StartRecord
    implements Record {
        public short element;
        public AttList attributes;

        public StartRecord(short s, AttList attList) {
            this.element = s;
            this.attributes = attList;
        }

        public void play() throws CompilerException {
            BidiResolver.this.handler.startElement(this.element, this.attributes);
        }
    }

    static interface Record {
        public void play() throws CompilerException;
    }
}

