/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.util.Hashtable;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.AttributeLexer;
import com.renderx.xep.pre.Expr;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.Token;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class AttributeParser {
    private static Hashtable parserCache = new Hashtable();
    private static Hashtable shorthandCache = new Hashtable();
    private static Vector productions = new Vector();
    private static final Token T_LeftPar = new Token(2);
    private static final Token T_RightPar = new Token(4);
    private static final Token T_Comma = new Token(8);
    private static final Token T_Plus = new Token(16);
    private static final Token T_Minus = new Token(32);
    private static final Token T_Asterisk = new Token(64);
    private static final Token T_Slash = new Token(128);
    private static final Token T_Divide = new Token(256);
    private static final Token T_Modulo = new Token(512);
    private static final Token T_UnaryPlus = new Token(1024);
    private static final Token T_UnaryMinus = new Token(2048);
    private static final Token T_Expr = new Token(8192);
    private static boolean initialized = false;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Bracketed;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$UnaryPlus;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$UnaryMinus;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Plus;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Minus;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Divide;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Multiply;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Modulo;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Floor;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Ceiling;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Round;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Absolute;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Minimum;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$Maximum;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$RGB_Color;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$RGB_ICC_Color;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$SystemColor;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$SystemFont;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$InheritedPropertyValue;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$FromParent;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$FromNearestSpecifiedValue;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$BodyStart;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$LabelEnd;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$FromTableColumn;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$MergePropertyValues;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$ProportionalColumnWidth;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$DefaultPageWidth;
    static /* synthetic */ Class class$com$renderx$xep$pre$exp$DefaultPageHeight;

    private static Attr getCached(String string) {
        return (Attr)parserCache.get(string);
    }

    private static synchronized void cache(String string, Attr attr) {
        parserCache.put(string, attr);
    }

    private static Stack getCachedStack(String string) {
        return (Stack)shorthandCache.get(string);
    }

    private static synchronized void cacheStack(String string, Stack stack) {
        shorthandCache.put(string, stack);
    }

    private static Stack makeStack(String string, boolean bl) throws ParserException {
        Stack<Token> stack = new Stack<Token>();
        AttributeLexer attributeLexer = new AttributeLexer(string, bl);
        Token token = attributeLexer.nextToken();
        while (token.type != 1) {
            stack.push(token);
            token = attributeLexer.nextToken();
            Enumeration enumeration = productions.elements();
            while (enumeration.hasMoreElements()) {
                Production production = (Production)enumeration.nextElement();
                if (!production.reduce(stack, token)) continue;
                enumeration = productions.elements();
            }
        }
        if (stack.empty()) {
            throw new ParserException("No meaningful characters in attribute value");
        }
        return stack;
    }

    public static Attr parse(String string) throws ParserException {
        Attr attr = AttributeParser.getCached(string);
        if (attr != null) {
            return attr;
        }
        Stack stack = AttributeParser.makeStack(string.trim().equals("inherit") ? "from-parent()" : string, false);
        if (stack.size() > 1) {
            throw new ParserException("Could not parse attribute value \"" + string + "\"");
        }
        Token token = (Token)stack.pop();
        if (token.type != 8192) {
            throw new ParserException("Attribute reduced to an unexpected token: " + token.getTypeName());
        }
        AttributeParser.cache(string, token.value);
        return token.value;
    }

    public static Stack parseShorthand(String string) throws ParserException {
        Stack stack = AttributeParser.getCachedStack(string);
        if (stack != null) {
            return stack;
        }
        stack = AttributeParser.makeStack(string, true);
        AttributeParser.cacheStack(string, stack);
        return stack;
    }

    private static void createProduction(Class clazz, Token[] tokenArray) throws InternalException {
        AttributeParser.createProduction(clazz, tokenArray, 0);
    }

    private static void createProduction(Class clazz, Token[] tokenArray, int n) throws InternalException {
        productions.addElement(new Production(clazz, tokenArray, n));
    }

    private static void createFunction(Class clazz, String string, int n) throws InternalException {
        Token[] tokenArray;
        Token token = new Token(4096, Attr.Word.create(string));
        if (n == 0) {
            tokenArray = new Token[]{token, T_RightPar};
        } else {
            tokenArray = new Token[n * 2 + 1];
            tokenArray[0] = token;
            int n2 = 0;
            while (n2 < n) {
                tokenArray[2 * n2 + 1] = T_Expr;
                ++n2;
            }
            int n3 = 1;
            while (n3 < n) {
                tokenArray[2 * n3] = T_Comma;
                ++n3;
            }
            tokenArray[2 * n] = T_RightPar;
        }
        AttributeParser.createProduction(clazz, tokenArray);
    }

    public static synchronized void init() throws InternalException {
        if (initialized) {
            return;
        }
        AttributeParser.createProduction(class$com$renderx$xep$pre$exp$Bracketed == null ? (class$com$renderx$xep$pre$exp$Bracketed = AttributeParser.class$("com.renderx.xep.pre.exp.Bracketed")) : class$com$renderx$xep$pre$exp$Bracketed, new Token[]{T_LeftPar, T_Expr, T_RightPar});
        AttributeParser.createProduction(class$com$renderx$xep$pre$exp$UnaryPlus == null ? (class$com$renderx$xep$pre$exp$UnaryPlus = AttributeParser.class$("com.renderx.xep.pre.exp.UnaryPlus")) : class$com$renderx$xep$pre$exp$UnaryPlus, new Token[]{T_UnaryPlus, T_Expr});
        AttributeParser.createProduction(class$com$renderx$xep$pre$exp$UnaryMinus == null ? (class$com$renderx$xep$pre$exp$UnaryMinus = AttributeParser.class$("com.renderx.xep.pre.exp.UnaryMinus")) : class$com$renderx$xep$pre$exp$UnaryMinus, new Token[]{T_UnaryMinus, T_Expr});
        AttributeParser.createProduction(class$com$renderx$xep$pre$exp$Plus == null ? (class$com$renderx$xep$pre$exp$Plus = AttributeParser.class$("com.renderx.xep.pre.exp.Plus")) : class$com$renderx$xep$pre$exp$Plus, new Token[]{T_Expr, T_Plus, T_Expr}, 832);
        AttributeParser.createProduction(class$com$renderx$xep$pre$exp$Minus == null ? (class$com$renderx$xep$pre$exp$Minus = AttributeParser.class$("com.renderx.xep.pre.exp.Minus")) : class$com$renderx$xep$pre$exp$Minus, new Token[]{T_Expr, T_Minus, T_Expr}, 832);
        AttributeParser.createProduction(class$com$renderx$xep$pre$exp$Divide == null ? (class$com$renderx$xep$pre$exp$Divide = AttributeParser.class$("com.renderx.xep.pre.exp.Divide")) : class$com$renderx$xep$pre$exp$Divide, new Token[]{T_Expr, T_Divide, T_Expr});
        AttributeParser.createProduction(class$com$renderx$xep$pre$exp$Multiply == null ? (class$com$renderx$xep$pre$exp$Multiply = AttributeParser.class$("com.renderx.xep.pre.exp.Multiply")) : class$com$renderx$xep$pre$exp$Multiply, new Token[]{T_Expr, T_Asterisk, T_Expr});
        AttributeParser.createProduction(class$com$renderx$xep$pre$exp$Modulo == null ? (class$com$renderx$xep$pre$exp$Modulo = AttributeParser.class$("com.renderx.xep.pre.exp.Modulo")) : class$com$renderx$xep$pre$exp$Modulo, new Token[]{T_Expr, T_Modulo, T_Expr});
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$Floor == null ? (class$com$renderx$xep$pre$exp$Floor = AttributeParser.class$("com.renderx.xep.pre.exp.Floor")) : class$com$renderx$xep$pre$exp$Floor, "floor", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$Ceiling == null ? (class$com$renderx$xep$pre$exp$Ceiling = AttributeParser.class$("com.renderx.xep.pre.exp.Ceiling")) : class$com$renderx$xep$pre$exp$Ceiling, "ceiling", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$Round == null ? (class$com$renderx$xep$pre$exp$Round = AttributeParser.class$("com.renderx.xep.pre.exp.Round")) : class$com$renderx$xep$pre$exp$Round, "round", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$Absolute == null ? (class$com$renderx$xep$pre$exp$Absolute = AttributeParser.class$("com.renderx.xep.pre.exp.Absolute")) : class$com$renderx$xep$pre$exp$Absolute, "abs", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$Minimum == null ? (class$com$renderx$xep$pre$exp$Minimum = AttributeParser.class$("com.renderx.xep.pre.exp.Minimum")) : class$com$renderx$xep$pre$exp$Minimum, "min", 2);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$Maximum == null ? (class$com$renderx$xep$pre$exp$Maximum = AttributeParser.class$("com.renderx.xep.pre.exp.Maximum")) : class$com$renderx$xep$pre$exp$Maximum, "max", 2);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$RGB_Color == null ? (class$com$renderx$xep$pre$exp$RGB_Color = AttributeParser.class$("com.renderx.xep.pre.exp.RGB_Color")) : class$com$renderx$xep$pre$exp$RGB_Color, "rgb", 3);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$RGB_ICC_Color == null ? (class$com$renderx$xep$pre$exp$RGB_ICC_Color = AttributeParser.class$("com.renderx.xep.pre.exp.RGB_ICC_Color")) : class$com$renderx$xep$pre$exp$RGB_ICC_Color, "rgb-icc", 5);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$RGB_ICC_Color == null ? (class$com$renderx$xep$pre$exp$RGB_ICC_Color = AttributeParser.class$("com.renderx.xep.pre.exp.RGB_ICC_Color")) : class$com$renderx$xep$pre$exp$RGB_ICC_Color, "rgb-icc", 6);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$RGB_ICC_Color == null ? (class$com$renderx$xep$pre$exp$RGB_ICC_Color = AttributeParser.class$("com.renderx.xep.pre.exp.RGB_ICC_Color")) : class$com$renderx$xep$pre$exp$RGB_ICC_Color, "rgb-icc", 7);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$RGB_ICC_Color == null ? (class$com$renderx$xep$pre$exp$RGB_ICC_Color = AttributeParser.class$("com.renderx.xep.pre.exp.RGB_ICC_Color")) : class$com$renderx$xep$pre$exp$RGB_ICC_Color, "rgb-icc", 8);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$RGB_ICC_Color == null ? (class$com$renderx$xep$pre$exp$RGB_ICC_Color = AttributeParser.class$("com.renderx.xep.pre.exp.RGB_ICC_Color")) : class$com$renderx$xep$pre$exp$RGB_ICC_Color, "rgb-icc", 9);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$RGB_ICC_Color == null ? (class$com$renderx$xep$pre$exp$RGB_ICC_Color = AttributeParser.class$("com.renderx.xep.pre.exp.RGB_ICC_Color")) : class$com$renderx$xep$pre$exp$RGB_ICC_Color, "rgb-icc", 10);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$RGB_ICC_Color == null ? (class$com$renderx$xep$pre$exp$RGB_ICC_Color = AttributeParser.class$("com.renderx.xep.pre.exp.RGB_ICC_Color")) : class$com$renderx$xep$pre$exp$RGB_ICC_Color, "rgb-icc", 11);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$SystemColor == null ? (class$com$renderx$xep$pre$exp$SystemColor = AttributeParser.class$("com.renderx.xep.pre.exp.SystemColor")) : class$com$renderx$xep$pre$exp$SystemColor, "system-color", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$SystemFont == null ? (class$com$renderx$xep$pre$exp$SystemFont = AttributeParser.class$("com.renderx.xep.pre.exp.SystemFont")) : class$com$renderx$xep$pre$exp$SystemFont, "system-font", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$SystemFont == null ? (class$com$renderx$xep$pre$exp$SystemFont = AttributeParser.class$("com.renderx.xep.pre.exp.SystemFont")) : class$com$renderx$xep$pre$exp$SystemFont, "system-font", 2);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$InheritedPropertyValue == null ? (class$com$renderx$xep$pre$exp$InheritedPropertyValue = AttributeParser.class$("com.renderx.xep.pre.exp.InheritedPropertyValue")) : class$com$renderx$xep$pre$exp$InheritedPropertyValue, "inherited-property-value", 0);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$InheritedPropertyValue == null ? (class$com$renderx$xep$pre$exp$InheritedPropertyValue = AttributeParser.class$("com.renderx.xep.pre.exp.InheritedPropertyValue")) : class$com$renderx$xep$pre$exp$InheritedPropertyValue, "inherited-property-value", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$FromParent == null ? (class$com$renderx$xep$pre$exp$FromParent = AttributeParser.class$("com.renderx.xep.pre.exp.FromParent")) : class$com$renderx$xep$pre$exp$FromParent, "from-parent", 0);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$FromParent == null ? (class$com$renderx$xep$pre$exp$FromParent = AttributeParser.class$("com.renderx.xep.pre.exp.FromParent")) : class$com$renderx$xep$pre$exp$FromParent, "from-parent", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$FromNearestSpecifiedValue == null ? (class$com$renderx$xep$pre$exp$FromNearestSpecifiedValue = AttributeParser.class$("com.renderx.xep.pre.exp.FromNearestSpecifiedValue")) : class$com$renderx$xep$pre$exp$FromNearestSpecifiedValue, "from-nearest-specified-value", 0);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$FromNearestSpecifiedValue == null ? (class$com$renderx$xep$pre$exp$FromNearestSpecifiedValue = AttributeParser.class$("com.renderx.xep.pre.exp.FromNearestSpecifiedValue")) : class$com$renderx$xep$pre$exp$FromNearestSpecifiedValue, "from-nearest-specified-value", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$BodyStart == null ? (class$com$renderx$xep$pre$exp$BodyStart = AttributeParser.class$("com.renderx.xep.pre.exp.BodyStart")) : class$com$renderx$xep$pre$exp$BodyStart, "body-start", 0);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$LabelEnd == null ? (class$com$renderx$xep$pre$exp$LabelEnd = AttributeParser.class$("com.renderx.xep.pre.exp.LabelEnd")) : class$com$renderx$xep$pre$exp$LabelEnd, "label-end", 0);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$FromTableColumn == null ? (class$com$renderx$xep$pre$exp$FromTableColumn = AttributeParser.class$("com.renderx.xep.pre.exp.FromTableColumn")) : class$com$renderx$xep$pre$exp$FromTableColumn, "from-table-column", 0);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$FromTableColumn == null ? (class$com$renderx$xep$pre$exp$FromTableColumn = AttributeParser.class$("com.renderx.xep.pre.exp.FromTableColumn")) : class$com$renderx$xep$pre$exp$FromTableColumn, "from-table-column", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$MergePropertyValues == null ? (class$com$renderx$xep$pre$exp$MergePropertyValues = AttributeParser.class$("com.renderx.xep.pre.exp.MergePropertyValues")) : class$com$renderx$xep$pre$exp$MergePropertyValues, "merge-property-values", 0);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$MergePropertyValues == null ? (class$com$renderx$xep$pre$exp$MergePropertyValues = AttributeParser.class$("com.renderx.xep.pre.exp.MergePropertyValues")) : class$com$renderx$xep$pre$exp$MergePropertyValues, "merge-property-values", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$ProportionalColumnWidth == null ? (class$com$renderx$xep$pre$exp$ProportionalColumnWidth = AttributeParser.class$("com.renderx.xep.pre.exp.ProportionalColumnWidth")) : class$com$renderx$xep$pre$exp$ProportionalColumnWidth, "proportional-column-width", 1);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$DefaultPageWidth == null ? (class$com$renderx$xep$pre$exp$DefaultPageWidth = AttributeParser.class$("com.renderx.xep.pre.exp.DefaultPageWidth")) : class$com$renderx$xep$pre$exp$DefaultPageWidth, "default-page-width", 0);
        AttributeParser.createFunction(class$com$renderx$xep$pre$exp$DefaultPageHeight == null ? (class$com$renderx$xep$pre$exp$DefaultPageHeight = AttributeParser.class$("com.renderx.xep.pre.exp.DefaultPageHeight")) : class$com$renderx$xep$pre$exp$DefaultPageHeight, "default-page-height", 0);
        Attn.init();
        initialized = true;
    }

    public static void main(String[] stringArray) {
        AttributeParser.init();
        char[] cArray = new char[8192];
        int n = 0;
        while (true) {
            Object object;
            try {
                object = new InputStreamReader(System.in);
                n = ((Reader)object).read(cArray);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.exit(1);
            }
            if (n < 0) {
                System.exit(0);
            }
            try {
                object = AttributeParser.parse(new String(cArray, 0, n));
                System.out.println(((Attr)object).toString());
                continue;
            }
            catch (ParserException parserException) {
                System.err.println(parserException.toString());
                continue;
            }
            catch (InternalException internalException) {
                System.err.println(internalException.toString());
                continue;
            }
            break;
        }
    }

    public static void PrintStackState(PrintStream printStream, Stack stack) {
        printStream.println("-------------------------");
        Enumeration enumeration = stack.elements();
        while (enumeration.hasMoreElements()) {
            Token token = (Token)enumeration.nextElement();
            printStream.println("  " + token.getTypeName() + (token.value == null ? "" : ": " + token.value));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Production {
        public Class generator;
        protected Token[] match;
        protected boolean[] mask;
        protected int arity = 0;
        protected int inhibitors = 0;

        public Production(Class clazz, Token[] tokenArray, int n) throws InternalException {
            this.generator = clazz;
            this.match = tokenArray;
            this.inhibitors = n;
            this.mask = new boolean[tokenArray.length];
            int n2 = 0;
            while (n2 < tokenArray.length) {
                if (tokenArray[n2].type == 8192) {
                    this.mask[n2] = true;
                    ++this.arity;
                } else {
                    this.mask[n2] = false;
                }
                ++n2;
            }
        }

        public boolean reduce(Stack stack, Token token) throws ParserException {
            Object object;
            Attr[] attrArray;
            if ((this.inhibitors & token.type) > 0) {
                return false;
            }
            if (stack.size() < this.match.length) {
                return false;
            }
            int n = stack.size() - this.match.length;
            int n2 = 0;
            while (n2 < this.match.length) {
                attrArray = (Attr[])stack.elementAt(n + n2);
                object = this.match[n2];
                if ((attrArray.type & ((Token)object).type) == 0) {
                    return false;
                }
                if (((Token)object).value != null && attrArray.value != ((Token)object).value) {
                    return false;
                }
                ++n2;
            }
            attrArray = null;
            if (this.arity > 0) {
                attrArray = new Attr[this.arity];
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.mask.length) {
                    if (this.mask[n4]) {
                        attrArray[n3++] = ((Token)stack.elementAt((int)(n + n4))).value;
                    }
                    ++n4;
                }
            }
            object = null;
            try {
                object = (Expr)this.generator.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new ParserException("Cannot instantiate expression: " + instantiationException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ParserException("Cannot access constructor for an expression: " + illegalAccessException.toString());
            }
            Attr attr = ((Expr)object).initialize(attrArray);
            stack.setSize(n + 1);
            stack.setElementAt(new Token(8192, attr), n);
            return true;
        }
    }
}

