/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.gen.backends;

import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Base64OutputStream;
import com.renderx.util.Hashtable;
import com.renderx.util.Stack;
import com.renderx.util.URLSpec;
import com.renderx.xep.gen.H4base;
import com.renderx.xep.gen.backends.Stamp;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.LicenseException;
import com.renderx.xep.lib.Session;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class H4SVG
extends H4base {
    private static final String SVGURI = "http://www.w3.org/2000/svg";
    private static final String XLINK = "http://www.w3.org/1999/xlink";
    private static final short O_EMBED_IMAGES = 0;
    private static final short O_GENERATE_FIRST_N_PAGES = 1;
    private static final short O_BREAK_PAGES = 2;
    private static final short O_PAGE_REORDERING = 3;
    private static final Hashtable optab = new Hashtable();
    private boolean EMBED_IMAGES;
    private int GENERATE_FIRST_N_PAGES;
    private boolean BREAK_PAGES;
    private boolean PAGE_REORDERING;
    private boolean EI;
    private int GFNP;
    private boolean BP;
    private boolean PR;
    private Hashtable imageIndex = new Hashtable();
    private final ImageFactory imageFactory;
    protected final Hashtable SVGimage = new Hashtable();
    protected final Hashtable XEPimage = new Hashtable();
    private int imageno = 0;
    private int clipno = 0;
    private boolean imageOK = true;
    private float[] currentViewBox;
    protected float xepoutX = 0.0f;
    protected float xepoutY = 0.0f;
    protected float xepoutScaleX = 0.0f;
    protected float xepoutScaleY = 0.0f;
    protected float xepoutW = 0.0f;
    protected float xepoutH = 0.0f;
    private boolean XEPOUTImageStart;
    private boolean XEPOUTImage;
    protected ContentHandler handler;
    protected Stack stack = new Stack();
    protected float totalH = 0.0f;
    protected float maxW = 0.0f;
    protected float pageH = 0.0f;
    protected float currentH = 0.0f;
    protected float currentW = 0.0f;
    protected float currentPageH = 0.0f;
    private StringBuffer sb;
    private java.util.Hashtable y = new java.util.Hashtable();
    private File TMPDIR;
    private java.util.Hashtable tmpFiles = new java.util.Hashtable();
    private java.util.Hashtable tmpStreams = new java.util.Hashtable();
    private java.util.Hashtable pageIDs = new java.util.Hashtable();
    private String pageID;
    private boolean USE_TEMP_FILE;
    private String currentPageID;
    private int pageNumber;
    private int maxP;
    private int countPage;
    private TreeSet page = new TreeSet();
    private int skip = 0;
    private FileOutputStream fosTmp;
    private ByteArrayOutputStream baosTmp;
    protected static java.util.Hashtable fontStretchAlias;
    private double[] alN = new double[]{482.0, 579.0, 694.0, 833.0, 1000.0, 1200.0, 1440.0, 1728.0, 2074.0};
    private double[] alP = new double[]{83.3, 120.0};
    private ZipOutputStream SVGStream;

    public H4SVG(OutputStream outputStream, Session session, Properties properties) throws IOException, LicenseException {
        super(outputStream, session, properties);
        if (!session.config.SVG && !session.config.SVGTrial) {
            session.error("SVG support is not licensed for this installation.");
            throw new LicenseException("SVG support is not licensed for this installation.");
        }
        this.setTMPDIR(session.config.TMPDIR);
        this.imageFactory = session.config.imageFactory;
    }

    private void setTMPDIR(File file) {
        if (file != null) {
            if (!file.exists()) {
                this.session.error("Directory " + file + " does not exist; disk caching in SVG generator disabled.");
                file = null;
            } else if (!file.isDirectory()) {
                this.session.error("File " + file + " is not a directory; disk caching in SVG generator disabled.");
                file = null;
            } else if (!file.canWrite()) {
                this.session.error("Directory " + file + " is not writable; disk caching in SVG generator disabled.");
                file = null;
            }
        }
        this.TMPDIR = file;
        this.USE_TEMP_FILE = file != null;
    }

    private void setTmpFile(String string) {
        if (this.USE_TEMP_FILE) {
            try {
                File file = this.getTempFile(string);
                this.fosTmp = new FileOutputStream(file);
                this.tmpFiles.put(string, file.toString());
            }
            catch (IOException iOException) {
                this.session.exception("Cannot create temporary file ", iOException);
                this.USE_TEMP_FILE = false;
            }
        }
        if (!this.USE_TEMP_FILE) {
            this.baosTmp = new ByteArrayOutputStream();
            this.tmpStreams.put(string, this.baosTmp);
        }
    }

    private synchronized File getTempFile(String string) {
        String string2;
        File file;
        while ((file = new File(this.TMPDIR, string2 = "svggen_" + Integer.toHexString((int)System.currentTimeMillis()) + "_" + string + ".tmp")).exists()) {
        }
        return file;
    }

    public String outFormat() {
        return "svg";
    }

    protected String getPropertyPrefix() {
        return "com.renderx.xep.H4SVG.";
    }

    protected String getProcessingInstructionPrefix() {
        return "xep-svg-";
    }

    protected void resetDefaultOptions() {
        this.EI = false;
        this.GFNP = 0;
        this.BP = false;
        this.PR = true;
    }

    protected void setOption(String string, String string2) {
        Object object = optab.get(string);
        if (object == null) {
            this.session.warning("Unrecognized SVG option " + string + ": setting ignored");
            return;
        }
        switch ((Short)object) {
            case 0: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.EI = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.EI = false;
                    break;
                }
                this.session.warning("Invalid EMBED_IMAGES value: " + string2 + "; setting ignored");
                break;
            }
            case 1: {
                string2 = string2.trim().toLowerCase();
                try {
                    this.GFNP = new Integer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.session.warning("Invalid GENERATE_FIRST_N_PAGES value: " + string2 + "; setting ignored");
                }
                if (this.GFNP >= 0) break;
                this.GFNP = 0;
                this.session.warning("GENERATE_FIRST_N_PAGES value cannot be negative: " + string2 + "; setting ignored");
                break;
            }
            case 2: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.BP = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.BP = false;
                    break;
                }
                this.session.warning("Invalid BREAK_PAGES value: " + string2 + "; setting ignored");
                break;
            }
            case 3: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.PR = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.PR = false;
                    break;
                }
                this.session.warning("Invalid PAGE_REORDERING value: " + string2 + "; setting ignored");
            }
        }
    }

    protected void initOptionsOnDocLevel() {
        this.EMBED_IMAGES = this.EI;
        this.GENERATE_FIRST_N_PAGES = this.GFNP;
        this.BREAK_PAGES = this.BP;
        this.PAGE_REORDERING = this.PR;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.maxW = 0.0f;
        this.totalH = 0.0f;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.skip > 0) {
            ++this.skip;
            return;
        }
        if (!"http://www.renderx.com/XEP/xep".equals(string)) {
            this.skip = 1;
            return;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        String[] stringArray = null;
        try {
            switch ((Short)H4base.idtab.get(string2)) {
                case 0: {
                    this.countPage = 0;
                    this.initOptionsOnDocLevel();
                    if (this.BREAK_PAGES) {
                        this.SVGStream = new ZipOutputStream(this.outstream);
                    }
                    break;
                }
                case 1: {
                    ++this.countPage;
                    this.pageNumber = this.parseInteger(attributes.getValue("page-number"));
                    if (this.PAGE_REORDERING) {
                        if (this.pageNumber > this.maxP) {
                            this.maxP = this.pageNumber;
                        }
                    } else {
                        this.maxP = this.countPage;
                    }
                    if (this.session.config.SVGTrial && this.countPage > 10 && this.countPage % 2 == 1 || this.countPage > this.GENERATE_FIRST_N_PAGES && this.GENERATE_FIRST_N_PAGES != 0) {
                        this.handler = null;
                    } else {
                        this.currentPageID = this.PAGE_REORDERING ? "" + this.pageNumber : "" + this.countPage;
                        if (!this.page.contains(new Integer(this.currentPageID))) {
                            if (this.BREAK_PAGES) {
                                this.currentPageH = this.parsePoint(attributes.getValue("height"));
                                this.currentW = this.parsePoint(attributes.getValue("width"));
                                this.handler = new Serializer(this.SVGStream, this.BREAK_PAGES, false, "");
                                this.pageID = this.currentPageID + Integer.toHexString((int)System.currentTimeMillis());
                                this.addSVGFile("page" + this.currentPageID + ".svg");
                                this.imageIndex = new Hashtable();
                            } else {
                                this.pageIDs.put(this.currentPageID, this.currentPageID + Integer.toHexString((int)System.currentTimeMillis()));
                                this.setTmpFile(this.currentPageID);
                                this.handler = this.USE_TEMP_FILE ? new Serializer(this.fosTmp, this.BREAK_PAGES, false, "") : new Serializer(this.baosTmp, this.BREAK_PAGES, false, "");
                            }
                            this.page.add(new Integer(this.currentPageID));
                        } else {
                            this.session.warning("Ignoring duplicate page " + this.currentPageID);
                            this.handler = null;
                        }
                    }
                    if (this.handler == null) {
                        return;
                    }
                    this.handler.startDocument();
                    attributesImpl.clear();
                    f7 = this.parsePoint(attributes.getValue("width"));
                    f8 = this.parsePoint(attributes.getValue("height"));
                    if (this.BREAK_PAGES) {
                        attributesImpl.addAttribute("", "id", "id", "CDATA", "page" + this.pageID);
                    } else {
                        attributesImpl.addAttribute("", "id", "id", "CDATA", "page" + this.pageIDs.get(this.currentPageID));
                    }
                    attributesImpl.addAttribute("", "width", "width", "CDATA", "" + f7 + "pt");
                    attributesImpl.addAttribute("", "height", "height", "CDATA", "" + f8 + "pt");
                    attributesImpl.addAttribute("", "overflow", "overflow", "CDATA", "hidden");
                    this.handler.startElement(SVGURI, "svg", "svg:svg", attributesImpl);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "x1", "x1", "CDATA", "0");
                    attributesImpl.addAttribute("", "y1", "y1", "CDATA", "0");
                    attributesImpl.addAttribute("", "x2", "x2", "CDATA", "" + f7 + "pt");
                    attributesImpl.addAttribute("", "y2", "y2", "CDATA", "0");
                    attributesImpl.addAttribute("", "stroke", "stroke", "CDATA", "blue");
                    attributesImpl.addAttribute("", "stroke-width", "stroke-width", "CDATA", "1pt");
                    this.handler.startElement(SVGURI, "line", "svg:line", attributesImpl);
                    this.handler.endElement(SVGURI, "line", "svg:line");
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "x1", "x1", "CDATA", "" + f7 + "pt");
                    attributesImpl.addAttribute("", "y1", "y1", "CDATA", "" + f8 + "pt");
                    attributesImpl.addAttribute("", "x2", "x2", "CDATA", "" + f7 + "pt");
                    attributesImpl.addAttribute("", "y2", "y2", "CDATA", "0");
                    attributesImpl.addAttribute("", "stroke", "stroke", "CDATA", "blue");
                    attributesImpl.addAttribute("", "stroke-width", "stroke-width", "CDATA", "1pt");
                    this.handler.startElement(SVGURI, "line", "svg:line", attributesImpl);
                    this.handler.endElement(SVGURI, "line", "svg:line");
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "stroke", "stroke", "CDATA", "currentColor");
                    attributesImpl.addAttribute("", "letter-spacing", "letter-spacing", "CDATA", "0");
                    attributesImpl.addAttribute("", "kerning", "kerning", "CDATA", "0");
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    this.stack.push("g");
                    attributesImpl.clear();
                    this.pageH += f8;
                    this.y.put(this.currentPageID, "" + f8);
                    this.totalH += f8;
                    if (f7 > this.maxW) {
                        this.maxW = f7;
                    }
                    this.currentH = f8;
                    this.currentPageH = f8;
                    this.currentW = f7;
                    this.currentViewBox = new float[]{0.0f, 0.0f, this.currentW, this.currentH};
                    break;
                }
                case 2: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.XEPOUTImageStart) {
                        if (attributes.getValue("id") != null) {
                            attributesImpl.addAttribute("", "id", "id", "CDATA", attributes.getValue("id"));
                        }
                        f7 = this.parsePoint(attributes.getValue("width"));
                        f8 = this.parsePoint(attributes.getValue("height"));
                        attributesImpl.addAttribute("", "width", "width", "CDATA", "" + f7 + "pt");
                        attributesImpl.addAttribute("", "height", "height", "CDATA", "" + f8 + "pt");
                        attributesImpl.addAttribute("", "overflow", "overflow", "CDATA", "hidden");
                        this.handler.startElement(SVGURI, "svg", "svg:svg", attributesImpl);
                        this.stack.push("svg");
                        this.XEPOUTImageStart = false;
                    } else {
                        int n = this.parseInteger(attributes.getValue("phi"));
                        attributesImpl.addAttribute("", "transform", "transform", "CDATA", "rotate(" + n + ")");
                        this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                        this.stack.push("g");
                    }
                    attributesImpl.clear();
                    break;
                }
                case 3: {
                    if (this.handler == null) {
                        return;
                    }
                    f2 = this.parsePoint(attributes.getValue("y"));
                    f = this.parsePoint(attributes.getValue("x"));
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f + "pt");
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f2 + "pt");
                    attributesImpl.addAttribute("", "overflow", "overflow", "CDATA", "visible");
                    this.handler.startElement(SVGURI, "svg", "svg:svg", attributesImpl);
                    this.stack.push("svg");
                    this.currentViewBox[2] = this.currentViewBox[2] - f;
                    this.currentViewBox[3] = this.currentViewBox[3] - f2;
                    break;
                }
                case 4: {
                    if (this.handler == null) {
                        return;
                    }
                    float f10 = this.parseFloat(attributes.getValue("a"));
                    int n = this.parseInteger(attributes.getValue("b"));
                    int n2 = this.parseInteger(attributes.getValue("c"));
                    float f11 = this.parseFloat(attributes.getValue("d"));
                    f = this.parseFloat(attributes.getValue("e"));
                    f2 = this.parseFloat(attributes.getValue("f"));
                    attributesImpl.addAttribute("", "overflow", "overflow", "CDATA", "visible");
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f + "pt");
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f2 + "pt");
                    this.handler.startElement(SVGURI, "svg", "svg:svg", attributesImpl);
                    this.stack.push("svg");
                    this.currentViewBox[2] = this.currentViewBox[2] - f;
                    this.currentViewBox[3] = this.currentViewBox[3] - f2;
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "transform", "transform", "CDATA", "matrix(" + f10 + "," + n + "," + n2 + "," + f11 + ",0,0)");
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    this.stack.push("g");
                    attributesImpl.clear();
                    break;
                }
                case 5: {
                    if (this.handler == null) {
                        return;
                    }
                    f3 = this.parsePoint(attributes.getValue("x-till"));
                    f4 = this.parsePoint(attributes.getValue("y-till"));
                    f5 = this.parsePoint(attributes.getValue("x-from"));
                    f6 = this.parsePoint(attributes.getValue("y-from"));
                    if (f3 < f5) {
                        f = f5;
                        f5 = f3;
                        f3 = f;
                    }
                    if (f4 < f6) {
                        f2 = f6;
                        f6 = f4;
                        f4 = f2;
                    }
                    this.handler.startElement(SVGURI, "defs", "svg:defs", attributesImpl);
                    attributesImpl.addAttribute("", "id", "id", "CDATA", "clip" + this.clipno);
                    this.handler.startElement(SVGURI, "clipPath", "svg:clipPath", attributesImpl);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f5 + "pt");
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f6 + "pt");
                    attributesImpl.addAttribute("", "width", "width", "CDATA", "" + (f3 - f5) + "pt");
                    attributesImpl.addAttribute("", "height", "height", "CDATA", "" + (f4 - f6) + "pt");
                    this.handler.startElement(SVGURI, "rect", "svg:rect", attributesImpl);
                    this.handler.endElement(SVGURI, "rect", "svg:rect");
                    this.handler.endElement(SVGURI, "clipPath", "svg:clipPath");
                    this.handler.endElement(SVGURI, "defs", "svg:defs");
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "0");
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "0");
                    attributesImpl.addAttribute("", "width", "width", "CDATA", "100%");
                    attributesImpl.addAttribute("", "height", "height", "CDATA", "100%");
                    attributesImpl.addAttribute("", "overflow", "overflow", "CDATA", "hidden");
                    attributesImpl.addAttribute("", "clip-path", "clip-path", "CDATA", "url(#clip" + this.clipno + ")");
                    this.handler.startElement(SVGURI, "svg", "svg:svg", attributesImpl);
                    this.stack.push("clip");
                    ++this.clipno;
                    attributesImpl.clear();
                    break;
                }
                case 6: {
                    if (this.handler == null) {
                        return;
                    }
                    attributesImpl.addAttribute("", "word-spacing", "word-spacing", "CDATA", "" + this.parsePoint(attributes.getValue("value")) + "pt");
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    attributesImpl.clear();
                    this.stack.push("g");
                    break;
                }
                case 7: {
                    if (this.handler == null) {
                        return;
                    }
                    attributesImpl.addAttribute("", "letter-spacing", "letter-spacing", "CDATA", "" + this.parsePoint(attributes.getValue("value")) + "pt");
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    attributesImpl.clear();
                    this.stack.push("g");
                    break;
                }
                case 8: {
                    if (this.handler == null) {
                        return;
                    }
                    Lexer lexer = new Lexer();
                    Token token = lexer.getSingleToken(attributes.getValue("value"));
                    String string4 = "";
                    if (token.type == 15) {
                        if (token.stringValue != null) {
                            if (token.stringValue.equals("%")) {
                                int n = 0;
                                while (n <= 1) {
                                    if (token.numValue >= this.alP[n]) {
                                        string4 = "" + fontStretchAlias.get("" + this.alP[n]);
                                    }
                                    ++n;
                                }
                                if (token.numValue <= this.alP[0]) {
                                    string4 = "" + fontStretchAlias.get("" + this.alP[0]);
                                }
                                if (string4.equals("")) {
                                    string4 = "normal";
                                }
                            } else {
                                this.session.warning("Data type mismatch: a 'normal' value  of 'font-stretch' element will be used instead.");
                                string4 = "normal";
                            }
                        } else {
                            token.numValue *= 1000.0;
                            int n = 0;
                            while (n <= 8) {
                                if (token.numValue >= this.alN[n]) {
                                    string4 = "" + fontStretchAlias.get("" + this.alN[n]);
                                }
                                ++n;
                            }
                            if (token.numValue <= this.alN[0]) {
                                string4 = "" + fontStretchAlias.get("" + this.alN[0]);
                            }
                            if (string4.equals("")) {
                                string4 = "normal";
                            }
                        }
                    } else {
                        this.session.warning("Data type mismatch: 'normal' value  of 'font-stretch' element will be used instead.");
                        string4 = "normal";
                    }
                    attributesImpl.addAttribute("", "font-stretch", "font-stretch", "CDATA", string4);
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    attributesImpl.clear();
                    this.stack.push("g");
                    break;
                }
                case 9: {
                    if (this.handler == null) {
                        return;
                    }
                    String string5 = attributes.getValue("family");
                    String string6 = attributes.getValue("variant");
                    String string7 = attributes.getValue("style");
                    String string8 = attributes.getValue("weight");
                    f9 = this.parsePoint(attributes.getValue("size"));
                    attributesImpl.addAttribute("", "font-family", "font-family", "CDATA", string5);
                    attributesImpl.addAttribute("", "font-variant", "font-variant", "CDATA", string6);
                    attributesImpl.addAttribute("", "font-style", "font-style", "CDATA", string7);
                    attributesImpl.addAttribute("", "font-weight", "font-weight", "CDATA", string8);
                    attributesImpl.addAttribute("", "font-size", "font-size", "CDATA", "" + f9 + "pt");
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    attributesImpl.clear();
                    this.stack.push("g");
                    break;
                }
                case 10: 
                case 45: {
                    if (this.handler == null) {
                        return;
                    }
                    f2 = this.parsePoint(attributes.getValue("y"));
                    f = this.parsePoint(attributes.getValue("x"));
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f + "pt");
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f2 + "pt");
                    attributesImpl.addAttribute("", "overflow", "overflow", "CDATA", "visible");
                    this.handler.startElement(SVGURI, "svg", "svg:svg", attributesImpl);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "fill", "fill", "CDATA", "currentColor");
                    attributesImpl.addAttribute("", "stroke", "stroke", "CDATA", "currentColor");
                    attributesImpl.addAttribute("", "transform", "transform", "CDATA", "scale(1.0, -1.0)");
                    attributesImpl.addAttribute("", "textLength", "textLength", "CDATA", "" + this.parsePoint(attributes.getValue("width")) + "pt");
                    this.handler.startElement(SVGURI, "text", "svg:text", attributesImpl);
                    attributesImpl.clear();
                    char[] cArray = attributes.getValue("value").toCharArray();
                    this.handler.characters(cArray, 0, cArray.length);
                    attributesImpl.addAttribute("", "transform", "transform", "CDATA", " scale(1.0, -1.0)");
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 11: {
                    if (this.handler == null) {
                        return;
                    }
                    f3 = this.parsePoint(attributes.getValue("x-till"));
                    f4 = this.parsePoint(attributes.getValue("y-till"));
                    f5 = this.parsePoint(attributes.getValue("x-from"));
                    f6 = this.parsePoint(attributes.getValue("y-from"));
                    String string9 = attributes.getValue("style").trim();
                    float f12 = this.parsePoint(attributes.getValue("thickness"));
                    attributesImpl.addAttribute("", "x1", "x1", "CDATA", "" + f5 + "pt");
                    attributesImpl.addAttribute("", "y1", "y1", "CDATA", "" + f6 + "pt");
                    attributesImpl.addAttribute("", "x2", "x2", "CDATA", "" + f3 + "pt");
                    attributesImpl.addAttribute("", "y2", "y2", "CDATA", "" + f4 + "pt");
                    if (string9.equalsIgnoreCase("dotted")) {
                        attributesImpl.addAttribute("", "stroke", "stroke", "CDATA", "currentColor");
                        attributesImpl.addAttribute("", "stroke-width", "stroke-width", "CDATA", "" + f12 + "pt");
                        attributesImpl.addAttribute("", "stroke-linecap", "stroke-linecap", "CDATA", "round");
                        attributesImpl.addAttribute("", "stroke-dasharray", "stroke-dasharray", "CDATA", "0, " + f12 * 2.0f + "pt");
                    } else if (string9.equalsIgnoreCase("dashed")) {
                        attributesImpl.addAttribute("", "stroke", "stroke", "CDATA", "currentColor");
                        attributesImpl.addAttribute("", "stroke-width", "stroke-width", "CDATA", "" + f12 + "pt");
                        attributesImpl.addAttribute("", "stroke-dasharray", "stroke-dasharray", "CDATA", "" + f12 * 2.0f + "pt, " + f12 + "pt");
                    } else if (string9.equalsIgnoreCase("solid")) {
                        attributesImpl.addAttribute("", "stroke", "stroke", "CDATA", "currentColor");
                        attributesImpl.addAttribute("", "stroke-width", "stroke-width", "CDATA", "" + f12 + "pt");
                    } else {
                        this.session.warning("Line style '" + string9 + "' is not supported. Line style 'solid' will be used instead.");
                        attributesImpl.addAttribute("", "stroke", "stroke", "CDATA", "currentColor");
                        attributesImpl.addAttribute("", "stroke-width", "stroke-width", "CDATA", "" + f12 + "pt");
                    }
                    this.handler.startElement(SVGURI, "line", "svg:line", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 12: {
                    if (this.handler == null) {
                        return;
                    }
                    f3 = this.parsePoint(attributes.getValue("x-till"));
                    f4 = this.parsePoint(attributes.getValue("y-till"));
                    f5 = this.parsePoint(attributes.getValue("x-from"));
                    f6 = this.parsePoint(attributes.getValue("y-from"));
                    if (f3 < f5) {
                        f = f5;
                        f5 = f3;
                        f3 = f;
                    }
                    if (f4 < f6) {
                        f2 = f6;
                        f6 = f4;
                        f4 = f2;
                    }
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f5 + "pt");
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f6 + "pt");
                    attributesImpl.addAttribute("", "width", "width", "CDATA", "" + (f3 - f5) + "pt");
                    attributesImpl.addAttribute("", "height", "height", "CDATA", "" + (f4 - f6) + "pt");
                    attributesImpl.addAttribute("", "fill", "fill", "CDATA", "currentColor");
                    attributesImpl.addAttribute("", "stroke", "stroke", "CDATA", "currentColor");
                    this.handler.startElement(SVGURI, "rect", "svg:rect", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 13: {
                    if (this.handler == null) {
                        return;
                    }
                    this.sb = new StringBuffer();
                    this.sb.append("" + this.parsePoint(attributes.getValue("x-from")));
                    this.sb.append(',');
                    this.sb.append("" + this.parsePoint(attributes.getValue("y-from")));
                    this.sb.append(' ');
                    break;
                }
                case 14: {
                    if (this.handler == null) {
                        return;
                    }
                    this.sb.append("" + this.parsePoint(attributes.getValue("x-till")));
                    this.sb.append(',');
                    this.sb.append("" + this.parsePoint(attributes.getValue("y-till")));
                    this.sb.append(' ');
                    break;
                }
                case 15: {
                    String string10;
                    if (this.handler == null) {
                        return;
                    }
                    try {
                        attributes = this.embedImage(attributes);
                    }
                    catch (Exception exception) {
                        this.imageOK = false;
                        this.session.exception("Error processing image", exception);
                    }
                    f5 = this.parsePoint(attributes.getValue("x-from"));
                    f6 = this.parsePoint(attributes.getValue("y-from"));
                    float f13 = this.parseFloat(attributes.getValue("scale-x"));
                    float f14 = this.parseFloat(attributes.getValue("scale-y"));
                    String string11 = attributes.getValue("type");
                    f8 = 0.0f;
                    f7 = 0.0f;
                    if (attributes.getValue("height") != null) {
                        f8 = this.parsePoint(attributes.getValue("height"));
                    }
                    if (attributes.getValue("width") != null) {
                        f7 = this.parsePoint(attributes.getValue("width"));
                    }
                    String string12 = "";
                    String string13 = "";
                    if (attributes.getValue("wunit") != null) {
                        string12 = attributes.getValue("wunit");
                    }
                    if (attributes.getValue("hunit") != null) {
                        string13 = attributes.getValue("hunit");
                    }
                    if (attributes.getValue("id") != null) {
                        if (string11.equalsIgnoreCase("application/xepout")) {
                            while (this.stack.length() != 0) {
                                String string14 = this.stack.pop().toString();
                                if (string14.equals("xepout")) break;
                                this.handler.endElement(SVGURI, string14, "svg:" + string14);
                            }
                            return;
                        }
                        this.handler.startElement(SVGURI, "defs", "svg:defs", attributesImpl);
                        char[] cArray = new char[]{' '};
                        this.handler.characters(cArray, 0, 0);
                        if (this.imageOK && (string11.equalsIgnoreCase("image/svg") || string11.equalsIgnoreCase("image/svg+xml"))) {
                            OutputStreamWriter outputStreamWriter;
                            if (!this.BREAK_PAGES) {
                                if (this.USE_TEMP_FILE) {
                                    try {
                                        outputStreamWriter = new OutputStreamWriter((OutputStream)this.fosTmp, "UTF8");
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        outputStreamWriter = new OutputStreamWriter(this.fosTmp);
                                    }
                                } else {
                                    try {
                                        outputStreamWriter = new OutputStreamWriter((OutputStream)this.baosTmp, "UTF8");
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        outputStreamWriter = new OutputStreamWriter(this.baosTmp);
                                    }
                                }
                            } else {
                                try {
                                    outputStreamWriter = new OutputStreamWriter((OutputStream)this.SVGStream, "UTF8");
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    outputStreamWriter = new OutputStreamWriter(this.SVGStream);
                                }
                            }
                            try {
                                outputStreamWriter.write(attributes.getValue("src"));
                                ((Writer)outputStreamWriter).flush();
                            }
                            catch (IOException iOException) {
                                throw new SVGIOException(iOException);
                            }
                        }
                        attributesImpl.addAttribute("", "id", "id", "CDATA", attributes.getValue("id"));
                        attributesImpl.addAttribute("", "width", "width", "CDATA", "" + f7 + "pt");
                        attributesImpl.addAttribute("", "height", "height", "CDATA", "" + f8 + "pt");
                        if (attributes.getValue("base") != null) {
                            attributesImpl.addAttribute("", "xml:base", "xml:base", "CDATA", "" + attributes.getValue("base"));
                        }
                        attributesImpl.addAttribute("", "xlink:href", "xlink:href", "CDATA", "" + attributes.getValue("src"));
                        this.handler.startElement(SVGURI, "image", "svg:image", attributesImpl);
                        this.handler.endElement(SVGURI, "image", "svg:image");
                        attributesImpl.clear();
                        this.handler.endElement(SVGURI, "defs", "svg:defs");
                        string10 = attributes.getValue("id");
                    } else {
                        string10 = attributes.getValue("id-ref");
                    }
                    if (string11.equalsIgnoreCase("application/xepout")) {
                        attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f5 + "pt");
                        attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f6 + "pt");
                        attributesImpl.addAttribute("", "overflow", "overflow", "CDATA", "visible");
                        this.handler.startElement(SVGURI, "svg", "svg:svg", attributesImpl);
                        attributesImpl.clear();
                        attributesImpl.addAttribute("", "transform", "transform", "CDATA", "scale(" + f13 + "," + f14 + ")");
                        attributesImpl.addAttribute("", "xlink:href", "xlink:href", "CDATA", "#" + string10);
                        this.handler.startElement(SVGURI, "use", "svg:use", attributesImpl);
                        attributesImpl.clear();
                        this.handler.endElement(SVGURI, "use", "svg:use");
                        this.handler.endElement(SVGURI, "svg", "svg:svg");
                        break;
                    }
                    if (this.imageOK && (string11.equalsIgnoreCase("image/svg") || string11.equalsIgnoreCase("image/svg+xml"))) {
                        attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f5 + "pt");
                        attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f6 + "pt");
                        attributesImpl.addAttribute("", "overflow", "overflow", "CDATA", "visible");
                        this.handler.startElement(SVGURI, "svg", "svg:svg", attributesImpl);
                        attributesImpl.clear();
                        if (string13.equals("px") || string13.equals("")) {
                            // empty if block
                        }
                        attributesImpl.addAttribute("", "x", "x", "CDATA", "0");
                        attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f8 * f14 + string13);
                        attributesImpl.addAttribute("", "overflow", "overflow", "CDATA", "visible");
                        this.handler.startElement(SVGURI, "svg", "svg:svg", attributesImpl);
                        attributesImpl.clear();
                        attributesImpl.addAttribute("", "transform", "transform", "CDATA", "scale(" + f13 + "," + -1.0f * f14 + ")");
                        attributesImpl.addAttribute("", "xlink:href", "xlink:href", "CDATA", "#" + string10);
                        this.handler.startElement(SVGURI, "use", "svg:use", attributesImpl);
                        attributesImpl.clear();
                        this.handler.endElement(SVGURI, "use", "svg:use");
                        this.handler.endElement(SVGURI, "svg", "svg:svg");
                        this.handler.endElement(SVGURI, "svg", "svg:svg");
                        break;
                    }
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f5 + "pt");
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "" + (f6 + f8 * f14) + "pt");
                    attributesImpl.addAttribute("", "overflow", "overflow", "CDATA", "visible");
                    this.handler.startElement(SVGURI, "svg", "svg:svg", attributesImpl);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "transform", "transform", "CDATA", "scale(" + f13 + "," + -1.0f * f14 + ")");
                    attributesImpl.addAttribute("", "xlink:href", "xlink:href", "CDATA", "#" + string10);
                    this.handler.startElement(SVGURI, "use", "svg:use", attributesImpl);
                    attributesImpl.clear();
                    this.handler.endElement(SVGURI, "use", "svg:use");
                    this.handler.endElement(SVGURI, "svg", "svg:svg");
                    break;
                }
                case 16: {
                    if (this.handler == null) {
                        return;
                    }
                    stringArray = this.RGB2RGB(this.parseFloat(attributes.getValue("red")), this.parseFloat(attributes.getValue("green")), this.parseFloat(attributes.getValue("blue")));
                    attributesImpl.addAttribute("", "color", "color", "CDATA", "#" + stringArray[0] + stringArray[1] + stringArray[2]);
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    attributesImpl.clear();
                    this.stack.push("g");
                    break;
                }
                case 17: {
                    if (this.handler == null) {
                        return;
                    }
                    stringArray = this.Grey2RGB(this.parseFloat(attributes.getValue("gray")));
                    attributesImpl.addAttribute("", "color", "color", "CDATA", "#" + stringArray[0] + stringArray[1] + stringArray[2]);
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    attributesImpl.clear();
                    this.stack.push("g");
                    break;
                }
                case 18: {
                    if (this.handler == null) {
                        return;
                    }
                    stringArray = this.CMYK2RGB(this.parseFloat(attributes.getValue("black")), this.parseFloat(attributes.getValue("cyan")), this.parseFloat(attributes.getValue("magenta")), this.parseFloat(attributes.getValue("yellow")));
                    attributesImpl.addAttribute("", "color", "color", "CDATA", "#" + stringArray[0] + stringArray[1] + stringArray[2]);
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    attributesImpl.clear();
                    this.stack.push("g");
                    break;
                }
                case 19: {
                    if (this.handler == null) {
                        return;
                    }
                    float f15 = this.parseFloat(attributes.getValue("tint"));
                    if (attributes.getValue("alt-gray") != null) {
                        f15 = 1.0f - f15;
                        stringArray = this.Grey2RGB(f15 * this.parseFloat(attributes.getValue("alt-gray")));
                    } else if (attributes.getValue("alt-red") != null) {
                        f15 = 1.0f - f15;
                        stringArray = this.RGB2RGB(f15 * this.parseFloat(attributes.getValue("alt-red")), f15 * this.parseFloat(attributes.getValue("alt-green")), f15 * this.parseFloat(attributes.getValue("alt-blue")));
                    } else if (attributes.getValue("alt-cyan") != null) {
                        stringArray = this.CMYK2RGB(f15 * this.parseFloat(attributes.getValue("alt-black")), f15 * this.parseFloat(attributes.getValue("alt-cyan")), f15 * this.parseFloat(attributes.getValue("alt-magenta")), f15 * this.parseFloat(attributes.getValue("alt-yellow")));
                    }
                    attributesImpl.addAttribute("", "color", "color", "CDATA", "#" + stringArray[0] + stringArray[1] + stringArray[2]);
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    attributesImpl.clear();
                    this.stack.push("g");
                    break;
                }
                case 20: {
                    if (this.handler == null) {
                        return;
                    }
                    String string15 = Integer.toHexString((int)Math.round(255.0 * (1.0 - (double)this.parseFloat(attributes.getValue("tint")))));
                    if (string15.length() < 2) {
                        string15 = "0" + string15;
                    }
                    attributesImpl.addAttribute("", "color", "color", "CDATA", "#" + string15 + string15 + string15);
                    this.handler.startElement(SVGURI, "g", "svg:g", attributesImpl);
                    attributesImpl.clear();
                    this.stack.push("g");
                    break;
                }
                case 21: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.XEPOUTImage) {
                        return;
                    }
                    f = this.parsePoint(attributes.getValue("x"));
                    f2 = this.parsePoint(attributes.getValue("y"));
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f + "pt");
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f2 + "pt");
                    attributesImpl.addAttribute("", "width", "width", "CDATA", "0");
                    attributesImpl.addAttribute("", "height", "height", "CDATA", "0");
                    attributesImpl.addAttribute("", "id", "id", "CDATA", attributes.getValue("name"));
                    attributesImpl.addAttribute("", "opacity", "opacity", "CDATA", "0");
                    this.handler.startElement(SVGURI, "rect", "svg:rect", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 22: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.XEPOUTImage) {
                        return;
                    }
                    if (this.BREAK_PAGES) {
                        attributesImpl.addAttribute("", "xlink:href", "xlink:href", "CDATA", "page" + attributes.getValue("destination") + ".svg#" + attributes.getValue("destination-id"));
                    } else {
                        attributesImpl.addAttribute("", "xlink:href", "xlink:href", "CDATA", "#" + attributes.getValue("destination-id"));
                    }
                    this.handler.startElement(SVGURI, "a", "svg:a", attributesImpl);
                    attributesImpl.clear();
                    f3 = this.parsePoint(attributes.getValue("x-till"));
                    f4 = this.parsePoint(attributes.getValue("y-till"));
                    f5 = this.parsePoint(attributes.getValue("x-from"));
                    f6 = this.parsePoint(attributes.getValue("y-from"));
                    if (f3 < f5) {
                        f = f5;
                        f5 = f3;
                        f3 = f;
                    }
                    if (f4 < f6) {
                        f2 = f6;
                        f6 = f4;
                        f4 = f2;
                    }
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f5 + "pt");
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f6 + "pt");
                    attributesImpl.addAttribute("", "width", "width", "CDATA", "" + (f3 - f5) + "pt");
                    attributesImpl.addAttribute("", "height", "height", "CDATA", "" + (f4 - f6) + "pt");
                    attributesImpl.addAttribute("", "opacity", "opacity", "CDATA", "0");
                    this.handler.startElement(SVGURI, "rect", "svg:rect", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 23: {
                    if (this.handler == null) {
                        return;
                    }
                    attributesImpl.addAttribute("", "xlink:href", "xlink:href", "CDATA", attributes.getValue("destination"));
                    attributesImpl.addAttribute("", "xlink:show", "xlink:show", "CDATA", attributes.getValue("show-destination"));
                    this.handler.startElement(SVGURI, "a", "svg:a", attributesImpl);
                    attributesImpl.clear();
                    f3 = this.parsePoint(attributes.getValue("x-till"));
                    f4 = this.parsePoint(attributes.getValue("y-till"));
                    f5 = this.parsePoint(attributes.getValue("x-from"));
                    f6 = this.parsePoint(attributes.getValue("y-from"));
                    if (f3 < f5) {
                        f = f5;
                        f5 = f3;
                        f3 = f;
                    }
                    if (f4 < f6) {
                        f2 = f6;
                        f6 = f4;
                        f4 = f2;
                    }
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "" + f5 + "pt");
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "" + f6 + "pt");
                    attributesImpl.addAttribute("", "width", "width", "CDATA", "" + (f3 - f5) + "pt");
                    attributesImpl.addAttribute("", "height", "height", "CDATA", "" + (f4 - f6) + "pt");
                    attributesImpl.addAttribute("", "opacity", "opacity", "CDATA", "0");
                    this.handler.startElement(SVGURI, "rect", "svg:rect", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 24: {
                    break;
                }
                case 25: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    this.skip = 1;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 46: {
                    break;
                }
                default: {
                    throw new InternalException("unknown instruction '" + string2 + "'");
                }
            }
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at element: " + string2 + " : " + exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void endElement(String var1_1, String var2_2, String var3_3) throws SAXException {
        if (this.skip > 0) {
            --this.skip;
            return;
        }
        if (!"http://www.renderx.com/XEP/xep".equals(var1_1)) {
            --this.skip;
            return;
        }
        if (this.handler == null) {
            return;
        }
        try {
            switch ((Short)H4base.idtab.get(var2_2)) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.handler != null) ** GOTO lbl18
                    return;
lbl-1000:
                    // 1 sources

                    {
                        var4_4 = this.stack.pop().toString();
                        this.handler.endElement("http://www.w3.org/2000/svg", var4_4, "svg:" + var4_4);
lbl18:
                        // 2 sources

                        ** while (this.stack.length() != 0)
                    }
lbl19:
                    // 1 sources

                    if (this.session.config.CUSTOM_STAMP == null & this.session.config.SVGTrial) {
                        Stamp.put(this, this.session);
                    }
                    if (this.session.config.CUSTOM_STAMP != null) {
                        this.putCustomStamp();
                    }
                    while (this.stack.length() != 0) {
                        var4_4 = this.stack.pop().toString();
                        this.handler.endElement("http://www.w3.org/2000/svg", var4_4, "svg:" + var4_4);
                    }
                    this.handler.endElement("http://www.w3.org/2000/svg", "svg", "svg:svg");
                    this.handler.endDocument();
                    if (this.USE_TEMP_FILE && !this.BREAK_PAGES) {
                        this.fosTmp.close();
                    }
                    if (this.BREAK_PAGES) {
                        this.endSVGFile();
                    }
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (this.handler != null) ** GOTO lbl46
                    return;
                    while (!(var4_5 = this.stack.pop().toString()).equals("clip")) {
                        this.handler.endElement("http://www.w3.org/2000/svg", var4_5, "svg:" + var4_5);
lbl46:
                        // 2 sources

                        if (this.stack.length() != 0) continue;
                    }
                    this.handler.endElement("http://www.w3.org/2000/svg", "svg", "svg:svg");
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    if (this.handler == null) {
                        return;
                    }
                    this.handler.endElement("http://www.w3.org/2000/svg", "g", "svg:g");
                    this.handler.endElement("http://www.w3.org/2000/svg", "text", "svg:text");
                    this.handler.endElement("http://www.w3.org/2000/svg", "svg", "svg:svg");
                    break;
                }
                case 11: {
                    if (this.handler == null) {
                        return;
                    }
                    this.handler.endElement("http://www.w3.org/2000/svg", "line", "svg:line");
                    break;
                }
                case 12: {
                    if (this.handler == null) {
                        return;
                    }
                    this.handler.endElement("http://www.w3.org/2000/svg", "rect", "svg:rect");
                    break;
                }
                case 13: {
                    if (this.handler == null) {
                        return;
                    }
                    var4_6 = new AttributesImpl();
                    var5_8 = this.currentViewBox[0] + " " + this.currentViewBox[1] + " " + this.currentViewBox[2] + " " + this.currentViewBox[3];
                    var4_6.addAttribute("", "x", "x", "CDATA", "0");
                    var4_6.addAttribute("", "y", "y", "CDATA", "0");
                    var4_6.addAttribute("", "width", "width", "CDATA", "" + this.currentViewBox[2] + "pt");
                    var4_6.addAttribute("", "height", "height", "CDATA", "" + this.currentViewBox[3] + "pt");
                    var4_6.addAttribute("", "viewBox", "viewBox", "CDATA", var5_8);
                    var4_6.addAttribute("", "overflow", "overflow", "CDATA", "visible");
                    this.handler.startElement("http://www.w3.org/2000/svg", "svg", "svg:svg", var4_6);
                    var4_6.clear();
                    var4_6.addAttribute("", "points", "points", "CDATA", this.sb.toString());
                    var4_6.addAttribute("", "fill", "fill", "CDATA", "currentColor");
                    var4_6.addAttribute("", "stroke", "stroke", "CDATA", "currentColor");
                    this.handler.startElement("http://www.w3.org/2000/svg", "polygon", "svg:polygon", var4_6);
                    this.handler.endElement("http://www.w3.org/2000/svg", "polygon", "svg:polygon");
                    this.handler.endElement("http://www.w3.org/2000/svg", "svg", "svg:svg");
                    var4_6.clear();
                    break;
                }
                case 14: {
                    break;
                }
                case 15: {
                    this.imageOK = true;
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    break;
                }
                case 20: {
                    break;
                }
                case 21: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.XEPOUTImage) {
                        return;
                    }
                    this.handler.endElement("http://www.w3.org/2000/svg", "rect", "svg:rect");
                    break;
                }
                case 22: {
                    if (this.handler == null) {
                        return;
                    }
                    this.handler.endElement("http://www.w3.org/2000/svg", "rect", "svg:rect");
                    this.handler.endElement("http://www.w3.org/2000/svg", "a", "svg:a");
                    break;
                }
                case 23: {
                    if (this.handler == null) {
                        return;
                    }
                    this.handler.endElement("http://www.w3.org/2000/svg", "rect", "svg:rect");
                    this.handler.endElement("http://www.w3.org/2000/svg", "a", "svg:a");
                    break;
                }
                case 24: {
                    break;
                }
                case 25: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    break;
                }
                default: {
                    throw new InternalException("unknown instruction '" + var2_2 + "'");
                }
            }
        }
        catch (Exception var4_7) {
            throw new InternalException("fatal error at element: " + var2_2 + " : " + var4_7);
        }
    }

    public void endDocument() throws SAXException {
        if (!this.BREAK_PAGES) {
            Object object;
            int n;
            OutputStreamWriter outputStreamWriter;
            try {
                outputStreamWriter = new OutputStreamWriter(this.outstream, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                outputStreamWriter = new OutputStreamWriter(this.outstream);
            }
            try {
                outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                outputStreamWriter.write("<svg:svg xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ");
                outputStreamWriter.write("width=\"" + this.maxW + "pt\" height=\"" + this.totalH + "pt\">\n\t");
                outputStreamWriter.write("<svg:defs>");
                ((Writer)outputStreamWriter).flush();
            }
            catch (IOException iOException) {
                throw new SVGIOException(iOException);
            }
            if (this.USE_TEMP_FILE) {
                n = 1;
                while (n <= this.maxP) {
                    if (this.tmpFiles.containsKey("" + n)) {
                        try {
                            int n2;
                            object = new File((String)this.tmpFiles.get("" + n));
                            FileInputStream fileInputStream = new FileInputStream((File)object);
                            byte[] byArray = new byte[512];
                            while ((n2 = fileInputStream.read(byArray)) != -1) {
                                this.outstream.write(byArray, 0, n2);
                            }
                            this.outstream.flush();
                            fileInputStream.close();
                            ((File)object).delete();
                        }
                        catch (IOException iOException) {
                            throw new SVGIOException(iOException);
                        }
                    }
                    ++n;
                }
            } else {
                n = 1;
                while (n <= this.maxP) {
                    if (this.tmpStreams.containsKey("" + n)) {
                        try {
                            object = (ByteArrayOutputStream)this.tmpStreams.get("" + n);
                            this.outstream.write(((ByteArrayOutputStream)object).toByteArray());
                            this.outstream.flush();
                            ((ByteArrayOutputStream)object).close();
                        }
                        catch (IOException iOException) {
                            throw new SVGIOException(iOException);
                        }
                    }
                    ++n;
                }
            }
            try {
                outputStreamWriter.write("\n\t</svg:defs>");
                float f = 0.0f;
                int n3 = 1;
                while (n3 <= this.maxP) {
                    if (this.y.containsKey("" + n3)) {
                        outputStreamWriter.write("\n\t<svg:svg overflow=\"visible\" x=\"0\" y=\"" + (f += new Float((String)this.y.get("" + n3)).floatValue()) + "pt\">");
                        outputStreamWriter.write("\n\t\t<svg:use xlink:href=\"#page" + this.pageIDs.get("" + n3) + "\" transform=\" scale(1.0,-1.0)\"/>");
                        outputStreamWriter.write("\n\t</svg:svg>");
                    }
                    ++n3;
                }
                outputStreamWriter.write("\n</svg:svg>");
                ((Writer)outputStreamWriter).flush();
            }
            catch (IOException iOException) {
                throw new SVGIOException(iOException);
            }
        }
        try {
            this.SVGStream.flush();
            this.SVGStream.close();
        }
        catch (IOException iOException) {
            this.session.error("Cannot close document: " + iOException);
        }
    }

    private void addSVGFile(String string) {
        ZipEntry zipEntry = new ZipEntry(string);
        try {
            this.SVGStream.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            this.session.error("Cannot create ZIP Entry. " + iOException);
        }
    }

    private void endSVGFile() {
        try {
            this.SVGStream.closeEntry();
        }
        catch (IOException iOException) {
            this.session.error("Cannot close ZIP Entry. " + iOException);
        }
    }

    public int parseInteger(String string) {
        return Integer.valueOf(string);
    }

    public float parseFloat(String string) {
        return Float.valueOf(string).floatValue();
    }

    public float parsePoint(String string) {
        return Float.valueOf(string).floatValue() / 1000.0f;
    }

    public String[] CMYK2RGB(float f, float f2, float f3, float f4) {
        float f5 = 1.0f - f;
        int n = f5 > f2 ? Math.round((f5 - f2) * 255.0f) : 0;
        int n2 = f5 > f3 ? Math.round((f5 - f3) * 255.0f) : 0;
        int n3 = f5 > f4 ? Math.round((f5 - f4) * 255.0f) : 0;
        String string = Integer.toHexString(n);
        String string2 = Integer.toHexString(n2);
        String string3 = Integer.toHexString(n3);
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        return new String[]{string, string2, string3};
    }

    public String[] Grey2RGB(float f) {
        String string = Integer.toHexString(Math.round(255.0f * f));
        if (string.length() < 2) {
            string = "0" + string;
        }
        return new String[]{string, string, string};
    }

    public String[] RGB2RGB(float f, float f2, float f3) {
        String string = Integer.toHexString(Math.round(255.0f * f));
        String string2 = Integer.toHexString(Math.round(255.0f * f2));
        String string3 = Integer.toHexString(Math.round(255.0f * f3));
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        return new String[]{string, string2, string3};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Attributes embedImage(Attributes attributes) throws IOException, SAXException {
        InputSource inputSource;
        XMLReader xMLReader;
        ContentHandler contentHandler;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        String string7;
        String string4;
        URLSpec uRLSpec;
        String string;
        int n;
        AttributesImpl attributesImpl;
        block39: {
            attributesImpl = new AttributesImpl(attributes);
            int n2 = attributesImpl.getIndex("id");
            if (n2 != -1) {
                attributesImpl.removeAttribute(n2);
            }
            if ((n2 = attributesImpl.getIndex("id-ref")) != -1) {
                attributesImpl.removeAttribute(n2);
            }
            if ((n = attributesImpl.getIndex("src")) == -1) {
                this.session.error("No source specified for an image");
                return attributes;
            }
            string = attributesImpl.getValue(n);
            String string2 = (String)this.imageIndex.get(string);
            String string3 = attributesImpl.getValue("base");
            uRLSpec = string3 == null ? new URLSpec(string) : new URLSpec(new URLSpec(string3), string);
            string4 = attributesImpl.getValue("type");
            String string5 = "0";
            String string6 = "0";
            if (!(string4.equalsIgnoreCase("image/svg") || string4.equalsIgnoreCase("image/svg+xml") || string4.equalsIgnoreCase("application/xepout"))) {
                try {
                    Image image = this.imageFactory.makeImage(uRLSpec);
                    string5 = "" + image.width * 1000.0;
                    string6 = "" + image.height * 1000.0;
                }
                catch (ImageFormatException imageFormatException) {
                    this.session.exception("Cannot parse image file", imageFormatException);
                }
                catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
                    this.session.error("Unknown MIME type: " + unregisteredMIMETypeException.toString());
                }
            }
            if ((string4.equalsIgnoreCase("image/svg") || string4.equalsIgnoreCase("image/svg+xml")) && string2 != null && this.SVGimage.containsKey(string2)) {
                string5 = ((String[])this.SVGimage.get(string2))[0];
                attributesImpl.addAttribute("http://www.renderx.com/XEP/xep", "wunit", "wunit", "CDATA", ((String[])this.SVGimage.get(string2))[1]);
                string6 = ((String[])this.SVGimage.get(string2))[2];
                attributesImpl.addAttribute("http://www.renderx.com/XEP/xep", "hunit", "hunit", "CDATA", ((String[])this.SVGimage.get(string2))[3]);
            }
            if (string4.equalsIgnoreCase("application/xepout") && string2 != null && this.XEPimage.containsKey(string2)) {
                string5 = ((String[])this.XEPimage.get(string2))[0];
                string6 = ((String[])this.XEPimage.get(string2))[1];
            }
            if (attributesImpl.getValue("width") != null) {
                int n3 = attributesImpl.getIndex("width");
                attributesImpl.setValue(n3, string5);
            } else {
                attributesImpl.addAttribute("http://www.renderx.com/XEP/xep", "width", "width", "CDATA", string5);
            }
            if (attributesImpl.getValue("height") != null) {
                int n4 = attributesImpl.getIndex("height");
                attributesImpl.setValue(n4, string6);
            } else {
                attributesImpl.addAttribute("http://www.renderx.com/XEP/xep", "height", "height", "CDATA", string6);
            }
            if (string2 != null) {
                attributesImpl.setQName(n, "id-ref");
                attributesImpl.setLocalName(n, "id-ref");
                attributesImpl.setValue(n, string2);
                return attributesImpl;
            }
            string7 = Integer.toHexString((int)System.currentTimeMillis()) + "_image" + ++this.imageno;
            this.imageIndex.put(string, string7);
            attributesImpl.addAttribute(attributesImpl.getURI(n), "id", "id", "CDATA", string7);
            inputStream = null;
            byteArrayOutputStream = null;
            contentHandler = null;
            xMLReader = null;
            inputSource = null;
            if (!string4.equalsIgnoreCase("application/xepout")) break block39;
            AttributesImpl attributesImpl2 = new AttributesImpl();
            this.xepoutX = this.parseFloat(attributesImpl.getValue("x-from"));
            this.xepoutY = this.parseFloat(attributesImpl.getValue("y-from"));
            this.xepoutScaleX = this.parseFloat(attributesImpl.getValue("scale-x"));
            this.xepoutScaleY = this.parseFloat(attributesImpl.getValue("scale-y"));
            inputStream = uRLSpec.scheme == 1 ? uRLSpec.openStream() : this.session.config.cache.openStream(uRLSpec, this.session);
            try {
                try {
                    int n5;
                    this.stack.push("xepout");
                    contentHandler = new XEPOUTImageHandler(this, string7);
                    xMLReader = XMLReaderFactory.createXMLReader();
                    xMLReader.setContentHandler(contentHandler);
                    inputSource = new InputSource(inputStream);
                    xMLReader.parse(inputSource);
                    if (attributesImpl.getValue("width") != null) {
                        n5 = attributesImpl.getIndex("width");
                        attributesImpl.setValue(n5, ((String[])this.XEPimage.get(string7))[0]);
                    } else {
                        attributesImpl.addAttribute("http://www.renderx.com/XEP/xep", "width", "width", "CDATA", ((String[])this.XEPimage.get(string7))[0]);
                    }
                    if (attributesImpl.getValue("height") != null) {
                        n5 = attributesImpl.getIndex("height");
                        attributesImpl.setValue(n5, ((String[])this.XEPimage.get(string7))[1]);
                    }
                    attributesImpl.addAttribute("http://www.renderx.com/XEP/xep", "height", "height", "CDATA", ((String[])this.XEPimage.get(string7))[1]);
                }
                catch (Exception exception) {
                    this.session.error("XEPOUT image. " + exception.toString());
                    Object var21_31 = null;
                    inputStream.close();
                    return attributesImpl;
                }
                Object var21_30 = null;
            }
            catch (Throwable throwable) {
                Object var21_32 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return attributesImpl;
        }
        if (string4.equalsIgnoreCase("image/svg") || string4.equalsIgnoreCase("image/svg+xml")) {
            int[] nArray = new int[]{31, 139};
            inputStream = uRLSpec.scheme == 1 ? uRLSpec.openStream() : this.session.config.cache.openStream(uRLSpec, this.session);
            boolean bl = false;
            try {
                bl = nArray[0] == inputStream.read() && nArray[1] == inputStream.read();
                Object var23_36 = null;
            }
            catch (Throwable throwable) {
                Object var23_37 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            inputStream = bl ? (uRLSpec.scheme == 1 ? new GZIPInputStream(uRLSpec.openStream()) : new GZIPInputStream(this.session.config.cache.openStream(uRLSpec, this.session))) : (uRLSpec.scheme == 1 ? uRLSpec.openStream() : this.session.config.cache.openStream(uRLSpec, this.session));
            String string8 = string;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    contentHandler = new Serializer(byteArrayOutputStream, false, true, string7);
                    xMLReader = XMLReaderFactory.createXMLReader();
                    xMLReader.setContentHandler(contentHandler);
                    inputSource = new InputSource(inputStream);
                    xMLReader.parse(inputSource);
                    string8 = new String(byteArrayOutputStream.toByteArray());
                    if (attributesImpl.getValue("width") != null) {
                        int n6 = attributesImpl.getIndex("width");
                        attributesImpl.setValue(n6, ((String[])this.SVGimage.get(string7))[0]);
                    } else {
                        attributesImpl.addAttribute("http://www.renderx.com/XEP/xep", "width", "width", "CDATA", ((String[])this.SVGimage.get(string7))[0]);
                    }
                    if (attributesImpl.getValue("height") != null) {
                        int n7 = attributesImpl.getIndex("height");
                        attributesImpl.setValue(n7, ((String[])this.SVGimage.get(string7))[2]);
                    } else {
                        attributesImpl.addAttribute("http://www.renderx.com/XEP/xep", "height", "height", "CDATA", ((String[])this.SVGimage.get(string7))[2]);
                    }
                    attributesImpl.addAttribute("http://www.renderx.com/XEP/xep", "wunit", "wunit", "CDATA", ((String[])this.SVGimage.get(string7))[1]);
                    attributesImpl.addAttribute("http://www.renderx.com/XEP/xep", "hunit", "hunit", "CDATA", ((String[])this.SVGimage.get(string7))[3]);
                    this.imageOK = true;
                }
                catch (Exception exception) {
                    this.imageOK = false;
                    this.session.error("SVG image." + exception.toString());
                }
                byteArrayOutputStream.close();
                Object var25_43 = null;
            }
            catch (Throwable throwable) {
                Object var25_44 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            attributesImpl.setValue(n, string8);
            return attributesImpl;
        }
        if (!this.EMBED_IMAGES) return attributesImpl;
        if (uRLSpec.scheme == 1) return attributesImpl;
        if (string4 == null) {
            string4 = "application/octet-stream";
        }
        inputStream = this.session.config.cache.openStream(uRLSpec, this.session);
        StringWriter stringWriter = new StringWriter();
        try {
            stringWriter.write("data:" + string4 + ";base64,");
            Base64OutputStream base64OutputStream = new Base64OutputStream(stringWriter);
            byte[] byArray = new byte[8192];
            int n8 = 0;
            while (true) {
                if ((n8 = inputStream.read(byArray)) == -1) {
                    ((OutputStream)base64OutputStream).close();
                    Object var27_46 = null;
                    break;
                }
                base64OutputStream.write(byArray, 0, n8);
            }
        }
        catch (Throwable throwable) {
            Object var27_47 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        attributesImpl.setValue(n, stringWriter.toString());
        return attributesImpl;
    }

    private String[] parseLength(String string) throws SAXException {
        if (string == null) {
            throw new SVGParseException("Missing either 'height' or 'width' on root element of SVG image ");
        }
        Length length = new Length(string);
        if (length.len == 0.0) {
            throw new SVGParseException("Zero-sized SVG: either 'height' or 'width' on root element of SVG image has value of '0'");
        }
        if (length.base == 3) {
            throw new SVGParseException("Percentages are not supported in dimensions of a top-level 'svg' element");
        }
        if (length.base == 1) {
            throw new SVGParseException("Em units are not supported in dimensions of a top-level 'svg' element");
        }
        if (length.base == 2) {
            throw new SVGParseException("Ex units are not supported in dimensions of a top-level 'svg' element");
        }
        return new String[]{"" + length.len, length.UNIT};
    }

    static {
        optab.put("EMBED_IMAGES", new Short(0));
        optab.put("GENERATE_FIRST_N_PAGES", new Short(1));
        optab.put("BREAK_PAGES", new Short(2));
        optab.put("PAGE_REORDERING", new Short(3));
        fontStretchAlias = new java.util.Hashtable();
        fontStretchAlias.put("482.0", "ultra-condensed");
        fontStretchAlias.put("579.0", "extra-condensed");
        fontStretchAlias.put("694.0", "condensed");
        fontStretchAlias.put("833.0", "semi-condensed");
        fontStretchAlias.put("1000.0", "normal");
        fontStretchAlias.put("1200.0", "semi-expanded");
        fontStretchAlias.put("1440.0", "expanded");
        fontStretchAlias.put("1728.0", "extra-expanded");
        fontStretchAlias.put("2074.0", "ultra-expanded");
        fontStretchAlias.put("120.0", "wider");
        fontStretchAlias.put("83.3", "narrower");
    }

    public class Lexer {
        public static final String blanks = " \t\r\n\f";
        public static final String token_delimiters = " \t\r\n\f'\"+()[]{},/:;";
        public static final String single_chars = "()[]{},/:;";
        public static final String quotes = "'\"";
        public static final String digits = "0123456789";
        public static final String hexdigits = "0123456789ABCDEFabcdef";
        private char[] data = null;
        private int length = 0;
        private int cursor = 0;

        public Lexer() {
        }

        public Lexer(String string) {
            this();
            this.setSource(string);
        }

        public Lexer(char[] cArray) {
            this();
            this.setSource(cArray);
        }

        public void setSource(String string) {
            this.setSource(string.toCharArray());
        }

        public void setSource(char[] cArray) {
            this.setSource(cArray, 0, cArray.length);
        }

        public void setSource(char[] cArray, int n, int n2) {
            this.data = cArray;
            this.cursor = n;
            this.length = n + n2;
        }

        private void skip_whitespace() {
            while (this.cursor < this.length) {
                if (blanks.indexOf(this.data[this.cursor]) == -1) break;
                ++this.cursor;
            }
        }

        public int nextToken(Token token) throws SVGParseException {
            token.reset();
            this.skip_whitespace();
            if (this.cursor >= this.length) {
                token.type = 1;
                return 1;
            }
            if (single_chars.indexOf(this.data[this.cursor]) != -1) {
                switch (this.data[this.cursor++]) {
                    case '(': {
                        token.type = 2;
                        return 2;
                    }
                    case ')': {
                        token.type = 3;
                        return 3;
                    }
                    case '[': {
                        token.type = 4;
                        return 4;
                    }
                    case ']': {
                        token.type = 5;
                        return 5;
                    }
                    case '{': {
                        token.type = 6;
                        return 6;
                    }
                    case '}': {
                        token.type = 7;
                        return 7;
                    }
                    case ',': {
                        token.type = 8;
                        return 8;
                    }
                    case '/': {
                        token.type = 9;
                        return 9;
                    }
                    case ':': {
                        token.type = 10;
                        return 10;
                    }
                    case ';': {
                        token.type = 11;
                        return 11;
                    }
                }
                throw new SVGParseException("Internal error: unrecognized separator character");
            }
            if (quotes.indexOf(this.data[this.cursor]) != -1) {
                char c = this.data[this.cursor];
                int n = ++this.cursor;
                do {
                    if (this.cursor != this.length) continue;
                    throw new SVGParseException("Unterminated quoted string");
                } while (this.data[this.cursor++] != c);
                token.stringValue = new String(this.data, n, this.cursor - n - 1);
                token.type = 14;
                return 14;
            }
            int n = this.cursor++;
            while (this.cursor < this.length) {
                if (token_delimiters.indexOf(this.data[this.cursor]) != -1) break;
                ++this.cursor;
            }
            if (this.data[n] == '#') {
                if (this.cursor - n == 7 && hexdigits.indexOf(this.data[n + 1]) != -1 && hexdigits.indexOf(this.data[n + 2]) != -1 && hexdigits.indexOf(this.data[n + 3]) != -1 && hexdigits.indexOf(this.data[n + 4]) != -1 && hexdigits.indexOf(this.data[n + 5]) != -1 && hexdigits.indexOf(this.data[n + 6]) != -1) {
                    int n2 = Integer.parseInt(new String(this.data, n + 1, 2), 16);
                    int n3 = Integer.parseInt(new String(this.data, n + 3, 2), 16);
                    int n4 = Integer.parseInt(new String(this.data, n + 5, 2), 16);
                    token.numValue = (n2 << 16) + (n3 << 8) + n4;
                    token.type = 12;
                    return 12;
                }
                if (this.cursor - n == 4 && hexdigits.indexOf(this.data[n + 1]) != -1 && hexdigits.indexOf(this.data[n + 2]) != -1 && hexdigits.indexOf(this.data[n + 3]) != -1) {
                    int n5 = Integer.parseInt(new String(this.data, n + 1, 1), 16) * 17;
                    int n6 = Integer.parseInt(new String(this.data, n + 2, 1), 16) * 17;
                    int n7 = Integer.parseInt(new String(this.data, n + 3, 1), 16) * 17;
                    token.numValue = (n5 << 16) + (n6 << 8) + n7;
                    token.type = 12;
                    return 12;
                }
            }
            int n8 = n;
            int n9 = 1;
            if (this.data[n8] == '-') {
                ++n8;
                n9 = -1;
            } else if (this.data[n8] == '+') {
                ++n8;
            }
            if (n8 < this.cursor && digits.indexOf(this.data[n8]) != -1 || n8 < this.cursor - 1 && this.data[n8] == '.' && digits.indexOf(this.data[n8 + 1]) != -1) {
                int n10;
                boolean bl = false;
                double d = 1.0;
                token.numValue = 0.0;
                while (n8 < this.cursor) {
                    if (digits.indexOf(this.data[n8]) != -1) {
                        n10 = this.data[n8] - 48;
                        if (bl) {
                            token.numValue += (d /= 10.0) * (double)n10;
                        } else {
                            token.numValue *= 10.0;
                            token.numValue += (double)n10;
                        }
                    } else {
                        if (this.data[n8] != '.' || bl) break;
                        bl = true;
                    }
                    ++n8;
                }
                token.numValue *= (double)n9;
                if (n8 < this.cursor && (this.data[n8] == 'e' || this.data[n8] == 'E') && (n8 < this.cursor - 1 && digits.indexOf(this.data[n8 + 1]) != -1 || n8 < this.cursor - 2 && (this.data[n8 + 1] == '+' || this.data[n8 + 1] == '-') && digits.indexOf(this.data[n8 + 2]) != -1)) {
                    n10 = 1;
                    if (this.data[++n8] == '-') {
                        ++n8;
                        n10 = -1;
                    } else if (this.data[n8] == '+') {
                        ++n8;
                    }
                    int n11 = 0;
                    while (n8 < this.cursor && digits.indexOf(this.data[n8]) != -1) {
                        n11 = (int)((double)n11 * 10.0);
                        n11 += this.data[n8] - 48;
                        ++n8;
                    }
                    token.numValue *= Math.pow(10.0, n11 *= n10);
                }
                if (n8 != this.cursor) {
                    token.stringValue = new String(this.data, n8, this.cursor - n8);
                }
                token.type = 15;
                return 15;
            }
            token.stringValue = new String(this.data, n, this.cursor - n);
            token.type = 13;
            return 13;
        }

        public Token getSingleToken(String string) throws SVGParseException {
            Lexer lexer = new Lexer(string);
            Token token = new Token();
            if (lexer.nextToken(token) == 1) {
                throw new SVGParseException("No meaningful data");
            }
            Token token2 = new Token();
            if (lexer.nextToken(token2) != 1) {
                throw new SVGParseException("Extra tokens in \"" + string.trim() + "\"");
            }
            return token;
        }
    }

    public class Token {
        public static final int INVALID_TYPE = Integer.MIN_VALUE;
        public static final int END_OF_DATA = 1;
        public static final int LEFT_PARENTHESIS = 2;
        public static final int RIGHT_PARENTHESIS = 3;
        public static final int LEFT_BRACKET = 4;
        public static final int RIGHT_BRACKET = 5;
        public static final int LEFT_BRACE = 6;
        public static final int RIGHT_BRACE = 7;
        public static final int COMMA = 8;
        public static final int SLASH = 9;
        public static final int COLON = 10;
        public static final int SEMICOLON = 11;
        public static final int COLOR = 12;
        public static final int STRING = 13;
        public static final int QUOTED_STRING = 14;
        public static final int QUANTITY = 15;
        public int type = Integer.MIN_VALUE;
        public double numValue = Double.MIN_VALUE;
        public String stringValue = null;

        public Token() {
        }

        public Token(int n) {
            this.type = n;
        }

        public String getTypeName() {
            switch (this.type) {
                case -2147483648: {
                    return "<INVALID TYPE>";
                }
                case 1: {
                    return "<END OF DATA>";
                }
                case 3: {
                    return "RIGHT PARENTHESIS";
                }
                case 2: {
                    return "LEFT PARENTHESIS";
                }
                case 5: {
                    return "RIGHT BRACKET";
                }
                case 4: {
                    return "LEFT BRACKET";
                }
                case 7: {
                    return "RIGHT BRACE";
                }
                case 6: {
                    return "LEFT BRACE";
                }
                case 8: {
                    return "COMMA";
                }
                case 9: {
                    return "SLASH";
                }
                case 10: {
                    return "COLON";
                }
                case 11: {
                    return "SEMICOLON";
                }
                case 12: {
                    return "COLOR";
                }
                case 13: {
                    return "STRING";
                }
                case 14: {
                    return "QUOTED STRING";
                }
                case 15: {
                    return "QUANTITY";
                }
            }
            return "<BAD TOKEN TYPE - INTERNAL ERROR>";
        }

        public void dump(PrintStream printStream) {
            printStream.print(this.getTypeName());
            switch (this.type) {
                case 13: 
                case 14: {
                    printStream.print(": \"" + this.stringValue + "\"");
                    break;
                }
                case 12: {
                    printStream.print(": #" + Long.toHexString(Math.round(this.numValue)));
                    break;
                }
                case 15: {
                    printStream.print(": " + this.numValue + (this.stringValue == null ? "" : this.stringValue));
                }
            }
            printStream.println();
        }

        public void reset() {
            this.numValue = Double.MIN_VALUE;
            this.stringValue = null;
        }
    }

    public class Length {
        public static final int ABSOLUTE = 0;
        public static final int RELATIVE_EM = 1;
        public static final int RELATIVE_EX = 2;
        public static final int RELATIVE_PERCENTS = 3;
        public static final int RELATIVE_PC = 4;
        public String UNIT;
        public double len = 0.0;
        public int base = 0;

        public Length() {
        }

        public Length(String string) throws SVGParseException {
            this.parse(string);
        }

        public String toString() {
            switch (this.base) {
                case 0: {
                    return String.valueOf(this.len) + "pt";
                }
                case 1: {
                    return String.valueOf(this.len) + "em";
                }
                case 2: {
                    return String.valueOf(this.len) + "ex";
                }
                case 3: {
                    return String.valueOf(this.len * 100.0) + "%";
                }
                case 4: {
                    return String.valueOf(this.len) + "pc";
                }
            }
            return "<ERROR! INCORRECT BASE FOR LENGTH>";
        }

        public String getTypeName() {
            return "Length";
        }

        public void create(Token token) throws SVGParseException {
            if (token.type == 15) {
                this.len = token.numValue;
                this.UNIT = token.stringValue;
                if (token.stringValue == null || token.stringValue.equals("px")) {
                    this.UNIT = "";
                } else if (token.stringValue.equals("em")) {
                    this.base = 1;
                } else if (token.stringValue.equals("ex")) {
                    this.base = 2;
                } else if (token.stringValue.equals("%")) {
                    this.base = 3;
                    this.len /= 100.0;
                } else if (token.stringValue.equals("pc")) {
                    this.base = 4;
                }
            } else {
                throw new SVGParseException("Data type mismatch: found " + token.getTypeName() + " where length is expected");
            }
        }

        public void parse(String string) throws SVGParseException {
            Lexer lexer = new Lexer();
            this.create(lexer.getSingleToken(string));
        }
    }

    public class XEPOUTImageParseException
    extends SAXException {
        public XEPOUTImageParseException() {
            super("");
        }

        public XEPOUTImageParseException(String string) {
            super(string);
        }
    }

    public class SVGParseException
    extends SAXException {
        public SVGParseException() {
            super("");
        }

        public SVGParseException(String string) {
            super(string);
        }
    }

    public class SVGIOException
    extends RuntimeException {
        public SVGIOException() {
        }

        public SVGIOException(Exception exception) {
            super(exception.toString());
        }

        public SVGIOException(String string) {
            super(string);
        }
    }

    public class Serializer
    implements ContentHandler {
        protected final Writer out;
        private String topURI = null;
        private Hashtable uritab = new Hashtable();
        private Hashtable prefixtab = new Hashtable();
        private boolean hasUTF8 = true;
        private boolean opentag = true;
        private boolean closeOnExit = false;
        private boolean breakpage = false;
        private boolean inlineImage = false;
        private boolean root = true;
        private String id;
        private Stack elementNames = new Stack();
        private int prefIndex = 0;
        private String[] prefixCharacters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        private int indent = 2;

        public Serializer(OutputStream outputStream, boolean bl, boolean bl2, String string) throws IOException {
            OutputStreamWriter outputStreamWriter;
            this.breakpage = bl;
            this.inlineImage = bl2;
            this.id = string;
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
                this.hasUTF8 = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                outputStreamWriter = new OutputStreamWriter(outputStream);
                this.hasUTF8 = false;
            }
            this.out = outputStreamWriter;
        }

        protected void closeTag() throws IOException {
            if (this.opentag) {
                this.out.write(">");
                this.opentag = false;
            }
            this.out.flush();
        }

        public void startDocument() throws SAXException {
            this.opentag = false;
            this.elementNames.clear();
            this.topURI = null;
            if (this.breakpage) {
                try {
                    this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    this.out.write("<svg:svg xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ");
                    this.out.write("width=\"" + H4SVG.this.currentW + "pt\" height=\"" + H4SVG.this.currentPageH + "pt\">\n\t");
                    this.out.write("<svg:defs>");
                    this.out.flush();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }

        public void endDocument() throws SAXException {
            try {
                this.closeTag();
                this.out.flush();
                if (this.breakpage) {
                    this.out.write("\n\t</svg:defs>");
                    this.out.write("\n\t<svg:svg overflow=\"visible\" x=\"0\" y=\"" + H4SVG.this.currentPageH + "pt\">");
                    this.out.write("\n\t\t<svg:use xlink:href=\"#page" + H4SVG.this.pageID + "\" transform=\" scale(1.0,-1.0)\"/>");
                    this.out.write("\n\t</svg:svg>");
                    this.out.write("\n</svg:svg>");
                    this.out.flush();
                }
                if (this.closeOnExit) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            try {
                this.closeTag();
                this.out.write("<?");
                this.out.write(string);
                if (string2 != null && string2.length() > 0) {
                    this.out.write(32);
                    this.out.write(string2);
                }
                this.out.write("?>");
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            try {
                this.closeTag();
                this.writePCDATA(cArray, n, n2);
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.characters(cArray, n, n2);
        }

        public void skippedEntity(String string) {
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string2.equalsIgnoreCase("svg") && this.inlineImage && this.root) {
                String string4;
                String string5;
                if (!H4SVG.SVGURI.equalsIgnoreCase(string)) {
                    throw new SAXException("Root element in an SVG image is not in the SVG namespace (http://www.w3.org/2000/svg)");
                }
                if (!"svg".equalsIgnoreCase(string2)) {
                    throw new SAXException("Root element is not 'svg' in SVG image ");
                }
                String string6 = "0";
                String string7 = "0";
                boolean bl = false;
                boolean bl2 = false;
                try {
                    String[] stringArray = H4SVG.this.parseLength(attributes.getValue("", "width"));
                    String[] stringArray2 = H4SVG.this.parseLength(attributes.getValue("", "height"));
                    string6 = stringArray[0];
                    string5 = stringArray[1];
                    string7 = stringArray2[0];
                    string4 = stringArray2[1];
                    bl = true;
                }
                catch (SVGParseException sVGParseException) {
                    String string8 = attributes.getValue("", "viewBox");
                    if (string8 == null) {
                        throw sVGParseException;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string8, ", \t\n\r");
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new SVGParseException("Invalid viewBox attribute: no data");
                    }
                    double d = (H4SVG)H4SVG.this.new Length((String)stringTokenizer.nextToken()).len;
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new SVGParseException("Invalid viewBox attribute: required 4 numbers, only 1 found");
                    }
                    double d2 = (H4SVG)H4SVG.this.new Length((String)stringTokenizer.nextToken()).len;
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new SVGParseException("Invalid viewBox attribute: required 4 numbers, only 2 found");
                    }
                    Length length = new Length(stringTokenizer.nextToken());
                    string6 = "" + length.len;
                    string5 = "px";
                    if (string6.equals("0")) {
                        throw new SVGParseException("Invalid viewBox attribute: width is 0");
                    }
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new SVGParseException("Invalid viewBox attribute: required 4 numbers, only 3 found");
                    }
                    length = new Length(stringTokenizer.nextToken());
                    string7 = "" + length.len;
                    string4 = "px";
                    if (string7.equals("0")) {
                        throw new SVGParseException("Invalid viewBox attribute: height is 0");
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        throw new SVGParseException("Invalid viewBox attribute: extra data after 4 numbers");
                    }
                    bl2 = true;
                }
                H4SVG.this.SVGimage.put(this.id, new String[]{"" + H4SVG.this.parseFloat(string6) * 1000.0f, string5, "" + H4SVG.this.parseFloat(string7) * 1000.0f, string4});
                AttributesImpl attributesImpl = new AttributesImpl(attributes);
                if (!bl && bl2) {
                    attributesImpl.removeAttribute(attributesImpl.getIndex("viewBox"));
                    if (attributesImpl.getIndex("height") == -1) {
                        attributesImpl.addAttribute("", "height", "height", "CDATA", string7 + "px");
                    } else {
                        attributesImpl.setValue(attributesImpl.getIndex("height"), string7 + "px");
                    }
                    if (attributesImpl.getIndex("width") == -1) {
                        attributesImpl.addAttribute("", "width", "width", "CDATA", string6 + "px");
                    } else {
                        attributesImpl.setValue(attributesImpl.getIndex("width"), string6 + "px");
                    }
                }
                if (attributesImpl.getValue("id") != null) {
                    attributesImpl.setValue(attributesImpl.getIndex("id"), this.id);
                } else {
                    attributesImpl.addAttribute("", "id", "id", "CDATA", this.id);
                }
                this.root = false;
                this.startElement(H4SVG.SVGURI, "svg", "svg:svg", attributesImpl);
                attributesImpl.clear();
                return;
            }
            this.ignorableWhitespace("\n".toCharArray(), 0, 1);
            int n = 0;
            while (n < this.indent) {
                this.ignorableWhitespace("\t".toCharArray(), 0, 1);
                ++n;
            }
            ++this.indent;
            String string9 = null;
            if (string2 != null) {
                if (string == null || string.length() == 0) {
                    string3 = string2;
                } else {
                    string9 = (String)this.uritab.get(string);
                    if (string9 == null) {
                        string9 = string.equals("http://www.w3.org/XML/1998/namespace") ? "xml" : this.assignPrefix(string, string3);
                    }
                    string3 = string9 + ":" + string2;
                }
            }
            this.elementNames.push(string3);
            try {
                this.closeTag();
                this.out.write("<");
                this.writeMarkupElement(string3);
                if (string2 != null && string != null && string.length() != 0 && !string.equals("http://www.w3.org/XML/1998/namespace") && !string.equals(this.topURI)) {
                    this.out.write(" xmlns:");
                    this.writeMarkupElement(string9);
                    this.out.write("=\"");
                    this.writeMarkupElement(string);
                    this.out.write("\"");
                    if (this.topURI == null) {
                        this.topURI = string;
                    }
                }
                if (attributes != null) {
                    Hashtable hashtable = new Hashtable();
                    int n2 = attributes.getLength();
                    int n3 = 0;
                    while (n3 < n2) {
                        String string10 = attributes.getLocalName(n3);
                        String string11 = attributes.getURI(n3);
                        String string12 = attributes.getQName(n3);
                        if (string10 != null) {
                            if (string11 == null || string11.length() == 0) {
                                string12 = string10;
                            } else {
                                string9 = (String)this.uritab.get(string11);
                                if (string9 == null) {
                                    string9 = string11.equals("http://www.w3.org/XML/1998/namespace") ? "xml" : this.assignPrefix(string11, string12);
                                }
                                string12 = string9 + ":" + string10;
                                if (!(hashtable.containsKey(string11) || string11.equals(string) || string11.equals(this.topURI) || string11.equals("http://www.w3.org/XML/1998/namespace"))) {
                                    this.out.write(" xmlns:");
                                    this.writeMarkupElement(string9);
                                    this.out.write("=\"");
                                    this.writeMarkupElement(string11);
                                    this.out.write("\"");
                                    hashtable.put(string11, string9);
                                }
                            }
                        }
                        this.out.write(" ");
                        this.writeMarkupElement(string12);
                        this.out.write("=\"");
                        this.writeMarkupElement(attributes.getValue(n3));
                        this.out.write("\"");
                        ++n3;
                    }
                }
                this.opentag = true;
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            --this.indent;
            this.ignorableWhitespace("\n".toCharArray(), 0, 1);
            int n = 0;
            while (n < this.indent) {
                this.ignorableWhitespace("\t".toCharArray(), 0, 1);
                ++n;
            }
            String string4 = (String)this.elementNames.pop();
            if (string2 != null) {
                if (string == null || string.length() == 0) {
                    string3 = string2;
                } else {
                    String string5 = (String)this.uritab.get(string);
                    if (string5 == null) {
                        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
                            string5 = "xml";
                        } else {
                            throw new SAXException("Namespace '" + string + "' first mentioned on the closing tag '" + string2 + "'");
                        }
                    }
                    string3 = string5 + ":" + string2;
                }
            }
            if (!string3.equals(string4)) {
                throw new SAXException("Open tag '" + string4 + "' does not match closing tag '" + string3 + "'");
            }
            try {
                if (this.opentag) {
                    this.out.write("/>");
                    this.opentag = false;
                } else {
                    this.out.write("</");
                    this.writeMarkupElement(string4);
                    this.out.write(">");
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        protected void writeNormalized(char[] cArray, int n, int n2, boolean bl) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n + n3];
                switch (c) {
                    case '<': {
                        this.out.write("&lt;");
                        break;
                    }
                    case '>': {
                        this.out.write("&gt;");
                        break;
                    }
                    case '&': {
                        this.out.write("&amp;");
                        break;
                    }
                    case '\"': {
                        if (bl) {
                            this.out.write("&quot;");
                            break;
                        }
                    }
                    case '\'': {
                        if (bl) {
                            this.out.write("&apos;");
                            break;
                        }
                    }
                    case '\n': {
                        if (bl) {
                            this.out.write("&#xA;");
                            break;
                        }
                    }
                    case '\t': {
                        if (bl) {
                            this.out.write("&#x9;");
                            break;
                        }
                    }
                    default: {
                        if (!(this.hasUTF8 || c <= '\u007f' && c >= '\u0000')) {
                            this.out.write("&#" + c + ";");
                            break;
                        }
                        this.out.write(c);
                    }
                }
                ++n3;
            }
            this.out.flush();
        }

        protected void writeMarkupElement(String string) throws IOException {
            this.writeNormalized(string.toCharArray(), 0, string.length(), true);
        }

        protected void writePCDATA(char[] cArray, int n, int n2) throws IOException {
            this.writeNormalized(cArray, n, n2, false);
        }

        protected String assignPrefix(String string, String string2) throws SAXException {
            String string3 = null;
            if (string2 != null && string2.indexOf(58) != -1 && this.prefixtab.containsKey(string3 = string2.substring(0, string2.indexOf(58)))) {
                string3 = null;
            }
            if (string3 == null) {
                int n = this.prefixCharacters.length;
                while (this.prefIndex < Integer.MAX_VALUE) {
                    int n2 = ++this.prefIndex;
                    string3 = "";
                    while (n2 != 0) {
                        int n3 = n2 % n;
                        n2 = (n2 - n3) / n;
                        string3 = string3 + this.prefixCharacters[n3];
                    }
                    if (!string3.equals("xml") && !this.prefixtab.containsKey(string3)) break;
                }
                if (this.prefIndex == Integer.MAX_VALUE) {
                    throw new SAXException("Cannot assign more than 2147483645 different prefixes");
                }
            }
            this.uritab.put(string, string3);
            this.prefixtab.put(string3, string);
            return string3;
        }
    }

    public class XEPOUTImageHandler
    implements ContentHandler {
        private ContentHandler ch = null;
        private String id;
        private int page = 0;

        public XEPOUTImageHandler(ContentHandler contentHandler, String string) {
            this.ch = contentHandler;
            this.id = string;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void skippedEntity(String string) {
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string.equalsIgnoreCase("http://www.renderx.com/XEP/xep")) {
                throw new SAXException("Element in an XEPOUT image is not in the XEP namespace (http://www.renderx.com/XEP/xep)");
            }
            if (string2.equalsIgnoreCase("document")) {
                return;
            }
            if (this.page > 1) {
                return;
            }
            if (string2.equalsIgnoreCase("page") && this.page <= 1) {
                H4SVG.this.XEPOUTImageStart = true;
                if (attributes.getValue("height") == null) {
                    throw new XEPOUTImageParseException("Attribute 'height' is null.");
                }
                H4SVG.this.xepoutH = H4SVG.this.parseFloat(attributes.getValue("height"));
                if (attributes.getValue("width") == null) {
                    throw new XEPOUTImageParseException("Attribute 'width' is null.");
                }
                H4SVG.this.xepoutW = H4SVG.this.parseFloat(attributes.getValue("width"));
                H4SVG.this.XEPimage.put(this.id, new String[]{"" + H4SVG.this.xepoutW, "" + H4SVG.this.xepoutH});
                AttributesImpl attributesImpl = new AttributesImpl();
                if (this.ch != null) {
                    attributesImpl.addAttribute("", "e", "e", "CDATA", "" + H4SVG.this.xepoutX / 1000.0f);
                    attributesImpl.addAttribute("", "f", "f", "CDATA", "" + H4SVG.this.xepoutY / 1000.0f);
                    attributesImpl.addAttribute("", "a", "a", "CDATA", "" + H4SVG.this.xepoutScaleX);
                    attributesImpl.addAttribute("", "d", "d", "CDATA", "" + H4SVG.this.xepoutScaleY);
                    attributesImpl.addAttribute("", "b", "b", "CDATA", "0");
                    attributesImpl.addAttribute("", "c", "c", "CDATA", "0");
                    this.ch.startElement("http://www.renderx.com/XEP/xep", "transform", "http://www.renderx.com/XEP/xep:transform", attributesImpl);
                    this.ch.endElement("http://www.renderx.com/XEP/xep", "transform", "http://www.renderx.com/XEP/xep:transform");
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "id", "id", "CDATA", this.id);
                    attributesImpl.addAttribute("", "width", "width", "CDATA", "" + H4SVG.this.xepoutW);
                    attributesImpl.addAttribute("", "height", "height", "CDATA", "" + H4SVG.this.xepoutH);
                    this.ch.startElement("http://www.renderx.com/XEP/xep", "rotate", "http://www.renderx.com/XEP/xep:rotate", attributesImpl);
                    this.ch.endElement("http://www.renderx.com/XEP/xep", "rotate", "http://www.renderx.com/XEP/xep:rotate");
                }
                ++this.page;
                return;
            }
            if (this.ch != null) {
                this.ch.startElement("http://www.renderx.com/XEP/xep", string2, "http://www.renderx.com/XEP/xep:" + string2, attributes);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string.equalsIgnoreCase("http://www.renderx.com/XEP/xep")) {
                throw new SAXException("Element in a XEPOUT image is not in the XEP namespace (http://www.renderx.com/XEP/xep)");
            }
            if (string2.equalsIgnoreCase("document")) {
                return;
            }
            if (string2.equalsIgnoreCase("page")) {
                ++this.page;
                return;
            }
            if (this.page > 1) {
                return;
            }
            if (this.ch != null) {
                this.ch.endElement("http://www.renderx.com/XEP/xep", string2, "http://www.renderx.com/XEP/xep:" + string2);
                return;
            }
        }
    }
}

