/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.crypto.Hex;
import com.renderx.crypto.MD5;
import com.renderx.fonts.FontCatalog;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.InvalidImageClassException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.MIMEType;
import com.renderx.util.MIMETypeParseException;
import com.renderx.util.Magic;
import com.renderx.util.SeekableInput;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import com.renderx.util.User;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ImageFactory {
    public URLSpec brokenimage = null;
    private Hashtable imageClasses = new Hashtable();
    private Hashtable namespaces = new Hashtable();
    private int fileno = 0;
    private final List filelist = new List();
    private File dir = null;
    private int image_memoize_threshold = 0;
    private boolean paranoid_cache = false;
    private MD5 cipher = new MD5();
    public final ErrorHandler errHandler;
    public final FontCatalog fontCatalog;
    public final URLCache cache;
    protected Hashtable imageCache = new Hashtable();
    protected Hashtable ehcaCegami = new Hashtable();
    static /* synthetic */ Class class$com$renderx$graphics$Image;

    private synchronized int nextfileno() {
        return this.fileno++;
    }

    private String hsh(Object object) {
        MD5 mD5 = this.cipher;
        synchronized (mD5) {
            String string = Hex.toString(this.cipher.digest(object.toString().getBytes()));
            return string;
        }
    }

    public ImageFactory(FontCatalog fontCatalog, URLCache uRLCache, ErrorHandler errorHandler) {
        this.fontCatalog = fontCatalog;
        this.cache = uRLCache;
        this.errHandler = errorHandler;
        String string = User.getProperty("com.renderx.graphics.formats");
        if (string == null) {
            string = "resource:com/renderx/graphics/formats.xml";
        }
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(new Config());
            xMLReader.parse(new InputSource(string));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException("error initializing ImageFactory:" + exception.toString());
        }
        Magic.init();
    }

    public ImageFactory(FontCatalog fontCatalog, URLCache uRLCache, ErrorHandler errorHandler, File file, int n) {
        this(fontCatalog, uRLCache, errorHandler, file);
        this.image_memoize_threshold = n;
    }

    public ImageFactory(FontCatalog fontCatalog, URLCache uRLCache, ErrorHandler errorHandler, File file, int n, boolean bl) {
        this(fontCatalog, uRLCache, errorHandler, file, n);
        this.paranoid_cache = bl;
    }

    public ImageFactory(FontCatalog fontCatalog, URLCache uRLCache, ErrorHandler errorHandler, File file) {
        this(fontCatalog, uRLCache, errorHandler);
        this.dir = file;
    }

    private void registerImageClass(MIMEType mIMEType, Class clazz) throws InvalidImageClassException {
        if (!(class$com$renderx$graphics$Image == null ? (class$com$renderx$graphics$Image = ImageFactory.class$("com.renderx.graphics.Image")) : class$com$renderx$graphics$Image).isAssignableFrom(clazz)) {
            throw new InvalidImageClassException(clazz);
        }
        this.imageClasses.put(mIMEType, clazz);
    }

    private Class getImageClass(MIMEType mIMEType) {
        Enumeration enumeration = this.imageClasses.keys();
        while (enumeration.hasMoreElements()) {
            MIMEType mIMEType2 = (MIMEType)enumeration.nextElement();
            if (!mIMEType.matches(mIMEType2)) continue;
            return (Class)this.imageClasses.get(mIMEType2);
        }
        return null;
    }

    protected Image fromCache(URLSpec uRLSpec) {
        String string = this.dir == null || uRLSpec.scheme != 1 ? ImageFactory.makeCacheKey(uRLSpec) : this.hsh(ImageFactory.makeCacheKey(uRLSpec));
        return this.fromCache(string);
    }

    protected Image fromCache(String string) {
        Object object = this.imageCache.get(string);
        return object == null ? null : (Image)((Object[])object)[0];
    }

    public String getKey(Image image) {
        return (String)((Object[])this.ehcaCegami.get(image))[0];
    }

    public URLSpec getSource(Image image) {
        if (image.source != null) {
            return image.source;
        }
        File file = (File)((Object[])this.ehcaCegami.get(image))[1];
        URLSpec uRLSpec = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            uRLSpec = (URLSpec)objectInputStream.readObject();
            objectInputStream.close();
            if (image.hasbeenseen < this.image_memoize_threshold) {
                ++image.hasbeenseen;
            } else {
                image.source = uRLSpec;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failure restoring image source from file: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Failure casting restored image source: " + classNotFoundException);
        }
        return uRLSpec;
    }

    protected void toCache(URLSpec uRLSpec, Image image) {
        String string = ImageFactory.makeCacheKey(uRLSpec);
        String string2 = null;
        if (this.dir == null || this.image_memoize_threshold < 1 || uRLSpec.scheme != 1) {
            Hashtable hashtable = this.imageCache;
            synchronized (hashtable) {
                this.imageCache.put(string, new Object[]{image, null});
            }
            Hashtable hashtable2 = this.ehcaCegami;
            synchronized (hashtable2) {
                this.ehcaCegami.put(image, new Object[]{string, null});
            }
        }
        string2 = this.hsh(string);
        File file = this.getTempFile();
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                objectOutputStream.writeObject(uRLSpec);
                objectOutputStream.close();
                image.source = null;
                Hashtable hashtable = this.imageCache;
                synchronized (hashtable) {
                    this.imageCache.put(string2, new Object[]{image, file});
                }
                Hashtable hashtable3 = this.ehcaCegami;
                synchronized (hashtable3) {
                    this.ehcaCegami.put(image, new Object[]{string2, file});
                }
                Object var11_16 = null;
                if (file != null) {
                    this.markFile(file);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (file != null) {
                this.markFile(file);
            }
            throw throwable;
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.cleanup();
    }

    protected File getTempFile(String string) {
        File file;
        if (this.dir == null) {
            return null;
        }
        while ((file = new File(this.dir, "" + this.nextfileno() + string)).exists()) {
        }
        return file;
    }

    protected void markFile(File file) {
        if (file == null) {
            return;
        }
        List list = this.filelist;
        synchronized (list) {
            this.filelist.append(file);
        }
    }

    public void cleanup() {
        Hashtable hashtable = this.imageCache;
        synchronized (hashtable) {
            this.imageCache.clear();
        }
        Hashtable hashtable2 = this.ehcaCegami;
        synchronized (hashtable2) {
            this.ehcaCegami.clear();
        }
        List list = this.filelist;
        synchronized (list) {
            Enumeration enumeration = this.filelist.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                file.delete();
            }
            this.filelist.clear();
        }
    }

    protected File getTempFile() {
        return this.getTempFile("." + this.hashCode() + ".com.renderx.graphics.ImageFactory.tmp");
    }

    public void clearCache() {
        this.cleanup();
    }

    private static final String makeCacheKey(URLSpec uRLSpec) {
        URLSpec uRLSpec2;
        if (uRLSpec.scheme == 1 && (uRLSpec2 = uRLSpec.getBase()) != null) {
            return uRLSpec2.toString() + " <!&!> " + uRLSpec.toString();
        }
        return uRLSpec.toString();
    }

    public Image makeImage(URLSpec uRLSpec) throws IOException, ImageFormatException, UnregisteredMIMETypeException {
        return this.makeImage(uRLSpec, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image makeImage(URLSpec uRLSpec, String string) throws IOException, ImageFormatException, UnregisteredMIMETypeException {
        Serializable serializable;
        Object object;
        Image image = this.fromCache(uRLSpec);
        if (string == null) {
            if (image != null) {
                return image;
            }
            string = this.cache.getContentType(uRLSpec, this.errHandler);
            if (string == null) {
                object = this.openSeekableStream(uRLSpec);
                try {
                    try {
                        string = Magic.MIME(uRLSpec.toString(), (SeekableInput)object);
                    }
                    catch (Magic.UnknownMIMETypeException unknownMIMETypeException) {
                        throw new ImageFormatException(unknownMIMETypeException.toString());
                    }
                    serializable = null;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    object.close();
                    throw throwable;
                }
                object.close();
            }
        }
        object = null;
        try {
            object = new MIMEType(string);
        }
        catch (MIMETypeParseException mIMETypeParseException) {
            throw new UnregisteredMIMETypeException(string, mIMETypeParseException.getMessage());
        }
        long l = 0L;
        try {
            if (this.paranoid_cache && uRLSpec.scheme != 1 && image.lastModified != (l = this.cache.getLastModified(uRLSpec, this.errHandler))) {
                this.errHandler.info("The image '" + uRLSpec + "' has changed, cached copy updated.");
                serializable = this.imageCache;
                synchronized (serializable) {
                    this.imageCache.remove(ImageFactory.makeCacheKey(uRLSpec));
                }
                Hashtable hashtable = this.ehcaCegami;
                synchronized (hashtable) {
                    this.ehcaCegami.remove(image);
                }
                image = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (image != null && image.mimetype.equals(((MIMEType)object).toString())) {
            return image;
        }
        serializable = this.getImageClass((MIMEType)object);
        if (serializable == null) {
            throw new UnregisteredMIMETypeException(string);
        }
        try {
            image = (Image)serializable.newInstance();
        }
        catch (InstantiationException hashtable) {
            hashtable.printStackTrace();
            throw new RuntimeException(hashtable.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new RuntimeException(illegalAccessException.getMessage());
        }
        image.factory = this;
        image.source = uRLSpec;
        image.mimetype = ((MIMEType)object).toString();
        image.lastModified = l > 0L ? l : 0L;
        image.parse();
        this.toCache(uRLSpec, image);
        return image;
    }

    InputStream openStream(URLSpec uRLSpec) throws IOException {
        return this.cache.openStream(uRLSpec, this.errHandler);
    }

    SeekableInput openSeekableStream(URLSpec uRLSpec) throws IOException {
        return this.cache.openSeekableStream(uRLSpec, this.errHandler);
    }

    public static void main(String[] stringArray) throws Exception {
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        URLCache uRLCache = new URLCache(defaultErrorHandler);
        ImageFactory imageFactory = new ImageFactory(new FontCatalog(uRLCache, defaultErrorHandler), uRLCache, defaultErrorHandler);
        if (stringArray.length == 2) {
            System.out.println(imageFactory.makeImage(new URLSpec(stringArray[0]), stringArray[1]));
        } else {
            System.err.println("Usage: com.renderx.graphics.ImageFactory  <image file name> <mime-type>");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Config
    extends DefaultHandler {
        private static final String NSURI = "http://www.renderx.com/graphics/formats";

        private Config() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("".equals(string) || NSURI.equals(string)) {
                if ("format".equals(string2)) {
                    this.registerFormat(attributes);
                } else if ("namespace".equals(string2)) {
                    this.registerNamespace(attributes);
                }
            }
        }

        private void registerFormat(Attributes attributes) {
            String string = attributes.getValue("mime-type");
            if (string == null) {
                this.printError("'format' descriptor has no 'mime-type' attribute.");
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) {
                this.printError("'format' descriptor has an empty 'mime-type' attribute.");
                return;
            }
            String string2 = attributes.getValue("parser");
            if (string2 == null) {
                this.printError("'format' descriptor for MIME type '" + string + "' has no 'parser' attribute.");
                return;
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string2.trim());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.printError("cannot find image parser class " + string2.trim() + " for MIME type '" + string + "'");
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                MIMEType mIMEType = null;
                try {
                    mIMEType = new MIMEType(string3);
                }
                catch (MIMETypeParseException mIMETypeParseException) {
                    this.printError("invalid MIME type specifier '" + string3 + "': " + mIMETypeParseException.getMessage());
                    continue;
                }
                try {
                    ImageFactory.this.registerImageClass(mIMEType, clazz);
                }
                catch (InvalidImageClassException invalidImageClassException) {
                    this.printError("invalid image parser class " + clazz.getName() + " for MIME type '" + string + "'");
                    return;
                }
            }
        }

        private void registerNamespace(Attributes attributes) {
            String string = attributes.getValue("uri");
            if (string == null) {
                this.printError("'namespace' descriptor has no 'uri' attribute.");
                return;
            }
            String string2 = attributes.getValue("mime-type");
            if (string2 == null) {
                this.printError("'namespace' descriptor has no 'mime-type' attribute.");
                return;
            }
            if (string2.trim().length() == 0) {
                this.printError("'namespace' descriptor has an empty 'mime-type' attribute.");
                return;
            }
            MIMEType mIMEType = null;
            try {
                mIMEType = new MIMEType(string2);
            }
            catch (MIMETypeParseException mIMETypeParseException) {
                this.printError("invalid MIME type specifier '" + string2 + "': " + mIMETypeParseException.getMessage());
                return;
            }
            ImageFactory.this.namespaces.put(string, mIMEType);
        }

        private void printError(String string) {
            if (ImageFactory.this.errHandler != null) {
                ImageFactory.this.errHandler.error("Error in image factory configuration file: " + string);
            }
        }
    }
}

