/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.graphics.TIFFImage;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.VectorImage;
import com.renderx.util.SeekableInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class EPSImage
extends VectorImage {
    private boolean hasBinaryHeader = false;
    public long psOffset = 0L;
    public long psLength = 0L;
    public long wmfOffset = 0L;
    public long wmfLength = 0L;
    public long tiffOffset = 0L;
    public long tiffLength = 0L;
    public double[] boundingBox = null;
    public double[] hiResBoundingBox = null;

    public EPSImage() {
        this.mimetype = "application/postscript";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse() throws IOException, ImageFormatException {
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            block12: {
                boolean bl = this.hasBinaryHeader = seekableInput.readUnsignedByte() == 197 && seekableInput.readUnsignedByte() == 208 && seekableInput.readUnsignedByte() == 211 && seekableInput.readUnsignedByte() == 198;
                if (this.hasBinaryHeader) {
                    this.psOffset = this.readUnsignedInt(seekableInput);
                    this.psLength = this.readUnsignedInt(seekableInput);
                    this.wmfOffset = this.readUnsignedInt(seekableInput);
                    this.wmfLength = this.readUnsignedInt(seekableInput);
                    this.tiffOffset = this.readUnsignedInt(seekableInput);
                    this.tiffLength = this.readUnsignedInt(seekableInput);
                    if (this.tiffOffset > 0L) {
                        this.hasBitmapPreview = true;
                    }
                } else {
                    this.psOffset = 0L;
                    this.psLength = seekableInput.length();
                }
                seekableInput.seek(this.psOffset);
                String string = seekableInput.readLine();
                if (!string.startsWith("%!PS-Adobe")) {
                    throw new ImageFormatException("invalid EPSF file " + this.toDisplayString() + ": PostScript header comment not found");
                }
                while ((string = seekableInput.readLine()) != null) {
                    String string2;
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    if (!string.startsWith("%") || (string2 = stringTokenizer.nextToken()).equals("%%EndComments") || string2.equals("%")) break;
                    if (string2.equals("%%BoundingBox:")) {
                        this.boundingBox = new double[4];
                        this.boundingBox[0] = Double.valueOf(stringTokenizer.nextToken());
                        this.boundingBox[1] = Double.valueOf(stringTokenizer.nextToken());
                        this.boundingBox[2] = Double.valueOf(stringTokenizer.nextToken());
                        this.boundingBox[3] = Double.valueOf(stringTokenizer.nextToken());
                        continue;
                    }
                    if (!string2.equals("%%HiResBoundingBox:")) continue;
                    this.hiResBoundingBox = new double[4];
                    this.hiResBoundingBox[0] = Double.valueOf(stringTokenizer.nextToken());
                    this.hiResBoundingBox[1] = Double.valueOf(stringTokenizer.nextToken());
                    this.hiResBoundingBox[2] = Double.valueOf(stringTokenizer.nextToken());
                    this.hiResBoundingBox[3] = Double.valueOf(stringTokenizer.nextToken());
                }
                if (this.hiResBoundingBox != null) {
                    this.width = this.hiResBoundingBox[2] - this.hiResBoundingBox[0];
                    this.height = this.hiResBoundingBox[3] - this.hiResBoundingBox[1];
                } else {
                    if (this.boundingBox == null) throw new ImageFormatException("invalid EPSF file " + this.toDisplayString() + ": '%%BoundingBox:' DSC comment not found");
                    this.width = this.boundingBox[2] - this.boundingBox[0];
                    this.height = this.boundingBox[3] - this.boundingBox[1];
                }
                if (!this.hasBitmapPreview) {
                    seekableInput.seek(this.psOffset);
                    do {
                        if ((string = seekableInput.readLine()) != null) continue;
                        break block12;
                    } while (!string.startsWith("%%BeginPreview:"));
                    this.hasBitmapPreview = true;
                }
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
    }

    private long readUnsignedInt(SeekableInput seekableInput) throws IOException {
        byte[] byArray = new byte[4];
        seekableInput.readFully(byArray);
        long l = 0L;
        int n = 3;
        while (n >= 0) {
            l <<= 8;
            l += (long)(0xFF & byArray[n]);
            --n;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BitmapImage getBitmapPreview() throws ImageFormatException, IOException {
        SeekableInput seekableInput;
        block9: {
            EPSIPreview ePSIPreview;
            block8: {
                TIFFImage tIFFImage;
                block7: {
                    seekableInput = this.openSeekableImageStream();
                    try {
                        try {
                            if (this.tiffOffset > 0L) {
                                TIFFImage tIFFImage2 = new TIFFImage(this.factory.makeImage(this.source), this.tiffOffset);
                                tIFFImage2.parse();
                                tIFFImage2.horzResolution *= tIFFImage2.width / this.width;
                                tIFFImage2.vertResolution *= tIFFImage2.height / this.height;
                                tIFFImage2.width = this.width;
                                tIFFImage2.height = this.height;
                                tIFFImage = tIFFImage2;
                                Object var7_7 = null;
                                break block7;
                            }
                            seekableInput.seek(this.psOffset);
                            String string = null;
                            while ((string = seekableInput.readLine()) != null) {
                                if (!string.startsWith("%%BeginPreview:")) continue;
                                StringTokenizer stringTokenizer = new StringTokenizer(string);
                                stringTokenizer.nextToken();
                                EPSIPreview ePSIPreview2 = new EPSIPreview();
                                ePSIPreview2.pxWidth = new Integer(stringTokenizer.nextToken());
                                ePSIPreview2.pxHeight = new Integer(stringTokenizer.nextToken());
                                ePSIPreview2.bitsPerComponent = new Integer(stringTokenizer.nextToken());
                                ePSIPreview2.numLines = new Integer(stringTokenizer.nextToken());
                                ePSIPreview2.rasterOffset = seekableInput.getFilePointer();
                                ePSIPreview2.source = this.source;
                                ePSIPreview2.width = this.width;
                                ePSIPreview2.height = this.height;
                                ePSIPreview2.horzResolution = (double)(ePSIPreview2.pxWidth * 72) / ePSIPreview2.width;
                                ePSIPreview2.vertResolution = (double)(ePSIPreview2.pxHeight * 72) / ePSIPreview2.height;
                                ePSIPreview = ePSIPreview2;
                                break block8;
                            }
                            break block9;
                        }
                        catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
                            Object var7_10 = null;
                            seekableInput.close();
                            return null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        seekableInput.close();
                        throw throwable;
                    }
                }
                seekableInput.close();
                return tIFFImage;
            }
            Object var7_8 = null;
            seekableInput.close();
            return ePSIPreview;
        }
        Object var7_9 = null;
        seekableInput.close();
        return null;
    }

    public static class EPSIPreview
    extends BitmapImage {
        public long rasterOffset = 0L;
        public int numLines = 0;

        public EPSIPreview() {
            this.canCopyData = false;
            this.canExpandData = true;
            this.colorSpace = (short)5;
        }

        public void parse() {
        }

        public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
            throw new ImageFormatException("EPSI data cannot be copied");
        }

        public void expandData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
            SeekableInput seekableInput = this.openSeekableImageStream();
            try {
                seekableInput.seek(this.rasterOffset);
                int n = (this.pxWidth * this.bitsPerComponent + 7) / 8;
                byte[] byArray = new byte[this.pxHeight * n];
                int n2 = 0;
                int n3 = 0;
                block2: while (n3 < this.numLines) {
                    String string = seekableInput.readLine();
                    if (string.length() == 0) {
                        throw new ImageFormatException("EPS image " + this.toDisplayString() + ": empty line in EPSI preview section");
                    }
                    if (string.charAt(0) != '%') {
                        throw new ImageFormatException("EPS image " + this.toDisplayString() + ": line in EPSI preview section does not start with '%'");
                    }
                    int n4 = 1;
                    while (n4 < string.length() - 1) {
                        int n5 = "0123456789ABCDEFabcdef".indexOf(string.charAt(n4));
                        int n6 = "0123456789ABCDEFabcdef".indexOf(string.charAt(n4 + 1));
                        if (n5 > 15) {
                            n5 -= 6;
                        }
                        if (n6 > 15) {
                            n6 -= 6;
                        }
                        if (n5 == -1 || n6 == -1) break;
                        byArray[n2++] = (byte)((n5 << 4) + n6);
                        if (n2 == byArray.length) break block2;
                        n4 += 2;
                    }
                    ++n3;
                }
                int n7 = this.pxHeight;
                while (n7-- > 0) {
                    outputStream.write(byArray, n7 * n, n);
                }
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                seekableInput.close();
                throw throwable;
            }
            seekableInput.close();
        }
    }
}

