/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afpcommon.CodePage;
import java.util.ArrayList;

public class XTextDecoderSingleton {
    private static final String LATIN = "Latin";
    private static XTextDecoderSingleton instance = null;
    public static final String BL_CODEPAGE_ID = "Latin";
    public static final String BL_AFP_CODEPAGE = "T1V10500";
    public static final String BL_CODEPAGE = "Cp500";
    public static final int BL_CODE_FROM = 0;
    public static final int BL_CODE_TILL = 127;
    private ArrayList codePages;
    public static CodePage currentCodePage;

    private XTextDecoderSingleton(ArrayList arrayList) {
        this.codePages = arrayList;
        this.resetCurrentCodepage();
        currentCodePage = (CodePage)arrayList.get(0);
    }

    public static synchronized XTextDecoderSingleton getInstance(ArrayList arrayList) {
        if (instance == null) {
            instance = new XTextDecoderSingleton(arrayList);
        }
        return instance;
    }

    public synchronized CodePage getCodePage(String string) {
        CodePage codePage = null;
        if (string != null && !string.equals("")) {
            codePage = this.getCharsetByChar(string.charAt(0));
        }
        return codePage;
    }

    public synchronized void resetCurrentCodepage() {
        currentCodePage = (CodePage)this.codePages.get(0);
    }

    public synchronized void setCurrentCodepage(CodePage codePage) {
        currentCodePage = codePage;
    }

    public synchronized CodePage getCharsetByChar(char c) {
        CodePage codePage = (CodePage)this.codePages.get(0);
        if (currentCodePage == null || !currentCodePage.isRecognize()) {
            currentCodePage = codePage;
        }
        if (!(currentCodePage.isContain(c) || codePage.isContain(c) && XTextDecoderSingleton.currentCodePage.forceLatin)) {
            currentCodePage = null;
            for (int i = 0; i < this.codePages.size(); ++i) {
                CodePage codePage2 = (CodePage)this.codePages.get(i);
                if (!codePage2.isContain(c)) continue;
                currentCodePage = codePage2;
            }
            if (currentCodePage == null) {
                currentCodePage = new CodePage();
            }
        }
        return currentCodePage;
    }
}

