package com.renderx.xepx.x4u.ct.charsetspanel;

import java.awt.Dimension;
import java.awt.event.FocusEvent;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.renderx.xepx.x4u.ct.DomToJTreeAdapter;

/**
 * @author AlexanderR
 *
 */

public class CodepageIbmNamePanel extends JPanel
{
    private static final long serialVersionUID = 3839950733117926797L;

    private CharsetsPanel parentPanel;
    
    private JLabel codepageIbmNameLabel = new JLabel();
    private JTextField codepageIbmNameTextField = new JTextField();
    private JTextField source = new JTextField();
    
    public CodepageIbmNamePanel(CharsetsPanel _charsetsPanel)
    {
	this.parentPanel = _charsetsPanel;
	
        add(codepageIbmNameLabel, null);
        add(codepageIbmNameTextField, null);
        
        codepageIbmNameTextField.setName("ibm-name");
        codepageIbmNameTextField.setText("T1000819");      
        codepageIbmNameTextField.setPreferredSize(new Dimension(105, 15));
        codepageIbmNameTextField.setEnabled(false);
        source.setName("");
        
	codepageIbmNameLabel.setText("ibm-name");
	
	codepageIbmNameTextField.getDocument().addDocumentListener
	(
		new DocumentListener()
		{
		  public void insertUpdate(DocumentEvent e) 
		  {
		      parentPanel.textField_focusLost(source, (Element) parentPanel.getCharsetNode());
		  };
		  public void removeUpdate(DocumentEvent e) 
		  { 
		      parentPanel.textField_focusLost(source, (Element) parentPanel.getCharsetNode());
		  };
		  public void changedUpdate(DocumentEvent e) 
		  { 
		  };
		}
	);
	
        codepageIbmNameTextField.addFocusListener
        (
        	new java.awt.event.FocusAdapter()
        	{
        	    public void focusLost(FocusEvent e)
        	    {
        	    }
        
        	    public void focusGained(FocusEvent e)
        	    {
        		parentPanel.textField_focusGained(e, (Element) parentPanel.getCharsetNode());
        	    }
        });	
    }
    
    public String getText()
    {
	return codepageIbmNameTextField.getText();
    }
    
    public void setText(String text)
    {
	codepageIbmNameTextField.setText(text);
    }
    
    public void setEnabled(boolean value)
    {
	codepageIbmNameTextField.setEnabled(value);
    }
    
    public void setTextFromNode(DomToJTreeAdapter.FontTreeNode node)
    {
	NamedNodeMap attribs = node.getBody().getAttributes();
	if (attribs.getNamedItem("ibm-name") != null)
	{
	    setText(attribs.getNamedItem("ibm-name").getNodeValue());
	    setEnabled(true);
	} else
	{
	    setText("false");
	    setEnabled(false);
	}	
	this.updateUI();
	
	Node sizeNode = node.getBody().getAttributes().getNamedItem("ibm-name");
	String sizeValue = "";
	
	if(sizeNode != null)
	    sizeValue = node.getBody().getAttributes().getNamedItem("ibm-name").getNodeValue();
	
	setText(sizeValue);
    }

    public JTextField getSource()
    {
        return source;
    }

    public void setSource(JTextField source)
    {
        this.source = source;
    }    
}
