/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.cmp;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.FontRecord;
import com.renderx.fonts.Metric;
import com.renderx.graphics.PDFIcons;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.xep.cmp.Area;
import com.renderx.xep.cmp.ExceptionDispatcher;
import com.renderx.xep.cmp.Flow;
import com.renderx.xep.cmp.ItemDispatcher;
import com.renderx.xep.cmp.ListContext;
import com.renderx.xep.cmp.TableContext;
import com.renderx.xep.cmp.Xattr;
import com.renderx.xep.fmt.BPB;
import com.renderx.xep.fmt.BkMaker;
import com.renderx.xep.fmt.BodyRegion;
import com.renderx.xep.fmt.Instruction;
import com.renderx.xep.fmt.InstructionDispatcher;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.lib.Util;
import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Attributed;
import com.renderx.xep.pre.Elem;
import java.util.Enumeration;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public abstract class Item
extends Xattr {
    public static final short PHRASE_BREAK = 1;
    public static final short ISP_BREAK = 2;
    public static final short LINE_BREAK = 4;
    public static final short DSP_BREAK = 8;
    public static final short BLOCK_BREAK = 16;
    public static final short HYPHENATED = 32;
    public static final short COMPLEX = 64;
    public static final short KEEP_FILLED = 256;
    public static final short SAVE_SWITCH = 512;
    public static final short USED = 8192;
    public static final short SKIPPED = 16384;
    protected short status = 0;
    public static final short CXT_AUTO = 0;
    public static final short CXT_COLUMN = 1;
    public static final short CXT_PAGE = 2;
    public static final short CXT_ODD_PAGE = 3;
    public static final short CXT_EVEN_PAGE = 4;
    private static final Hashtable cxts = new Hashtable();
    public static final short BEFORE_EDGE = 0;
    public static final short AFTER_EDGE = 1;
    public static final short START_EDGE = 2;
    public static final short END_EDGE = 3;
    private static final Attn[] margin_edge;
    private static final Attn[] padding_edge;
    private static final Attn[] border_edge;
    private static final Attn[] edge_indent;
    public static final short WST_PRESERVE = 0;
    public static final short WST_IGNORE = 1;
    public static final short WST_IGNORE_BEFORE_LF = 2;
    public static final short WST_IGNORE_AFTER_LF = 4;
    public static final short WST_IGNORE_AROUND_LF = 6;
    public static final short LFT_PRESERVE = 0;
    public static final short LFT_IGNORE = 1;
    public static final short LFT_AS_SPACE = 2;
    public static final short LFT_AS_ZWSP = 3;
    public static final short FONT_HEIGHT = 0;
    public static final short MAX_HEIGHT = 1;
    public static final short LINE_HEIGHT = 2;
    public static final short START = 0;
    public static final short CENTER = 1;
    public static final short END = 2;
    public static final short JUSTIFY = 3;
    public static final short INSIDE = 4;
    public static final short OUTSIDE = 5;
    public static final short STRING = 6;
    private static final Hashtable wstCodes;
    private static final Hashtable lftCodes;
    private static final Hashtable alignCodes;
    public static final short DISPLACE_AUTO = -1;
    public static final short DISPLACE_NONE = 0;
    public static final short DISPLACE_LINE = 1;
    public static final short DISPLACE_INDENT = 2;
    public static final short DISPLACE_BLOCK = 3;
    private static final Hashtable displaces;
    public static final Endb endb;
    public static final Endli endli;
    public static final Endf endf;
    public static final Ends ends;
    public static final Endl endl;
    public static final FootnotesPending footnotesPending;
    public static final FootnotesAppended footnotesAppended;
    public static final short FL_NONE = 0;
    public static final short FL_BEFORE = 1;
    public static final short FL_START = 2;
    public static final short FL_END = 3;
    public static final short FL_INSIDE = 4;
    public static final short FL_OUTSIDE = 5;
    private static final Hashtable fltab;
    public static final short CL_NONE = 0;
    public static final short CL_START = 1;
    public static final short CL_END = 2;
    public static final short CL_BOTH = 3;
    public static final short CL_INSIDE = 4;
    public static final short CL_OUTSIDE = 8;
    private static final Hashtable cltab;
    public static final Endw endw;
    public static final Empty empty;
    public static final Filled filled;
    public static final Eofl eofl;

    public abstract void pass(ItemDispatcher var1);

    public final boolean breaksPhrase() {
        return (this.status & 1) != 0;
    }

    public final boolean breaksInlineSpace() {
        return (this.status & 2) != 0;
    }

    public final boolean breaksLine() {
        return (this.status & 4) != 0;
    }

    public final boolean breaksDisplaySpace() {
        return (this.status & 8) != 0;
    }

    public final boolean breaksBlock() {
        return (this.status & 0x10) != 0;
    }

    public final boolean isAtomic() {
        return (this.status & 0x40) == 0;
    }

    public final boolean keepsFilled() {
        return (this.status & 0x100) != 0;
    }

    public final boolean ss() {
        return (this.status & 0x200) != 0;
    }

    public final boolean isHyphenated() {
        return (this.status & 0x20) != 0;
    }

    public final boolean isSkipped() {
        return (this.status & 0x4000) != 0;
    }

    public final Item setFlags(int n) {
        this.status = (short)(this.status | n);
        return this;
    }

    public final Item clearFlags(int n) {
        this.status = (short)(this.status & ~n);
        return this;
    }

    public final void skip() {
        this.setFlags(16384);
    }

    public Item(Attributed attributed) {
        super(attributed);
    }

    public Item() {
        this(AttList.empty);
    }

    public void dimensions(int n) {
    }

    public String toString() {
        return this.getClass().getName();
    }

    public final Item cow() {
        if ((this.status & 0x2000) != 0) {
            Item item = (Item)this.clone();
            item.clearFlags(8192);
            return item;
        }
        this.setFlags(8192);
        return this;
    }

    static {
        cxts.put(Attr.auto, new Short(0));
        cxts.put(Attr.newWord("column"), new Short(1));
        cxts.put(Attr.newWord("page"), new Short(2));
        cxts.put(Attr.newWord("odd-page"), new Short(3));
        cxts.put(Attr.newWord("even-page"), new Short(4));
        margin_edge = new Attn[]{Attn.$margin_before, Attn.$margin_after, Attn.$margin_start, Attn.$margin_end};
        padding_edge = new Attn[]{Attn.$padding_before_length, Attn.$padding_after_length, Attn.$padding_start_length, Attn.$padding_end_length};
        border_edge = new Attn[]{Attn.$border_before_width_length, Attn.$border_after_width_length, Attn.$border_start_width_length, Attn.$border_end_width_length};
        edge_indent = new Attn[]{Attn.$before_indent, Attn.$after_indent, Attn.$start_indent, Attn.$end_indent};
        wstCodes = new Hashtable();
        lftCodes = new Hashtable();
        alignCodes = new Hashtable();
        wstCodes.put(Attr.newWord("preserve"), new Short(0));
        wstCodes.put(Attr.newWord("ignore"), new Short(1));
        wstCodes.put(Attr.newWord("ignore-if-before-linefeed"), new Short(2));
        wstCodes.put(Attr.newWord("ignore-if-after-linefeed"), new Short(4));
        wstCodes.put(Attr.newWord("ignore-if-surrounding-linefeed"), new Short(6));
        lftCodes.put(Attr.newWord("preserve"), new Short(0));
        lftCodes.put(Attr.newWord("ignore"), new Short(1));
        lftCodes.put(Attr.newWord("treat-as-space"), new Short(2));
        lftCodes.put(Attr.newWord("treat-as-zero-width-space"), new Short(3));
        alignCodes.put(Attr.newWord("start"), new Short(0));
        alignCodes.put(Attr.newWord("center"), new Short(1));
        alignCodes.put(Attr.newWord("middle"), new Short(1));
        alignCodes.put(Attr.newWord("end"), new Short(2));
        alignCodes.put(Attr.newWord("justify"), new Short(3));
        alignCodes.put(Attr.newWord("inside"), new Short(4));
        alignCodes.put(Attr.newWord("outside"), new Short(5));
        alignCodes.put(Attr.newWord("left"), new Short(0));
        alignCodes.put(Attr.newWord("right"), new Short(2));
        displaces = new Hashtable();
        displaces.put(Attr.newWord("auto"), new Short(-1));
        displaces.put(Attr.newWord("none"), new Short(0));
        displaces.put(Attr.newWord("line"), new Short(1));
        displaces.put(Attr.newWord("indent"), new Short(2));
        displaces.put(Attr.newWord("block"), new Short(3));
        endb = new Endb();
        endli = new Endli();
        endf = new Endf();
        ends = new Ends();
        endl = new Endl();
        footnotesPending = new FootnotesPending();
        footnotesAppended = new FootnotesAppended();
        fltab = new Hashtable();
        fltab.put(Attr.newWord("none"), new Short(0));
        fltab.put(Attr.newWord("before"), new Short(1));
        fltab.put(Attr.newWord("start"), new Short(2));
        fltab.put(Attr.newWord("end"), new Short(3));
        fltab.put(Attr.newWord("left"), new Short(2));
        fltab.put(Attr.newWord("right"), new Short(3));
        fltab.put(Attr.newWord("inside"), new Short(4));
        fltab.put(Attr.newWord("outside"), new Short(5));
        cltab = new Hashtable();
        cltab.put(Attr.newWord("none"), new Short(0));
        cltab.put(Attr.newWord("start"), new Short(1));
        cltab.put(Attr.newWord("end"), new Short(2));
        cltab.put(Attr.newWord("left"), new Short(1));
        cltab.put(Attr.newWord("right"), new Short(2));
        cltab.put(Attr.newWord("both"), new Short(3));
        cltab.put(Attr.newWord("inside"), new Short(4));
        cltab.put(Attr.newWord("outside"), new Short(8));
        endw = new Endw();
        empty = new Empty();
        filled = new Filled();
        eofl = new Eofl();
    }

    public static class Bookmark
    extends Item
    implements Instruction {
        public Id id;
        public Integer bno;
        public Bookmark parent;
        public String label = "";
        public Attr color;
        public Attr font_style;
        public Attr font_weight;

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public void pass(InstructionDispatcher instructionDispatcher) {
            instructionDispatcher.process(this);
        }

        public Bookmark(Attributed attributed, Bookmark bookmark, Session session) {
            super(attributed);
            this.parent = bookmark;
            this.bno = new Integer(session.nextno());
        }
    }

    public static class Level
    extends Item {
        public List bnos = new List();

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Level() {
            this.setFlags(279);
        }

        public void register(Block block) {
            this.bnos.cons(block.bno);
            block.level = this;
        }
    }

    public static class Eofl
    extends Item {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        Eofl() {
            this.setFlags(95);
        }
    }

    public static class Filled
    extends Item
    implements Instruction {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public void pass(InstructionDispatcher instructionDispatcher) {
            instructionDispatcher.process(this);
        }

        public Filled() {
            this.setFlags(799);
        }
    }

    public static class Empty
    extends Item {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Empty() {
            this.setFlags(23);
        }
    }

    public static class Softsync
    extends Sync {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Softsync(String string) {
            super(string);
        }
    }

    public static class Sync
    extends Fctl {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Sync(String string) {
            super(string);
            this.setFlags(23);
        }
    }

    public static class Label
    extends Fctl {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Label(String string) {
            super(string);
        }
    }

    public static class Jump
    extends Fctl {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Jump(String string) {
            super(string);
        }

        public Jump(Flow flow) {
            super((String)null);
            this.adr = flow;
        }
    }

    public static class Fork
    extends Fctl {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Fork(String string) {
            super(string);
            this.setFlags(23);
        }
    }

    public static abstract class Fctl
    extends Item {
        public Flow adr = null;
        public String id = null;

        public Fctl(String string) {
            this.id = string;
            this.setFlags(320);
        }

        public String toString() {
            return super.toString() + ":" + this.id;
        }
    }

    public static class Endw
    extends Item {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Endw() {
            super(AttList.empty);
            this.setFlags(95);
        }
    }

    public static class Wide
    extends Item {
        public final Integer wno;

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Wide(Attributed attributed, Session session) {
            super(attributed);
            this.wno = new Integer(session.nextno());
            this.setFlags(95);
        }

        public Wide(Session session) {
            this(AttList.empty, session);
        }
    }

    public static class Clear
    extends Exception {
        public short edge = 0;

        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Clear(Attributed attributed) {
            super(attributed);
            this.edge = (Short)cltab.get(attributed.get(Attn.$clear));
            this.setFlags(5);
        }
    }

    public static class Float
    extends Exception {
        public short edge = 0;

        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Float(Attributed attributed) {
            super(attributed);
            this.flow = new Flow();
            this.edge = (Short)fltab.get(attributed.get(Attn.$float));
            this.setFlags(1);
        }
    }

    public static class Remark
    extends Exception {
        public static final short BND_PAGE = 0;
        public static final short BND_SEQ = 1;
        public static final short BND_DOC = 2;
        public static final short POS_FIRST = 0;
        public static final short POS_SFIRST = 1;
        public static final short POS_EFIRST = 2;
        public static final short POS_SLAST = 3;
        public static final short POS_ELAST = 4;
        public static final short POS_LAST = 5;
        public Attr name;
        public short boundary;
        public short pos;
        private static final Hashtable idtab = new Hashtable();

        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Remark(Attributed attributed) {
            super(attributed);
            this.name = attributed.get(Attn.$retrieve_class_name);
            this.boundary = (Short)idtab.get(attributed.get(Attn.$retrieve_boundary));
            this.pos = (Short)idtab.get(attributed.get(Attn.$retrieve_position));
        }

        static {
            idtab.put(Attr.newWord("page"), new Short(0));
            idtab.put(Attr.newWord("page-sequence"), new Short(1));
            idtab.put(Attr.newWord("document"), new Short(2));
            idtab.put(Attr.newWord("first-starting-within-page"), new Short(1));
            idtab.put(Attr.newWord("first-including-carryover"), new Short(0));
            idtab.put(Attr.newWord("last-starting-within-page"), new Short(3));
            idtab.put(Attr.newWord("last-ending-within-page"), new Short(4));
        }
    }

    public static class Break
    extends Exception {
        public short context;

        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Break(Attributed attributed, String string) {
            super(attributed);
            this.context = (Short)cxts.get(attributed.get(Attn.oldName("break-" + string)));
            this.setFlags(23);
        }
    }

    public static class Keep
    extends Exception {
        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Keep(Attributed attributed) {
            super(attributed);
            this.setFlags(23);
        }
    }

    public static class PI
    extends Item
    implements Instruction {
        public String target = null;
        public String data = null;

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public void pass(InstructionDispatcher instructionDispatcher) {
            instructionDispatcher.process(this);
        }

        public PI(String string, String string2) {
            super((Attributed)null);
            this.target = string;
            this.data = string2;
        }
    }

    public static class PDFFormFieldOption
    extends PDFFormField {
        public PDFFormField parentfield = null;
        private static final List content = null;

        public PDFFormFieldOption(Attributed attributed, Session session) {
            super(attributed, session);
        }
    }

    public static class PDFFormFieldSubmit
    extends PDFFormField {
        public PDFFormField parentfield = null;
        private static final List content = null;

        public PDFFormFieldSubmit(Attributed attributed, Session session) {
            super(attributed, session);
        }
    }

    public static class PDFFormFieldReset
    extends PDFFormField {
        public PDFFormField parentfield = null;
        private static final List content = null;

        public PDFFormFieldReset(Attributed attributed, Session session) {
            super(attributed, session);
        }
    }

    public static class PDFFormFieldCombobox
    extends PDFFormField {
        public PDFFormField parentfield = null;

        public PDFFormFieldCombobox(Attributed attributed, Session session) {
            super(attributed, session);
        }
    }

    public static class PDFFormFieldListbox
    extends PDFFormField {
        public PDFFormField parentfield = null;

        public PDFFormFieldListbox(Attributed attributed, Session session) {
            super(attributed, session);
        }
    }

    public static class PDFFormFieldCheckbox
    extends PDFFormField {
        public PDFFormField parentfield = null;

        public PDFFormFieldCheckbox(Attributed attributed, Session session) {
            super(attributed, session);
        }
    }

    public static class PDFFormFieldRadio
    extends PDFFormField {
        public PDFFormField parentfield = null;

        public PDFFormFieldRadio(Attributed attributed, Session session) {
            super(attributed, session);
        }
    }

    public static class PDFFormFieldText
    extends PDFFormField {
        public PDFFormField parentfield = null;
        private static final List content = null;

        public PDFFormFieldText(Attributed attributed, Session session) {
            super(attributed, session);
        }
    }

    public static class PDFFormField {
        public Attributed a;
        public BPB parentbpb = null;
        public List content = new List();
        public TextTraits tt;
        public int fieldno = -1;

        public PDFFormField(Attributed attributed, Session session) {
            this.a = attributed;
            this.tt = new TextTraits(attributed, session);
        }

        public String toString() {
            String string = this.getClass().getName() + "@" + this.hashCode();
            string = string + "(" + this.a.toString() + ")";
            if (!this.content.isEmpty()) {
                string = string + ":[";
                Enumeration enumeration = this.content.elements();
                while (enumeration.hasMoreElements()) {
                    PDFFormField pDFFormField = (PDFFormField)enumeration.nextElement();
                    string = string + pDFFormField.toString() + ", ";
                }
                string = string.substring(0, string.length() - 2);
                string = string + "]";
            }
            return string;
        }
    }

    public static class ChangeBar
    extends Exception {
        public static final Type START = new Type("start");
        public static final Type END = new Type("end");
        public static final Type FSTART = new Type("fake-start");
        public static final Type FEND = new Type("fake-end");
        public final Attributed attlist;
        public final String cbclass;
        public final int serial;
        public final Type type;
        public final boolean start;
        public final boolean fake;
        public final int zindex;
        public final List points = new List();
        public BodyRegion.Type regtype = BodyRegion.NORMAL;
        public ChangeBar pair;

        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public ChangeBar(Attributed attributed, int n, Type type) {
            super(attributed);
            this.attlist = attributed;
            this.cbclass = attributed.get(Attn.$change_bar_class).word();
            this.zindex = attributed.get(Attn.$z_index).count();
            this.serial = n;
            this.type = type;
            this.start = type == START || type == FSTART;
            this.fake = type == FSTART || type == FEND;
        }

        public ChangeBarPoint getMatchingPoint(BodyRegion bodyRegion) {
            Enumeration enumeration = this.points.elements();
            while (enumeration.hasMoreElements()) {
                ChangeBarPoint changeBarPoint = (ChangeBarPoint)enumeration.nextElement();
                if (!changeBarPoint.active || changeBarPoint.bodyreg.serial != bodyRegion.serial) continue;
                return changeBarPoint;
            }
            throw new InternalException("No matching point found for change-bar: " + this.toString() + " in region " + bodyRegion);
        }

        public String toString() {
            String string = "/type=" + this.type + ",class=" + this.cbclass + ",serial=" + this.serial + ",points: " + this.points + ", regtype=" + this.regtype;
            if (this.pair != null) {
                string = string + ", pair.serial=" + this.pair.serial;
            }
            string = string + "/";
            return string;
        }

        public static final class Type {
            private final String type;

            private Type(String string) {
                this.type = string;
            }

            public String toString() {
                return this.type;
            }
        }
    }

    public static class ChangeBarPoint
    implements Instruction {
        public final BodyRegion bodyreg;
        public final BPB.Block par;
        public int x = Integer.MIN_VALUE;
        public int y = Integer.MIN_VALUE;
        public int line_shift = 0;
        public boolean active = false;

        public void pass(InstructionDispatcher instructionDispatcher) {
            instructionDispatcher.process(this);
        }

        public ChangeBarPoint(int n, int n2, BodyRegion bodyRegion, BPB.Block block) {
            this.x = n;
            this.y = n2;
            this.bodyreg = bodyRegion;
            this.par = block;
        }

        public String toString() {
            return "(x=" + this.x + ",y=" + this.y + ",line_shift=" + this.line_shift + ",region serial=" + this.bodyreg.serial + ",active=" + this.active + ")";
        }
    }

    public static class Pinpoint
    extends Exception
    implements Instruction {
        public int x = 0;
        public int y = 0;
        public Attr writing_mode;

        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public void pass(InstructionDispatcher instructionDispatcher) {
            instructionDispatcher.process(this);
        }

        public Pinpoint(Attributed attributed) {
            super(attributed);
            this.writing_mode = attributed.get(Attn.$writing_mode);
        }
    }

    public static class Endk
    extends Tag {
        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Endk(Attributed attributed, Attr attr) {
            super(attributed);
            this.id = attr;
        }
    }

    public static class Key
    extends Tag {
        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Key(Attributed attributed, Session session) {
            super(attributed);
            this.id = attributed.containsKey(Attn.$id) ? attributed.get(Attn.$id) : Attr.newWord("rx:key@" + session.nextno());
        }
    }

    public static class Lid
    extends Id {
        public Lid(Attributed attributed, Attr attr) {
            super(attributed);
            this.id = Attr.newWord("rx:last@" + attr.word());
        }
    }

    public static class Id
    extends Tag
    implements Instruction {
        public static final Id UNRESOLVED = new Id();

        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public void pass(InstructionDispatcher instructionDispatcher) {
            instructionDispatcher.process(this);
        }

        public Id(Attributed attributed) {
            super(attributed);
            this.id = attributed.containsKey(Attn.$id) ? attributed.get(Attn.$id) : Attr.newWord("");
        }

        private Id() {
            super(AttList.empty);
            this.id = Attr.newWord("");
            this.page = new BkMaker.Page(0);
        }
    }

    public static abstract class Tag
    extends Exception {
        int desc_count;
        public BkMaker.Page page = null;
        public int x = 0;
        public int y = 0;
        public Attr id;
        public Attr writing_mode;

        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Tag(Attributed attributed) {
            super(attributed);
            this.writing_mode = attributed.get(Attn.$writing_mode);
        }
    }

    public static class PageKey
    extends Exception {
        public List terms = new List();

        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public PageKey(Attributed attributed) {
            super(attributed);
        }

        public static class Term
        extends Xattr {
            public final Attr ref_key;
            public final Text RS;
            public final boolean merge;
            public final boolean link;
            public List ranges;

            Term(Attributed attributed, Session session) {
                super(attributed);
                this.ref_key = attributed.get(Attn.$ref_key);
                this.RS = new Text(attributed.get(Attn.$range_separator).word(), attributed, session);
                this.merge = attributed.get(Attn.$merge_subsequent_page_numbers).bool();
                this.link = attributed.get(Attn.$link_back).bool();
            }
        }
    }

    public static class PageNumber
    extends Exception {
        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public PageNumber(Attributed attributed) {
            super(attributed);
        }
    }

    public static class FootnotesAppended
    extends Item {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public FootnotesAppended() {
            super(AttList.empty);
            this.setFlags(512);
        }
    }

    public static class FootnotesPending
    extends Exception {
        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public FootnotesPending() {
            super(AttList.empty);
        }
    }

    public static class Footnote
    extends Exception {
        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Footnote(Attributed attributed) {
            super(attributed);
            this.flow = new Flow();
        }
    }

    public static class Rotated
    extends Exception {
        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Rotated(Attributed attributed) {
            super(attributed);
            this.setFlags(31);
        }
    }

    public static class Fixed
    extends Exception {
        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Fixed(Attributed attributed) {
            super(attributed);
            this.flow = new Flow();
        }
    }

    public static class Absolute
    extends Exception {
        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Absolute(Attributed attributed) {
            super(attributed);
            this.flow = new Flow();
        }
    }

    public static class Exception
    extends Item {
        public Flow flow = null;

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public void pass(ExceptionDispatcher exceptionDispatcher) {
            exceptionDispatcher.process(this);
        }

        public Exception(Attributed attributed) {
            super(attributed);
        }
    }

    public static abstract class Washer
    extends Item {
        public int thickness;

        public Washer(int n) {
            this.thickness = n;
        }

        public static class Inline
        extends Washer
        implements Instruction {
            public void pass(ItemDispatcher itemDispatcher) {
                itemDispatcher.process(this);
            }

            public void pass(InstructionDispatcher instructionDispatcher) {
                instructionDispatcher.process(this);
            }

            public Inline(int n) {
                super(n);
                this.setFlags(2);
            }
        }

        public static class Display
        extends Washer {
            public void pass(ItemDispatcher itemDispatcher) {
                itemDispatcher.process(this);
            }

            public Display(int n) {
                super(n);
                this.setFlags(31);
            }
        }
    }

    public static abstract class Space
    extends Item {
        private static final int FORCE = Integer.MAX_VALUE;
        private String tag;
        private int base;
        private Attn tagmin;
        private Attn tagopt;
        private Attn tagmax;
        public int minimum;
        public int maximum;
        public int optimum;
        public int precedence;
        public boolean retain;
        public boolean nil = false;

        public Space(Attributed attributed, String string) {
            super(attributed);
            this.tag = string;
            Attr attr = attributed.get(Attn.oldName(string + ".precedence"));
            this.precedence = attr instanceof Attr.Word ? Integer.MAX_VALUE : attr.count();
            this.retain = attributed.get(Attn.oldName(string + ".conditionality")) == Attr.retain;
            this.tagmin = Attn.oldName(string + ".minimum");
            this.tagopt = Attn.oldName(string + ".optimum");
            this.tagmax = Attn.oldName(string + ".maximum");
            this.dimensions(1000);
            this.nil = this.precedence == 0 && this.minimum == this.maximum && this.optimum == 0;
            this.optimum = Integer.MIN_VALUE;
            this.base = Integer.MIN_VALUE;
        }

        public void dimensions(int n) {
            if (n != this.base) {
                this.minimum = this.get(this.tagmin).length_or_ratio(n);
                this.maximum = this.get(this.tagmax).length_or_ratio(n);
                this.optimum = this.get(this.tagopt).length_or_ratio(n);
                if (this.minimum > this.maximum) {
                    if (this.a.containsKey(this.tagmax)) {
                        this.minimum = this.maximum;
                    } else {
                        this.maximum = this.minimum;
                    }
                }
                if (!this.a.containsKey(this.tagopt)) {
                    this.optimum = this.minimum;
                }
                if (this.optimum < this.minimum) {
                    this.minimum = this.optimum;
                }
                if (this.maximum < this.optimum) {
                    this.maximum = this.optimum;
                }
                this.base = n;
            }
        }

        public Space merge(Space space) {
            Space space2 = (Space)space.clone();
            if (this.optimum == Integer.MIN_VALUE) {
                this.minimum = space.minimum;
                this.optimum = space.optimum;
                this.maximum = space.maximum;
                this.precedence = space.precedence;
            } else if (space.precedence < this.precedence) {
                space2.maximum = 0;
                space2.optimum = 0;
                space2.minimum = 0;
            } else if (this.precedence != Integer.MAX_VALUE) {
                if (space.precedence > this.precedence || space.optimum > this.optimum) {
                    space2.minimum = space.minimum - this.minimum;
                    this.minimum = space.minimum;
                    space2.optimum = space.optimum - this.optimum;
                    this.optimum = space.optimum;
                    space2.maximum = space.maximum - this.maximum;
                    this.maximum = space.maximum;
                    if (space2.minimum > space2.optimum) {
                        space2.minimum = space2.optimum;
                    }
                    if (space2.maximum < space2.optimum) {
                        space2.maximum = space2.optimum;
                    }
                    this.precedence = space.precedence;
                } else {
                    space2.maximum = 0;
                    space2.optimum = 0;
                    space2.minimum = 0;
                }
            }
            return space2;
        }

        public String toString() {
            if (this.base == Integer.MIN_VALUE) {
                return super.toString() + ": " + this.get(Attn.oldName(this.tag + ".minimum")) + "," + this.get(Attn.oldName(this.tag + ".optimum")) + "," + this.get(Attn.oldName(this.tag + ".maximum")) + "," + this.get(Attn.oldName(this.tag + ".precedence")) + "," + this.get(Attn.oldName(this.tag + ".conditionality"));
            }
            return super.toString() + ": " + this.minimum + "," + this.optimum + "," + this.maximum + "," + (this.precedence == Integer.MAX_VALUE ? "force" : Integer.toString(this.precedence)) + "," + (this.retain ? "retain" : "discard");
        }

        public static class Inline
        extends Space {
            public void pass(ItemDispatcher itemDispatcher) {
                itemDispatcher.process(this);
            }

            public Inline(Attributed attributed, String string) {
                super(attributed, string);
            }

            public Inline() {
                this(AttList.empty, "space-start");
            }
        }

        public static class Display
        extends Space {
            public void pass(ItemDispatcher itemDispatcher) {
                itemDispatcher.process(this);
            }

            public Display(Attributed attributed, String string) {
                super(attributed, string);
                this.setFlags(23);
            }

            public Display() {
                this(AttList.empty, "space-before");
            }
        }
    }

    public static class PDFComment
    extends Inline
    implements Instruction {
        public float cwidth;
        public float cheight;
        protected StickyNote sticky_note = null;
        protected FileAttachment file_attachment = null;
        private int base = Integer.MIN_VALUE;
        Span span = null;

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public void pass(InstructionDispatcher instructionDispatcher) {
            instructionDispatcher.process(this);
        }

        public StickyNote getStickyNote() {
            return this.sticky_note;
        }

        public String getStickyIconType() {
            return this.sticky_note.icon_type;
        }

        public boolean isOpen() {
            return this.sticky_note.open;
        }

        public FileAttachment getFileAttachment() {
            return this.file_attachment;
        }

        public String getFileIconType() {
            return this.file_attachment.icon_type;
        }

        public String getFileName() {
            return this.file_attachment.filename;
        }

        public String getFile() {
            return this.file_attachment.file;
        }

        public PDFComment(Attributed attributed, Session session) {
            super(attributed);
            this.tt = new TextTraits(attributed, session);
            Attn[] attnArray = new Attn[]{Attn.$block_progression_dimension_minimum, Attn.$block_progression_dimension_optimum, Attn.$block_progression_dimension_maximum};
            int n = 0;
            while (n != attnArray.length) {
                if (attributed.get(attnArray[n]) instanceof Attr.Ratio) {
                    this.put(attnArray[n], Attr.auto);
                }
                ++n;
            }
            this.setFlags(10);
        }

        String getIconName(String string) {
            String string2 = null;
            int n = 0;
            while (n < PDFIcons.icon_names.length) {
                if (PDFIcons.icon_names[n].equalsIgnoreCase(string)) {
                    string2 = PDFIcons.icon_names[n];
                }
                ++n;
            }
            return string2;
        }

        public float[] getIconSize(String string) {
            return PDFIcons.getDimensions(string);
        }

        public void dimensions(int n) {
            float[] fArray = this.getIconSize("Note");
            if (this.sticky_note != null) {
                if (this.sticky_note.icon_type == null) {
                    this.sticky_note.icon_type = "Note";
                }
                fArray = this.getIconSize(this.sticky_note.icon_type);
            } else {
                if (this.file_attachment.icon_type == null) {
                    this.file_attachment.icon_type = "Pushpin";
                }
                fArray = this.getIconSize(this.file_attachment.icon_type);
            }
            this.cwidth = fArray[0];
            this.cheight = fArray[1];
            if (n != this.base) {
                int[] nArray = new int[]{Attr.dim_range(this, Attn.$inline_progression_dimension_minimum, Attn.$inline_progression_dimension_optimum, Attn.$inline_progression_dimension_maximum, n), Attr.dim_range(this, Attn.$block_progression_dimension_minimum, Attn.$block_progression_dimension_optimum, Attn.$block_progression_dimension_maximum, n)};
                double[] dArray = new double[]{0.0, 0.0};
                int n2 = 0;
                while (n2 != 2) {
                    if (nArray[n2] == Integer.MIN_VALUE) {
                        nArray[n2] = (int)Math.round(dArray[n2]);
                    }
                    ++n2;
                }
                this.ascender = nArray[0];
                this.descender = 0;
                this.width = nArray[0];
                this.tt.x_height = this.tt.max_ascender = this.ascender;
                this.tt.font_size = this.tt.max_ascender;
                this.tt.line_height = this.tt.max_ascender;
                this.tt.min_descender = 0;
                this.tt.lea = 0;
                this.tt.csp = 0;
                this.tt.wsp = 0;
                this.tt.varwsp = false;
                this.tt.varcsp = false;
                this.span.tt = this.tt;
                this.span.ascender = this.ascender;
                this.span.descender = this.descender;
                this.base = n;
            }
        }

        public class FileAttachment {
            String icon_type;
            String filename;
            String file;

            protected FileAttachment() {
            }
        }

        public class StickyNote {
            String icon_type;
            boolean open = false;

            protected StickyNote() {
            }
        }
    }

    public static class Image
    extends Inline
    implements Instruction {
        public com.renderx.graphics.Image im = null;
        public com.renderx.graphics.Image poster = null;
        public Hashtable rmoResources = null;
        public boolean isRMO = false;
        public String rmoName = null;
        protected FlashVars flashvars = null;
        public boolean[] any_allowed = new boolean[]{false, false};
        public double[] scale = new double[]{1.0, 1.0};
        private int base = Integer.MIN_VALUE;
        Span span = null;

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public void pass(InstructionDispatcher instructionDispatcher) {
            instructionDispatcher.process(this);
        }

        public FlashVars getFlashVars() {
            return this.flashvars;
        }

        public Image(Attributed attributed, Session session) {
            super(attributed);
            this.im = session.config.imageFactory.makeImage(attributed.get(Attn.$src), attributed.get(Attn.$image_base_url), attributed.get(Attn.$content_type), session);
            if (attributed.containsKey(Attn.$poster)) {
                this.poster = session.config.imageFactory.makeImage(attributed.get(Attn.$poster), attributed.get(Attn.$image_base_url), attributed.get(Attn.$poster_content_type), session);
            }
            this.tt = new TextTraits(attributed, session);
            Attn[] attnArray = new Attn[]{Attn.$block_progression_dimension_minimum, Attn.$block_progression_dimension_optimum, Attn.$block_progression_dimension_maximum};
            int n = 0;
            while (n != attnArray.length) {
                if (attributed.get(attnArray[n]) instanceof Attr.Ratio) {
                    this.put(attnArray[n], Attr.auto);
                }
                ++n;
            }
            this.setFlags(10);
            this.a.remove(Attn.$src);
        }

        private List unifyScalings(List[] listArray, Attr[] attrArray) {
            List list = new List();
            Enumeration enumeration = listArray[0].elements();
            block0: while (enumeration.hasMoreElements()) {
                double d = (Double)enumeration.nextElement();
                if (this.any_allowed[1]) {
                    if (attrArray[1] == Attr.newWord("scale-up-to-fit") && d < 1.0 || attrArray[1] == Attr.newWord("scale-down-to-fit") && d > 1.0) continue;
                    list.snoc(new Double(d));
                    continue;
                }
                Enumeration enumeration2 = listArray[1].elements();
                while (enumeration2.hasMoreElements()) {
                    double d2 = (Double)enumeration2.nextElement();
                    if (d2 != d) continue;
                    list.snoc(new Double(d));
                    continue block0;
                }
            }
            Enumeration enumeration3 = listArray[1].elements();
            block2: while (enumeration3.hasMoreElements()) {
                double d = (Double)enumeration3.nextElement();
                if (this.any_allowed[0]) {
                    if (attrArray[0] == Attr.newWord("scale-up-to-fit") && d < 1.0 || attrArray[0] == Attr.newWord("scale-down-to-fit") && d > 1.0) continue;
                    list.snoc(new Double(d));
                    continue;
                }
                Enumeration enumeration4 = listArray[0].elements();
                while (enumeration4.hasMoreElements()) {
                    double d3 = (Double)enumeration4.nextElement();
                    if (d3 != d) continue;
                    list.snoc(new Double(d));
                    continue block2;
                }
            }
            if (!this.any_allowed[0] || !this.any_allowed[1]) {
                this.any_allowed[0] = false;
                this.any_allowed[1] = false;
            }
            return list;
        }

        private List[] combAllowedScalings(Attr.Composite[] compositeArray, Attr[] attrArray) {
            int[] nArray = new int[]{this.any_allowed[0] ? compositeArray[0].vector.length - 1 : compositeArray[0].vector.length, this.any_allowed[1] ? compositeArray[1].vector.length - 1 : compositeArray[1].vector.length};
            List[] listArray = new List[]{new List(), new List()};
            int n = 0;
            while (n < 2) {
                int n2;
                if (attrArray[n] == Attr.newWord("scale-down-to-fit")) {
                    n2 = 0;
                    while (n2 < nArray[n]) {
                        if (((Attr.Percentage)compositeArray[n].vector[n2]).percentage / 100.0 <= 1.0) {
                            listArray[n].snoc(new Double(((Attr.Percentage)compositeArray[n].vector[n2]).percentage / 100.0));
                        }
                        ++n2;
                    }
                    listArray[n].snoc(new Double(1.0));
                } else if (attrArray[n] == Attr.newWord("scale-up-to-fit")) {
                    n2 = 0;
                    while (n2 < nArray[n]) {
                        if (((Attr.Percentage)compositeArray[n].vector[n2]).percentage / 100.0 >= 1.0) {
                            listArray[n].snoc(new Double(((Attr.Percentage)compositeArray[n].vector[n2]).percentage / 100.0));
                        }
                        ++n2;
                    }
                    listArray[n].snoc(new Double(1.0));
                } else {
                    n2 = 0;
                    while (n2 < nArray[n]) {
                        listArray[n].snoc(new Double(((Attr.Percentage)compositeArray[n].vector[n2]).percentage / 100.0));
                        ++n2;
                    }
                }
                ++n;
            }
            if (this.get(Attn.$scaling) == Attr.newWord("uniform")) {
                List list;
                listArray[0] = list = this.unifyScalings(listArray, attrArray);
                listArray[1] = list;
            }
            return listArray;
        }

        private double[] findAllowedScalings() {
            double[] dArray = new double[]{Double.MIN_VALUE, Double.MIN_VALUE};
            if (this.get(Attn.$allowed_width_scale) instanceof Attr.Word && this.get(Attn.$allowed_height_scale) instanceof Attr.Word) {
                this.any_allowed[0] = true;
                this.any_allowed[1] = true;
                return this.scale;
            }
            Attr.Composite[] compositeArray = new Attr.Composite[]{(Attr.Composite)this.get(Attn.$allowed_width_scale), (Attr.Composite)this.get(Attn.$allowed_height_scale)};
            Attr[] attrArray = new Attr[]{this.get(Attn.$content_width), this.get(Attn.$content_height)};
            this.any_allowed[0] = compositeArray[0].vector[compositeArray[0].vector.length - 1] instanceof Attr.Word;
            this.any_allowed[1] = compositeArray[1].vector[compositeArray[1].vector.length - 1] instanceof Attr.Word;
            List[] listArray = this.combAllowedScalings(compositeArray, attrArray);
            int n = 0;
            while (n < 2) {
                Enumeration enumeration = listArray[n].elements();
                while (enumeration.hasMoreElements()) {
                    double d = (Double)enumeration.nextElement();
                    if (!(d > dArray[n]) || !(d <= this.scale[n])) continue;
                    dArray[n] = d;
                }
                if (this.any_allowed[n] && dArray[n] < 0.0) {
                    dArray[n] = this.scale[n];
                }
                ++n;
            }
            return dArray;
        }

        public void dimensions(int n) {
            if (n != this.base) {
                double[] dArray = new double[]{this.im.width * 1000.0, this.im.height * 1000.0};
                Attr[] attrArray = new Attr[]{this.get(Attn.$content_width), this.get(Attn.$content_height)};
                int[] nArray = new int[]{Attr.dim_range(this, Attn.$inline_progression_dimension_minimum, Attn.$inline_progression_dimension_optimum, Attn.$inline_progression_dimension_maximum, n), Attr.dim_range(this, Attn.$block_progression_dimension_minimum, Attn.$block_progression_dimension_optimum, Attn.$block_progression_dimension_maximum, n)};
                int n2 = 0;
                while (n2 != 2) {
                    if (attrArray[n2] instanceof Attr.Length) {
                        this.scale[n2] = (double)attrArray[n2].length() / dArray[n2];
                    } else if (attrArray[n2] instanceof Attr.Ratio) {
                        this.scale[n2] = attrArray[n2].ratio();
                    } else if (nArray[n2] != Integer.MIN_VALUE) {
                        if (attrArray[n2] == Attr.newWord("scale-to-fit")) {
                            this.scale[n2] = (double)nArray[n2] / dArray[n2];
                        } else if (attrArray[n2] == Attr.newWord("scale-down-to-fit")) {
                            this.scale[n2] = (double)nArray[n2] / dArray[n2];
                            if (this.scale[n2] > 1.0) {
                                this.scale[n2] = 1.0;
                            }
                        } else if (attrArray[n2] == Attr.newWord("scale-up-to-fit")) {
                            this.scale[n2] = (double)nArray[n2] / dArray[n2];
                            if (this.scale[n2] < 1.0) {
                                this.scale[n2] = 1.0;
                            }
                        }
                    }
                    ++n2;
                }
                if (this.get(Attn.$scaling) == Attr.newWord("uniform")) {
                    if (attrArray[0] != Attr.auto && attrArray[1] != Attr.auto) {
                        if (this.scale[0] < this.scale[1]) {
                            this.scale[1] = this.scale[0];
                        } else {
                            this.scale[0] = this.scale[1];
                        }
                    } else if (attrArray[0] == Attr.auto) {
                        this.scale[0] = this.scale[1];
                    } else {
                        this.scale[1] = this.scale[0];
                    }
                }
                double[] dArray2 = this.findAllowedScalings();
                int n3 = 0;
                while (n3 < 2) {
                    if (dArray2[n3] != Double.MIN_VALUE) {
                        this.scale[n3] = dArray2[n3];
                    }
                    ++n3;
                }
                int n4 = 0;
                while (n4 != 2) {
                    if (nArray[n4] == Integer.MIN_VALUE) {
                        nArray[n4] = (int)Math.round(dArray[n4] * this.scale[n4]);
                    }
                    ++n4;
                }
                this.ascender = nArray[1];
                this.descender = 0;
                this.width = nArray[0];
                this.tt.x_height = this.tt.max_ascender = this.ascender;
                this.tt.font_size = this.tt.max_ascender;
                this.tt.line_height = this.tt.max_ascender;
                this.tt.min_descender = 0;
                this.tt.lea = 0;
                this.tt.csp = 0;
                this.tt.wsp = 0;
                this.tt.varwsp = false;
                this.tt.varcsp = false;
                this.span.tt = this.tt;
                this.span.ascender = this.ascender;
                this.span.descender = this.descender;
                this.base = n;
            }
        }

        public class FlashVars {
            protected Hashtable vars = new Hashtable();

            public Hashtable getVars() {
                return this.vars;
            }

            public class FlashVar {
                private String name = null;
                private String value = null;
                private String content = null;

                protected FlashVar(String string, String string2, boolean bl) {
                    this.name = string;
                    if (bl) {
                        this.content = string2;
                    } else {
                        this.value = string2;
                    }
                }

                public Attributes getAttrs() {
                    AttributesImpl attributesImpl = new AttributesImpl();
                    attributesImpl.addAttribute("", "name", "name", "CDATA", this.name);
                    if (this.value != null) {
                        attributesImpl.addAttribute("", "value", "value", "CDATA", this.value);
                    }
                    if (this.content != null) {
                        attributesImpl.addAttribute("", "content", "content", "CDATA", this.content);
                    }
                    return attributesImpl;
                }
            }
        }
    }

    public static class Leader
    extends Inline
    implements Instruction {
        private int base = Integer.MIN_VALUE;
        Span span = null;
        public Text dot = null;
        public int length;
        public int len_opt;
        public int len_min;
        public int len_max;
        public int patwidth;
        private static final Hashtable leader_patterns = new Hashtable();
        public short leader_pattern;
        public static final short SPACE = 0;
        public static final short RULE = 1;
        public static final short DOTS = 2;
        public static final short USE_CONTENT = 3;

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public void pass(InstructionDispatcher instructionDispatcher) {
            instructionDispatcher.process(this);
        }

        public Leader(Attributed attributed, Session session) {
            super(attributed);
            try {
                this.leader_pattern = (Short)leader_patterns.get(attributed.get(Attn.$leader_pattern));
            }
            catch (NullPointerException nullPointerException) {
                session.error("invalid leader-pattern " + attributed.get(Attn.$leader_pattern));
                this.leader_pattern = 0;
            }
            this.tt = new TextTraits(attributed, session);
            this.tt.varcsp = false;
            this.tt.varwsp = false;
            block8: while (true) {
                switch (this.leader_pattern) {
                    case 0: {
                        this.descender = 0;
                        this.ascender = 0;
                        break block8;
                    }
                    case 1: {
                        if (attributed.get(Attn.$rule_style) == Attr.none) {
                            this.leader_pattern = 0;
                        }
                        this.tt.max_ascender = this.ascender = attributed.get(Attn.$rule_thickness).length() / 2;
                        this.tt.min_descender = this.descender = -this.ascender;
                        this.tt.x_height = 0;
                        break block8;
                    }
                    case 2: {
                        char c;
                        int n;
                        int n2;
                        this.dot = new Text(attributed.get(Attn.$leader_dot).word(), attributed, session);
                        if (this.get(Attn.$direction) == Attr.rtl) {
                            int n3 = this.dot.chars.length / 2;
                            n2 = this.dot.chars.length - 1;
                            n = 0;
                            while (n != n3) {
                                c = this.dot.chars[n];
                                this.dot.chars[n] = this.dot.chars[n2];
                                this.dot.chars[n2] = c;
                                --n2;
                                ++n;
                            }
                        }
                        this.dot.tt.varwsp = false;
                        this.dot.tt.varcsp = false;
                        if (Util.ne0(this.dot.width)) {
                            this.ascender = this.dot.ascender;
                            this.descender = this.dot.descender;
                            break block8;
                        }
                        this.leader_pattern = 0;
                        continue block8;
                    }
                    case 3: {
                        char c;
                        int n;
                        int n2;
                        this.dot = new Text(attributed.get(Attn.$leader_dot).word(), attributed, session);
                        if (this.get(Attn.$direction) == Attr.rtl) {
                            int n4 = this.dot.chars.length / 2;
                            n2 = this.dot.chars.length - 1;
                            n = 0;
                            while (n != n4) {
                                c = this.dot.chars[n];
                                this.dot.chars[n] = this.dot.chars[n2];
                                this.dot.chars[n2] = c;
                                --n2;
                                ++n;
                            }
                        }
                        this.dot.tt.varwsp = false;
                        this.dot.tt.varcsp = false;
                        if (Util.ne0(this.dot.width)) {
                            this.ascender = this.tt.max_ascender;
                            this.descender = this.tt.min_descender;
                            break block8;
                        }
                        this.leader_pattern = 0;
                        continue block8;
                    }
                    default: {
                        throw new InternalException("leader-pattern=" + this.leader_pattern);
                    }
                }
                break;
            }
            this.setFlags(10);
        }

        public void dimensions(int n) {
            if (n != this.base) {
                this.len_opt = this.get(Attn.$leader_length_optimum).length_or_ratio(n);
                this.len_min = this.get(Attn.$leader_length_minimum).length_or_ratio(n);
                this.len_max = this.get(Attn.$leader_length_maximum).length_or_ratio(n);
                if (this.len_opt < this.len_min) {
                    this.len_min = this.len_opt;
                }
                if (this.len_max < this.len_opt) {
                    this.len_max = this.len_opt;
                }
                this.width = this.length = this.len_opt;
                if (this.leader_pattern == 2 || this.leader_pattern == 3) {
                    this.patwidth = this.get(Attn.$leader_pattern_width).length_or_ratio(n);
                    if (this.patwidth < this.dot.width) {
                        this.patwidth = this.dot.width;
                    }
                    int n2 = this.len_opt / this.patwidth * this.patwidth;
                    int n3 = n2 + this.patwidth;
                    if (n2 >= this.len_min && n3 <= this.len_max) {
                        this.length = n3 - this.len_opt < this.len_opt - n2 ? n3 : n2;
                        this.width = this.length;
                    } else if (n2 >= this.len_min) {
                        this.width = this.length = n2;
                    } else if (n3 <= this.len_max) {
                        this.width = this.length = n3;
                    }
                }
                this.span.tt = this.tt;
                this.span.ascender = this.ascender;
                this.span.descender = this.descender;
                this.base = n;
            }
        }

        static {
            leader_patterns.put(Attr.newWord("space"), new Short(0));
            leader_patterns.put(Attr.newWord("rule"), new Short(1));
            leader_patterns.put(Attr.newWord("dots"), new Short(2));
            leader_patterns.put(Attr.newWord("use-content"), new Short(3));
        }
    }

    public static class PageLid
    extends PageId {
        public PageLid(Attributed attributed, Session session) {
            super(attributed, session);
            this.put(Attn.$ref_id, Attr.newWord("rx:last@" + this.get(Attn.$ref_id).word()));
        }
    }

    public static class PageId
    extends Text {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public PageId(Attributed attributed, Session session) {
            super("0", attributed, session);
            this.width = (int)Math.round((double)session.config.PAGE_ID_WIDTH * this.tt.font_stretch * (double)this.tt.font_size / 1000.0);
        }

        public PageId(String string, Attributed attributed, Session session) {
            super(string, attributed, session);
        }
    }

    public static class Text
    extends Inline
    implements Instruction {
        public char[] chars;
        public int nwsp;
        static char[][] DWN_GLYPS = new char[][]{{'\u0e3c', '\u0e3d', '\u0e3e', '\u0e68', '\u0e69', '\u0e6a', '\u0e6b', '\u0e6c', '\u0e6d', '\u0e6e'}, {'\uf718', '\uf719', '\uf71a', '\u0e47', '\uf70a', '\uf70b', '\uf70c', '\uf70d', '\uf70e', '\u0e4d'}, {'\u0e38', '\u0e39', '\u0e3a', '\u0e47', '\uf88b', '\uf88e', '\uf891', '\uf894', '\uf897', '\u0e4d'}, {'\u0e38', '\u0e39', '\u0e3a', '\u0e47', '\u0e48', '\u0e49', '\u0e4a', '\u0e4b', '\u0e4c', '\u0e4d'}};
        static char[][] LFT_DWN_Tones = new char[][]{{'\u0e76', '\u0e77', '\u0e78', '\u0e79', '\u0e7a', '\u0e7b', '\u0e7c'}, {'\uf712', '\uf705', '\uf706', '\uf707', '\uf708', '\uf709', '\uf711'}, {'\uf889', '\uf88c', '\uf88f', '\uf892', '\uf895', '\uf898', '\uf899'}, {'\u0e47', '\u0e48', '\u0e49', '\u0e4a', '\u0e4b', '\u0e4c', '\u0e4d'}};
        static char[][] LFT_Vovels = new char[][]{{'\u0e61', '\u0e32', '\u0e33', '\u0e64', '\u0e65', '\u0e66', '\u0e67'}, {'\uf710', '\u0e32', '\u0e33', '\uf701', '\uf702', '\uf703', '\uf704'}, {'\uf884', '\u0e32', '\u0e33', '\uf885', '\uf886', '\uf887', '\uf788'}, {'\u0e31', '\u0e32', '\u0e33', '\u0e34', '\u0e35', '\u0e36', '\u0e37'}};
        static char[][] LFT_Tones = new char[][]{{'\u0e6f', '\u0e70', '\u0e71', '\u0e72', '\u0e73', '\u0e74', '\u0e75'}, {'\uf712', '\uf713', '\uf714', '\uf715', '\uf716', '\uf717', '\uf711'}, {'\uf889', '\uf88a', '\uf88d', '\uf890', '\uf893', '\uf896', '\uf899'}, {'\u0e47', '\u0e48', '\u0e49', '\u0e4a', '\u0e4b', '\u0e4c', '\u0e4d'}};
        static char[][] REPLACE = new char[][]{{'\u0e60', '\u0e0e', '\u0e0f', '\u0e63'}, {'\uf70f', '\u0e0e', '\u0e0f', '\uf700'}, {'\u0e0d', '\u0e0e', '\u0e0f', '\u0e10'}, {'\u0e0d', '\u0e0e', '\u0e0f', '\u0e10'}};
        private static final char CH_YAMAKKAN = '\u0e4e';
        private static final char CH_MAI_HANAKAT = '\u0e31';
        private static final char CH_SARA_AA = '\u0e32';
        private static final char CH_SARA_AM = '\u0e33';
        private static final char CH_SARA_UEE = '\u0e37';
        private static final char CH_MAITAIKHU = '\u0e47';
        private static final char CH_NIKHAHIT = '\u0e4d';
        private static final char CH_SARA_U = '\u0e38';
        private static final char CH_PHINTHU = '\u0e3a';
        private static final char CH_YO_YING = '\u0e0d';
        private static final char CH_THO_THAN = '\u0e10';
        private static final char CH_DOTTED_CIRCLE = '\u25cc';

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public void pass(InstructionDispatcher instructionDispatcher) {
            instructionDispatcher.process(this);
        }

        public Text(char[] cArray, int n, Attributed attributed, Session session) {
            this(cArray, n, attributed, session, null, null);
        }

        public Text(char[] cArray, int n, Attributed attributed, Session session, Attributed attributed2, TextTraits textTraits) {
            super(attributed);
            this.chars = new char[n];
            System.arraycopy(cArray, 0, this.chars, 0, n);
            this.tt = attributed == attributed2 ? textTraits : new TextTraits(attributed, session);
            this.width = 0;
            double d = 0.0;
            double d2 = 0.0;
            this.nwsp = 0;
            Metric metric = this.tt.te.getMetric();
            int n2 = 0;
            while (n2 != n) {
                char c = this.chars[n2];
                CharMetrics charMetrics = metric.ucm(c);
                if (charMetrics == null && this.tt.tes.length() != 1) {
                    Enumeration enumeration = this.tt.tes.elements();
                    while (enumeration.hasMoreElements()) {
                        FontRecord fontRecord = (FontRecord)enumeration.nextElement();
                        Metric metric2 = fontRecord.getMetric();
                        charMetrics = metric2.ucm(c);
                        if (charMetrics == null) continue;
                        this.tt.multifont = true;
                        break;
                    }
                }
                if (charMetrics == null) {
                    charMetrics = metric.missingGlyph;
                }
                if (charMetrics != null) {
                    this.width = (int)((float)this.width + charMetrics.wx);
                    if (d < (double)charMetrics.b[3]) {
                        d = charMetrics.b[3];
                    }
                    if (d2 > (double)charMetrics.b[1]) {
                        d2 = charMetrics.b[1];
                    }
                    if (c == ' ') {
                        ++this.nwsp;
                    }
                }
                ++n2;
            }
            this.width = (int)Math.round((double)this.width * this.tt.font_stretch * (double)this.tt.font_size / 1000.0);
            this.width += n * this.tt.csp + this.nwsp * this.tt.wsp;
            this.ascender = (int)Math.round(d / 1000.0 * (double)this.tt.font_size);
            this.descender = (int)Math.round(d2 / 1000.0 * (double)this.tt.font_size);
            if (this.ascender < this.tt.max_ascender) {
                this.ascender = this.tt.max_ascender;
            }
            if (this.descender > this.tt.min_descender) {
                this.descender = this.tt.min_descender;
            }
            if (this.nwsp != n) {
                this.setFlags(10);
            }
            if (this.tt.font_thai_encoding < 3) {
                this.thaiRendering();
            }
        }

        public Text(String string, Attributed attributed, Session session) {
            this(string.toCharArray(), string.length(), attributed, session);
        }

        public String toString() {
            return super.toString() + ":" + new String(this.chars);
        }

        void thaiRendering() {
            int n = this.tt.font_thai_encoding;
            int n2 = this.chars.length;
            StringBuffer stringBuffer = new StringBuffer(n2);
            stringBuffer.append(this.chars);
            int n3 = 1;
            while (n3 < n2) {
                if (!Text.isCns(stringBuffer.charAt(n3))) {
                    char c = stringBuffer.charAt(n3 - 1);
                    if (Text.isUpTM(stringBuffer.charAt(n3)) && n3 < n2 - 1 && stringBuffer.charAt(n3 + 1) == '\u0e33') {
                        stringBuffer.setCharAt(n3 + 1, stringBuffer.charAt(n3));
                        stringBuffer.setCharAt(n3, '\u0e33');
                    }
                    if (Text.isCns(c)) {
                        int n4;
                        int n5;
                        int n6;
                        char c2;
                        int n7;
                        char c3;
                        if (stringBuffer.charAt(n3) == '\u0e33') {
                            c3 = '\u0e32';
                            stringBuffer.setCharAt(n3, '\u0e4d');
                            n7 = 0;
                            if (n3 < n2 - 1 && (Text.isDnTM(stringBuffer.charAt(n3 + 1)) || Text.isUpTM(stringBuffer.charAt(n3 + 1)))) {
                                n7 = 1;
                            }
                            stringBuffer.insert(n3 + 1 + n7, c3);
                            ++n2;
                        }
                        c3 = c == '\u0e1b' || c == '\u0e1d' || c == '\u0e1f' ? (char)'\u0001' : '\u0000';
                        n7 = c == '\u0e0e' || c == '\u0e0f' || c == '\u0e24' || c == '\u0e26' ? 1 : 0;
                        char c4 = stringBuffer.charAt(n3);
                        char c5 = c2 = n3 < n2 - 1 ? stringBuffer.charAt(n3 + 1) : (char)'\u0000';
                        int n8 = Text.isUpTM(c4) ? n3 : (n6 = Text.isUpTM(c2) ? n3 + 1 : -1);
                        int n9 = Text.isUpV(c4) ? n3 : (n5 = Text.isUpV(c2) ? n3 + 1 : -1);
                        int n10 = Text.isDnTM(c4) ? n3 : (n4 = Text.isDnTM(c2) ? n3 + 1 : -1);
                        if ((c == '\u0e0d' || c == '\u0e10') && n4 > 0) {
                            stringBuffer.setCharAt(n3 - 1, REPLACE[n][c - 3597]);
                            if (n6 > 0) {
                                stringBuffer.setCharAt(n6, Text.downShift(stringBuffer.charAt(n6), n));
                                ++n3;
                            }
                        } else if (n6 > 0) {
                            ++n3;
                            if (n5 < 0) {
                                if (c3 != '\u0000') {
                                    stringBuffer.setCharAt(n6, Text.left_downShift(stringBuffer.charAt(n6), n));
                                } else {
                                    stringBuffer.setCharAt(n6, Text.downShift(stringBuffer.charAt(n6), n));
                                }
                            } else {
                                ++n3;
                                if (c3 != '\u0000') {
                                    stringBuffer.setCharAt(n5, Text.leftShift(stringBuffer.charAt(n5), n));
                                    stringBuffer.setCharAt(n6, Text.leftShift(stringBuffer.charAt(n6), n));
                                }
                            }
                            if (n7 != 0 && n4 > 0) {
                                stringBuffer.setCharAt(n4, Text.downShift(stringBuffer.charAt(n4), n));
                            }
                        } else {
                            ++n3;
                            if (c3 != '\u0000' && n5 > 0) {
                                stringBuffer.setCharAt(n5, Text.leftShift(stringBuffer.charAt(n5), n));
                            }
                            if (n7 != 0 && n4 > 0) {
                                stringBuffer.setCharAt(n4, Text.downShift(stringBuffer.charAt(n4), n));
                            }
                        }
                    }
                }
                ++n3;
            }
            this.chars = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), this.chars, 0);
        }

        private static boolean isUpV(char c) {
            return c == '\u0e31' || '\u0e34' <= c && c <= '\u0e37' || c == '\u0e4e';
        }

        private static boolean isUpTM(char c) {
            return c >= '\u0e47' && c <= '\u0e4d';
        }

        private static boolean isDnTM(char c) {
            return c >= '\u0e38' && c <= '\u0e3a';
        }

        private static boolean isCns(char c) {
            return '\u0e01' <= c && c <= '\u0e2e';
        }

        private static char downShift(char c, int n) {
            if (c >= '\u0e38' && c <= '\u0e3a') {
                return DWN_GLYPS[n][c - 3640];
            }
            if (c >= '\u0e47' && c <= '\u0e4d') {
                return DWN_GLYPS[n][c - 3655 + 3];
            }
            return c;
        }

        private static char left_downShift(char c, int n) {
            if (c >= '\u0e47' && c <= '\u0e4d') {
                return LFT_DWN_Tones[n][c - 3655];
            }
            return '\u25cc';
        }

        private static char leftShift(char c, int n) {
            if (c >= '\u0e47' && c <= '\u0e4d') {
                return LFT_Tones[n][c - 3655];
            }
            if (c >= '\u0e31' && c <= '\u0e37') {
                return LFT_Vovels[n][c - 3633];
            }
            if (c == '\u0e4e' && n == 0) {
                return '\u0e7e';
            }
            return c;
        }
    }

    public static abstract class Inline
    extends Item {
        public TextTraits tt = null;
        public int width;
        public int offset;
        public int ascender;
        public int descender;
        public PDFFormField pdfformfield = null;

        public Inline(Attributed attributed) {
            super(attributed);
        }

        public Inline() {
            this(AttList.empty);
        }
    }

    public static class Endl
    extends Item {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Endl() {
            this.setFlags(15);
        }
    }

    public static class Ends
    extends Item {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Ends() {
            this.setFlags(64);
        }
    }

    public static class Anchor
    extends Span {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Anchor(Attributed attributed, Session session) {
            super(attributed, session);
        }
    }

    public static class Span
    extends Inline {
        public PropList proplist = new PropList();
        public final Integer sno;
        public BPB.Inline bpb = null;
        public Hashtable markers = null;
        public boolean first_word = false;
        public int base = Integer.MIN_VALUE;
        public int start_indent;
        public int end_indent;
        public Attr writing_mode;
        private int[] abs_margin = new int[]{0, 0, 0, 0};

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Span(Attributed attributed, Session session) {
            super(attributed);
            this.sno = new Integer(session.nextno());
            Area.fixBorderWidth(attributed);
            Attr attr = attributed.containsKey(Attn.$direction) ? (attributed.get(Attn.$direction) == Attr.ltr ? Attr.lr_tb : Attr.rl_tb) : (this.writing_mode = attributed.get(Attn.$writing_mode));
            if (this.writing_mode != Attr.lr_tb && this.writing_mode != Attr.rl_tb) {
                session.warning("writing mode '" + this.writing_mode + "' is not supported");
                this.writing_mode = Attr.lr_tb;
            }
            this.tt = new TextTraits(attributed, session);
            this.width = 0;
            this.offset = 0;
            this.ascender = this.tt.max_ascender;
            this.descender = this.tt.min_descender;
            this.setFlags(64);
        }

        public void dimensions(Span span, int n) {
            if (this.base != n) {
                int[] nArray = new int[]{0, 0, 0, 0};
                int n2 = 0;
                while (n2 != 4) {
                    Attr attr = this.get(margin_edge[n2]);
                    Attr attr2 = this.get(padding_edge[n2]);
                    Attr attr3 = this.get(edge_indent[n2]);
                    if (attr instanceof Attr.Ratio) {
                        attr = Attr.newLength((int)Math.round(attr.ratio() * (double)n));
                        this.put(margin_edge[n2], attr);
                    } else if (attr instanceof Attr.Word) {
                        attr = Attr.newLength(0);
                        this.put(margin_edge[n2], attr);
                    }
                    if (attr2 instanceof Attr.Ratio) {
                        attr2 = Attr.newLength((int)Math.round(attr2.ratio() * (double)n));
                        this.put(padding_edge[n2], attr2);
                    }
                    if (attr3 instanceof Attr.Ratio) {
                        attr3 = Attr.newLength((int)Math.round(attr3.ratio() * (double)n));
                        this.put(edge_indent[n2], attr3);
                    }
                    this.abs_margin[n2] = this.get(margin_edge[n2]).length();
                    if (span != null) {
                        int n3 = n2;
                        this.abs_margin[n3] = this.abs_margin[n3] + (span.abs_margin[n2] + span.get(border_edge[n2]).length() + span.get(padding_edge[n2]).length());
                    }
                    nArray[n2] = this.abs_margin[n2] + this.get(border_edge[n2]).length() + this.get(padding_edge[n2]).length();
                    ++n2;
                }
                this.start_indent = nArray[2];
                this.end_indent = nArray[3];
                this.base = n;
            }
        }

        public String toString() {
            return super.toString() + ": " + this.sno + ":" + this.writing_mode;
        }
    }

    public static class Endf
    extends Endb {
        Endf() {
            this.setFlags(8);
        }
    }

    public static class Endli
    extends Endb {
        Endli() {
            this.setFlags(8);
        }
    }

    public static class Endb
    extends Item {
        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        Endb() {
            this.setFlags(599);
        }
    }

    public static class Table
    extends Frame {
        public Flow header = new Flow();
        public Flow footer = new Flow();
        public TableContext context;

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Table(Attributed attributed, TableContext tableContext) {
            super(attributed, tableContext.session);
            this.context = tableContext;
        }
    }

    public static class Frame
    extends Block {
        public static final short NORMAL = 0;
        public static final short ROTATED = 1;
        public static final short ABSOLUTE = 2;
        public static final short FIXED = 3;
        public short mode = 0;
        public PDFFormField pdfformfield = null;

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Frame(Attributed attributed, Session session) {
            super(attributed, session);
        }
    }

    public static class ListBlock
    extends Block {
        public ListContext context;
        Attr.Length alabel_end_indent;
        Attr.Length abody_indent;

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public ListBlock(Attributed attributed, ListContext listContext) {
            super(attributed, listContext.session);
            this.context = listContext;
        }

        public void dimensions(Block block, ListBlock listBlock, Hashtable hashtable, int n) {
            super.dimensions(block, listBlock, hashtable, n);
            int n2 = this.start_indent + this.get(Attn.$provisional_distance_between_starts).length_or_ratio(this.base);
            this.abody_indent = Attr.newLength(n2);
            this.alabel_end_indent = Attr.newLength(n - n2 + this.get(Attn.$provisional_label_separation).length_or_ratio(this.base));
        }
    }

    public static class ListItem
    extends Block {
        public ListItem(Attributed attributed, Session session) {
            super(attributed, session);
            this.setFlags(8);
        }
    }

    public static class Block
    extends Item {
        public final Integer bno;
        public PropList proplist = new PropList();
        public BPB.Block bpb = null;
        public Level level = null;
        public Hashtable markers = null;
        public TextTraits tt;
        public int base = Integer.MIN_VALUE;
        public int content_width;
        public int start_indent;
        public int end_indent;
        public int before_indent;
        public int after_indent;
        public int text_indent;
        public int last_indent;
        public int gap;
        public boolean collapse;
        public boolean wrap;
        public boolean keep_together;
        public short lss;
        public boolean consider_shifts;
        public int orphans;
        public int widows;
        public Attr writing_mode;
        public short displace;
        public int[] abs_margin = new int[]{0, 0, 0, 0};
        public short align = (short)-1;
        public short align_last = (short)-1;
        public String align_string = "";

        public void pass(ItemDispatcher itemDispatcher) {
            itemDispatcher.process(this);
        }

        public Block(Attributed attributed, Session session) {
            super(attributed);
            this.bno = new Integer(session.nextno());
            Area.fixBorderWidth(attributed);
            this.wrap = attributed.get(Attn.$wrap_option) == Attr.wrap;
            this.collapse = attributed.get(Attn.$white_space_collapse).bool();
            Attr attr = attributed.get(Attn.$line_stacking_strategy);
            this.lss = attr == Attr.font_height ? 0 : (attr == Attr.max_height ? 1 : 2);
            this.consider_shifts = attributed.get(Attn.$line_height_shift_adjustment) == Attr.consider_shifts;
            this.orphans = attributed.get(Attn.$orphans).count();
            this.widows = attributed.get(Attn.$widows).count();
            boolean bl = this.keep_together = attributed.get(Attn.$keep_together_within_column) != Attr.auto || attributed.get(Attn.$keep_together_within_page) != Attr.auto;
            if (alignCodes.containsKey(attributed.get(Attn.$text_align))) {
                this.align = (Short)alignCodes.get(attributed.get(Attn.$text_align));
            } else {
                this.align = (short)6;
                this.align_string = attributed.get(Attn.$text_align).word();
            }
            this.align_last = attributed.get(Attn.$text_align_last) == Attr.relative ? (this.align == 3 ? (short)0 : this.align) : (Short)alignCodes.get(attributed.get(Attn.$text_align_last));
            this.writing_mode = attributed.get(Attn.$writing_mode);
            if (this.writing_mode != Attr.lr_tb && this.writing_mode != Attr.rl_tb) {
                session.warning("writing mode '" + this.writing_mode + "' is not supported");
                this.writing_mode = Attr.lr_tb;
            }
            this.displace = (Short)displaces.get(attributed.get(Attn.$intrusion_displace));
            if (this.displace == -1) {
                this.displace = (short)(this instanceof Frame ? 3 : 1);
            }
            if (this.get(Attn.$reference_orientation).count() != 0 && this.displace != 0) {
                this.displace = (short)3;
            }
            this.tt = new TextTraits(attributed, session);
            this.setFlags(87);
        }

        public void dimensions(Block block, ListBlock listBlock, Hashtable hashtable, int n) {
            int n2 = n;
            if (!(block instanceof Frame)) {
                n2 -= block.start_indent + block.end_indent;
            }
            if (n2 != this.base) {
                Attr.Length length;
                Object object;
                this.resetall();
                boolean bl = false;
                if (this.get(Attn.$end_indent) == Attr.auto) {
                    this.put(Attn.$end_indent, Attr.newLength(0));
                } else if (this.get(Attn.$end_indent) instanceof Attr.Word) {
                    object = this.get(Attn.$end_indent).word();
                    length = Attr.zerolength;
                    if (((String)object).startsWith("label-end:")) {
                        if (hashtable.containsKey(object)) {
                            length = (Attr.Length)hashtable.get(object);
                        } else if (listBlock != null) {
                            length = listBlock.alabel_end_indent;
                            hashtable.put(object, length);
                        }
                        bl = true;
                    } else if (((String)object).startsWith("body-start:")) {
                        if (hashtable.containsKey(object)) {
                            length = (Attr.Length)hashtable.get(object);
                        } else if (listBlock != null) {
                            length = listBlock.abody_indent;
                            hashtable.put(object, length);
                        }
                    }
                    this.put(Attn.$end_indent, length);
                }
                if (this.get(Attn.$start_indent) == Attr.auto) {
                    this.put(Attn.$start_indent, Attr.newLength(0));
                } else if (this.get(Attn.$start_indent) instanceof Attr.Word) {
                    object = this.get(Attn.$start_indent).word();
                    length = Attr.zerolength;
                    if (((String)object).startsWith("body-start:")) {
                        if (hashtable.containsKey(object)) {
                            length = (Attr.Length)hashtable.get(object);
                        } else if (listBlock != null) {
                            length = listBlock.abody_indent;
                            hashtable.put(object, length);
                        }
                    } else if (((String)object).startsWith("label-end:")) {
                        if (hashtable.containsKey(object)) {
                            length = (Attr.Length)hashtable.get(object);
                        } else if (listBlock != null) {
                            length = listBlock.alabel_end_indent;
                            hashtable.put(object, length);
                        }
                        bl = true;
                    }
                    this.put(Attn.$start_indent, length);
                }
                this.content_width = Attr.dim_range(this, Attn.$inline_progression_dimension_minimum, Attn.$inline_progression_dimension_optimum, Attn.$inline_progression_dimension_maximum, n2);
                this.gap = 0;
                object = new int[]{0, 0, 0, 0};
                int n3 = 0;
                while (n3 != 4) {
                    Attr attr;
                    Attr attr2 = this.get(margin_edge[n3]);
                    Attr attr3 = this.get(padding_edge[n3]);
                    if (attr2 instanceof Attr.Ratio) {
                        attr2 = Attr.newLength((int)Math.round(attr2.ratio() * (double)n2));
                        this.put(margin_edge[n3], attr2);
                    }
                    if (attr3 instanceof Attr.Ratio) {
                        attr3 = Attr.newLength((int)Math.round(attr3.ratio() * (double)n2));
                        this.put(padding_edge[n3], attr3);
                    }
                    if ((attr = this.get(edge_indent[n3])) instanceof Attr.Ratio) {
                        attr = Attr.newLength((int)Math.round(attr.ratio() * (double)n));
                    }
                    switch (n3) {
                        case 0: 
                        case 1: {
                            this.abs_margin[n3] = attr2.length();
                            if (!(block instanceof Frame)) {
                                int n4 = n3;
                                this.abs_margin[n4] = this.abs_margin[n4] + (block.abs_margin[n3] + block.get(border_edge[n3]).length() + block.get(padding_edge[n3]).length());
                            }
                            object[n3] = this.abs_margin[n3] + this.get(border_edge[n3]).length() + this.get(padding_edge[n3]).length();
                            break;
                        }
                        case 2: 
                        case 3: {
                            int n5;
                            int n6;
                            int n7;
                            if (this.writing_mode == block.writing_mode) {
                                n7 = n3;
                                n6 = 2;
                                n5 = 3;
                            } else {
                                n7 = n3 == 2 ? 3 : 2;
                                n6 = 3;
                                n5 = 2;
                            }
                            if (!this.containsKey(edge_indent[n3]) && !this.containsKey(margin_edge[n3])) {
                                attr = block instanceof Frame ? Attr.newLength(0) : block.get(edge_indent[n7]);
                                this.put(edge_indent[n3], attr);
                            }
                            if (this.containsKey(edge_indent[n3])) {
                                object[n3] = attr.length();
                                this.abs_margin[n3] = (int)(object[n3] - this.get(border_edge[n3]).length() - this.get(padding_edge[n3]).length());
                                this.put(margin_edge[n3], Attr.newLength(block instanceof Frame ? this.abs_margin[n3] : this.abs_margin[n3] - block.abs_margin[n7] - block.get(border_edge[n7]).length() - block.get(padding_edge[n7]).length()));
                            } else {
                                this.abs_margin[n3] = attr2.length();
                                if (!(block instanceof Frame)) {
                                    int n8 = n3;
                                    this.abs_margin[n8] = this.abs_margin[n8] + (block.abs_margin[n7] + block.get(border_edge[n7]).length() + block.get(padding_edge[n7]).length());
                                }
                                object[n3] = this.abs_margin[n3] + this.get(border_edge[n3]).length() + this.get(padding_edge[n3]).length();
                            }
                            if (n3 != 3 || this.content_width == Integer.MIN_VALUE) break;
                            Object object2 = object[3];
                            object[3] = n2 - object[2] - this.content_width;
                            if (!(block instanceof Frame)) {
                                Object object3 = object;
                                object3[3] = object3[3] + (block.start_indent + block.end_indent);
                            }
                            this.gap += object[3] - object2;
                            this.abs_margin[3] = (int)(object[3] - this.get(Attn.$border_end_width_length).length() - this.get(Attn.$padding_end_length).length());
                            this.put(Attn.$margin_end, Attr.newLength(block instanceof Frame ? this.abs_margin[3] : this.abs_margin[3] - block.abs_margin[n5] - block.get(border_edge[n5]).length() - block.get(padding_edge[n5]).length()));
                        }
                    }
                    ++n3;
                }
                Object object4 = object[2];
                this.start_indent = (int)object4;
                this.put(Attn.$start_indent, Attr.newLength((int)object4));
                Object object5 = object[3];
                this.end_indent = (int)object5;
                this.put(Attn.$end_indent, Attr.newLength((int)object5));
                Object object6 = object[0];
                this.before_indent = (int)object6;
                this.put(Attn.$before_indent, Attr.newLength((int)object6));
                Object object7 = object[1];
                this.after_indent = (int)object7;
                this.put(Attn.$after_indent, Attr.newLength((int)object7));
                this.text_indent = this.get(Attn.$text_indent).length_or_ratio(n2);
                this.last_indent = this.get(Attn.$last_line_end_indent).length_or_ratio(n2);
                if (this.content_width == Integer.MIN_VALUE && bl) {
                    this.content_width = n2 - this.start_indent - this.end_indent;
                    this.gap += this.end_indent;
                }
                this.base = n2;
            } else {
                String string;
                if (this.get(Attn.$end_indent) instanceof Attr.Word && (string = this.get(Attn.$end_indent).word()).startsWith("label-end:") && !hashtable.containsKey(string)) {
                    hashtable.put(string, this.get(Attn.$inline_progression_dimension_optimum));
                }
                if (this.get(Attn.$start_indent) instanceof Attr.Word && (string = this.get(Attn.$start_indent).word()).startsWith("body-start:") && !hashtable.containsKey(string)) {
                    hashtable.put(string, this.get(Attn.$start_indent));
                }
            }
        }

        public String toString() {
            return super.toString() + ":" + this.bno;
        }
    }

    public static class TextTraits {
        public List tes;
        public FontRecord te;
        public boolean multifont = false;
        public boolean merge_white_space = true;
        public boolean thai_case = false;
        public int font_size;
        public int font_thai_encoding;
        public int max_ascender;
        public int min_descender;
        public int x_height;
        public int wsp;
        public int csp;
        public int line_height;
        public int lea;
        public int offset = Integer.MIN_VALUE;
        public double font_stretch;
        public Attr font_weight;
        public Attr font_style;
        public Attr font_variant;
        public boolean varwsp;
        public boolean varcsp;
        public short wst;
        public short lft;

        public TextTraits(Attributed attributed, Session session) {
            Object object;
            Object object2;
            this.font_weight = attributed.get(Attn.$font_weight);
            this.font_style = attributed.get(Attn.$font_style);
            this.font_variant = attributed.get(Attn.$font_variant);
            String string = attributed.get(Attn.$language).word();
            Attr attr = attributed.get(Attn.$country);
            if (attr != Attr.none) {
                string = string + "-" + attr.word();
            }
            this.tes = session.findAllFonts(attributed.get(Attn.$font_family).word(), this.font_weight.count(), this.font_style.word(), this.font_variant.word(), string);
            if (!session.config.MERGE_WHITE_SPACE) {
                this.merge_white_space = false;
            } else {
                object2 = this.tes.elements();
                while (object2.hasMoreElements()) {
                    object = (FontRecord)object2.nextElement();
                    if (!((FontRecord)object).getMetric().isCIDFont) continue;
                    this.merge_white_space = false;
                    break;
                }
            }
            this.te = (FontRecord)this.tes.car();
            object2 = this.te.getMetric();
            this.font_thai_encoding = this.te.getThaiShaping();
            this.font_size = attributed.get(Attn.$font_size).length();
            object = attributed.get(Attn.$font_size_adjust);
            if (object instanceof Attr.Ratio) {
                this.font_size = (int)Math.round((double)this.font_size * ((Attr)object).ratio() * 1000.0 / (double)((Metric)object2).xHeight);
            }
            Attr attr2 = attributed.get(Attn.$text_altitude);
            Attr attr3 = attributed.get(Attn.$text_depth);
            this.max_ascender = attr2 instanceof Attr.Word ? Math.round(((Metric)object2).ascender / 1000.0f * (float)this.font_size) : attr2.length();
            this.min_descender = attr3 instanceof Attr.Word ? Math.round(((Metric)object2).descender / 1000.0f * (float)this.font_size) : -attr3.length();
            this.x_height = Math.round(((Metric)object2).xHeight / 1000.0f * (float)this.font_size);
            this.varwsp = attributed.get(Attn.$word_spacing_minimum) instanceof Attr.Word && attributed.get(Attn.$word_spacing_maximum) instanceof Attr.Word;
            this.wsp = Attr.length_range(attributed, Attn.$word_spacing_minimum, Attn.$word_spacing_optimum, Attn.$word_spacing_maximum, 0);
            this.varcsp = attributed.get(Attn.$letter_spacing_minimum) instanceof Attr.Word && attributed.get(Attn.$letter_spacing_maximum) instanceof Attr.Word;
            this.csp = Attr.length_range(attributed, Attn.$letter_spacing_minimum, Attn.$letter_spacing_optimum, Attn.$letter_spacing_maximum, 0);
            this.font_stretch = attributed.get(Attn.$font_stretch).ratio();
            int n = this.max_ascender - this.min_descender;
            this.line_height = Attr.length_range(attributed, Attn.$line_height_minimum, Attn.$line_height_optimum, Attn.$line_height_maximum, this.font_size);
            this.lea = (this.line_height - n) / 2;
            this.wst = (Short)wstCodes.get(attributed.get(Attn.$white_space_treatment));
            this.lft = (Short)lftCodes.get(attributed.get(Attn.$linefeed_treatment));
        }
    }

    public static final class PropList {
        private Hashtable tab = new Hashtable();

        public List put(short s, AttList attList) {
            Elem.Descriptor descriptor = Elem.getDescriptor(s);
            List list = (List)this.tab.get(descriptor);
            if (list == null) {
                list = new List();
                this.tab.put(descriptor, list);
            }
            list.snoc(attList);
            return list;
        }

        public List get(short s) {
            return (List)this.tab.get(Elem.getDescriptor(s));
        }

        public AttList get0(short s) {
            List list = this.get(s);
            return list != null ? (AttList)list.car() : null;
        }

        public boolean contains(short s) {
            return this.get(s) != null;
        }
    }
}

