/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.sax.Canonicalizer;
import com.renderx.sax.Fork;
import com.renderx.sax.Serializer;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Args;
import com.renderx.util.Base64OutputStream;
import com.renderx.util.PGPException;
import cryptix.pgp.CRC;
import cryptix.pgp.DecryptException;
import cryptix.pgp.Packet;
import cryptix.pgp.PacketFactory;
import cryptix.pgp.Passphrase;
import cryptix.pgp.SecretKeyRing;
import cryptix.pgp.Signature;
import cryptix.provider.Cryptix;
import cryptix.security.MD5;
import cryptix.security.rsa.SecretKey;
import java.io.IOException;
import java.io.StringWriter;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class XMLLicense {
    public static void sign(InputSource inputSource, XMLReader xMLReader, ContentHandler contentHandler, String string, String string2, String string3) throws IOException, SAXException, DecryptException, PGPException {
        SecretKeyRing secretKeyRing = new SecretKeyRing(string2);
        SecretKey secretKey = secretKeyRing.getKey(string, new Passphrase(string3));
        if (secretKey == null) {
            throw new PGPException("cannot retrieve a secret key for '" + string + "' from secret key ring '" + string2 + "'");
        }
        xMLReader.setContentHandler(new SigningFilter(contentHandler, secretKey));
        xMLReader.parse(inputSource);
    }

    public static void main(String[] stringArray) {
        Object object;
        Args args = new Args(stringArray);
        if (args.arguments.length() != 1) {
            System.err.println("call: java com.renderx.util.License [-Dsecring=<path to secring.pgp>] [-Daddress=<signer's address>] passphrase\n");
            System.exit(1);
        }
        String string = "RenderX";
        String string2 = "secring.pgp";
        String string3 = (String)args.arguments.car();
        Enumeration enumeration = args.options.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).equals("address")) {
                string = (String)args.options.get("address");
                continue;
            }
            if (((String)object).equals("secring")) {
                string2 = (String)args.options.get("secring");
                continue;
            }
            System.err.println("illegal option '" + (String)object + "', skipping");
        }
        object = Security.getProvider("Cryptix");
        if (object == null) {
            Security.addProvider((Provider)new Cryptix());
        }
        try {
            XMLLicense.sign(new InputSource(System.in), XMLReaderFactory.createXMLReader(), new Serializer(System.out), string, string2, string3);
        }
        catch (Exception exception) {
            System.err.println("error signing the license: " + exception.getMessage());
            System.exit(2);
        }
    }

    private static class SigningFilter
    extends Fork {
        int level = 0;
        final SecretKey secretKey;

        SigningFilter(ContentHandler contentHandler, SecretKey secretKey) {
            super(new Canonicalizer(), contentHandler);
            this.secretKey = secretKey;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.level;
            super.startElement(string, string2, string3, attributes);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            --this.level;
            if (this.level == 0) {
                this.h1.endElement(string, string2, string3);
                this.h1.endDocument();
                Canonicalizer canonicalizer = (Canonicalizer)this.h1;
                String string4 = null;
                try {
                    string4 = this.makeSignature(canonicalizer.body);
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
                String string5 = "signature";
                String string6 = null;
                if (string3 != null) {
                    String string7 = string3.substring(0, string3.length() - string2.length());
                    string6 = string7 + string5;
                }
                this.h2.startElement(string, string5, string6, new AttributesImpl());
                this.h2.characters(string4.toCharArray(), 0, string4.length());
                this.h2.endElement(string, string5, string6);
                this.h1 = null;
            }
            super.endElement(string, string2, string3);
        }

        private String makeSignature(byte[] byArray) throws IOException {
            MD5 mD5 = new MD5();
            mD5.add(byArray);
            Signature signature = new Signature(this.secretKey, mD5);
            byte[] byArray2 = PacketFactory.save((Packet)signature);
            byte[] byArray3 = new byte[3];
            int n = CRC.checksum((byte[])byArray2);
            byArray3[0] = (byte)(n >>> 16);
            byArray3[1] = (byte)(n >>> 8);
            byArray3[2] = (byte)n;
            return SigningFilter.base64encode(byArray2) + "=" + SigningFilter.base64encode(byArray3);
        }

        private static final String base64encode(byte[] byArray) throws IOException {
            StringWriter stringWriter = new StringWriter();
            Base64OutputStream base64OutputStream = new Base64OutputStream(stringWriter);
            base64OutputStream.write(byArray);
            base64OutputStream.close();
            return stringWriter.toString();
        }
    }
}

