/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg;

import com.renderx.svg.SVGParseException;
import com.renderx.svg.Token;
import java.io.IOException;
import java.io.InputStreamReader;

public class PathLexer {
    public static final String blanks = " \t\r\n\f,";
    public static final String digits = "0123456789";
    public static final String commands = "MmZzLlHhVvCcSsQqTtAa";
    private char[] data = null;
    private int length = 0;
    private int cursor = 0;

    public PathLexer() {
    }

    public PathLexer(String string) {
        this();
        this.setSource(string);
    }

    public PathLexer(char[] cArray) {
        this();
        this.setSource(cArray);
    }

    public void setSource(String string) {
        this.setSource(string.toCharArray());
    }

    public void setSource(char[] cArray) {
        this.setSource(cArray, 0, cArray.length);
    }

    public void setSource(char[] cArray, int n, int n2) {
        this.data = cArray;
        this.cursor = n;
        this.length = n + n2;
    }

    private void skip_whitespace() {
        while (this.cursor < this.length) {
            if (blanks.indexOf(this.data[this.cursor]) == -1) break;
            ++this.cursor;
        }
    }

    public int nextToken(Token token) throws SVGParseException {
        int n;
        token.reset();
        this.skip_whitespace();
        if (this.cursor >= this.length) {
            token.type = 1;
            return 1;
        }
        if (commands.indexOf(this.data[this.cursor]) != -1) {
            token.stringValue = "" + this.data[this.cursor++];
            token.type = 13;
            return 13;
        }
        int n2 = 1;
        if (this.data[this.cursor] == '-') {
            ++this.cursor;
            n2 = -1;
        } else if (this.data[this.cursor] == '+') {
            ++this.cursor;
        }
        if (this.cursor >= this.length) {
            throw new SVGParseException("Premature end of data");
        }
        if (digits.indexOf(this.data[this.cursor]) == -1 && (this.cursor >= this.length - 1 || this.data[this.cursor] != '.' || digits.indexOf(this.data[this.cursor + 1]) == -1)) {
            throw new SVGParseException("Invalid data: command character or digit expected");
        }
        boolean bl = false;
        double d = 1.0;
        token.numValue = 0.0;
        while (this.cursor < this.length) {
            if (digits.indexOf(this.data[this.cursor]) != -1) {
                n = this.data[this.cursor] - 48;
                if (bl) {
                    token.numValue += (d /= 10.0) * (double)n;
                } else {
                    token.numValue *= 10.0;
                    token.numValue += (double)n;
                }
            } else {
                if (this.data[this.cursor] != '.' || bl) break;
                bl = true;
            }
            ++this.cursor;
        }
        token.numValue *= (double)n2;
        if (this.cursor < this.length && (this.data[this.cursor] == 'e' || this.data[this.cursor] == 'E')) {
            if (++this.cursor >= this.length) {
                throw new SVGParseException("Premature end of data");
            }
            n = 1;
            if (this.data[this.cursor] == '-') {
                ++this.cursor;
                n = -1;
            } else if (this.data[this.cursor] == '+') {
                ++this.cursor;
            }
            if (this.cursor >= this.length) {
                throw new SVGParseException("Premature end of data");
            }
            if (digits.indexOf(this.data[this.cursor]) == -1) {
                throw new SVGParseException("Invalid data: digit expected");
            }
            int n3 = 0;
            while (this.cursor < this.length && digits.indexOf(this.data[this.cursor]) != -1) {
                n3 = (int)((double)n3 * 10.0);
                n3 += this.data[this.cursor] - 48;
                ++this.cursor;
            }
            token.numValue *= Math.pow(10.0, n3 *= n);
        }
        token.type = 15;
        return 15;
    }

    public static void main(String[] stringArray) {
        char[] cArray = new char[8192];
        int n = 0;
        PathLexer pathLexer = new PathLexer();
        Token token = new Token();
        while (true) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                n = inputStreamReader.read(cArray);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.exit(1);
            }
            if (n < 0) {
                System.exit(0);
            }
            pathLexer.setSource(cArray, 0, n);
            try {
                do {
                    pathLexer.nextToken(token);
                    token.dump(System.out);
                } while (token.type != 1);
            }
            catch (SVGParseException sVGParseException) {
                System.err.println(sVGParseException.toString());
            }
            System.out.println();
        }
    }
}

