/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.pslib.PSOutputStream;
import com.renderx.util.Hashtable;
import java.io.IOException;
import java.util.Enumeration;

public class SpotColors {
    int colorantsCount = -1;
    Hashtable colorants = new Hashtable();

    SpotColors() {
    }

    String getPSSpotColorName(String string, float[] fArray) {
        SpotColor spotColor = new SpotColor(string, fArray);
        return (String)this.colorants.get(spotColor);
    }

    void addSpotColor(String string, float[] fArray) {
        ++this.colorantsCount;
        SpotColor spotColor = new SpotColor(string, fArray);
        this.colorants.put(spotColor, "CS" + this.colorantsCount);
    }

    void write(PSOutputStream pSOutputStream) throws IOException {
        Enumeration enumeration = this.colorants.keys();
        while (enumeration.hasMoreElements()) {
            SpotColor spotColor = (SpotColor)enumeration.nextElement();
            String string = (String)this.colorants.get(spotColor);
            pSOutputStream.print("/" + string + " ");
            pSOutputStream.print("[ /Separation (" + spotColor.colorant + ") ");
            this.writeAltColorTransformProcedure(pSOutputStream, spotColor.altcolor);
            pSOutputStream.print(" ] ");
            pSOutputStream.print("/ColorSpace ");
            pSOutputStream.println("defineresource");
        }
    }

    private void writeAltColorTransformProcedure(PSOutputStream pSOutputStream, float[] fArray) throws IOException {
        float[] fArray2 = fArray;
        if (fArray == null) {
            fArray2 = new float[]{0.0f};
        }
        String string = "";
        switch (fArray2.length) {
            case 1: {
                string = "DeviceGray";
                break;
            }
            case 3: {
                string = "DeviceRGB";
                break;
            }
            case 4: {
                string = "DeviceCMYK";
                break;
            }
            default: {
                string = "DeviceGray";
            }
        }
        pSOutputStream.print("/" + string);
        int n = fArray2.length;
        pSOutputStream.print(" { ");
        if (n == 1 || n == 3) {
            int n2 = 0;
            while (n2 < n) {
                if (n2 < n - 1) {
                    pSOutputStream.print("dup dup " + fArray2[n2] + " mul 1 add exch sub exch ");
                } else {
                    pSOutputStream.print("dup " + fArray2[n2] + " mul 1 add exch sub");
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                if (n3 < n - 1) {
                    pSOutputStream.print("dup " + fArray2[n3] + " mul exch ");
                } else {
                    pSOutputStream.print("" + fArray2[n3] + " mul");
                }
                ++n3;
            }
        }
        pSOutputStream.print(" }");
    }

    public class SpotColor {
        String colorant;
        float[] altcolor;

        SpotColor(String string, float[] fArray) {
            this.colorant = string;
            this.altcolor = fArray;
            if (fArray == null) {
                this.altcolor = new float[]{0.0f};
            }
        }

        public int hashCode() {
            return this.colorant.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof SpotColor)) {
                return false;
            }
            SpotColor spotColor = (SpotColor)object;
            if (!spotColor.colorant.equals(this.colorant)) {
                return false;
            }
            if (spotColor.altcolor.length != this.altcolor.length) {
                return false;
            }
            int n = 0;
            while (n < this.altcolor.length) {
                if (spotColor.altcolor[n] != this.altcolor[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

