/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.hyphen;

import com.renderx.hyphen.DumbHyphenator;
import com.renderx.hyphen.Hyphenator;
import com.renderx.hyphen.HyphenatorFactory;
import com.renderx.hyphen.TeXHyphenator;
import com.renderx.sax.ConfigHandler;
import com.renderx.sax.ConfigHandlerAdapter;
import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.URLSpec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TeXHyphenatorFactory
implements HyphenatorFactory {
    private String configFileName = null;
    private final Hashtable langtab = new Hashtable();
    private final ErrorHandler errHandler;
    private final Hyphenator fallbackHyphenator = new DumbHyphenator();

    public TeXHyphenatorFactory(URLSpec uRLSpec, ErrorHandler errorHandler) throws IOException, SAXException {
        this.errHandler = errorHandler;
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setContentHandler(new ConfigHandlerAdapter(new Config(), uRLSpec));
        xMLReader.parse(new InputSource(uRLSpec));
    }

    public TeXHyphenatorFactory(org.xml.sax.InputSource inputSource, XMLReader xMLReader, ErrorHandler errorHandler) throws IOException, SAXException {
        this.errHandler = errorHandler;
        xMLReader.setContentHandler(new ConfigHandlerAdapter(new Config(), new URLSpec(inputSource.getSystemId())));
        xMLReader.parse(inputSource);
    }

    public Hyphenator getHyphenator(String string) {
        int n;
        if (string == null) {
            return this.fallbackHyphenator;
        }
        HyphenatorRecord hyphenatorRecord = (HyphenatorRecord)this.langtab.get(string = string.toLowerCase().trim());
        if (hyphenatorRecord == null && (n = string.indexOf(45)) != -1) {
            string = string.substring(0, n).trim();
            hyphenatorRecord = (HyphenatorRecord)this.langtab.get(string);
        }
        return hyphenatorRecord == null ? this.fallbackHyphenator : hyphenatorRecord.getHyphenator();
    }

    public void printWarning(String string) {
        if (this.errHandler == null) {
            return;
        }
        ErrorHandler errorHandler = this.errHandler;
        synchronized (errorHandler) {
            this.errHandler.warning(this.configFileName + ": " + string);
        }
    }

    public void printError(String string) {
        if (this.errHandler == null) {
            return;
        }
        ErrorHandler errorHandler = this.errHandler;
        synchronized (errorHandler) {
            this.errHandler.error(this.configFileName + ": " + string);
        }
    }

    public void printException(String string, Exception exception) {
        if (this.errHandler == null) {
            return;
        }
        ErrorHandler errorHandler = this.errHandler;
        synchronized (errorHandler) {
            this.errHandler.exception(this.configFileName + ": " + string, exception);
        }
    }

    private class Config
    implements ConfigHandler {
        private static final String NSURI = "http://www.renderx.com/XEP/config";
        private int skip = 0;

        private Config() {
        }

        public void startDocument(Hashtable hashtable) {
            TeXHyphenatorFactory.this.configFileName = (String)hashtable.get("document");
        }

        public void endDocument(Hashtable hashtable) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes, Hashtable hashtable) {
            if (this.skip > 0) {
                ++this.skip;
                return;
            }
            if (!"".equals(string) && !NSURI.equals(string)) {
                return;
            }
            if (string2.equals("language")) {
                String string4 = this.getRequiredValue(string2, attributes, "codes");
                if (string4 == null) {
                    return;
                }
                hashtable.put("language-codes", string4);
                String string5 = attributes.getValue("name");
                if (string5 != null) {
                    hashtable.put("language", string5);
                }
            } else if (string2.equals("hyphenation")) {
                String string6 = (String)hashtable.get("language-codes");
                if (string6 == null) {
                    TeXHyphenatorFactory.this.printError("'hyphenation' element is not a child of 'language' element; element ignored");
                    this.skip = 1;
                    return;
                }
                String string7 = (String)hashtable.get("language");
                String string8 = this.getRequiredValue(string2, attributes, "pattern");
                if (string8 == null) {
                    return;
                }
                URLSpec uRLSpec = null;
                try {
                    uRLSpec = new URLSpec((URLSpec)hashtable.get("base"), string8);
                }
                catch (MalformedURLException malformedURLException) {
                    TeXHyphenatorFactory.this.printException("Invalid URL to hyphenation pattern for language " + string7, malformedURLException);
                    this.skip = 1;
                    return;
                }
                String string9 = attributes.getValue("encoding");
                StringTokenizer stringTokenizer = new StringTokenizer(string6, " \t\r\n,");
                if (!stringTokenizer.hasMoreTokens()) {
                    TeXHyphenatorFactory.this.printError("Empty list of codes for language " + string7);
                    this.skip = 1;
                    return;
                }
                HyphenatorRecord hyphenatorRecord = new HyphenatorRecord(string7, uRLSpec, string9);
                while (stringTokenizer.hasMoreTokens()) {
                    TeXHyphenatorFactory.this.langtab.put(stringTokenizer.nextToken().toLowerCase(), hyphenatorRecord);
                }
            }
        }

        public void endElement(String string, String string2, String string3, Hashtable hashtable) {
            if (this.skip > 0) {
                --this.skip;
                return;
            }
            if (!"".equals(string) && !NSURI.equals(string)) {
                return;
            }
        }

        public void characters(char[] cArray, int n, int n2, Hashtable hashtable) {
            if (this.skip > 0) {
                return;
            }
        }

        public void processingInstruction(String string, String string2, Hashtable hashtable) {
            if (this.skip > 0) {
                return;
            }
        }

        private final String getRequiredValue(String string, Attributes attributes, String string2) {
            String string3 = attributes.getValue(string2);
            if (string3 == null) {
                TeXHyphenatorFactory.this.printError("Mandatory attribute '" + string2 + "' is missing on element '" + string + "'; element skipped");
                this.skip = 1;
            }
            return string3;
        }
    }

    class HyphenatorRecord {
        final String language;
        final URLSpec table;
        final String encoding;
        Hyphenator hyphenator = null;

        HyphenatorRecord(String string, URLSpec uRLSpec, String string2) {
            this.language = string;
            this.table = uRLSpec;
            this.encoding = string2;
        }

        synchronized Hyphenator getHyphenator() {
            if (this.hyphenator != null) {
                return this.hyphenator;
            }
            try {
                InputStream inputStream = this.table.openStream();
                try {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.encoding == null ? "ISO-8859-1" : this.encoding));
                        this.hyphenator = new TeXHyphenator(bufferedReader, TeXHyphenatorFactory.this.errHandler);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        TeXHyphenatorFactory.this.printError("Unsupported encoding: " + this.encoding);
                        this.hyphenator = TeXHyphenatorFactory.this.fallbackHyphenator;
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                {
                }
            }
            catch (Exception exception) {
                TeXHyphenatorFactory.this.printException("Cannot initialize hyphenator for language " + this.language, exception);
                this.hyphenator = TeXHyphenatorFactory.this.fallbackHyphenator;
            }
            return this.hyphenator;
        }
    }
}

