/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics.vector;

import com.renderx.graphics.vector.GraphicObject;
import com.renderx.util.List;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;

public class Subpath
extends GraphicObject {
    public double startX = 0.0;
    public double startY = 0.0;
    public boolean closed = false;
    public List segs = new List();

    public void append(Segment segment) {
        this.segs.append(segment);
    }

    public Subpath(double d, double d2) {
        this.startX = d;
        this.startY = d2;
    }

    public void dump(PrintStream printStream, String string) throws IOException {
        printStream.println(string + "%<subpath closed=\"" + this.closed + "\">");
        printStream.println(string + "  " + this.startX + " " + this.startY + " moveto");
        Enumeration enumeration = this.segs.elements();
        while (enumeration.hasMoreElements()) {
            ((Segment)enumeration.nextElement()).dump(printStream, string + "  ");
        }
        if (this.closed) {
            printStream.println(string + "  closepath");
        }
        printStream.println(string + "%</subpath>");
    }

    public static class Ellipse
    extends Curve {
        public Ellipse(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            super(d, d2, d3, d4, d5, d6, d7, d8);
        }
    }

    public static class Curve
    extends Segment {
        public double cpx1 = 0.0;
        public double cpy1 = 0.0;
        public double cpx2 = 0.0;
        public double cpy2 = 0.0;

        public Curve(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            super(d, d2, d7, d8);
            this.cpx1 = d3;
            this.cpy1 = d4;
            this.cpx2 = d5;
            this.cpy2 = d6;
        }

        public void dump(PrintStream printStream, String string) throws IOException {
            printStream.println(string + "%<curve x-from=\"" + this.xbeg + "\"" + " y-from=\"" + this.ybeg + "\"" + " cpx1=\"" + this.cpx1 + "\"" + " cpy1=\"" + this.cpy1 + "\"" + " cpx2=\"" + this.cpx2 + "\"" + " cpy2=\"" + this.cpy2 + "\"" + " x-to=\"" + this.xend + "\"" + " y-to=\"" + this.yend + "\">");
            printStream.println(string + "  " + this.cpx1 + " " + this.cpy1 + " " + this.cpx2 + " " + this.cpy2 + " " + this.xend + " " + this.yend + " curveto");
            printStream.println(string + "%</curve>");
        }

        public double startSlopeX() {
            if (this.cpx1 != this.xbeg || this.cpy1 != this.ybeg) {
                return this.cpx1 - this.xbeg;
            }
            if (this.cpx2 != this.xbeg || this.cpy2 != this.ybeg) {
                return this.cpx2 - this.xbeg;
            }
            return this.xend - this.xbeg;
        }

        public double startSlopeY() {
            if (this.cpx1 != this.xbeg || this.cpy1 != this.ybeg) {
                return this.cpy1 - this.ybeg;
            }
            if (this.cpx2 != this.xbeg || this.cpy2 != this.ybeg) {
                return this.cpy2 - this.ybeg;
            }
            return this.cpy1 - this.ybeg;
        }

        public double endSlopeX() {
            if (this.xend != this.cpx2 || this.yend != this.cpy2) {
                return this.xend - this.cpx2;
            }
            if (this.xend != this.cpx1 || this.yend != this.cpy1) {
                return this.xend - this.cpx1;
            }
            return this.xend - this.xbeg;
        }

        public double endSlopeY() {
            if (this.xend != this.cpx2 || this.yend != this.cpy2) {
                return this.yend - this.cpy2;
            }
            if (this.xend != this.cpx1 || this.yend != this.cpy1) {
                return this.yend - this.cpy1;
            }
            return this.yend - this.ybeg;
        }
    }

    public static class Line
    extends Segment {
        public Line(double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
        }

        public void dump(PrintStream printStream, String string) throws IOException {
            printStream.println(string + "%<line x-from=\"" + this.xbeg + "\"" + " y-from=\"" + this.ybeg + "\"" + " x-to=\"" + this.xend + "\"" + " y-to=\"" + this.yend + "\">");
            printStream.println(string + "  " + this.xend + " " + this.yend + " lineto");
            printStream.println(string + "%</line>");
        }

        public double startSlopeX() {
            return this.xend - this.xbeg;
        }

        public double startSlopeY() {
            return this.yend - this.ybeg;
        }

        public double endSlopeX() {
            return this.xend - this.xbeg;
        }

        public double endSlopeY() {
            return this.yend - this.ybeg;
        }
    }

    public static abstract class Segment
    extends GraphicObject {
        public double xbeg = 0.0;
        public double ybeg = 0.0;
        public double xend = 0.0;
        public double yend = 0.0;
        public boolean beginsArc = true;
        public boolean endsArc = true;

        public Segment(double d, double d2, double d3, double d4) {
            this.xbeg = d;
            this.ybeg = d2;
            this.xend = d3;
            this.yend = d4;
        }

        public abstract void dump(PrintStream var1, String var2) throws IOException;

        public abstract double startSlopeX();

        public abstract double startSlopeY();

        public abstract double endSlopeX();

        public abstract double endSlopeY();
    }
}

