/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.SvgLevelParams;
import com.renderx.graphics.VectorImage;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.URLSpec;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XMLVectorImage
extends VectorImage {
    public abstract void parse(XMLReader var1, org.xml.sax.InputSource var2) throws IOException, ImageFormatException, SAXException;

    public final void parse() throws IOException, ImageFormatException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            InputStream inputStream = this.openImageStream();
            try {
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId(this.getSourceId());
                this.parse(xMLReader, inputSource);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            {
            }
        }
        catch (SAXException sAXException) {
            throw new ImageFormatException(sAXException.toString(), this.mimetype);
        }
    }

    public ImageTree getImageTree(XMLReader xMLReader, org.xml.sax.InputSource inputSource, int n, SvgLevelParams svgLevelParams) throws IOException, ImageFormatException, SAXException {
        throw new ImageFormatException("Vector rendering of " + this.mimetype + " not supported", this.mimetype);
    }

    public final ImageTree getImageTreeByType(int n, SvgLevelParams svgLevelParams) throws IOException, ImageFormatException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            ImageTree imageTree = null;
            InputStream inputStream = this.openImageStream();
            try {
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId(this.getSourceId());
                imageTree = this.getImageTree(xMLReader, inputSource, n, svgLevelParams);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return imageTree;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new ImageFormatException(sAXException.toString(), this.mimetype);
        }
    }

    public final ImageTree getImageTree() throws IOException, ImageFormatException {
        return this.getImageTreeByType(VectorImage.IMAGE_TYPE_DEFAULT, null);
    }

    private final String getSourceId() throws MalformedURLException {
        switch (this.source.scheme) {
            case 2: {
                String string = this.source.resource;
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                return new URLSpec(string).toString();
            }
            case 1: {
                URLSpec uRLSpec = this.source.getBase();
                if (uRLSpec != null) {
                    return uRLSpec.toString() + ".data";
                }
                return this.source.toString();
            }
            case 3: {
                return this.source.toString();
            }
        }
        return null;
    }
}

