/**
 * 
 */
package com.renderx.xepx.x4u.ct.nodedscpanel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.renderx.xepx.x4u.ct.FontsPanel;
import com.renderx.xepx.x4u.ct.nodedscpanel.transformpanel.SizePanel;
import com.renderx.xepx.x4u.ct.nodedscpanel.transformpanel.SlantPanel;
import com.renderx.xepx.x4u.ct.nodedscpanel.transformpanel.SmallcapPanel;

/**
 * @author AlexanderR
 *
 */
public class TransformPanel extends JPanel
{
    private static final long serialVersionUID = 1642386931731255311L;

    private FontsPanel parentPanel;
    
    private SlantPanel customSlantPanel;
    private SmallcapPanel customSmallcapPanel;
    private SizePanel sizePanel;
    
    private TitledBorder titledBorder3;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    
    public TransformPanel(FontsPanel _parentPanel)
    {
	this.parentPanel = _parentPanel;
	
	customSlantPanel = new SlantPanel(parentPanel);
	customSmallcapPanel = new SmallcapPanel(parentPanel);
	sizePanel = new SizePanel(parentPanel);
	
        setLayout(gridBagLayout1);
	setBorder(titledBorder3);

	add(customSlantPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
		GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(
			0, 0, 0, 0), 0, 0));
	add(customSmallcapPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0,
		GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(
			0, 0, 0, 0), 0, 0));
	// Commented for 4.11 version
/*	add(sizePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
		GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(
			0, 0, 0, 0), 0, 0));*/
    }
    
    public void setFontTrans(Node node)
    {
	if (node == null)
	    return; // for inserted nodes
	
	NamedNodeMap attribs = node.getAttributes();
	if (attribs.getNamedItem("slant-angle") != null)
	{
	    this.customSlantPanel.setSelected(true);
	    this.customSlantPanel.setText(attribs.getNamedItem("slant-angle").getNodeValue());
	    this.customSlantPanel.setEnabled(true);
	} else
	{
	    this.customSlantPanel.setSelected(false);
	    this.customSlantPanel.setText("15");
	    this.customSlantPanel.setEnabled(false);
	}
	this.customSlantPanel.updateUI();
	if (attribs.getNamedItem("smallcap-size") != null)
	{
	    this.customSmallcapPanel.setSelected(true);
	    this.customSmallcapPanel.setText(attribs.getNamedItem("smallcap-size").getNodeValue());
	    this.customSmallcapPanel.setEnabled(true);
	} else
	{
	    this.customSmallcapPanel.setSelected(false);
	    this.customSmallcapPanel.setText("1");
	    this.customSmallcapPanel.setEnabled(false);
	}
	this.customSmallcapPanel.updateUI();	
/*	if (attribs.getNamedItem("size") != null)
	{
	    this.sizePanel.setSelected(true);
	    this.sizePanel.setText(attribs.getNamedItem("size").getNodeValue());
	    this.sizePanel.setEnabled(true);
	} else
	{
	    this.sizePanel.setSelected(false);
	    this.sizePanel.setText("1");
	    this.sizePanel.setEnabled(false);
	}	
	this.sizePanel.updateUI();*/
	updateUI();
    }    
    
    public void setDefaultValues()
    {
	this.customSlantPanel.setSelected(false);
	this.customSlantPanel.setText("15");
	this.customSlantPanel.setEnabled(false);
	this.customSmallcapPanel.setSelected(false);
	this.customSmallcapPanel.setText("1");
	this.customSmallcapPanel.setEnabled(false);
	this.sizePanel.setSelected(false);
	this.sizePanel.setText("1");
	this.sizePanel.setEnabled(false);
    }

    public SlantPanel getCustomSlantPanel()
    {
        return customSlantPanel;
    }

    public SmallcapPanel getCustomSmallcapPanel()
    {
        return customSmallcapPanel;
    }
    
    public SizePanel getSizePanel()
    {
        return sizePanel;
    }
    
}

