/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.util.Hashtable;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Bidi;
import com.renderx.xep.pre.ParserException;

public class WritingMode {
    private static final Hashtable nametab = new Hashtable();
    static WritingMode $defaultmode = null;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final int START = 0;
    public static final int END = 1;
    public static final int BEFORE = 2;
    public static final int AFTER = 3;
    public final int[] sides = new int[4];
    public boolean isHorizontal = true;
    public Attr direction;
    public Attr attribute;
    private static boolean initialized = false;

    public static WritingMode byName(String string) throws ParserException {
        Object object = nametab.get(string);
        if (object == null) {
            throw new ParserException("Unrecognized writing mode: " + string);
        }
        return (WritingMode)object;
    }

    public static synchronized void init() throws InternalException {
        if (initialized) {
            return;
        }
        Attn.init();
        Bidi.init();
        new WritingMode("lr-tb", 0, 1, 2, 3);
        new WritingMode("rl-tb", 1, 0, 2, 3);
        new WritingMode("tb-rl", 2, 3, 1, 0);
        new WritingMode("tb-lr", 2, 3, 0, 1);
        new WritingMode("lr-bt", 0, 1, 3, 2);
        new WritingMode("rl-bt", 1, 0, 3, 2);
        new WritingMode("bt-rl", 3, 2, 1, 0);
        new WritingMode("bt-lr", 3, 2, 0, 1);
        $defaultmode = (WritingMode)nametab.get(Attn.$writing_mode.defaultValue.word());
        if ($defaultmode == null) {
            throw new InternalException("Invalid value for default writing mode");
        }
        initialized = true;
    }

    private WritingMode(String string, int n, int n2, int n3, int n4) {
        nametab.put(string, this);
        this.sides[n] = 0;
        this.sides[n2] = 1;
        this.sides[n3] = 2;
        this.sides[n4] = 3;
        this.isHorizontal = this.sides[0] == 0 || this.sides[0] == 1;
        this.direction = this.sides[0] == 1 ? Bidi.RIGHTTOLEFT : Bidi.LEFTTORIGHT;
        this.attribute = Attr.Word.create(string);
    }
}

